/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm;

import com.google.common.base.Objects;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.iterator.FilterIterator;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.util.Consumers;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;

public abstract class OltpTraverser
extends HugeTraverser
implements AutoCloseable {
    private static final String EXECUTOR_NAME = "oltp";
    private static Consumers.ExecutorPool executors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OltpTraverser(HugeGraph graph) {
        super(graph);
        if (executors != null) {
            return;
        }
        Class<OltpTraverser> clazz = OltpTraverser.class;
        synchronized (OltpTraverser.class) {
            if (executors != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int workers = (Integer)this.graph().option(CoreOptions.OLTP_CONCURRENT_THREADS);
            if (workers > 0) {
                executors = new Consumers.ExecutorPool(EXECUTOR_NAME, workers);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        Class<OltpTraverser> clazz = OltpTraverser.class;
        synchronized (OltpTraverser.class) {
            if (executors != null) {
                executors.destroy();
                executors = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    protected long traversePairs(Iterator<Pair<Id, Id>> pairs, Consumer<Pair<Id, Id>> consumer) {
        return this.traverse(pairs, consumer, "traverse-pairs");
    }

    protected long traverseIds(Iterator<Id> ids, Consumer<Id> consumer, boolean concurrent) {
        if (concurrent) {
            return this.traverseIds(ids, consumer);
        }
        long count = 0L;
        while (ids.hasNext()) {
            ++count;
            consumer.accept(ids.next());
        }
        return count;
    }

    protected long traverseIds(Iterator<Id> ids, Consumer<Id> consumer) {
        return this.traverse(ids, consumer, "traverse-ids");
    }

    protected <K> long traverse(Iterator<K> iterator, Consumer<K> consumer, String name) {
        if (!iterator.hasNext()) {
            return 0L;
        }
        Consumers<K> consumers = new Consumers<K>(executors.getExecutor(), consumer, null);
        consumers.start(name);
        long total = 0L;
        try {
            while (iterator.hasNext()) {
                ++total;
                K v = iterator.next();
                consumers.provide(v);
            }
        }
        catch (Consumers.StopExecution e) {
            try {
                consumers.await();
            }
            catch (Throwable e2) {
                throw Consumers.wrapException(e2);
            }
            finally {
                executors.returnExecutor(consumers.executor());
                CloseableIterator.closeIterator(iterator);
            }
        }
        catch (Throwable e) {
            throw Consumers.wrapException(e);
        }
        finally {
            try {
                consumers.await();
            }
            catch (Throwable e) {
                throw Consumers.wrapException(e);
            }
            finally {
                executors.returnExecutor(consumers.executor());
                CloseableIterator.closeIterator(iterator);
            }
        }
        return total;
    }

    protected Iterator<Vertex> filter(Iterator<Vertex> vertices, String key, Object value) {
        return new FilterIterator(vertices, vertex -> this.match((Element)vertex, key, value));
    }

    protected boolean match(Element elem, String key, Object value) {
        this.graph().propertyKey(key);
        Property p = elem.property(key);
        return p.isPresent() && Objects.equal((Object)p.value(), (Object)value);
    }

    public static class ConcurrentMultiValuedMap<K, V>
    extends ConcurrentHashMap<K, List<V>> {
        private static final long serialVersionUID = -7249946839643493614L;

        public void add(K key, V value) {
            List<V> values = this.getValues(key);
            values.add(value);
        }

        public void addAll(K key, List<V> value) {
            List<V> values = this.getValues(key);
            values.addAll(value);
        }

        public List<V> getValues(K key) {
            List old;
            List values = (CopyOnWriteArrayList)this.get(key);
            if (values == null && (old = (List)this.putIfAbsent(key, values = new CopyOnWriteArrayList())) != null) {
                values = old;
            }
            return values;
        }
    }
}

