/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.tinkerpop.gremlin.structure.Element;

public final class ElementValueComparator<V>
implements Comparator<Element>,
Serializable {
    private final String propertyKey;
    private final Comparator<V> valueComparator;

    public ElementValueComparator(String propertyKey, Comparator<V> valueComparator) {
        this.propertyKey = propertyKey;
        this.valueComparator = valueComparator;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public Comparator<V> getValueComparator() {
        return this.valueComparator;
    }

    @Override
    public int compare(Element elementA, Element elementB) {
        return this.valueComparator.compare(elementA.value(this.propertyKey), elementB.value(this.propertyKey));
    }

    public String toString() {
        return this.valueComparator.toString() + '(' + this.propertyKey + ')';
    }
}

