/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.loadbalancing.adaptive;

import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.loadbalancing.adaptive.AdaptiveLoadProbe;

public class AdaptiveJobCountLoadProbe
implements AdaptiveLoadProbe {
    private boolean useAvg = true;

    public AdaptiveJobCountLoadProbe() {
    }

    public AdaptiveJobCountLoadProbe(boolean useAvg) {
        this.useAvg = useAvg;
    }

    public boolean isUseAverage() {
        return this.useAvg;
    }

    public void setUseAverage(boolean useAvg) {
        this.useAvg = useAvg;
    }

    @Override
    public double getLoad(ClusterNode node, int jobsSentSinceLastUpdate) {
        double load;
        ClusterMetrics metrics = node.metrics();
        if (this.useAvg && (load = (double)(metrics.getAverageActiveJobs() + metrics.getAverageWaitingJobs())) > 0.0) {
            return load;
        }
        load = metrics.getCurrentActiveJobs() + metrics.getCurrentWaitingJobs();
        return load < 0.0 ? 0.0 : load;
    }

    public String toString() {
        return S.toString(AdaptiveJobCountLoadProbe.class, this);
    }
}

