/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import java.util.StringJoiner;
import java.util.UUID;
import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridReservable;
import org.apache.ignite.internal.processors.job.GridJobProcessor;
import org.apache.ignite.internal.processors.job.GridJobWorker;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class ComputeJobView {
    private final GridJobWorker job;
    private final IgniteUuid id;
    private final ComputeJobState state;

    public ComputeJobView(IgniteUuid id, GridJobWorker job, ComputeJobState state) {
        this.id = id;
        this.job = job;
        this.state = state;
    }

    @Order
    public IgniteUuid id() {
        return this.id;
    }

    @Order(value=1)
    public IgniteUuid sessionId() {
        return this.job.getSession().getId();
    }

    @Order(value=2)
    public UUID originNodeId() {
        return this.job.getTaskNode().id();
    }

    @Order(value=3)
    public String taskName() {
        return this.job.getSession().getTaskName();
    }

    @Order(value=4)
    public String taskClassName() {
        return this.job.getSession().getTaskClassName();
    }

    @Order(value=5)
    public String affinityCacheIds() {
        GridReservable res = this.job.getPartsReservation();
        if (!(res instanceof GridJobProcessor.PartitionsReservation)) {
            return null;
        }
        int[] ids = ((GridJobProcessor.PartitionsReservation)res).getCacheIds();
        if (ids == null || ids.length == 0) {
            return null;
        }
        StringJoiner joiner = new StringJoiner(",");
        for (int id : ids) {
            joiner.add(Integer.toString(id));
        }
        return joiner.toString();
    }

    @Order(value=6)
    public int affinityPartitionId() {
        GridReservable res = this.job.getPartsReservation();
        if (!(res instanceof GridJobProcessor.PartitionsReservation)) {
            return -1;
        }
        return ((GridJobProcessor.PartitionsReservation)res).getPartId();
    }

    @Order(value=7)
    public long createTime() {
        return this.job.getCreateTime();
    }

    @Order(value=8)
    public long startTime() {
        return this.job.getStartTime();
    }

    @Order(value=9)
    public long finishTime() {
        return this.job.getFinishTime();
    }

    public boolean isInternal() {
        return this.job.isInternal();
    }

    public boolean isFinishing() {
        return this.job.isFinishing();
    }

    public boolean isTimedOut() {
        return this.job.isTimedOut();
    }

    public boolean isStarted() {
        return this.job.isStarted();
    }

    @Nullable
    public String executorName() {
        return this.job.executorName();
    }

    public ComputeJobState state() {
        return this.state;
    }

    public static enum ComputeJobState {
        ACTIVE,
        PASSIVE,
        CANCELED;

    }
}

