/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.descriptors;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableSchemaVersions;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;

public class CatalogTableSchemaVersionsSerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class TableSchemaVersionsSerializerV2
    implements CatalogObjectSerializer<CatalogTableSchemaVersions> {
        TableSchemaVersionsSerializerV2() {
        }

        @Override
        public CatalogTableSchemaVersions readFrom(CatalogObjectDataInput input) throws IOException {
            List<CatalogTableSchemaVersions.TableVersion> versions = input.readCompactEntryList(CatalogTableSchemaVersions.TableVersion.class);
            int base = input.readVarIntAsInt();
            return new CatalogTableSchemaVersions(base, versions.toArray(new CatalogTableSchemaVersions.TableVersion[0]));
        }

        @Override
        public void writeTo(CatalogTableSchemaVersions tabVersions, CatalogObjectDataOutput output) throws IOException {
            output.writeCompactEntryList(Arrays.asList(tabVersions.versions()));
            output.writeVarInt(tabVersions.earliestVersion());
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    static class TableSchemaVersionsSerializerV1
    implements CatalogObjectSerializer<CatalogTableSchemaVersions> {
        private final CatalogEntrySerializerProvider serializers;

        public TableSchemaVersionsSerializerV1(CatalogEntrySerializerProvider serializers) {
            this.serializers = serializers;
        }

        @Override
        public CatalogTableSchemaVersions readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogObjectSerializer serializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_TABLE_VERSION.id());
            CatalogTableSchemaVersions.TableVersion[] versions = CatalogSerializationUtils.readArray(serializer, input, CatalogTableSchemaVersions.TableVersion.class);
            int base = input.readVarIntAsInt();
            return new CatalogTableSchemaVersions(base, versions);
        }

        @Override
        public void writeTo(CatalogTableSchemaVersions tabVersions, CatalogObjectDataOutput output) throws IOException {
            CatalogObjectSerializer serializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_TABLE_VERSION.id());
            CatalogSerializationUtils.writeArray(tabVersions.versions(), serializer, output);
            output.writeVarInt(tabVersions.earliestVersion());
        }
    }
}

