/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.call.recovery.cluster;

import jakarta.inject.Singleton;
import java.io.IOException;
import org.apache.ignite3.internal.cli.call.recovery.cluster.ResetClusterCallInput;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.RecoveryApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.ResetClusterRequest;

@Singleton
public class ResetClusterCall
implements Call<ResetClusterCallInput, String> {
    private final ApiClientFactory clientFactory;

    public ResetClusterCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public DefaultCallOutput<String> execute(ResetClusterCallInput input) {
        RecoveryApi client = new RecoveryApi(this.clientFactory.getClient(input.clusterUrl()));
        ResetClusterRequest command = new ResetClusterRequest();
        command.setCmgNodeNames(input.cmgNodeNames());
        command.setMetastorageReplicationFactor(input.metastorageReplicationFactor());
        try {
            client.resetCluster(command);
            return DefaultCallOutput.success("Successfully initiated cluster repair.");
        }
        catch (ApiException e) {
            if (e.getCause() instanceof IOException) {
                return DefaultCallOutput.success("Node has gone, this most probably means that cluster repair is initiated and the node restarts.");
            }
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.clusterUrl()));
        }
    }
}

