/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.repl.registry.impl;

import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.cli.call.cluster.unit.ClusterListUnitCall;
import org.apache.ignite3.internal.cli.call.unit.ListUnitCallInput;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.repl.SessionInfo;
import org.apache.ignite3.internal.cli.core.repl.registry.UnitsRegistry;
import org.apache.ignite3.internal.cli.core.repl.registry.impl.LazyObjectRef;
import org.apache.ignite3.internal.cli.event.ConnectionEventListener;
import org.apache.ignite3.rest.client.model.UnitStatus;
import org.apache.ignite3.rest.client.model.UnitVersionStatus;
import org.jetbrains.annotations.Nullable;

@Singleton
public class UnitsRegistryImpl
implements UnitsRegistry,
ConnectionEventListener {
    private final AtomicReference<String> lastKnownUrl = new AtomicReference<Object>(null);
    private final ClusterListUnitCall call;
    @Nullable
    private LazyObjectRef<Map<String, Set<String>>> idToVersionsRef;

    public UnitsRegistryImpl(ClusterListUnitCall call) {
        this.call = call;
    }

    @Override
    public void onConnect(SessionInfo sessionInfo) {
        this.updateState(sessionInfo.nodeUrl());
    }

    private void updateState(String url) {
        this.lastKnownUrl.set(url);
        this.idToVersionsRef = new LazyObjectRef<Map>(() -> {
            ListUnitCallInput input = ListUnitCallInput.builder().url(url).build();
            CallOutput<List<UnitStatus>> output = this.call.execute(input);
            if (!output.hasError() && !output.isEmpty()) {
                return output.body().stream().collect(Collectors.toMap(UnitStatus::getId, status -> status.getVersionToStatus().stream().map(UnitVersionStatus::getVersion).collect(Collectors.toSet())));
            }
            return null;
        });
    }

    @Override
    public void onDisconnect() {
        this.idToVersionsRef = null;
    }

    @Override
    public Set<String> versions(String unitId) {
        Map<String, Set<String>> idToVersions = this.idToVersions();
        return idToVersions == null ? Set.of() : idToVersions.get(unitId);
    }

    @Override
    public Set<String> ids() {
        Map<String, Set<String>> idToVersions = this.idToVersions();
        return idToVersions == null ? Set.of() : idToVersions.keySet();
    }

    @Nullable
    private Map<String, Set<String>> idToVersions() {
        return this.idToVersionsRef == null ? null : this.idToVersionsRef.get();
    }

    @Override
    public void refresh() {
        this.onDisconnect();
        this.updateState(this.lastKnownUrl.get());
    }
}

