/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Spool;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite3.internal.schema.BinaryTupleSchema;
import org.apache.ignite3.internal.sql.engine.exec.DestinationFactory;
import org.apache.ignite3.internal.sql.engine.exec.ExchangeService;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.MailboxRegistry;
import org.apache.ignite3.internal.sql.engine.exec.PartitionProvider;
import org.apache.ignite3.internal.sql.engine.exec.ResolvedDependencies;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.ScannableDataSource;
import org.apache.ignite3.internal.sql.engine.exec.ScannableTable;
import org.apache.ignite3.internal.sql.engine.exec.UpdatableTable;
import org.apache.ignite3.internal.sql.engine.exec.exp.ExpressionFactory;
import org.apache.ignite3.internal.sql.engine.exec.exp.RangeIterable;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlComparator;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlJoinPredicate;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlJoinProjection;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlPredicate;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlProjection;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlRowProvider;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlScalar;
import org.apache.ignite3.internal.sql.engine.exec.exp.agg.AggregateType;
import org.apache.ignite3.internal.sql.engine.exec.exp.func.TableFunction;
import org.apache.ignite3.internal.sql.engine.exec.exp.func.TableFunctionRegistry;
import org.apache.ignite3.internal.sql.engine.exec.mapping.ColocationGroup;
import org.apache.ignite3.internal.sql.engine.exec.rel.AbstractSetOpNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.CorrelatedNestedLoopJoinNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.DataSourceScanNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.FilterNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.HashAggregateNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.HashJoinNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.Inbox;
import org.apache.ignite3.internal.sql.engine.exec.rel.IndexScanNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.IndexSpoolNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.IntersectNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.LimitNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.MergeJoinNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.MinusNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.ModifyNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.NestedLoopJoinNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.Node;
import org.apache.ignite3.internal.sql.engine.exec.rel.Outbox;
import org.apache.ignite3.internal.sql.engine.exec.rel.ProjectNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.ScanNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.SortAggregateNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.SortNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.TableScanNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.TableSpoolNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.UnionAllNode;
import org.apache.ignite3.internal.sql.engine.exec.row.RowSchema;
import org.apache.ignite3.internal.sql.engine.prepare.bounds.SearchBounds;
import org.apache.ignite3.internal.sql.engine.rel.IgniteCorrelatedNestedLoopJoin;
import org.apache.ignite3.internal.sql.engine.rel.IgniteExchange;
import org.apache.ignite3.internal.sql.engine.rel.IgniteFilter;
import org.apache.ignite3.internal.sql.engine.rel.IgniteHashIndexSpool;
import org.apache.ignite3.internal.sql.engine.rel.IgniteHashJoin;
import org.apache.ignite3.internal.sql.engine.rel.IgniteIndexScan;
import org.apache.ignite3.internal.sql.engine.rel.IgniteKeyValueGet;
import org.apache.ignite3.internal.sql.engine.rel.IgniteKeyValueModify;
import org.apache.ignite3.internal.sql.engine.rel.IgniteLimit;
import org.apache.ignite3.internal.sql.engine.rel.IgniteMergeJoin;
import org.apache.ignite3.internal.sql.engine.rel.IgniteNestedLoopJoin;
import org.apache.ignite3.internal.sql.engine.rel.IgniteProject;
import org.apache.ignite3.internal.sql.engine.rel.IgniteReceiver;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite3.internal.sql.engine.rel.IgniteSelectCount;
import org.apache.ignite3.internal.sql.engine.rel.IgniteSender;
import org.apache.ignite3.internal.sql.engine.rel.IgniteSort;
import org.apache.ignite3.internal.sql.engine.rel.IgniteSortedIndexSpool;
import org.apache.ignite3.internal.sql.engine.rel.IgniteSystemViewScan;
import org.apache.ignite3.internal.sql.engine.rel.IgniteTableFunctionScan;
import org.apache.ignite3.internal.sql.engine.rel.IgniteTableModify;
import org.apache.ignite3.internal.sql.engine.rel.IgniteTableScan;
import org.apache.ignite3.internal.sql.engine.rel.IgniteTableSpool;
import org.apache.ignite3.internal.sql.engine.rel.IgniteTrimExchange;
import org.apache.ignite3.internal.sql.engine.rel.IgniteUnionAll;
import org.apache.ignite3.internal.sql.engine.rel.IgniteValues;
import org.apache.ignite3.internal.sql.engine.rel.agg.IgniteColocatedHashAggregate;
import org.apache.ignite3.internal.sql.engine.rel.agg.IgniteColocatedSortAggregate;
import org.apache.ignite3.internal.sql.engine.rel.agg.IgniteMapHashAggregate;
import org.apache.ignite3.internal.sql.engine.rel.agg.IgniteMapSortAggregate;
import org.apache.ignite3.internal.sql.engine.rel.agg.IgniteReduceHashAggregate;
import org.apache.ignite3.internal.sql.engine.rel.agg.IgniteReduceSortAggregate;
import org.apache.ignite3.internal.sql.engine.rel.set.IgniteIntersect;
import org.apache.ignite3.internal.sql.engine.rel.set.IgniteMapSetOp;
import org.apache.ignite3.internal.sql.engine.rel.set.IgniteReduceIntersect;
import org.apache.ignite3.internal.sql.engine.rel.set.IgniteSetOp;
import org.apache.ignite3.internal.sql.engine.rule.LogicalScanConverterRule;
import org.apache.ignite3.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite3.internal.sql.engine.schema.IgniteDataSource;
import org.apache.ignite3.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite3.internal.sql.engine.trait.Destination;
import org.apache.ignite3.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite3.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite3.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.IgniteMath;
import org.apache.ignite3.internal.sql.engine.util.IgniteResource;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;
import org.apache.ignite3.internal.util.ArrayUtils;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.sql.SqlException;
import org.jetbrains.annotations.Nullable;

public class LogicalRelImplementor<RowT>
implements IgniteRelVisitor<Node<RowT>> {
    private static final EnumSet<JoinRelType> JOIN_NEEDS_PROJECTION = EnumSet.of(JoinRelType.INNER, JoinRelType.LEFT, JoinRelType.FULL, JoinRelType.RIGHT);
    private static final Comparator<IntPair> CONDITION_PAIRS_COMPARATOR = Comparator.comparingInt(l -> Math.max(l.source, l.target)).thenComparingInt(l -> Math.min(l.source, l.target));
    public static final String CNLJ_NOT_SUPPORTED_JOIN_ASSERTION_MSG = "only INNER and LEFT join supported by IgniteCorrelatedNestedLoop";
    private final ExecutionContext<RowT> ctx;
    private final DestinationFactory<RowT> destinationFactory;
    private final ExchangeService exchangeSvc;
    private final MailboxRegistry mailboxRegistry;
    private final ExpressionFactory<RowT> expressionFactory;
    private final ResolvedDependencies resolvedDependencies;
    private final TableFunctionRegistry tableFunctionRegistry;
    @Nullable
    private List<RexNode> projectionToFuse;

    public LogicalRelImplementor(ExecutionContext<RowT> ctx, MailboxRegistry mailboxRegistry, ExchangeService exchangeSvc, ResolvedDependencies resolvedDependencies, TableFunctionRegistry tableFunctionRegistry) {
        this.mailboxRegistry = mailboxRegistry;
        this.exchangeSvc = exchangeSvc;
        this.ctx = ctx;
        this.resolvedDependencies = resolvedDependencies;
        this.tableFunctionRegistry = tableFunctionRegistry;
        this.expressionFactory = ctx.expressionFactory();
        this.destinationFactory = new DestinationFactory<RowT>(ctx.rowHandler(), resolvedDependencies);
    }

    @Override
    public Node<RowT> visit(IgniteSender rel) {
        IgniteDistribution distribution = rel.distribution();
        ColocationGroup targetGroup = this.ctx.target();
        assert (targetGroup != null);
        Destination<RowT> dest = this.destinationFactory.createDestination(distribution, targetGroup);
        Outbox<RowT> outbox = new Outbox<RowT>(this.ctx, this.exchangeSvc, this.mailboxRegistry, rel.exchangeId(), rel.targetFragmentId(), dest);
        Node<RowT> input = this.visit(rel.getInput());
        outbox.register(input);
        this.mailboxRegistry.register(outbox);
        return outbox;
    }

    @Override
    public Node<RowT> visit(IgniteFilter rel) {
        SqlPredicate<RowT> sqlPredicate = this.expressionFactory.predicate(rel.getCondition(), rel.getRowType());
        Predicate<Object> pred = row -> sqlPredicate.test(this.ctx, row);
        FilterNode<Object> node = new FilterNode<Object>(this.ctx, pred);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteTrimExchange rel) {
        assert (TraitUtils.distribution((RelNode)rel).getType() == RelDistribution.Type.HASH_DISTRIBUTED);
        ColocationGroup targetGroup = this.ctx.group(rel.sourceId());
        assert (targetGroup != null);
        Destination dest = this.destinationFactory.createDestination(rel.distribution(), targetGroup);
        String localNodeName = this.ctx.localNode().name();
        FilterNode<Object> node = new FilterNode<Object>(this.ctx, r -> Objects.equals(localNodeName, CollectionUtils.first(dest.targets(r))));
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteProject rel) {
        if (this.projectionToFuse == null && LogicalRelImplementor.canFuseProjectionInto(rel.getInput())) {
            this.projectionToFuse = rel.getProjects();
            return this.visit(rel.getInput());
        }
        SqlProjection<RowT> sqlProjection = this.expressionFactory.project(rel.getProjects(), rel.getInput().getRowType());
        Function<Object, Object> prj = row -> sqlProjection.project(this.ctx, row);
        ProjectNode<Object> node = new ProjectNode<Object>(this.ctx, prj);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteNestedLoopJoin rel) {
        RelDataType outType = rel.getRowType();
        RelDataType leftType = rel.getLeft().getRowType();
        RelDataType rightType = rel.getRight().getRowType();
        JoinRelType joinType = rel.getJoinType();
        SqlJoinProjection<RowT> joinProjection = this.createJoinProjection(rel, outType, leftType.getFieldCount());
        RelDataType rowType = TypeUtils.combinedRowType(this.ctx.getTypeFactory(), leftType, rightType);
        SqlJoinPredicate<RowT> joinPredicate = this.expressionFactory.joinPredicate(rel.getCondition(), rowType, leftType.getFieldCount());
        BiPredicate<Object, Object> cond = (left, right) -> joinPredicate.test(this.ctx, left, right);
        NestedLoopJoinNode<Object> node = NestedLoopJoinNode.create(this.ctx, joinProjection, leftType, rightType, joinType, cond);
        Node<RowT> leftInput = this.visit(rel.getLeft());
        Node<RowT> rightInput = this.visit(rel.getRight());
        node.register(ArrayUtils.asList(leftInput, rightInput));
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteHashJoin rel) {
        RelDataType outType = rel.getRowType();
        RelDataType leftType = rel.getLeft().getRowType();
        RelDataType rightType = rel.getRight().getRowType();
        JoinRelType joinType = rel.getJoinType();
        SqlJoinProjection<RowT> joinProjection = this.createJoinProjection(rel, outType, leftType.getFieldCount());
        RexNode nonEquiConditionExpression = RexUtil.composeConjunction((RexBuilder)Commons.rexBuilder(), (Iterable)rel.analyzeCondition().nonEquiConditions, (boolean)true);
        BiPredicate<Object, Object> nonEquiCondition = null;
        if (nonEquiConditionExpression != null) {
            RelDataType rowType = TypeUtils.combinedRowType(this.ctx.getTypeFactory(), leftType, rightType);
            SqlJoinPredicate<RowT> nonEquiPredicate = this.expressionFactory.joinPredicate(rel.getCondition(), rowType, leftType.getFieldCount());
            nonEquiCondition = (left, right) -> nonEquiPredicate.test(this.ctx, left, right);
        }
        HashJoinNode node = HashJoinNode.create(this.ctx, joinProjection, leftType, rightType, joinType, rel.analyzeCondition(), nonEquiCondition);
        Node<RowT> leftInput = this.visit(rel.getLeft());
        Node<RowT> rightInput = this.visit(rel.getRight());
        node.register(ArrayUtils.asList(leftInput, rightInput));
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteCorrelatedNestedLoopJoin rel) {
        RelDataType outType = rel.getRowType();
        RelDataType leftType = rel.getLeft().getRowType();
        RelDataType rightType = rel.getRight().getRowType();
        RowSchema rightRowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rightType));
        assert (rel.getJoinType() == JoinRelType.INNER || rel.getJoinType() == JoinRelType.LEFT) : "only INNER and LEFT join supported by IgniteCorrelatedNestedLoop";
        SqlJoinProjection<RowT> joinProjection = this.createJoinProjection(rel, outType, leftType.getFieldCount());
        assert (joinProjection != null);
        SqlJoinPredicate<RowT> joinPredicate = this.expressionFactory.joinPredicate(rel.getCondition(), outType, leftType.getFieldCount());
        BiPredicate<Object, Object> cond = (left, right) -> joinPredicate.test(this.ctx, left, right);
        RowHandler.RowFactory<RowT> rightRowFactory = this.ctx.rowHandler().factory(rightRowSchema);
        CorrelatedNestedLoopJoinNode<Object> node = new CorrelatedNestedLoopJoinNode<Object>(this.ctx, cond, rel.getVariablesSet(), rel.getJoinType(), rightRowFactory, joinProjection);
        Node<RowT> leftInput = this.visit(rel.getLeft());
        Node<RowT> rightInput = this.visit(rel.getRight());
        node.register(ArrayUtils.asList(leftInput, rightInput));
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteMergeJoin rel) {
        RelDataType leftType = rel.getLeft().getRowType();
        RelDataType rightType = rel.getRight().getRowType();
        JoinRelType joinType = rel.getJoinType();
        SqlJoinProjection<RowT> joinProjection = this.createJoinProjection(rel, rel.getRowType(), leftType.getFieldCount());
        ImmutableBitSet nullCompAsEqual = LogicalRelImplementor.nullComparisonStrategyVector(rel, rel.analyzeCondition().leftSet());
        ImmutableIntList leftKeys = rel.leftCollation().getKeys();
        ImmutableIntList rightKeys = rel.rightCollation().getKeys();
        List conditionPairs = rel.analyzeCondition().pairs();
        ArrayList<IntPair> condIndexes = new ArrayList<IntPair>(conditionPairs.size());
        for (IntPair pair : conditionPairs) {
            condIndexes.add(IntPair.of((int)leftKeys.indexOf(pair.source), (int)rightKeys.indexOf(pair.target)));
        }
        condIndexes.sort(CONDITION_PAIRS_COMPARATOR);
        int conditions = condIndexes.size();
        ArrayList<RelFieldCollation> leftCollation = new ArrayList<RelFieldCollation>(conditions);
        ArrayList<RelFieldCollation> rightCollation = new ArrayList<RelFieldCollation>(conditions);
        for (IntPair pair : condIndexes) {
            leftCollation.add((RelFieldCollation)rel.leftCollation().getFieldCollations().get(pair.source));
            rightCollation.add((RelFieldCollation)rel.rightCollation().getFieldCollations().get(pair.target));
        }
        if (IgniteUtils.assertionsEnabled()) {
            LogicalRelImplementor.ensureComparatorCollationSatisfiesSourceCollation(leftCollation, leftKeys, "Left");
            LogicalRelImplementor.ensureComparatorCollationSatisfiesSourceCollation(rightCollation, rightKeys, "Right");
        }
        SqlComparator<RowT> sqlComparator = this.expressionFactory.comparator(leftCollation, rightCollation, nullCompAsEqual);
        Comparator comp = (r1, r2) -> sqlComparator.compare(this.ctx, r1, r2);
        MergeJoinNode node = MergeJoinNode.create(this.ctx, leftType, rightType, joinType, comp, joinProjection);
        Node<RowT> leftInput = this.visit(rel.getLeft());
        Node<RowT> rightInput = this.visit(rel.getRight());
        node.register(ArrayUtils.asList(leftInput, rightInput));
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteIndexScan rel) {
        IgniteTable tbl = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
        IgniteTypeFactory typeFactory = this.ctx.getTypeFactory();
        ImmutableIntList requiredColumns = rel.requiredColumns();
        RelDataType rowType = tbl.getRowType((RelDataTypeFactory)typeFactory, requiredColumns);
        ScannableTable scannableTable = this.resolvedDependencies.scannableTable(tbl.id());
        IgniteIndex idx = tbl.indexes().get(rel.indexName());
        List<SearchBounds> searchBounds = rel.searchBounds();
        RexNode condition = rel.condition();
        List<RexNode> projects = rel.projects();
        Predicate<Object> filters = null;
        if (condition != null) {
            SqlPredicate<RowT> sqlPredicate = this.expressionFactory.predicate(condition, rowType);
            filters = row -> sqlPredicate.test(this.ctx, row);
        }
        Function<Object, Object> prj = null;
        if (projects != null) {
            SqlProjection<RowT> sqlProjection = this.expressionFactory.project(projects, rowType);
            prj = row -> sqlProjection.project(this.ctx, row);
        }
        RangeIterable<RowT> ranges = null;
        if (searchBounds != null) {
            SqlComparator<RowT> searchRowComparator = idx.type() == IgniteIndex.Type.SORTED ? this.expressionFactory.comparator(IgniteIndex.createSearchRowCollation(idx.collation())) : null;
            ranges = this.expressionFactory.ranges(searchBounds, idx.rowType(typeFactory, tbl.descriptor()), searchRowComparator).get(this.ctx);
        }
        RelCollation collation = rel.collation();
        ColocationGroup group = this.ctx.group(rel.sourceId());
        assert (group != null);
        Comparator comp = null;
        if (idx.type() == IgniteIndex.Type.SORTED && collation != null && !CollectionUtils.nullOrEmpty(collation.getFieldCollations())) {
            RelCollation partitionStreamCollation;
            if (projects != null) {
                partitionStreamCollation = idx.collation();
                if (rel.requiredColumns() != null) {
                    Mappings.TargetMapping mapping = LogicalScanConverterRule.createMapping(null, rel.requiredColumns(), tbl.getRowType((RelDataTypeFactory)typeFactory).getFieldCount());
                    partitionStreamCollation = (RelCollation)partitionStreamCollation.apply(mapping);
                }
            } else {
                partitionStreamCollation = collation;
            }
            SqlComparator<RowT> searchRowComparator = this.expressionFactory.comparator(partitionStreamCollation);
            comp = (r1, r2) -> searchRowComparator.compare(this.ctx, r1, r2);
        }
        if (!group.nodeNames().contains(this.ctx.localNode().name())) {
            return new ScanNode<RowT>(this.ctx, Collections.emptyList());
        }
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        PartitionProvider<RowT> partitionProvider = this.ctx.getPartitionProvider(rel.sourceId(), group, tbl);
        return new IndexScanNode<Object>(this.ctx, rowFactory, idx, scannableTable, tbl.descriptor(), partitionProvider, comp, ranges, filters, prj, requiredColumns);
    }

    @Override
    public Node<RowT> visit(IgniteTableScan rel) {
        RexNode condition = rel.condition();
        List<RexNode> projects = rel.projects();
        ImmutableIntList requiredColumns = rel.requiredColumns();
        IgniteTable tbl = (IgniteTable)rel.getTable().unwrapOrThrow(IgniteTable.class);
        ScannableTable scannableTable = this.resolvedDependencies.scannableTable(tbl.id());
        IgniteTypeFactory typeFactory = this.ctx.getTypeFactory();
        RelDataType rowType = tbl.getRowType((RelDataTypeFactory)typeFactory, requiredColumns);
        Predicate<Object> filters = null;
        if (condition != null) {
            SqlPredicate<RowT> sqlPredicate = this.expressionFactory.predicate(condition, rowType);
            filters = row -> sqlPredicate.test(this.ctx, row);
        }
        Function<Object, Object> prj = null;
        if (projects != null) {
            SqlProjection<RowT> sqlProjection = this.expressionFactory.project(projects, rowType);
            prj = row -> sqlProjection.project(this.ctx, row);
        }
        long sourceId = rel.sourceId();
        ColocationGroup group = this.ctx.group(sourceId);
        assert (group != null);
        if (!group.nodeNames().contains(this.ctx.localNode().name())) {
            return new ScanNode<RowT>(this.ctx, Collections.emptyList());
        }
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        PartitionProvider<RowT> partitionProvider = this.ctx.getPartitionProvider(rel.sourceId(), group, tbl);
        return new TableScanNode<Object>(this.ctx, rowFactory, scannableTable, partitionProvider, filters, prj, requiredColumns);
    }

    @Override
    public Node<RowT> visit(IgniteSystemViewScan rel) {
        RexNode condition = rel.condition();
        List<RexNode> projects = rel.projects();
        ImmutableIntList requiredColumns = rel.requiredColumns();
        IgniteDataSource igniteDataSource = (IgniteDataSource)rel.getTable().unwrapOrThrow(IgniteDataSource.class);
        BinaryTupleSchema schema = LogicalRelImplementor.fromTableDescriptor(igniteDataSource.descriptor());
        ScannableDataSource dataSource = this.resolvedDependencies.dataSource(igniteDataSource.id());
        IgniteTypeFactory typeFactory = this.ctx.getTypeFactory();
        RelDataType rowType = igniteDataSource.getRowType((RelDataTypeFactory)typeFactory, requiredColumns);
        Predicate<Object> filters = null;
        if (condition != null) {
            SqlPredicate<RowT> sqlPredicate = this.expressionFactory.predicate(condition, rowType);
            filters = row -> sqlPredicate.test(this.ctx, row);
        }
        Function<Object, Object> prj = null;
        if (projects != null) {
            SqlProjection<RowT> sqlProjection = this.expressionFactory.project(projects, rowType);
            prj = row -> sqlProjection.project(this.ctx, row);
        }
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        return new DataSourceScanNode<Object>(this.ctx, rowFactory, schema, dataSource, filters, prj, requiredColumns);
    }

    @Override
    public Node<RowT> visit(IgniteValues rel) {
        List<List<RexLiteral>> vals = Commons.cast(rel.getTuples());
        RelDataType rowType = rel.getRowType();
        return new ScanNode<RowT>(this.ctx, (Iterable)this.expressionFactory.values(vals, rowType).get(this.ctx));
    }

    @Override
    public Node<RowT> visit(IgniteUnionAll rel) {
        UnionAllNode node = new UnionAllNode(this.ctx);
        List inputs = Commons.transform(rel.getInputs(), this::visit);
        node.register(inputs);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteLimit rel) {
        long offset = rel.offset() == null ? 0L : this.validateAndGetFetchOffsetParams(rel.offset(), "offset");
        long fetch = rel.fetch() == null ? -1L : this.validateAndGetFetchOffsetParams(rel.fetch(), "fetch");
        LimitNode<RowT> node = new LimitNode<RowT>(this.ctx, offset, fetch);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteSort rel) {
        RelCollation collation = rel.getCollation();
        long offset = rel.offset == null ? 0L : this.validateAndGetFetchOffsetParams(rel.offset, "offset");
        long fetch = rel.fetch == null ? -1L : this.validateAndGetFetchOffsetParams(rel.fetch, "fetch");
        SqlComparator<RowT> sqlComparator = this.expressionFactory.comparator(collation);
        SortNode<RowT> node = new SortNode<RowT>(this.ctx, (r1, r2) -> sqlComparator.compare(this.ctx, r1, r2), offset, fetch);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteTableSpool rel) {
        TableSpoolNode<RowT> node = new TableSpoolNode<RowT>(this.ctx, rel.readType == Spool.Type.LAZY);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteSortedIndexSpool rel) {
        RelCollation collation = rel.collation();
        assert (rel.searchBounds() != null) : rel;
        SqlPredicate<RowT> sqlPredicate = this.expressionFactory.predicate(rel.condition(), rel.getRowType());
        Predicate<Object> filter = row -> sqlPredicate.test(this.ctx, row);
        SqlComparator<RowT> comparator = this.expressionFactory.comparator(collation);
        RangeIterable<RowT> ranges = this.expressionFactory.ranges(rel.searchBounds(), rel.getRowType(), comparator).get(this.ctx);
        IndexSpoolNode<Object> node = IndexSpoolNode.createTreeSpool(this.ctx, rel.getRowType(), collation, (r1, r2) -> comparator.compare(this.ctx, r1, r2), filter, ranges);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteHashIndexSpool rel) {
        SqlRowProvider<RowT> rowProvider = this.expressionFactory.rowSource(rel.searchRow());
        Supplier<Object> searchRow = () -> rowProvider.get(this.ctx);
        SqlPredicate<RowT> sqlPredicate = this.expressionFactory.predicate(rel.condition(), rel.getRowType());
        Predicate<Object> filter = row -> sqlPredicate.test(this.ctx, row);
        IndexSpoolNode<Object> node = IndexSpoolNode.createHashSpool(this.ctx, ImmutableBitSet.of((Iterable)rel.keys()), filter, searchRow, rel.allowNulls());
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteSetOp rel) {
        AbstractSetOpNode node;
        RelDataType rowType = rel.getRowType();
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        List inputs = Commons.transform(rel.getInputs(), this::visit);
        int columnNum = rel instanceof IgniteMapSetOp ? rel.getInput(0).getRowType().getFieldCount() : rowType.getFieldCount();
        if (rel instanceof Minus) {
            node = new MinusNode(this.ctx, columnNum, rel.aggregateType(), rel.all(), rowFactory);
        } else if (rel instanceof IgniteIntersect) {
            int inputsNum;
            if (rel instanceof IgniteReduceIntersect) {
                int inputCols = rel.getInput(0).getRowType().getFieldCount();
                int outputCols = rel.getRowType().getFieldCount();
                inputsNum = inputCols - outputCols;
            } else {
                inputsNum = rel.getInputs().size();
            }
            node = new IntersectNode<RowT>(this.ctx, columnNum, rel.aggregateType(), rel.all(), rowFactory, inputsNum);
        } else {
            throw new AssertionError((Object)("Unexpected set node: " + rel));
        }
        node.register(inputs);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteTableFunctionScan rel) {
        TableFunction<RowT> tableFunction = this.tableFunctionRegistry.getTableFunction(this.ctx, (RexCall)rel.getCall());
        return new ScanNode<RowT>(this.ctx, tableFunction);
    }

    @Override
    public Node<RowT> visit(IgniteTableModify rel) {
        IgniteTable table = (IgniteTable)rel.getTable().unwrapOrThrow(IgniteTable.class);
        UpdatableTable updatableTable = this.resolvedDependencies.updatableTable(table.id());
        RelDataType rowType = rel.getInput().getRowType();
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        ModifyNode<RowT> node = new ModifyNode<RowT>(this.ctx, updatableTable, rel.sourceId(), rel.getOperation(), rel.getUpdateColumnList(), rowFactory);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteReceiver rel) {
        RelDataType rowType = rel.getRowType();
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        RelCollation collation = rel.collation();
        Comparator comp = null;
        if (collation != null && !CollectionUtils.nullOrEmpty(collation.getFieldCollations())) {
            SqlComparator<RowT> searchRowComparator = this.expressionFactory.comparator(collation);
            comp = (r1, r2) -> searchRowComparator.compare(this.ctx, r1, r2);
        }
        Inbox<RowT> inbox = new Inbox<RowT>(this.ctx, this.exchangeSvc, this.mailboxRegistry, this.ctx.remotes(rel.exchangeId()), comp, rowFactory, rel.exchangeId(), rel.sourceFragmentId());
        this.mailboxRegistry.register(inbox);
        return inbox;
    }

    @Override
    public Node<RowT> visit(IgniteColocatedHashAggregate rel) {
        AggregateType type = AggregateType.SINGLE;
        RelDataType rowType = rel.getRowType();
        RelDataType inputType = rel.getInput().getRowType();
        List<Object> accumulators = rel.getAggCallList().isEmpty() ? List.of() : this.expressionFactory.accumulatorsFactory(type, rel.getAggCallList(), inputType).get(this.ctx);
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        HashAggregateNode<RowT> node = new HashAggregateNode<RowT>(this.ctx, type, (List<ImmutableBitSet>)rel.getGroupSets(), accumulators, rowFactory);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteMapHashAggregate rel) {
        AggregateType type = AggregateType.MAP;
        RelDataType rowType = rel.getRowType();
        RelDataType inputType = rel.getInput().getRowType();
        List<Object> accumulators = rel.getAggCallList().isEmpty() ? List.of() : this.expressionFactory.accumulatorsFactory(type, rel.getAggCallList(), inputType).get(this.ctx);
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        HashAggregateNode<RowT> node = new HashAggregateNode<RowT>(this.ctx, type, (List<ImmutableBitSet>)rel.getGroupSets(), accumulators, rowFactory);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteReduceHashAggregate rel) {
        AggregateType type = AggregateType.REDUCE;
        RelDataType rowType = rel.getRowType();
        List<Object> accumulators = rel.getAggregateCalls().isEmpty() ? List.of() : this.expressionFactory.accumulatorsFactory(type, rel.getAggregateCalls(), rel.getInput().getRowType()).get(this.ctx);
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        HashAggregateNode<RowT> node = new HashAggregateNode<RowT>(this.ctx, type, rel.getGroupSets(), accumulators, rowFactory);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteColocatedSortAggregate rel) {
        AggregateType type = AggregateType.SINGLE;
        RelDataType rowType = rel.getRowType();
        RelDataType inputType = rel.getInput().getRowType();
        List<Object> accumulators = rel.getAggCallList().isEmpty() ? List.of() : this.expressionFactory.accumulatorsFactory(type, rel.getAggCallList(), inputType).get(this.ctx);
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        RelCollation collation = rel.collation();
        Comparator comp = null;
        if (collation != null && !CollectionUtils.nullOrEmpty(collation.getFieldCollations())) {
            SqlComparator<RowT> searchRowComparator = this.expressionFactory.comparator(collation);
            comp = (r1, r2) -> searchRowComparator.compare(this.ctx, r1, r2);
        }
        if (rel.getGroupSet().isEmpty() && comp == null) {
            comp = (k1, k2) -> 0;
        }
        SortAggregateNode<RowT> node = new SortAggregateNode<RowT>(this.ctx, type, rel.getGroupSet(), accumulators, rowFactory, comp);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteMapSortAggregate rel) {
        AggregateType type = AggregateType.MAP;
        RelDataType rowType = rel.getRowType();
        RelDataType inputType = rel.getInput().getRowType();
        List<Object> accumulators = rel.getAggCallList().isEmpty() ? List.of() : this.expressionFactory.accumulatorsFactory(type, rel.getAggCallList(), inputType).get(this.ctx);
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        RelCollation collation = rel.collation();
        Comparator comp = null;
        if (collation != null && !CollectionUtils.nullOrEmpty(collation.getFieldCollations())) {
            SqlComparator<RowT> searchRowComparator = this.expressionFactory.comparator(collation);
            comp = (r1, r2) -> searchRowComparator.compare(this.ctx, r1, r2);
        }
        if (rel.getGroupSet().isEmpty() && comp == null) {
            comp = (k1, k2) -> 0;
        }
        SortAggregateNode<RowT> node = new SortAggregateNode<RowT>(this.ctx, type, rel.getGroupSet(), accumulators, rowFactory, comp);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteReduceSortAggregate rel) {
        AggregateType type = AggregateType.REDUCE;
        RelDataType rowType = rel.getRowType();
        List<Object> accumulators = rel.getAggregateCalls().isEmpty() ? List.of() : this.expressionFactory.accumulatorsFactory(type, rel.getAggregateCalls(), rel.getInput().getRowType()).get(this.ctx);
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        RelCollation collation = rel.collation();
        Comparator comp = null;
        if (collation != null && !CollectionUtils.nullOrEmpty(collation.getFieldCollations())) {
            SqlComparator<RowT> searchRowComparator = this.expressionFactory.comparator(collation);
            comp = (r1, r2) -> searchRowComparator.compare(this.ctx, r1, r2);
        }
        if (rel.getGroupSet().isEmpty() && comp == null) {
            comp = (k1, k2) -> 0;
        }
        SortAggregateNode<RowT> node = new SortAggregateNode<RowT>(this.ctx, type, rel.getGroupSet(), accumulators, rowFactory, comp);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteRel rel) {
        return (Node)rel.accept(this);
    }

    @Override
    public Node<RowT> visit(IgniteExchange rel) {
        throw new AssertionError(rel.getClass());
    }

    @Override
    public Node<RowT> visit(IgniteKeyValueGet rel) {
        throw new AssertionError(rel.getClass());
    }

    @Override
    public Node<RowT> visit(IgniteKeyValueModify rel) {
        throw new AssertionError(rel.getClass());
    }

    @Override
    public Node<RowT> visit(IgniteSelectCount rel) {
        throw new AssertionError(rel.getClass());
    }

    private Node<RowT> visit(RelNode rel) {
        return this.visit((IgniteRel)rel);
    }

    public <T extends Node<RowT>> T go(IgniteRel rel) {
        return (T)this.visit(rel);
    }

    private static BinaryTupleSchema fromTableDescriptor(TableDescriptor descriptor) {
        BinaryTupleSchema.Element[] elements = new BinaryTupleSchema.Element[descriptor.columnsCount()];
        int idx = 0;
        for (ColumnDescriptor column : descriptor) {
            elements[idx++] = new BinaryTupleSchema.Element(column.physicalType(), column.nullable());
        }
        return BinaryTupleSchema.create(elements);
    }

    private static boolean canFuseProjectionInto(RelNode rel) {
        if (rel instanceof Join) {
            Join join = (Join)rel;
            return JOIN_NEEDS_PROJECTION.contains(join.getJoinType());
        }
        return false;
    }

    @Nullable
    private SqlJoinProjection<RowT> createJoinProjection(Join rel, RelDataType outType, int leftRowSize) {
        SqlJoinProjection<RowT> joinProjection = null;
        if (this.projectionToFuse != null) {
            assert (JOIN_NEEDS_PROJECTION.contains(rel.getJoinType()));
            joinProjection = this.expressionFactory.joinProject(this.projectionToFuse, outType, leftRowSize);
            this.projectionToFuse = null;
        } else if (JOIN_NEEDS_PROJECTION.contains(rel.getJoinType())) {
            List identityProjection = rel.getCluster().getRexBuilder().identityProjects(outType);
            joinProjection = this.expressionFactory.joinProject(identityProjection, outType, leftRowSize);
        }
        return joinProjection;
    }

    private long validateAndGetFetchOffsetParams(RexNode node, String op) {
        long paramAsLong;
        SqlScalar sqlScalar = this.expressionFactory.scalar(node);
        Number param = (Number)sqlScalar.get(this.ctx);
        try {
            paramAsLong = IgniteMath.convertToLongExact(param);
        }
        catch (RuntimeException ex) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, IgniteResource.INSTANCE.illegalFetchLimit(op).str(), (Throwable)ex);
        }
        if (paramAsLong < 0L) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, IgniteResource.INSTANCE.illegalFetchLimit(op).str());
        }
        return paramAsLong;
    }

    private static ImmutableBitSet nullComparisonStrategyVector(IgniteMergeJoin rel, final ImmutableBitSet leftKeys) {
        final ImmutableBitSet.Builder nullCompAsEqualBuilder = ImmutableBitSet.builder();
        RexShuttle shuttle = new RexShuttle(){

            public RexNode visitInputRef(RexInputRef ref) {
                int idx = ref.getIndex();
                if (leftKeys.get(idx)) {
                    nullCompAsEqualBuilder.set(idx);
                }
                return ref;
            }
        };
        List conjunctions = RelOptUtil.conjunctions((RexNode)rel.getCondition());
        for (RexNode expr : conjunctions) {
            if (expr.getKind() != SqlKind.IS_NOT_DISTINCT_FROM) continue;
            shuttle.apply(expr);
        }
        return nullCompAsEqualBuilder.build();
    }

    private static void ensureComparatorCollationSatisfiesSourceCollation(List<RelFieldCollation> compCollation, ImmutableIntList collationKeys, String name) {
        int[] effectiveCollation = compCollation.stream().mapToInt(RelFieldCollation::getFieldIndex).distinct().toArray();
        assert (effectiveCollation.length <= collationKeys.size()) : name + " effective collation size mismatch";
        int[] keysPrefix = collationKeys.stream().mapToInt(Integer::intValue).limit(effectiveCollation.length).toArray();
        assert (Arrays.equals(effectiveCollation, keysPrefix)) : name + " collation mismatch the source collation";
    }
}

