/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql.fun;

import java.util.Map;
import java.util.Set;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;

public class SqlDateTimeIntervalTypeChecker
implements SqlOperandTypeChecker {
    private static final Map<SqlTypeName, Set<SqlTypeName>> MATCHING_INTERVAL_TYPES = Map.of(SqlTypeName.TIME, SqlTypeName.DAY_INTERVAL_TYPES, SqlTypeName.DATE, SqlTypeName.INTERVAL_TYPES, SqlTypeName.TIMESTAMP, SqlTypeName.INTERVAL_TYPES, SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, SqlTypeName.INTERVAL_TYPES);
    private static final SqlOperandCountRange TWO_OPERANDS = SqlOperandCountRanges.of((int)2);
    private final boolean dateTimeFirst;

    SqlDateTimeIntervalTypeChecker(boolean dateTimeFirst) {
        this.dateTimeFirst = dateTimeFirst;
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        assert (callBinding.getOperandCount() == 2);
        boolean result = this.doCheckOperandTypes(callBinding);
        if (!result && throwOnFailure) {
            throw callBinding.newValidationSignatureError();
        }
        return result;
    }

    private boolean doCheckOperandTypes(SqlCallBinding callBinding) {
        SqlTypeName intervalType;
        SqlTypeName dateTimeType;
        RelDataType t1 = callBinding.getOperandType(0);
        RelDataType t2 = callBinding.getOperandType(1);
        if (this.dateTimeFirst) {
            if (!SqlTypeUtil.isDatetime((RelDataType)t1) || !SqlTypeUtil.isInterval((RelDataType)t2)) {
                return false;
            }
            dateTimeType = t1.getSqlTypeName();
            intervalType = t2.getSqlTypeName();
        } else {
            if (!SqlTypeUtil.isInterval((RelDataType)t1) || !SqlTypeUtil.isDatetime((RelDataType)t2)) {
                return false;
            }
            intervalType = t1.getSqlTypeName();
            dateTimeType = t2.getSqlTypeName();
        }
        Set<SqlTypeName> intervalTypes = MATCHING_INTERVAL_TYPES.get(dateTimeType);
        return intervalTypes != null && intervalTypes.contains(intervalType);
    }

    public SqlOperandCountRange getOperandCountRange() {
        return TWO_OPERANDS;
    }

    public String getAllowedSignatures(SqlOperator op, String opName) {
        if (this.dateTimeFirst) {
            return IgniteStringFormatter.format("'<DATETIME> {} <INTERVAL>'", op.getName());
        }
        return IgniteStringFormatter.format("'<INTERVAL> {} <DATETIME>'", op.getName());
    }
}

