/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.util.format;

import java.time.DateTimeException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.sql.engine.util.format.DateTimeFormatElement;
import org.apache.ignite3.internal.sql.engine.util.format.DateTimeTemplateField;

final class Scanner {
    private static final Map<String, DateTimeTemplateField> FIELDS_BY_PATTERN = new HashMap<String, DateTimeTemplateField>();
    private final String pattern;
    private final Set<DateTimeTemplateField.FieldKind> allowedFields;
    private final String formatName;
    private final List<DateTimeFormatElement> elements = new ArrayList<DateTimeFormatElement>();
    private final EnumSet<DateTimeTemplateField> fields = EnumSet.noneOf(DateTimeTemplateField.class);
    private final EnumSet<DateTimeTemplateField.FieldKind> groups = EnumSet.noneOf(DateTimeTemplateField.FieldKind.class);
    private int start;
    private int current;

    Scanner(String pattern) {
        this(pattern, "ALL_FIELDS", EnumSet.allOf(DateTimeTemplateField.FieldKind.class));
    }

    Scanner(String pattern, String formatName, Set<DateTimeTemplateField.FieldKind> allowedFields) {
        Objects.requireNonNull(pattern, "pattern");
        Objects.requireNonNull(formatName, "formatName");
        Objects.requireNonNull(allowedFields, "allowedFields");
        this.pattern = pattern.toUpperCase(Locale.US);
        this.formatName = formatName;
        this.allowedFields = allowedFields;
    }

    List<DateTimeFormatElement> scan() {
        while (!this.atEnd()) {
            this.start = this.current;
            this.scanToken();
        }
        this.validateFields();
        return this.elements;
    }

    private boolean atEnd() {
        return this.current >= this.pattern.length();
    }

    private void scanToken() {
        char c = this.advance();
        switch (c) {
            case ' ': 
            case '\'': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': {
                this.addDelimiter(c);
                break;
            }
            default: {
                if (Scanner.isAlpha(c)) {
                    this.addField(c);
                    break;
                }
                throw Scanner.formatError("Unexpected character <{}> in pattern <{}>", Character.valueOf(c), this.pattern);
            }
        }
    }

    private void addField(char c) {
        switch (c) {
            case 'Y': {
                if (!this.match("YYYY") && !this.match("YYY") && !this.match("YY") && !this.match("Y")) break;
                this.doAddField();
                return;
            }
            case 'R': {
                if (!this.match("RRRR") && !this.match("RR")) break;
                this.doAddField();
                return;
            }
            case 'M': {
                if (!this.match("MM") && !this.match("MI")) break;
                this.doAddField();
                return;
            }
            case 'D': {
                if (!this.match("DDD") && !this.match("DD")) break;
                this.doAddField();
                return;
            }
            case 'H': {
                if (!this.match("HH24") && !this.match("HH12") && !this.match("HH")) break;
                this.doAddField();
                return;
            }
            case 'S': {
                if (!this.match("SSSSS") && !this.match("SS")) break;
                this.doAddField();
                return;
            }
            case 'F': {
                if (!this.match("FF1") && !this.match("FF2") && !this.match("FF3") && !this.match("FF4") && !this.match("FF5") && !this.match("FF6") && !this.match("FF7") && !this.match("FF8") && !this.match("FF9")) break;
                this.doAddField();
                return;
            }
            case 'T': {
                if (!this.match("TZH") && !this.match("TZM")) break;
                this.doAddField();
                return;
            }
            default: {
                if (!this.match("A.M.") && !this.match("P.M.")) break;
                this.doAddField();
                return;
            }
        }
        while (Scanner.isAlphaNumeric(this.peek())) {
            this.advance();
        }
        throw Scanner.formatError("Unexpected element <{}> in pattern <{}>", this.pattern.substring(this.start, this.current), this.pattern);
    }

    private boolean match(String text) {
        if (this.pattern.charAt(this.start) != text.charAt(0)) {
            return false;
        }
        int pos = this.current;
        boolean matches = true;
        for (int i = 1; i < text.length(); ++i) {
            if (this.atEnd()) {
                matches = false;
                break;
            }
            char c = this.advance();
            if (c == text.charAt(i)) continue;
            matches = false;
            break;
        }
        if (!matches) {
            this.current = pos;
            return false;
        }
        return true;
    }

    private char advance() {
        ++this.current;
        return this.pattern.charAt(this.current - 1);
    }

    private char peek() {
        if (this.atEnd()) {
            return '\u0000';
        }
        return this.pattern.charAt(this.current);
    }

    private void addDelimiter(char c) {
        if (!this.elements.isEmpty()) {
            DateTimeFormatElement e = this.elements.get(this.elements.size() - 1);
            if (e.kind == DateTimeFormatElement.ElementKind.DELIMITER) {
                throw Scanner.formatError("Consecutive delimiters are not allowed", new Object[0]);
            }
        }
        this.elements.add(new DateTimeFormatElement(c));
    }

    private void doAddField() {
        boolean alreadyPresent;
        String token = this.pattern.substring(this.start, this.current);
        DateTimeTemplateField field = FIELDS_BY_PATTERN.get(token);
        if (field == null) {
            throw Scanner.formatError("Unexpected field <{}>", token);
        }
        DateTimeTemplateField.FieldKind dtField = field.kind();
        boolean bl = alreadyPresent = !this.groups.add(dtField);
        if (!this.allowedFields.contains((Object)dtField)) {
            throw Scanner.formatError("Illegal field <{}> for format {}", new Object[]{field, this.formatName});
        }
        if (dtField == DateTimeTemplateField.FieldKind.TIMEZONE) {
            boolean bl2 = alreadyPresent = !this.fields.add(field);
        }
        if (alreadyPresent) {
            throw Scanner.formatError("Element is already present: {}", new Object[]{dtField});
        }
        this.elements.add(new DateTimeFormatElement(field));
    }

    private static boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isAlphaNumeric(char c) {
        return Scanner.isAlpha(c) || Character.isDigit(c);
    }

    private void ensureOnlyOnePresent(DateTimeTemplateField.FieldKind f1, DateTimeTemplateField.FieldKind f2, String message) {
        if (this.groups.contains((Object)f1) && this.groups.contains((Object)f2)) {
            throw Scanner.formatError("Invalid format. Only one field must be present: {}", message);
        }
    }

    private void ensureBothPresent(DateTimeTemplateField.FieldKind f1, DateTimeTemplateField.FieldKind f2, String message) {
        if (this.groups.contains((Object)f1) != this.groups.contains((Object)f2)) {
            throw Scanner.formatError("Invalid format. Expected both fields: {}", message);
        }
    }

    private void validateFields() {
        this.ensureOnlyOnePresent(DateTimeTemplateField.FieldKind.YEAR, DateTimeTemplateField.FieldKind.ROUNDED_YEAR, "year / rounded year");
        this.ensureOnlyOnePresent(DateTimeTemplateField.FieldKind.DAY_OF_YEAR, DateTimeTemplateField.FieldKind.MONTH, "day of year / month");
        this.ensureOnlyOnePresent(DateTimeTemplateField.FieldKind.DAY_OF_YEAR, DateTimeTemplateField.FieldKind.DAY_OF_MONTH, "day of year / day of month");
        this.ensureOnlyOnePresent(DateTimeTemplateField.FieldKind.HOUR_24, DateTimeTemplateField.FieldKind.HOUR_12, "24-hour / 12-hour");
        this.ensureBothPresent(DateTimeTemplateField.FieldKind.HOUR_12, DateTimeTemplateField.FieldKind.AM_PM, "12-hour / am pm");
        this.ensureOnlyOnePresent(DateTimeTemplateField.FieldKind.HOUR_24, DateTimeTemplateField.FieldKind.AM_PM, "24-hour / am pm");
        this.ensureOnlyOnePresent(DateTimeTemplateField.FieldKind.SECOND_OF_DAY, DateTimeTemplateField.FieldKind.HOUR_12, "second of day / 12-hour");
        this.ensureOnlyOnePresent(DateTimeTemplateField.FieldKind.SECOND_OF_DAY, DateTimeTemplateField.FieldKind.HOUR_24, "second of day / 24-hour");
        this.ensureOnlyOnePresent(DateTimeTemplateField.FieldKind.SECOND_OF_DAY, DateTimeTemplateField.FieldKind.MINUTE, "second of day / minute");
        this.ensureOnlyOnePresent(DateTimeTemplateField.FieldKind.SECOND_OF_DAY, DateTimeTemplateField.FieldKind.SECOND_OF_MINUTE, "second of day / second of minute");
        if (this.fields.contains((Object)DateTimeTemplateField.TZH) != this.fields.contains((Object)DateTimeTemplateField.TZM)) {
            throw Scanner.formatError("Invalid format. Expected both fields: time zone hour / time zone minute", new Object[0]);
        }
    }

    private static DateTimeException formatError(String message, Object ... elements) {
        return new DateTimeException(IgniteStringFormatter.format(message, elements));
    }

    static {
        for (DateTimeTemplateField field : DateTimeTemplateField.values()) {
            FIELDS_BY_PATTERN.put(field.pattern(), field);
        }
    }
}

