/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.rocksdb.index;

import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.rocksdb.ColumnFamily;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.StorageRebalanceException;
import org.apache.ignite3.internal.storage.index.IndexStorage;
import org.apache.ignite3.internal.storage.index.PeekCursor;
import org.apache.ignite3.internal.storage.index.StorageIndexDescriptor;
import org.apache.ignite3.internal.storage.rocksdb.IgniteRocksDbException;
import org.apache.ignite3.internal.storage.rocksdb.PartitionDataHelper;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbMetaStorage;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbStorageUtils;
import org.apache.ignite3.internal.storage.util.StorageState;
import org.apache.ignite3.internal.storage.util.StorageUtils;
import org.apache.ignite3.internal.util.ArrayUtils;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.AbstractSlice;
import org.rocksdb.AbstractWriteBatch;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteBatchWithIndex;

public abstract class AbstractRocksDbIndexStorage
implements IndexStorage {
    public static final int PREFIX_WITH_IDS_LENGTH = 10;
    private final int tableId;
    private final int indexId;
    protected final StorageIndexDescriptor descriptor;
    protected final int partitionId;
    private final RocksDbMetaStorage indexMetaStorage;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    protected final AtomicReference<StorageState> state = new AtomicReference<StorageState>(StorageState.RUNNABLE);
    @Nullable
    private volatile RowId nextRowIdToBuild;

    AbstractRocksDbIndexStorage(StorageIndexDescriptor descriptor, int tableId, int partitionId, RocksDbMetaStorage indexMetaStorage) {
        this.tableId = tableId;
        this.indexId = descriptor.id();
        this.descriptor = descriptor;
        this.indexMetaStorage = indexMetaStorage;
        this.partitionId = partitionId;
        RowId rowIdFromMeta = indexMetaStorage.getNextRowIdToBuild(tableId, this.indexId, partitionId);
        if (rowIdFromMeta == null && descriptor.mustBeBuilt()) {
            rowIdFromMeta = StorageUtils.initialRowIdToBuild(partitionId);
        }
        this.nextRowIdToBuild = rowIdFromMeta;
    }

    @Override
    @Nullable
    public RowId getNextRowIdToBuild() {
        return this.busyNonDataRead(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance(this.state.get(), this::createStorageInfo);
            return this.nextRowIdToBuild;
        });
    }

    @Override
    public void setNextRowIdToBuild(@Nullable RowId rowId) {
        this.busyNonDataRead(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance(this.state.get(), this::createStorageInfo);
            WriteBatchWithIndex writeBatch = PartitionDataHelper.requireWriteBatch();
            this.indexMetaStorage.putNextRowIdToBuild((AbstractWriteBatch)writeBatch, this.tableId, this.indexId, this.partitionId, rowId);
            this.nextRowIdToBuild = rowId;
            return null;
        });
    }

    public void close() {
        if (!StorageUtils.transitionToClosedState(this.state, this::createStorageInfo)) {
            return;
        }
        this.busyLock.block();
    }

    public void transitionToDestroyedState() {
        if (!StorageUtils.transitionToDestroyedState(this.state)) {
            return;
        }
        this.busyLock.block();
    }

    public void startRebalance(WriteBatch writeBatch) {
        if (!this.state.compareAndSet(StorageState.RUNNABLE, StorageState.REBALANCE)) {
            StorageUtils.throwExceptionDependingOnStorageStateOnRebalance(this.state.get(), this.createStorageInfo());
        }
        this.busyLock.block();
        try {
            this.clearData(writeBatch);
        }
        catch (RocksDBException e) {
            throw new StorageRebalanceException("Error when trying to start rebalancing storage: " + this.createStorageInfo(), (Throwable)e);
        }
        finally {
            this.busyLock.unblock();
        }
    }

    public void abortRebalance(WriteBatch writeBatch) {
        if (!this.state.compareAndSet(StorageState.REBALANCE, StorageState.RUNNABLE)) {
            StorageUtils.throwExceptionDependingOnStorageStateOnRebalance(this.state.get(), this.createStorageInfo());
        }
        try {
            this.clearData(writeBatch);
        }
        catch (RocksDBException e) {
            throw new StorageRebalanceException("Error when trying to abort rebalancing storage: " + this.createStorageInfo(), (Throwable)e);
        }
    }

    public void finishRebalance() {
        if (!this.state.compareAndSet(StorageState.REBALANCE, StorageState.RUNNABLE)) {
            StorageUtils.throwExceptionDependingOnStorageStateOnRebalance(this.state.get(), this.createStorageInfo());
        }
    }

    public void startCleanup(WriteBatch writeBatch) throws RocksDBException {
        if (!this.state.compareAndSet(StorageState.RUNNABLE, StorageState.CLEANUP)) {
            StorageUtils.throwExceptionDependingOnStorageState(this.state.get(), this.createStorageInfo());
        }
        this.busyLock.block();
        this.clearData(writeBatch);
    }

    public void finishCleanup() {
        if (this.state.compareAndSet(StorageState.CLEANUP, StorageState.RUNNABLE)) {
            this.busyLock.unblock();
        }
    }

    <V> V busyNonDataRead(Supplier<V> supplier) {
        return this.busy(supplier, false);
    }

    <V> V busyDataRead(Supplier<V> supplier) {
        return this.busy(supplier, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V busy(Supplier<V> supplier, boolean read) {
        if (!this.busyLock.enterBusy()) {
            StorageUtils.throwExceptionDependingOnIndexStorageState(this.state.get(), read, this.createStorageInfo());
        }
        try {
            V v = supplier.get();
            return v;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    String createStorageInfo() {
        return IgniteStringFormatter.format("indexId={}, partitionId={}", this.indexId, this.partitionId);
    }

    public final void clearData(WriteBatch writeBatch) throws RocksDBException {
        this.clearIndex(writeBatch);
        if (this.descriptor.mustBeBuilt()) {
            this.resetNextRowIdToBuild(writeBatch);
        } else {
            this.removeNextRowIdToBuild(writeBatch);
        }
    }

    public final void destroyData(WriteBatch writeBatch) throws RocksDBException {
        this.clearIndex(writeBatch);
        this.removeNextRowIdToBuild(writeBatch);
    }

    private void resetNextRowIdToBuild(WriteBatch writeBatch) {
        RowId initialRowId = StorageUtils.initialRowIdToBuild(this.partitionId);
        this.indexMetaStorage.putNextRowIdToBuild((AbstractWriteBatch)writeBatch, this.tableId, this.indexId, this.partitionId, initialRowId);
        this.nextRowIdToBuild = initialRowId;
    }

    private void removeNextRowIdToBuild(WriteBatch writeBatch) {
        this.indexMetaStorage.removeNextRowIdToBuild((AbstractWriteBatch)writeBatch, this.tableId, this.indexId, this.partitionId);
        this.nextRowIdToBuild = null;
    }

    abstract void clearIndex(WriteBatch var1) throws RocksDBException;

    protected void throwExceptionIfIndexNotBuilt() {
        StorageUtils.throwExceptionIfIndexIsNotBuilt(this.nextRowIdToBuild, this::createStorageInfo);
    }

    protected abstract class UpToDatePeekCursor<T>
    implements PeekCursor<T> {
        private final Slice upperBoundSlice;
        private final byte[] lowerBound;
        private final ReadOptions options;
        private final RocksIterator it;
        @Nullable
        private Boolean hasNext;
        private byte @Nullable [] key;
        private byte @Nullable [] peekedKey = ArrayUtils.BYTE_EMPTY_ARRAY;

        UpToDatePeekCursor(byte[] upperBound, ColumnFamily indexCf, byte[] lowerBound) {
            this.lowerBound = lowerBound;
            this.upperBoundSlice = new Slice(upperBound);
            this.options = new ReadOptions().setIterateUpperBound((AbstractSlice)this.upperBoundSlice);
            this.it = indexCf.newIterator(this.options);
        }

        protected abstract T map(ByteBuffer var1);

        @Override
        public void close() {
            try {
                IgniteUtils.closeAll(new AutoCloseable[]{this.it, this.options, this.upperBoundSlice});
            }
            catch (Exception e) {
                throw new StorageException("Error closing cursor", (Throwable)e);
            }
        }

        @Override
        public boolean hasNext() {
            return AbstractRocksDbIndexStorage.this.busyDataRead(this::advanceIfNeededBusy);
        }

        @Override
        public T next() {
            return (T)AbstractRocksDbIndexStorage.this.busyDataRead(() -> {
                if (!this.advanceIfNeededBusy()) {
                    throw new NoSuchElementException();
                }
                this.hasNext = null;
                return this.map(ByteBuffer.wrap(this.key).order(RocksDbStorageUtils.KEY_BYTE_ORDER));
            });
        }

        @Override
        @Nullable
        public T peek() {
            return (T)AbstractRocksDbIndexStorage.this.busyDataRead(() -> {
                StorageUtils.throwExceptionIfStorageInProgressOfRebalance(AbstractRocksDbIndexStorage.this.state.get(), AbstractRocksDbIndexStorage.this::createStorageInfo);
                byte[] res = this.peekBusy();
                if (res == null) {
                    return null;
                }
                return this.map(ByteBuffer.wrap(res).order(RocksDbStorageUtils.KEY_BYTE_ORDER));
            });
        }

        private byte @Nullable [] peekBusy() {
            if (this.hasNext != null) {
                return this.key;
            }
            this.refreshAndPrepareRocksIteratorBusy();
            if (!this.it.isValid()) {
                try {
                    this.it.status();
                }
                catch (RocksDBException e) {
                    throw new IgniteRocksDbException(e);
                }
                this.peekedKey = null;
            } else {
                this.peekedKey = this.it.key();
            }
            return this.peekedKey;
        }

        private boolean advanceIfNeededBusy() throws StorageException {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance(AbstractRocksDbIndexStorage.this.state.get(), AbstractRocksDbIndexStorage.this::createStorageInfo);
            this.key = this.peekedKey == ArrayUtils.BYTE_EMPTY_ARRAY ? this.peekBusy() : this.peekedKey;
            this.peekedKey = ArrayUtils.BYTE_EMPTY_ARRAY;
            this.hasNext = this.key != null;
            return this.hasNext;
        }

        private void refreshAndPrepareRocksIteratorBusy() {
            try {
                this.it.refresh();
            }
            catch (RocksDBException e) {
                throw new IgniteRocksDbException("Error refreshing an iterator", e);
            }
            if (this.key == null) {
                this.it.seek(this.lowerBound);
            } else {
                this.it.seekForPrev(this.key);
                if (this.it.isValid()) {
                    this.it.next();
                } else {
                    try {
                        this.it.status();
                    }
                    catch (RocksDBException e) {
                        throw new IgniteRocksDbException(e);
                    }
                    this.it.seek(this.lowerBound);
                }
            }
        }
    }
}

