//*
// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.17.3
// source: MasterService.proto

package protocol

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type EventProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RebalanceId *int64 `protobuf:"varint,1,opt,name=rebalanceId" json:"rebalanceId,omitempty"`
	OpType      *int32 `protobuf:"varint,2,opt,name=opType" json:"opType,omitempty"`
	Status      *int32 `protobuf:"varint,3,opt,name=status" json:"status,omitempty"`
	// consumerId@group-brokerId:host:port-topic:partitionId
	SubscribeInfo []string `protobuf:"bytes,4,rep,name=subscribeInfo" json:"subscribeInfo,omitempty"`
}

func (x *EventProto) Reset() {
	*x = EventProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventProto) ProtoMessage() {}

func (x *EventProto) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventProto.ProtoReflect.Descriptor instead.
func (*EventProto) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{0}
}

func (x *EventProto) GetRebalanceId() int64 {
	if x != nil && x.RebalanceId != nil {
		return *x.RebalanceId
	}
	return 0
}

func (x *EventProto) GetOpType() int32 {
	if x != nil && x.OpType != nil {
		return *x.OpType
	}
	return 0
}

func (x *EventProto) GetStatus() int32 {
	if x != nil && x.Status != nil {
		return *x.Status
	}
	return 0
}

func (x *EventProto) GetSubscribeInfo() []string {
	if x != nil {
		return x.SubscribeInfo
	}
	return nil
}

type EnableBrokerFunInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EnableConsumeAuthenticate *bool `protobuf:"varint,1,req,name=enableConsumeAuthenticate" json:"enableConsumeAuthenticate,omitempty"`
	EnableConsumeAuthorize    *bool `protobuf:"varint,2,req,name=enableConsumeAuthorize" json:"enableConsumeAuthorize,omitempty"`
	EnableProduceAuthenticate *bool `protobuf:"varint,3,req,name=enableProduceAuthenticate" json:"enableProduceAuthenticate,omitempty"`
	EnableProduceAuthorize    *bool `protobuf:"varint,4,req,name=enableProduceAuthorize" json:"enableProduceAuthorize,omitempty"`
	EnableVisitTokenCheck     *bool `protobuf:"varint,5,opt,name=enableVisitTokenCheck" json:"enableVisitTokenCheck,omitempty"`
}

func (x *EnableBrokerFunInfo) Reset() {
	*x = EnableBrokerFunInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnableBrokerFunInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnableBrokerFunInfo) ProtoMessage() {}

func (x *EnableBrokerFunInfo) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnableBrokerFunInfo.ProtoReflect.Descriptor instead.
func (*EnableBrokerFunInfo) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{1}
}

func (x *EnableBrokerFunInfo) GetEnableConsumeAuthenticate() bool {
	if x != nil && x.EnableConsumeAuthenticate != nil {
		return *x.EnableConsumeAuthenticate
	}
	return false
}

func (x *EnableBrokerFunInfo) GetEnableConsumeAuthorize() bool {
	if x != nil && x.EnableConsumeAuthorize != nil {
		return *x.EnableConsumeAuthorize
	}
	return false
}

func (x *EnableBrokerFunInfo) GetEnableProduceAuthenticate() bool {
	if x != nil && x.EnableProduceAuthenticate != nil {
		return *x.EnableProduceAuthenticate
	}
	return false
}

func (x *EnableBrokerFunInfo) GetEnableProduceAuthorize() bool {
	if x != nil && x.EnableProduceAuthorize != nil {
		return *x.EnableProduceAuthorize
	}
	return false
}

func (x *EnableBrokerFunInfo) GetEnableVisitTokenCheck() bool {
	if x != nil && x.EnableVisitTokenCheck != nil {
		return *x.EnableVisitTokenCheck
	}
	return false
}

type AuthenticateInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UserName  *string `protobuf:"bytes,1,req,name=userName" json:"userName,omitempty"`
	Timestamp *int64  `protobuf:"varint,2,req,name=timestamp" json:"timestamp,omitempty"`
	Nonce     *int32  `protobuf:"varint,3,req,name=nonce" json:"nonce,omitempty"`
	OthParams *string `protobuf:"bytes,4,req,name=othParams" json:"othParams,omitempty"`
	Signature *string `protobuf:"bytes,5,req,name=signature" json:"signature,omitempty"`
}

func (x *AuthenticateInfo) Reset() {
	*x = AuthenticateInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthenticateInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthenticateInfo) ProtoMessage() {}

func (x *AuthenticateInfo) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthenticateInfo.ProtoReflect.Descriptor instead.
func (*AuthenticateInfo) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{2}
}

func (x *AuthenticateInfo) GetUserName() string {
	if x != nil && x.UserName != nil {
		return *x.UserName
	}
	return ""
}

func (x *AuthenticateInfo) GetTimestamp() int64 {
	if x != nil && x.Timestamp != nil {
		return *x.Timestamp
	}
	return 0
}

func (x *AuthenticateInfo) GetNonce() int32 {
	if x != nil && x.Nonce != nil {
		return *x.Nonce
	}
	return 0
}

func (x *AuthenticateInfo) GetOthParams() string {
	if x != nil && x.OthParams != nil {
		return *x.OthParams
	}
	return ""
}

func (x *AuthenticateInfo) GetSignature() string {
	if x != nil && x.Signature != nil {
		return *x.Signature
	}
	return ""
}

type MasterCertificateInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AuthInfo        *AuthenticateInfo `protobuf:"bytes,1,opt,name=authInfo" json:"authInfo,omitempty"`
	AuthorizedToken *string           `protobuf:"bytes,2,opt,name=authorizedToken" json:"authorizedToken,omitempty"`
}

func (x *MasterCertificateInfo) Reset() {
	*x = MasterCertificateInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MasterCertificateInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MasterCertificateInfo) ProtoMessage() {}

func (x *MasterCertificateInfo) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MasterCertificateInfo.ProtoReflect.Descriptor instead.
func (*MasterCertificateInfo) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{3}
}

func (x *MasterCertificateInfo) GetAuthInfo() *AuthenticateInfo {
	if x != nil {
		return x.AuthInfo
	}
	return nil
}

func (x *MasterCertificateInfo) GetAuthorizedToken() string {
	if x != nil && x.AuthorizedToken != nil {
		return *x.AuthorizedToken
	}
	return ""
}

type MasterAuthorizedInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	VisitAuthorizedToken *int64  `protobuf:"varint,1,req,name=visitAuthorizedToken" json:"visitAuthorizedToken,omitempty"`
	AuthAuthorizedToken  *string `protobuf:"bytes,2,opt,name=authAuthorizedToken" json:"authAuthorizedToken,omitempty"`
}

func (x *MasterAuthorizedInfo) Reset() {
	*x = MasterAuthorizedInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MasterAuthorizedInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MasterAuthorizedInfo) ProtoMessage() {}

func (x *MasterAuthorizedInfo) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MasterAuthorizedInfo.ProtoReflect.Descriptor instead.
func (*MasterAuthorizedInfo) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{4}
}

func (x *MasterAuthorizedInfo) GetVisitAuthorizedToken() int64 {
	if x != nil && x.VisitAuthorizedToken != nil {
		return *x.VisitAuthorizedToken
	}
	return 0
}

func (x *MasterAuthorizedInfo) GetAuthAuthorizedToken() string {
	if x != nil && x.AuthAuthorizedToken != nil {
		return *x.AuthAuthorizedToken
	}
	return ""
}

type MasterBrokerAuthorizedInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	VisitAuthorizedToken *string `protobuf:"bytes,1,req,name=visitAuthorizedToken" json:"visitAuthorizedToken,omitempty"`
	AuthAuthorizedToken  *string `protobuf:"bytes,2,opt,name=authAuthorizedToken" json:"authAuthorizedToken,omitempty"`
}

func (x *MasterBrokerAuthorizedInfo) Reset() {
	*x = MasterBrokerAuthorizedInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MasterBrokerAuthorizedInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MasterBrokerAuthorizedInfo) ProtoMessage() {}

func (x *MasterBrokerAuthorizedInfo) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MasterBrokerAuthorizedInfo.ProtoReflect.Descriptor instead.
func (*MasterBrokerAuthorizedInfo) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{5}
}

func (x *MasterBrokerAuthorizedInfo) GetVisitAuthorizedToken() string {
	if x != nil && x.VisitAuthorizedToken != nil {
		return *x.VisitAuthorizedToken
	}
	return ""
}

func (x *MasterBrokerAuthorizedInfo) GetAuthAuthorizedToken() string {
	if x != nil && x.AuthAuthorizedToken != nil {
		return *x.AuthAuthorizedToken
	}
	return ""
}

type ApprovedClientConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConfigId   *int64 `protobuf:"varint,1,req,name=configId" json:"configId,omitempty"`
	MaxMsgSize *int32 `protobuf:"varint,2,opt,name=maxMsgSize" json:"maxMsgSize,omitempty"`
}

func (x *ApprovedClientConfig) Reset() {
	*x = ApprovedClientConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApprovedClientConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApprovedClientConfig) ProtoMessage() {}

func (x *ApprovedClientConfig) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApprovedClientConfig.ProtoReflect.Descriptor instead.
func (*ApprovedClientConfig) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{6}
}

func (x *ApprovedClientConfig) GetConfigId() int64 {
	if x != nil && x.ConfigId != nil {
		return *x.ConfigId
	}
	return 0
}

func (x *ApprovedClientConfig) GetMaxMsgSize() int32 {
	if x != nil && x.MaxMsgSize != nil {
		return *x.MaxMsgSize
	}
	return 0
}

type ClusterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConfigId   *int64 `protobuf:"varint,1,req,name=configId" json:"configId,omitempty"`
	MaxMsgSize *int32 `protobuf:"varint,2,opt,name=maxMsgSize" json:"maxMsgSize,omitempty"`
}

func (x *ClusterConfig) Reset() {
	*x = ClusterConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterConfig) ProtoMessage() {}

func (x *ClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterConfig.ProtoReflect.Descriptor instead.
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{7}
}

func (x *ClusterConfig) GetConfigId() int64 {
	if x != nil && x.ConfigId != nil {
		return *x.ConfigId
	}
	return 0
}

func (x *ClusterConfig) GetMaxMsgSize() int32 {
	if x != nil && x.MaxMsgSize != nil {
		return *x.MaxMsgSize
	}
	return 0
}

type RegisterRequestP2M struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientId       *string                `protobuf:"bytes,1,req,name=clientId" json:"clientId,omitempty"`
	TopicList      []string               `protobuf:"bytes,2,rep,name=topicList" json:"topicList,omitempty"`
	BrokerCheckSum *int64                 `protobuf:"varint,3,req,name=brokerCheckSum" json:"brokerCheckSum,omitempty"`
	HostName       *string                `protobuf:"bytes,4,req,name=hostName" json:"hostName,omitempty"`
	AuthInfo       *MasterCertificateInfo `protobuf:"bytes,5,opt,name=authInfo" json:"authInfo,omitempty"`
	JdkVersion     *string                `protobuf:"bytes,6,opt,name=jdkVersion" json:"jdkVersion,omitempty"`
	AppdConfig     *ApprovedClientConfig  `protobuf:"bytes,7,opt,name=appdConfig" json:"appdConfig,omitempty"`
}

func (x *RegisterRequestP2M) Reset() {
	*x = RegisterRequestP2M{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterRequestP2M) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterRequestP2M) ProtoMessage() {}

func (x *RegisterRequestP2M) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterRequestP2M.ProtoReflect.Descriptor instead.
func (*RegisterRequestP2M) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{8}
}

func (x *RegisterRequestP2M) GetClientId() string {
	if x != nil && x.ClientId != nil {
		return *x.ClientId
	}
	return ""
}

func (x *RegisterRequestP2M) GetTopicList() []string {
	if x != nil {
		return x.TopicList
	}
	return nil
}

func (x *RegisterRequestP2M) GetBrokerCheckSum() int64 {
	if x != nil && x.BrokerCheckSum != nil {
		return *x.BrokerCheckSum
	}
	return 0
}

func (x *RegisterRequestP2M) GetHostName() string {
	if x != nil && x.HostName != nil {
		return *x.HostName
	}
	return ""
}

func (x *RegisterRequestP2M) GetAuthInfo() *MasterCertificateInfo {
	if x != nil {
		return x.AuthInfo
	}
	return nil
}

func (x *RegisterRequestP2M) GetJdkVersion() string {
	if x != nil && x.JdkVersion != nil {
		return *x.JdkVersion
	}
	return ""
}

func (x *RegisterRequestP2M) GetAppdConfig() *ApprovedClientConfig {
	if x != nil {
		return x.AppdConfig
	}
	return nil
}

type RegisterResponseM2P struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Success        *bool                 `protobuf:"varint,1,req,name=success" json:"success,omitempty"`
	ErrCode        *int32                `protobuf:"varint,2,req,name=errCode" json:"errCode,omitempty"`
	ErrMsg         *string               `protobuf:"bytes,3,req,name=errMsg" json:"errMsg,omitempty"`
	BrokerCheckSum *int64                `protobuf:"varint,4,req,name=brokerCheckSum" json:"brokerCheckSum,omitempty"`
	BrokerInfos    []string              `protobuf:"bytes,5,rep,name=brokerInfos" json:"brokerInfos,omitempty"`
	AuthorizedInfo *MasterAuthorizedInfo `protobuf:"bytes,6,opt,name=authorizedInfo" json:"authorizedInfo,omitempty"`
	AppdConfig     *ApprovedClientConfig `protobuf:"bytes,7,opt,name=appdConfig" json:"appdConfig,omitempty"`
}

func (x *RegisterResponseM2P) Reset() {
	*x = RegisterResponseM2P{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterResponseM2P) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterResponseM2P) ProtoMessage() {}

func (x *RegisterResponseM2P) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterResponseM2P.ProtoReflect.Descriptor instead.
func (*RegisterResponseM2P) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{9}
}

func (x *RegisterResponseM2P) GetSuccess() bool {
	if x != nil && x.Success != nil {
		return *x.Success
	}
	return false
}

func (x *RegisterResponseM2P) GetErrCode() int32 {
	if x != nil && x.ErrCode != nil {
		return *x.ErrCode
	}
	return 0
}

func (x *RegisterResponseM2P) GetErrMsg() string {
	if x != nil && x.ErrMsg != nil {
		return *x.ErrMsg
	}
	return ""
}

func (x *RegisterResponseM2P) GetBrokerCheckSum() int64 {
	if x != nil && x.BrokerCheckSum != nil {
		return *x.BrokerCheckSum
	}
	return 0
}

func (x *RegisterResponseM2P) GetBrokerInfos() []string {
	if x != nil {
		return x.BrokerInfos
	}
	return nil
}

func (x *RegisterResponseM2P) GetAuthorizedInfo() *MasterAuthorizedInfo {
	if x != nil {
		return x.AuthorizedInfo
	}
	return nil
}

func (x *RegisterResponseM2P) GetAppdConfig() *ApprovedClientConfig {
	if x != nil {
		return x.AppdConfig
	}
	return nil
}

type HeartRequestP2M struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientId       *string                `protobuf:"bytes,1,req,name=clientId" json:"clientId,omitempty"`
	BrokerCheckSum *int64                 `protobuf:"varint,2,req,name=brokerCheckSum" json:"brokerCheckSum,omitempty"`
	HostName       *string                `protobuf:"bytes,3,req,name=hostName" json:"hostName,omitempty"`
	TopicList      []string               `protobuf:"bytes,4,rep,name=topicList" json:"topicList,omitempty"`
	AuthInfo       *MasterCertificateInfo `protobuf:"bytes,5,opt,name=authInfo" json:"authInfo,omitempty"`
	AppdConfig     *ApprovedClientConfig  `protobuf:"bytes,6,opt,name=appdConfig" json:"appdConfig,omitempty"`
}

func (x *HeartRequestP2M) Reset() {
	*x = HeartRequestP2M{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeartRequestP2M) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeartRequestP2M) ProtoMessage() {}

func (x *HeartRequestP2M) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeartRequestP2M.ProtoReflect.Descriptor instead.
func (*HeartRequestP2M) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{10}
}

func (x *HeartRequestP2M) GetClientId() string {
	if x != nil && x.ClientId != nil {
		return *x.ClientId
	}
	return ""
}

func (x *HeartRequestP2M) GetBrokerCheckSum() int64 {
	if x != nil && x.BrokerCheckSum != nil {
		return *x.BrokerCheckSum
	}
	return 0
}

func (x *HeartRequestP2M) GetHostName() string {
	if x != nil && x.HostName != nil {
		return *x.HostName
	}
	return ""
}

func (x *HeartRequestP2M) GetTopicList() []string {
	if x != nil {
		return x.TopicList
	}
	return nil
}

func (x *HeartRequestP2M) GetAuthInfo() *MasterCertificateInfo {
	if x != nil {
		return x.AuthInfo
	}
	return nil
}

func (x *HeartRequestP2M) GetAppdConfig() *ApprovedClientConfig {
	if x != nil {
		return x.AppdConfig
	}
	return nil
}

type HeartResponseM2P struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Success        *bool   `protobuf:"varint,1,req,name=success" json:"success,omitempty"`
	ErrCode        *int32  `protobuf:"varint,2,req,name=errCode" json:"errCode,omitempty"`
	ErrMsg         *string `protobuf:"bytes,3,req,name=errMsg" json:"errMsg,omitempty"`
	BrokerCheckSum *int64  `protobuf:"varint,4,req,name=brokerCheckSum" json:"brokerCheckSum,omitempty"`
	// brokerId:host:port-topic:partitionNum
	TopicInfos     []string              `protobuf:"bytes,5,rep,name=topicInfos" json:"topicInfos,omitempty"`
	BrokerInfos    []string              `protobuf:"bytes,6,rep,name=brokerInfos" json:"brokerInfos,omitempty"`
	RequireAuth    *bool                 `protobuf:"varint,7,opt,name=requireAuth" json:"requireAuth,omitempty"`
	AuthorizedInfo *MasterAuthorizedInfo `protobuf:"bytes,8,opt,name=authorizedInfo" json:"authorizedInfo,omitempty"`
	AppdConfig     *ApprovedClientConfig `protobuf:"bytes,9,opt,name=appdConfig" json:"appdConfig,omitempty"`
}

func (x *HeartResponseM2P) Reset() {
	*x = HeartResponseM2P{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeartResponseM2P) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeartResponseM2P) ProtoMessage() {}

func (x *HeartResponseM2P) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeartResponseM2P.ProtoReflect.Descriptor instead.
func (*HeartResponseM2P) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{11}
}

func (x *HeartResponseM2P) GetSuccess() bool {
	if x != nil && x.Success != nil {
		return *x.Success
	}
	return false
}

func (x *HeartResponseM2P) GetErrCode() int32 {
	if x != nil && x.ErrCode != nil {
		return *x.ErrCode
	}
	return 0
}

func (x *HeartResponseM2P) GetErrMsg() string {
	if x != nil && x.ErrMsg != nil {
		return *x.ErrMsg
	}
	return ""
}

func (x *HeartResponseM2P) GetBrokerCheckSum() int64 {
	if x != nil && x.BrokerCheckSum != nil {
		return *x.BrokerCheckSum
	}
	return 0
}

func (x *HeartResponseM2P) GetTopicInfos() []string {
	if x != nil {
		return x.TopicInfos
	}
	return nil
}

func (x *HeartResponseM2P) GetBrokerInfos() []string {
	if x != nil {
		return x.BrokerInfos
	}
	return nil
}

func (x *HeartResponseM2P) GetRequireAuth() bool {
	if x != nil && x.RequireAuth != nil {
		return *x.RequireAuth
	}
	return false
}

func (x *HeartResponseM2P) GetAuthorizedInfo() *MasterAuthorizedInfo {
	if x != nil {
		return x.AuthorizedInfo
	}
	return nil
}

func (x *HeartResponseM2P) GetAppdConfig() *ApprovedClientConfig {
	if x != nil {
		return x.AppdConfig
	}
	return nil
}

type CloseRequestP2M struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientId *string                `protobuf:"bytes,1,req,name=clientId" json:"clientId,omitempty"`
	AuthInfo *MasterCertificateInfo `protobuf:"bytes,2,opt,name=authInfo" json:"authInfo,omitempty"`
}

func (x *CloseRequestP2M) Reset() {
	*x = CloseRequestP2M{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloseRequestP2M) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseRequestP2M) ProtoMessage() {}

func (x *CloseRequestP2M) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseRequestP2M.ProtoReflect.Descriptor instead.
func (*CloseRequestP2M) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{12}
}

func (x *CloseRequestP2M) GetClientId() string {
	if x != nil && x.ClientId != nil {
		return *x.ClientId
	}
	return ""
}

func (x *CloseRequestP2M) GetAuthInfo() *MasterCertificateInfo {
	if x != nil {
		return x.AuthInfo
	}
	return nil
}

type CloseResponseM2P struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Success *bool   `protobuf:"varint,1,req,name=success" json:"success,omitempty"`
	ErrCode *int32  `protobuf:"varint,2,req,name=errCode" json:"errCode,omitempty"`
	ErrMsg  *string `protobuf:"bytes,3,req,name=errMsg" json:"errMsg,omitempty"`
}

func (x *CloseResponseM2P) Reset() {
	*x = CloseResponseM2P{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloseResponseM2P) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseResponseM2P) ProtoMessage() {}

func (x *CloseResponseM2P) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseResponseM2P.ProtoReflect.Descriptor instead.
func (*CloseResponseM2P) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{13}
}

func (x *CloseResponseM2P) GetSuccess() bool {
	if x != nil && x.Success != nil {
		return *x.Success
	}
	return false
}

func (x *CloseResponseM2P) GetErrCode() int32 {
	if x != nil && x.ErrCode != nil {
		return *x.ErrCode
	}
	return 0
}

func (x *CloseResponseM2P) GetErrMsg() string {
	if x != nil && x.ErrMsg != nil {
		return *x.ErrMsg
	}
	return ""
}

type RegisterRequestC2M struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientId  *string  `protobuf:"bytes,1,req,name=clientId" json:"clientId,omitempty"`
	GroupName *string  `protobuf:"bytes,2,req,name=groupName" json:"groupName,omitempty"`
	HostName  *string  `protobuf:"bytes,3,req,name=hostName" json:"hostName,omitempty"`
	TopicList []string `protobuf:"bytes,4,rep,name=topicList" json:"topicList,omitempty"`
	// consumerId@group-brokerId:host:port-topic:partitionId
	SubscribeInfo     []string               `protobuf:"bytes,5,rep,name=subscribeInfo" json:"subscribeInfo,omitempty"`
	TopicCondition    []string               `protobuf:"bytes,6,rep,name=topicCondition" json:"topicCondition,omitempty"`
	RequireBound      *bool                  `protobuf:"varint,7,opt,name=requireBound" json:"requireBound,omitempty"`
	SessionTime       *int64                 `protobuf:"varint,8,opt,name=sessionTime" json:"sessionTime,omitempty"`
	SessionKey        *string                `protobuf:"bytes,9,opt,name=sessionKey" json:"sessionKey,omitempty"`
	TotalCount        *int32                 `protobuf:"varint,10,opt,name=totalCount" json:"totalCount,omitempty"`
	RequiredPartition *string                `protobuf:"bytes,11,opt,name=requiredPartition" json:"requiredPartition,omitempty"`
	NotAllocated      *bool                  `protobuf:"varint,12,opt,name=notAllocated" json:"notAllocated,omitempty"`
	SelectBig         *bool                  `protobuf:"varint,13,opt,name=selectBig" json:"selectBig,omitempty"`
	GroupFlowCheckId  *int64                 `protobuf:"varint,14,opt,name=groupFlowCheckId" json:"groupFlowCheckId,omitempty"`
	DefFlowCheckId    *int64                 `protobuf:"varint,15,opt,name=defFlowCheckId" json:"defFlowCheckId,omitempty"`
	SsdStoreId        *int64                 `protobuf:"varint,16,opt,name=ssdStoreId" json:"ssdStoreId,omitempty"` // Deprecated
	QryPriorityId     *int32                 `protobuf:"varint,17,opt,name=qryPriorityId" json:"qryPriorityId,omitempty"`
	AuthInfo          *MasterCertificateInfo `protobuf:"bytes,18,opt,name=authInfo" json:"authInfo,omitempty"`
	JdkVersion        *string                `protobuf:"bytes,19,opt,name=jdkVersion" json:"jdkVersion,omitempty"`
}

func (x *RegisterRequestC2M) Reset() {
	*x = RegisterRequestC2M{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterRequestC2M) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterRequestC2M) ProtoMessage() {}

func (x *RegisterRequestC2M) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterRequestC2M.ProtoReflect.Descriptor instead.
func (*RegisterRequestC2M) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{14}
}

func (x *RegisterRequestC2M) GetClientId() string {
	if x != nil && x.ClientId != nil {
		return *x.ClientId
	}
	return ""
}

func (x *RegisterRequestC2M) GetGroupName() string {
	if x != nil && x.GroupName != nil {
		return *x.GroupName
	}
	return ""
}

func (x *RegisterRequestC2M) GetHostName() string {
	if x != nil && x.HostName != nil {
		return *x.HostName
	}
	return ""
}

func (x *RegisterRequestC2M) GetTopicList() []string {
	if x != nil {
		return x.TopicList
	}
	return nil
}

func (x *RegisterRequestC2M) GetSubscribeInfo() []string {
	if x != nil {
		return x.SubscribeInfo
	}
	return nil
}

func (x *RegisterRequestC2M) GetTopicCondition() []string {
	if x != nil {
		return x.TopicCondition
	}
	return nil
}

func (x *RegisterRequestC2M) GetRequireBound() bool {
	if x != nil && x.RequireBound != nil {
		return *x.RequireBound
	}
	return false
}

func (x *RegisterRequestC2M) GetSessionTime() int64 {
	if x != nil && x.SessionTime != nil {
		return *x.SessionTime
	}
	return 0
}

func (x *RegisterRequestC2M) GetSessionKey() string {
	if x != nil && x.SessionKey != nil {
		return *x.SessionKey
	}
	return ""
}

func (x *RegisterRequestC2M) GetTotalCount() int32 {
	if x != nil && x.TotalCount != nil {
		return *x.TotalCount
	}
	return 0
}

func (x *RegisterRequestC2M) GetRequiredPartition() string {
	if x != nil && x.RequiredPartition != nil {
		return *x.RequiredPartition
	}
	return ""
}

func (x *RegisterRequestC2M) GetNotAllocated() bool {
	if x != nil && x.NotAllocated != nil {
		return *x.NotAllocated
	}
	return false
}

func (x *RegisterRequestC2M) GetSelectBig() bool {
	if x != nil && x.SelectBig != nil {
		return *x.SelectBig
	}
	return false
}

func (x *RegisterRequestC2M) GetGroupFlowCheckId() int64 {
	if x != nil && x.GroupFlowCheckId != nil {
		return *x.GroupFlowCheckId
	}
	return 0
}

func (x *RegisterRequestC2M) GetDefFlowCheckId() int64 {
	if x != nil && x.DefFlowCheckId != nil {
		return *x.DefFlowCheckId
	}
	return 0
}

func (x *RegisterRequestC2M) GetSsdStoreId() int64 {
	if x != nil && x.SsdStoreId != nil {
		return *x.SsdStoreId
	}
	return 0
}

func (x *RegisterRequestC2M) GetQryPriorityId() int32 {
	if x != nil && x.QryPriorityId != nil {
		return *x.QryPriorityId
	}
	return 0
}

func (x *RegisterRequestC2M) GetAuthInfo() *MasterCertificateInfo {
	if x != nil {
		return x.AuthInfo
	}
	return nil
}

func (x *RegisterRequestC2M) GetJdkVersion() string {
	if x != nil && x.JdkVersion != nil {
		return *x.JdkVersion
	}
	return ""
}

type RegisterResponseM2C struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Success *bool   `protobuf:"varint,1,req,name=success" json:"success,omitempty"`
	ErrCode *int32  `protobuf:"varint,2,req,name=errCode" json:"errCode,omitempty"`
	ErrMsg  *string `protobuf:"bytes,3,req,name=errMsg" json:"errMsg,omitempty"`
	// brokerId:host:port-topic:partitionNum
	TopicInfo            []string              `protobuf:"bytes,4,rep,name=topicInfo" json:"topicInfo,omitempty"`
	NotAllocated         *bool                 `protobuf:"varint,5,opt,name=notAllocated" json:"notAllocated,omitempty"`
	DefFlowCheckId       *int64                `protobuf:"varint,6,opt,name=defFlowCheckId" json:"defFlowCheckId,omitempty"`
	DefFlowControlInfo   *string               `protobuf:"bytes,7,opt,name=defFlowControlInfo" json:"defFlowControlInfo,omitempty"`
	GroupFlowCheckId     *int64                `protobuf:"varint,8,opt,name=groupFlowCheckId" json:"groupFlowCheckId,omitempty"`
	GroupFlowControlInfo *string               `protobuf:"bytes,9,opt,name=groupFlowControlInfo" json:"groupFlowControlInfo,omitempty"`
	SsdStoreId           *int64                `protobuf:"varint,10,opt,name=ssdStoreId" json:"ssdStoreId,omitempty"` // Deprecated
	QryPriorityId        *int32                `protobuf:"varint,11,opt,name=qryPriorityId" json:"qryPriorityId,omitempty"`
	AuthorizedInfo       *MasterAuthorizedInfo `protobuf:"bytes,12,opt,name=authorizedInfo" json:"authorizedInfo,omitempty"`
}

func (x *RegisterResponseM2C) Reset() {
	*x = RegisterResponseM2C{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterResponseM2C) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterResponseM2C) ProtoMessage() {}

func (x *RegisterResponseM2C) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterResponseM2C.ProtoReflect.Descriptor instead.
func (*RegisterResponseM2C) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{15}
}

func (x *RegisterResponseM2C) GetSuccess() bool {
	if x != nil && x.Success != nil {
		return *x.Success
	}
	return false
}

func (x *RegisterResponseM2C) GetErrCode() int32 {
	if x != nil && x.ErrCode != nil {
		return *x.ErrCode
	}
	return 0
}

func (x *RegisterResponseM2C) GetErrMsg() string {
	if x != nil && x.ErrMsg != nil {
		return *x.ErrMsg
	}
	return ""
}

func (x *RegisterResponseM2C) GetTopicInfo() []string {
	if x != nil {
		return x.TopicInfo
	}
	return nil
}

func (x *RegisterResponseM2C) GetNotAllocated() bool {
	if x != nil && x.NotAllocated != nil {
		return *x.NotAllocated
	}
	return false
}

func (x *RegisterResponseM2C) GetDefFlowCheckId() int64 {
	if x != nil && x.DefFlowCheckId != nil {
		return *x.DefFlowCheckId
	}
	return 0
}

func (x *RegisterResponseM2C) GetDefFlowControlInfo() string {
	if x != nil && x.DefFlowControlInfo != nil {
		return *x.DefFlowControlInfo
	}
	return ""
}

func (x *RegisterResponseM2C) GetGroupFlowCheckId() int64 {
	if x != nil && x.GroupFlowCheckId != nil {
		return *x.GroupFlowCheckId
	}
	return 0
}

func (x *RegisterResponseM2C) GetGroupFlowControlInfo() string {
	if x != nil && x.GroupFlowControlInfo != nil {
		return *x.GroupFlowControlInfo
	}
	return ""
}

func (x *RegisterResponseM2C) GetSsdStoreId() int64 {
	if x != nil && x.SsdStoreId != nil {
		return *x.SsdStoreId
	}
	return 0
}

func (x *RegisterResponseM2C) GetQryPriorityId() int32 {
	if x != nil && x.QryPriorityId != nil {
		return *x.QryPriorityId
	}
	return 0
}

func (x *RegisterResponseM2C) GetAuthorizedInfo() *MasterAuthorizedInfo {
	if x != nil {
		return x.AuthorizedInfo
	}
	return nil
}

type HeartRequestC2M struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientId            *string                `protobuf:"bytes,1,req,name=clientId" json:"clientId,omitempty"`
	GroupName           *string                `protobuf:"bytes,2,req,name=groupName" json:"groupName,omitempty"`
	SubscribeInfo       []string               `protobuf:"bytes,3,rep,name=subscribeInfo" json:"subscribeInfo,omitempty"`
	ReportSubscribeInfo *bool                  `protobuf:"varint,4,req,name=reportSubscribeInfo" json:"reportSubscribeInfo,omitempty"`
	Event               *EventProto            `protobuf:"bytes,5,opt,name=event" json:"event,omitempty"`
	DefFlowCheckId      *int64                 `protobuf:"varint,6,opt,name=defFlowCheckId" json:"defFlowCheckId,omitempty"`
	GroupFlowCheckId    *int64                 `protobuf:"varint,7,opt,name=groupFlowCheckId" json:"groupFlowCheckId,omitempty"`
	SsdStoreId          *int64                 `protobuf:"varint,8,opt,name=ssdStoreId" json:"ssdStoreId,omitempty"` // Deprecated
	QryPriorityId       *int32                 `protobuf:"varint,9,opt,name=qryPriorityId" json:"qryPriorityId,omitempty"`
	AuthInfo            *MasterCertificateInfo `protobuf:"bytes,10,opt,name=authInfo" json:"authInfo,omitempty"`
}

func (x *HeartRequestC2M) Reset() {
	*x = HeartRequestC2M{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeartRequestC2M) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeartRequestC2M) ProtoMessage() {}

func (x *HeartRequestC2M) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeartRequestC2M.ProtoReflect.Descriptor instead.
func (*HeartRequestC2M) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{16}
}

func (x *HeartRequestC2M) GetClientId() string {
	if x != nil && x.ClientId != nil {
		return *x.ClientId
	}
	return ""
}

func (x *HeartRequestC2M) GetGroupName() string {
	if x != nil && x.GroupName != nil {
		return *x.GroupName
	}
	return ""
}

func (x *HeartRequestC2M) GetSubscribeInfo() []string {
	if x != nil {
		return x.SubscribeInfo
	}
	return nil
}

func (x *HeartRequestC2M) GetReportSubscribeInfo() bool {
	if x != nil && x.ReportSubscribeInfo != nil {
		return *x.ReportSubscribeInfo
	}
	return false
}

func (x *HeartRequestC2M) GetEvent() *EventProto {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *HeartRequestC2M) GetDefFlowCheckId() int64 {
	if x != nil && x.DefFlowCheckId != nil {
		return *x.DefFlowCheckId
	}
	return 0
}

func (x *HeartRequestC2M) GetGroupFlowCheckId() int64 {
	if x != nil && x.GroupFlowCheckId != nil {
		return *x.GroupFlowCheckId
	}
	return 0
}

func (x *HeartRequestC2M) GetSsdStoreId() int64 {
	if x != nil && x.SsdStoreId != nil {
		return *x.SsdStoreId
	}
	return 0
}

func (x *HeartRequestC2M) GetQryPriorityId() int32 {
	if x != nil && x.QryPriorityId != nil {
		return *x.QryPriorityId
	}
	return 0
}

func (x *HeartRequestC2M) GetAuthInfo() *MasterCertificateInfo {
	if x != nil {
		return x.AuthInfo
	}
	return nil
}

type HeartResponseM2C struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Success              *bool                 `protobuf:"varint,1,req,name=success" json:"success,omitempty"`
	ErrCode              *int32                `protobuf:"varint,2,req,name=errCode" json:"errCode,omitempty"`
	ErrMsg               *string               `protobuf:"bytes,3,req,name=errMsg" json:"errMsg,omitempty"`
	Event                *EventProto           `protobuf:"bytes,4,opt,name=event" json:"event,omitempty"`
	NotAllocated         *bool                 `protobuf:"varint,5,opt,name=notAllocated" json:"notAllocated,omitempty"`
	DefFlowCheckId       *int64                `protobuf:"varint,6,opt,name=defFlowCheckId" json:"defFlowCheckId,omitempty"`
	DefFlowControlInfo   *string               `protobuf:"bytes,7,opt,name=defFlowControlInfo" json:"defFlowControlInfo,omitempty"`
	GroupFlowCheckId     *int64                `protobuf:"varint,8,opt,name=groupFlowCheckId" json:"groupFlowCheckId,omitempty"`
	GroupFlowControlInfo *string               `protobuf:"bytes,9,opt,name=groupFlowControlInfo" json:"groupFlowControlInfo,omitempty"`
	SsdStoreId           *int64                `protobuf:"varint,10,opt,name=ssdStoreId" json:"ssdStoreId,omitempty"` // Deprecated
	QryPriorityId        *int32                `protobuf:"varint,11,opt,name=qryPriorityId" json:"qryPriorityId,omitempty"`
	RequireAuth          *bool                 `protobuf:"varint,12,opt,name=requireAuth" json:"requireAuth,omitempty"`
	AuthorizedInfo       *MasterAuthorizedInfo `protobuf:"bytes,13,opt,name=authorizedInfo" json:"authorizedInfo,omitempty"`
}

func (x *HeartResponseM2C) Reset() {
	*x = HeartResponseM2C{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeartResponseM2C) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeartResponseM2C) ProtoMessage() {}

func (x *HeartResponseM2C) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeartResponseM2C.ProtoReflect.Descriptor instead.
func (*HeartResponseM2C) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{17}
}

func (x *HeartResponseM2C) GetSuccess() bool {
	if x != nil && x.Success != nil {
		return *x.Success
	}
	return false
}

func (x *HeartResponseM2C) GetErrCode() int32 {
	if x != nil && x.ErrCode != nil {
		return *x.ErrCode
	}
	return 0
}

func (x *HeartResponseM2C) GetErrMsg() string {
	if x != nil && x.ErrMsg != nil {
		return *x.ErrMsg
	}
	return ""
}

func (x *HeartResponseM2C) GetEvent() *EventProto {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *HeartResponseM2C) GetNotAllocated() bool {
	if x != nil && x.NotAllocated != nil {
		return *x.NotAllocated
	}
	return false
}

func (x *HeartResponseM2C) GetDefFlowCheckId() int64 {
	if x != nil && x.DefFlowCheckId != nil {
		return *x.DefFlowCheckId
	}
	return 0
}

func (x *HeartResponseM2C) GetDefFlowControlInfo() string {
	if x != nil && x.DefFlowControlInfo != nil {
		return *x.DefFlowControlInfo
	}
	return ""
}

func (x *HeartResponseM2C) GetGroupFlowCheckId() int64 {
	if x != nil && x.GroupFlowCheckId != nil {
		return *x.GroupFlowCheckId
	}
	return 0
}

func (x *HeartResponseM2C) GetGroupFlowControlInfo() string {
	if x != nil && x.GroupFlowControlInfo != nil {
		return *x.GroupFlowControlInfo
	}
	return ""
}

func (x *HeartResponseM2C) GetSsdStoreId() int64 {
	if x != nil && x.SsdStoreId != nil {
		return *x.SsdStoreId
	}
	return 0
}

func (x *HeartResponseM2C) GetQryPriorityId() int32 {
	if x != nil && x.QryPriorityId != nil {
		return *x.QryPriorityId
	}
	return 0
}

func (x *HeartResponseM2C) GetRequireAuth() bool {
	if x != nil && x.RequireAuth != nil {
		return *x.RequireAuth
	}
	return false
}

func (x *HeartResponseM2C) GetAuthorizedInfo() *MasterAuthorizedInfo {
	if x != nil {
		return x.AuthorizedInfo
	}
	return nil
}

type CloseRequestC2M struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientId  *string                `protobuf:"bytes,1,req,name=clientId" json:"clientId,omitempty"`
	GroupName *string                `protobuf:"bytes,2,req,name=groupName" json:"groupName,omitempty"`
	AuthInfo  *MasterCertificateInfo `protobuf:"bytes,3,opt,name=authInfo" json:"authInfo,omitempty"`
}

func (x *CloseRequestC2M) Reset() {
	*x = CloseRequestC2M{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloseRequestC2M) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseRequestC2M) ProtoMessage() {}

func (x *CloseRequestC2M) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseRequestC2M.ProtoReflect.Descriptor instead.
func (*CloseRequestC2M) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{18}
}

func (x *CloseRequestC2M) GetClientId() string {
	if x != nil && x.ClientId != nil {
		return *x.ClientId
	}
	return ""
}

func (x *CloseRequestC2M) GetGroupName() string {
	if x != nil && x.GroupName != nil {
		return *x.GroupName
	}
	return ""
}

func (x *CloseRequestC2M) GetAuthInfo() *MasterCertificateInfo {
	if x != nil {
		return x.AuthInfo
	}
	return nil
}

type CloseResponseM2C struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Success *bool   `protobuf:"varint,1,req,name=success" json:"success,omitempty"`
	ErrCode *int32  `protobuf:"varint,2,req,name=errCode" json:"errCode,omitempty"`
	ErrMsg  *string `protobuf:"bytes,3,req,name=errMsg" json:"errMsg,omitempty"`
}

func (x *CloseResponseM2C) Reset() {
	*x = CloseResponseM2C{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloseResponseM2C) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseResponseM2C) ProtoMessage() {}

func (x *CloseResponseM2C) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseResponseM2C.ProtoReflect.Descriptor instead.
func (*CloseResponseM2C) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{19}
}

func (x *CloseResponseM2C) GetSuccess() bool {
	if x != nil && x.Success != nil {
		return *x.Success
	}
	return false
}

func (x *CloseResponseM2C) GetErrCode() int32 {
	if x != nil && x.ErrCode != nil {
		return *x.ErrCode
	}
	return 0
}

func (x *CloseResponseM2C) GetErrMsg() string {
	if x != nil && x.ErrMsg != nil {
		return *x.ErrMsg
	}
	return ""
}

type RegisterRequestB2M struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientId        *string `protobuf:"bytes,1,req,name=clientId" json:"clientId,omitempty"`
	BrokerOnline    *bool   `protobuf:"varint,2,req,name=brokerOnline" json:"brokerOnline,omitempty"`
	EnableTls       *bool   `protobuf:"varint,3,req,name=enableTls" json:"enableTls,omitempty"`
	ReadStatusRpt   *int32  `protobuf:"varint,4,req,name=readStatusRpt" json:"readStatusRpt,omitempty"`
	WriteStatusRpt  *int32  `protobuf:"varint,5,req,name=writeStatusRpt" json:"writeStatusRpt,omitempty"`
	CurBrokerConfId *int64  `protobuf:"varint,6,req,name=curBrokerConfId" json:"curBrokerConfId,omitempty"`
	ConfCheckSumId  *int32  `protobuf:"varint,7,req,name=confCheckSumId" json:"confCheckSumId,omitempty"`
	// defaultPartNum:acceptPublish:acceptSubscribe:unflushThreshold:unflushInterval:deleteWhen:deletePolicy
	BrokerDefaultConfInfo *string `protobuf:"bytes,8,req,name=brokerDefaultConfInfo" json:"brokerDefaultConfInfo,omitempty"`
	// topic:partNum:acceptPublish:acceptSubscribe:unflushThreshold:unflushInterval:deleteWhen:deletePolicy:filterStatusId:statusId:attributes
	BrokerTopicSetConfInfo []string               `protobuf:"bytes,9,rep,name=brokerTopicSetConfInfo" json:"brokerTopicSetConfInfo,omitempty"`
	SsdStoreId             *int64                 `protobuf:"varint,10,opt,name=ssdStoreId" json:"ssdStoreId,omitempty"` // Deprecated
	FlowCheckId            *int64                 `protobuf:"varint,11,opt,name=flowCheckId" json:"flowCheckId,omitempty"`
	QryPriorityId          *int32                 `protobuf:"varint,12,opt,name=qryPriorityId" json:"qryPriorityId,omitempty"`
	TlsPort                *int32                 `protobuf:"varint,13,opt,name=tlsPort" json:"tlsPort,omitempty"`
	AuthInfo               *MasterCertificateInfo `protobuf:"bytes,14,opt,name=authInfo" json:"authInfo,omitempty"`
	ClsConfig              *ClusterConfig         `protobuf:"bytes,15,opt,name=clsConfig" json:"clsConfig,omitempty"`
}

func (x *RegisterRequestB2M) Reset() {
	*x = RegisterRequestB2M{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterRequestB2M) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterRequestB2M) ProtoMessage() {}

func (x *RegisterRequestB2M) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterRequestB2M.ProtoReflect.Descriptor instead.
func (*RegisterRequestB2M) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{20}
}

func (x *RegisterRequestB2M) GetClientId() string {
	if x != nil && x.ClientId != nil {
		return *x.ClientId
	}
	return ""
}

func (x *RegisterRequestB2M) GetBrokerOnline() bool {
	if x != nil && x.BrokerOnline != nil {
		return *x.BrokerOnline
	}
	return false
}

func (x *RegisterRequestB2M) GetEnableTls() bool {
	if x != nil && x.EnableTls != nil {
		return *x.EnableTls
	}
	return false
}

func (x *RegisterRequestB2M) GetReadStatusRpt() int32 {
	if x != nil && x.ReadStatusRpt != nil {
		return *x.ReadStatusRpt
	}
	return 0
}

func (x *RegisterRequestB2M) GetWriteStatusRpt() int32 {
	if x != nil && x.WriteStatusRpt != nil {
		return *x.WriteStatusRpt
	}
	return 0
}

func (x *RegisterRequestB2M) GetCurBrokerConfId() int64 {
	if x != nil && x.CurBrokerConfId != nil {
		return *x.CurBrokerConfId
	}
	return 0
}

func (x *RegisterRequestB2M) GetConfCheckSumId() int32 {
	if x != nil && x.ConfCheckSumId != nil {
		return *x.ConfCheckSumId
	}
	return 0
}

func (x *RegisterRequestB2M) GetBrokerDefaultConfInfo() string {
	if x != nil && x.BrokerDefaultConfInfo != nil {
		return *x.BrokerDefaultConfInfo
	}
	return ""
}

func (x *RegisterRequestB2M) GetBrokerTopicSetConfInfo() []string {
	if x != nil {
		return x.BrokerTopicSetConfInfo
	}
	return nil
}

func (x *RegisterRequestB2M) GetSsdStoreId() int64 {
	if x != nil && x.SsdStoreId != nil {
		return *x.SsdStoreId
	}
	return 0
}

func (x *RegisterRequestB2M) GetFlowCheckId() int64 {
	if x != nil && x.FlowCheckId != nil {
		return *x.FlowCheckId
	}
	return 0
}

func (x *RegisterRequestB2M) GetQryPriorityId() int32 {
	if x != nil && x.QryPriorityId != nil {
		return *x.QryPriorityId
	}
	return 0
}

func (x *RegisterRequestB2M) GetTlsPort() int32 {
	if x != nil && x.TlsPort != nil {
		return *x.TlsPort
	}
	return 0
}

func (x *RegisterRequestB2M) GetAuthInfo() *MasterCertificateInfo {
	if x != nil {
		return x.AuthInfo
	}
	return nil
}

func (x *RegisterRequestB2M) GetClsConfig() *ClusterConfig {
	if x != nil {
		return x.ClsConfig
	}
	return nil
}

type RegisterResponseM2B struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Success          *bool                `protobuf:"varint,1,req,name=success" json:"success,omitempty"`
	ErrCode          *int32               `protobuf:"varint,2,req,name=errCode" json:"errCode,omitempty"`
	ErrMsg           *string              `protobuf:"bytes,3,req,name=errMsg" json:"errMsg,omitempty"`
	StopRead         *bool                `protobuf:"varint,4,req,name=stopRead" json:"stopRead,omitempty"`
	StopWrite        *bool                `protobuf:"varint,5,req,name=stopWrite" json:"stopWrite,omitempty"`
	TakeConfInfo     *bool                `protobuf:"varint,6,req,name=takeConfInfo" json:"takeConfInfo,omitempty"`
	EnableBrokerInfo *EnableBrokerFunInfo `protobuf:"bytes,7,opt,name=enableBrokerInfo" json:"enableBrokerInfo,omitempty"`
	CurBrokerConfId  *int64               `protobuf:"varint,8,opt,name=curBrokerConfId" json:"curBrokerConfId,omitempty"`
	ConfCheckSumId   *int32               `protobuf:"varint,9,opt,name=confCheckSumId" json:"confCheckSumId,omitempty"`
	// defaultPartNum:acceptPublish:acceptSubscribe:unflushThreshold:unflushInterval:deleteWhen:deletePolicy
	BrokerDefaultConfInfo *string `protobuf:"bytes,10,opt,name=brokerDefaultConfInfo" json:"brokerDefaultConfInfo,omitempty"`
	// topic:partNum:acceptPublish:acceptSubscribe:unflushThreshold:unflushInterval:deleteWhen:deletePolicy:filterStatusId:statusId:attributes
	BrokerTopicSetConfInfo []string                    `protobuf:"bytes,11,rep,name=brokerTopicSetConfInfo" json:"brokerTopicSetConfInfo,omitempty"`
	SsdStoreId             *int64                      `protobuf:"varint,12,opt,name=ssdStoreId" json:"ssdStoreId,omitempty"` // Deprecated
	FlowCheckId            *int64                      `protobuf:"varint,13,opt,name=flowCheckId" json:"flowCheckId,omitempty"`
	FlowControlInfo        *string                     `protobuf:"bytes,14,opt,name=flowControlInfo" json:"flowControlInfo,omitempty"`
	QryPriorityId          *int32                      `protobuf:"varint,15,opt,name=qryPriorityId" json:"qryPriorityId,omitempty"`
	AuthorizedInfo         *MasterAuthorizedInfo       `protobuf:"bytes,16,opt,name=authorizedInfo" json:"authorizedInfo,omitempty"` // Deprecated
	BrokerAuthorizedInfo   *MasterBrokerAuthorizedInfo `protobuf:"bytes,17,opt,name=brokerAuthorizedInfo" json:"brokerAuthorizedInfo,omitempty"`
	ClsConfig              *ClusterConfig              `protobuf:"bytes,18,opt,name=clsConfig" json:"clsConfig,omitempty"`
}

func (x *RegisterResponseM2B) Reset() {
	*x = RegisterResponseM2B{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterResponseM2B) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterResponseM2B) ProtoMessage() {}

func (x *RegisterResponseM2B) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterResponseM2B.ProtoReflect.Descriptor instead.
func (*RegisterResponseM2B) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{21}
}

func (x *RegisterResponseM2B) GetSuccess() bool {
	if x != nil && x.Success != nil {
		return *x.Success
	}
	return false
}

func (x *RegisterResponseM2B) GetErrCode() int32 {
	if x != nil && x.ErrCode != nil {
		return *x.ErrCode
	}
	return 0
}

func (x *RegisterResponseM2B) GetErrMsg() string {
	if x != nil && x.ErrMsg != nil {
		return *x.ErrMsg
	}
	return ""
}

func (x *RegisterResponseM2B) GetStopRead() bool {
	if x != nil && x.StopRead != nil {
		return *x.StopRead
	}
	return false
}

func (x *RegisterResponseM2B) GetStopWrite() bool {
	if x != nil && x.StopWrite != nil {
		return *x.StopWrite
	}
	return false
}

func (x *RegisterResponseM2B) GetTakeConfInfo() bool {
	if x != nil && x.TakeConfInfo != nil {
		return *x.TakeConfInfo
	}
	return false
}

func (x *RegisterResponseM2B) GetEnableBrokerInfo() *EnableBrokerFunInfo {
	if x != nil {
		return x.EnableBrokerInfo
	}
	return nil
}

func (x *RegisterResponseM2B) GetCurBrokerConfId() int64 {
	if x != nil && x.CurBrokerConfId != nil {
		return *x.CurBrokerConfId
	}
	return 0
}

func (x *RegisterResponseM2B) GetConfCheckSumId() int32 {
	if x != nil && x.ConfCheckSumId != nil {
		return *x.ConfCheckSumId
	}
	return 0
}

func (x *RegisterResponseM2B) GetBrokerDefaultConfInfo() string {
	if x != nil && x.BrokerDefaultConfInfo != nil {
		return *x.BrokerDefaultConfInfo
	}
	return ""
}

func (x *RegisterResponseM2B) GetBrokerTopicSetConfInfo() []string {
	if x != nil {
		return x.BrokerTopicSetConfInfo
	}
	return nil
}

func (x *RegisterResponseM2B) GetSsdStoreId() int64 {
	if x != nil && x.SsdStoreId != nil {
		return *x.SsdStoreId
	}
	return 0
}

func (x *RegisterResponseM2B) GetFlowCheckId() int64 {
	if x != nil && x.FlowCheckId != nil {
		return *x.FlowCheckId
	}
	return 0
}

func (x *RegisterResponseM2B) GetFlowControlInfo() string {
	if x != nil && x.FlowControlInfo != nil {
		return *x.FlowControlInfo
	}
	return ""
}

func (x *RegisterResponseM2B) GetQryPriorityId() int32 {
	if x != nil && x.QryPriorityId != nil {
		return *x.QryPriorityId
	}
	return 0
}

func (x *RegisterResponseM2B) GetAuthorizedInfo() *MasterAuthorizedInfo {
	if x != nil {
		return x.AuthorizedInfo
	}
	return nil
}

func (x *RegisterResponseM2B) GetBrokerAuthorizedInfo() *MasterBrokerAuthorizedInfo {
	if x != nil {
		return x.BrokerAuthorizedInfo
	}
	return nil
}

func (x *RegisterResponseM2B) GetClsConfig() *ClusterConfig {
	if x != nil {
		return x.ClsConfig
	}
	return nil
}

type HeartRequestB2M struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BrokerId             *string `protobuf:"bytes,1,req,name=brokerId" json:"brokerId,omitempty"`
	BrokerOnline         *bool   `protobuf:"varint,2,req,name=brokerOnline" json:"brokerOnline,omitempty"`
	ReadStatusRpt        *int32  `protobuf:"varint,3,req,name=readStatusRpt" json:"readStatusRpt,omitempty"`
	WriteStatusRpt       *int32  `protobuf:"varint,4,req,name=writeStatusRpt" json:"writeStatusRpt,omitempty"`
	CurBrokerConfId      *int64  `protobuf:"varint,5,req,name=curBrokerConfId" json:"curBrokerConfId,omitempty"`
	ConfCheckSumId       *int32  `protobuf:"varint,6,req,name=confCheckSumId" json:"confCheckSumId,omitempty"`
	TakeConfInfo         *bool   `protobuf:"varint,7,req,name=takeConfInfo" json:"takeConfInfo,omitempty"`
	TakeRemovedTopicInfo *bool   `protobuf:"varint,8,req,name=takeRemovedTopicInfo" json:"takeRemovedTopicInfo,omitempty"`
	// defaultPartNum:acceptPublish:acceptSubscribe:unflushThreshold:unflushInterval:deleteWhen:deletePolicy
	BrokerDefaultConfInfo *string `protobuf:"bytes,9,opt,name=brokerDefaultConfInfo" json:"brokerDefaultConfInfo,omitempty"`
	// topic:partNum:acceptPublish:acceptSubscribe:unflushThreshold:unflushInterval:deleteWhen:deletePolicy:filterStatusId:statusId:attributes
	BrokerTopicSetConfInfo []string               `protobuf:"bytes,10,rep,name=brokerTopicSetConfInfo" json:"brokerTopicSetConfInfo,omitempty"`
	RemovedTopicsInfo      []string               `protobuf:"bytes,11,rep,name=removedTopicsInfo" json:"removedTopicsInfo,omitempty"`
	SsdStoreId             *int64                 `protobuf:"varint,12,opt,name=ssdStoreId" json:"ssdStoreId,omitempty"` // Deprecated
	FlowCheckId            *int64                 `protobuf:"varint,13,opt,name=flowCheckId" json:"flowCheckId,omitempty"`
	QryPriorityId          *int32                 `protobuf:"varint,14,opt,name=qryPriorityId" json:"qryPriorityId,omitempty"`
	AuthInfo               *MasterCertificateInfo `protobuf:"bytes,15,opt,name=authInfo" json:"authInfo,omitempty"`
	ClsConfig              *ClusterConfig         `protobuf:"bytes,16,opt,name=clsConfig" json:"clsConfig,omitempty"`
}

func (x *HeartRequestB2M) Reset() {
	*x = HeartRequestB2M{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeartRequestB2M) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeartRequestB2M) ProtoMessage() {}

func (x *HeartRequestB2M) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeartRequestB2M.ProtoReflect.Descriptor instead.
func (*HeartRequestB2M) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{22}
}

func (x *HeartRequestB2M) GetBrokerId() string {
	if x != nil && x.BrokerId != nil {
		return *x.BrokerId
	}
	return ""
}

func (x *HeartRequestB2M) GetBrokerOnline() bool {
	if x != nil && x.BrokerOnline != nil {
		return *x.BrokerOnline
	}
	return false
}

func (x *HeartRequestB2M) GetReadStatusRpt() int32 {
	if x != nil && x.ReadStatusRpt != nil {
		return *x.ReadStatusRpt
	}
	return 0
}

func (x *HeartRequestB2M) GetWriteStatusRpt() int32 {
	if x != nil && x.WriteStatusRpt != nil {
		return *x.WriteStatusRpt
	}
	return 0
}

func (x *HeartRequestB2M) GetCurBrokerConfId() int64 {
	if x != nil && x.CurBrokerConfId != nil {
		return *x.CurBrokerConfId
	}
	return 0
}

func (x *HeartRequestB2M) GetConfCheckSumId() int32 {
	if x != nil && x.ConfCheckSumId != nil {
		return *x.ConfCheckSumId
	}
	return 0
}

func (x *HeartRequestB2M) GetTakeConfInfo() bool {
	if x != nil && x.TakeConfInfo != nil {
		return *x.TakeConfInfo
	}
	return false
}

func (x *HeartRequestB2M) GetTakeRemovedTopicInfo() bool {
	if x != nil && x.TakeRemovedTopicInfo != nil {
		return *x.TakeRemovedTopicInfo
	}
	return false
}

func (x *HeartRequestB2M) GetBrokerDefaultConfInfo() string {
	if x != nil && x.BrokerDefaultConfInfo != nil {
		return *x.BrokerDefaultConfInfo
	}
	return ""
}

func (x *HeartRequestB2M) GetBrokerTopicSetConfInfo() []string {
	if x != nil {
		return x.BrokerTopicSetConfInfo
	}
	return nil
}

func (x *HeartRequestB2M) GetRemovedTopicsInfo() []string {
	if x != nil {
		return x.RemovedTopicsInfo
	}
	return nil
}

func (x *HeartRequestB2M) GetSsdStoreId() int64 {
	if x != nil && x.SsdStoreId != nil {
		return *x.SsdStoreId
	}
	return 0
}

func (x *HeartRequestB2M) GetFlowCheckId() int64 {
	if x != nil && x.FlowCheckId != nil {
		return *x.FlowCheckId
	}
	return 0
}

func (x *HeartRequestB2M) GetQryPriorityId() int32 {
	if x != nil && x.QryPriorityId != nil {
		return *x.QryPriorityId
	}
	return 0
}

func (x *HeartRequestB2M) GetAuthInfo() *MasterCertificateInfo {
	if x != nil {
		return x.AuthInfo
	}
	return nil
}

func (x *HeartRequestB2M) GetClsConfig() *ClusterConfig {
	if x != nil {
		return x.ClsConfig
	}
	return nil
}

type HeartResponseM2B struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Success             *bool   `protobuf:"varint,1,req,name=success" json:"success,omitempty"`
	ErrCode             *int32  `protobuf:"varint,2,req,name=errCode" json:"errCode,omitempty"`
	ErrMsg              *string `protobuf:"bytes,3,req,name=errMsg" json:"errMsg,omitempty"`
	StopRead            *bool   `protobuf:"varint,4,req,name=stopRead" json:"stopRead,omitempty"`
	StopWrite           *bool   `protobuf:"varint,5,req,name=stopWrite" json:"stopWrite,omitempty"`
	CurBrokerConfId     *int64  `protobuf:"varint,6,req,name=curBrokerConfId" json:"curBrokerConfId,omitempty"`
	ConfCheckSumId      *int32  `protobuf:"varint,7,req,name=confCheckSumId" json:"confCheckSumId,omitempty"`
	NeedReportData      *bool   `protobuf:"varint,8,req,name=needReportData" json:"needReportData,omitempty"`
	TakeConfInfo        *bool   `protobuf:"varint,9,req,name=takeConfInfo" json:"takeConfInfo,omitempty"`
	TakeRemoveTopicInfo *bool   `protobuf:"varint,10,req,name=takeRemoveTopicInfo" json:"takeRemoveTopicInfo,omitempty"`
	// defaultPartNum:acceptPublish:acceptSubscribe:unflushThreshold:unflushInterval:deleteWhen:deletePolicy
	BrokerDefaultConfInfo *string `protobuf:"bytes,11,opt,name=brokerDefaultConfInfo" json:"brokerDefaultConfInfo,omitempty"`
	// topic:partNum:acceptPublish:acceptSubscribe:unflushThreshold:unflushInterval:deleteWhen:deletePolicy:filterStatusId:statusId:attributes
	BrokerTopicSetConfInfo []string `protobuf:"bytes,12,rep,name=brokerTopicSetConfInfo" json:"brokerTopicSetConfInfo,omitempty"`
	// topic:partNum:acceptPublish:acceptSubscribe:unflushThreshold:unflushInterval:deleteWhen:deletePolicy:filterStatusId:statusId:attributes
	RemoveTopicConfInfo  []string                    `protobuf:"bytes,13,rep,name=removeTopicConfInfo" json:"removeTopicConfInfo,omitempty"`
	SsdStoreId           *int64                      `protobuf:"varint,14,opt,name=ssdStoreId" json:"ssdStoreId,omitempty"` // Deprecated
	FlowCheckId          *int64                      `protobuf:"varint,15,opt,name=flowCheckId" json:"flowCheckId,omitempty"`
	FlowControlInfo      *string                     `protobuf:"bytes,16,opt,name=flowControlInfo" json:"flowControlInfo,omitempty"`
	QryPriorityId        *int32                      `protobuf:"varint,17,opt,name=qryPriorityId" json:"qryPriorityId,omitempty"`
	AuthorizedInfo       *MasterAuthorizedInfo       `protobuf:"bytes,18,opt,name=authorizedInfo" json:"authorizedInfo,omitempty"` // Deprecated
	BrokerAuthorizedInfo *MasterBrokerAuthorizedInfo `protobuf:"bytes,19,opt,name=brokerAuthorizedInfo" json:"brokerAuthorizedInfo,omitempty"`
	ClsConfig            *ClusterConfig              `protobuf:"bytes,20,opt,name=clsConfig" json:"clsConfig,omitempty"`
}

func (x *HeartResponseM2B) Reset() {
	*x = HeartResponseM2B{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeartResponseM2B) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeartResponseM2B) ProtoMessage() {}

func (x *HeartResponseM2B) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeartResponseM2B.ProtoReflect.Descriptor instead.
func (*HeartResponseM2B) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{23}
}

func (x *HeartResponseM2B) GetSuccess() bool {
	if x != nil && x.Success != nil {
		return *x.Success
	}
	return false
}

func (x *HeartResponseM2B) GetErrCode() int32 {
	if x != nil && x.ErrCode != nil {
		return *x.ErrCode
	}
	return 0
}

func (x *HeartResponseM2B) GetErrMsg() string {
	if x != nil && x.ErrMsg != nil {
		return *x.ErrMsg
	}
	return ""
}

func (x *HeartResponseM2B) GetStopRead() bool {
	if x != nil && x.StopRead != nil {
		return *x.StopRead
	}
	return false
}

func (x *HeartResponseM2B) GetStopWrite() bool {
	if x != nil && x.StopWrite != nil {
		return *x.StopWrite
	}
	return false
}

func (x *HeartResponseM2B) GetCurBrokerConfId() int64 {
	if x != nil && x.CurBrokerConfId != nil {
		return *x.CurBrokerConfId
	}
	return 0
}

func (x *HeartResponseM2B) GetConfCheckSumId() int32 {
	if x != nil && x.ConfCheckSumId != nil {
		return *x.ConfCheckSumId
	}
	return 0
}

func (x *HeartResponseM2B) GetNeedReportData() bool {
	if x != nil && x.NeedReportData != nil {
		return *x.NeedReportData
	}
	return false
}

func (x *HeartResponseM2B) GetTakeConfInfo() bool {
	if x != nil && x.TakeConfInfo != nil {
		return *x.TakeConfInfo
	}
	return false
}

func (x *HeartResponseM2B) GetTakeRemoveTopicInfo() bool {
	if x != nil && x.TakeRemoveTopicInfo != nil {
		return *x.TakeRemoveTopicInfo
	}
	return false
}

func (x *HeartResponseM2B) GetBrokerDefaultConfInfo() string {
	if x != nil && x.BrokerDefaultConfInfo != nil {
		return *x.BrokerDefaultConfInfo
	}
	return ""
}

func (x *HeartResponseM2B) GetBrokerTopicSetConfInfo() []string {
	if x != nil {
		return x.BrokerTopicSetConfInfo
	}
	return nil
}

func (x *HeartResponseM2B) GetRemoveTopicConfInfo() []string {
	if x != nil {
		return x.RemoveTopicConfInfo
	}
	return nil
}

func (x *HeartResponseM2B) GetSsdStoreId() int64 {
	if x != nil && x.SsdStoreId != nil {
		return *x.SsdStoreId
	}
	return 0
}

func (x *HeartResponseM2B) GetFlowCheckId() int64 {
	if x != nil && x.FlowCheckId != nil {
		return *x.FlowCheckId
	}
	return 0
}

func (x *HeartResponseM2B) GetFlowControlInfo() string {
	if x != nil && x.FlowControlInfo != nil {
		return *x.FlowControlInfo
	}
	return ""
}

func (x *HeartResponseM2B) GetQryPriorityId() int32 {
	if x != nil && x.QryPriorityId != nil {
		return *x.QryPriorityId
	}
	return 0
}

func (x *HeartResponseM2B) GetAuthorizedInfo() *MasterAuthorizedInfo {
	if x != nil {
		return x.AuthorizedInfo
	}
	return nil
}

func (x *HeartResponseM2B) GetBrokerAuthorizedInfo() *MasterBrokerAuthorizedInfo {
	if x != nil {
		return x.BrokerAuthorizedInfo
	}
	return nil
}

func (x *HeartResponseM2B) GetClsConfig() *ClusterConfig {
	if x != nil {
		return x.ClsConfig
	}
	return nil
}

type CloseRequestB2M struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BrokerId *string                `protobuf:"bytes,1,req,name=brokerId" json:"brokerId,omitempty"`
	AuthInfo *MasterCertificateInfo `protobuf:"bytes,2,opt,name=authInfo" json:"authInfo,omitempty"`
}

func (x *CloseRequestB2M) Reset() {
	*x = CloseRequestB2M{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloseRequestB2M) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseRequestB2M) ProtoMessage() {}

func (x *CloseRequestB2M) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseRequestB2M.ProtoReflect.Descriptor instead.
func (*CloseRequestB2M) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{24}
}

func (x *CloseRequestB2M) GetBrokerId() string {
	if x != nil && x.BrokerId != nil {
		return *x.BrokerId
	}
	return ""
}

func (x *CloseRequestB2M) GetAuthInfo() *MasterCertificateInfo {
	if x != nil {
		return x.AuthInfo
	}
	return nil
}

type CloseResponseM2B struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Success *bool   `protobuf:"varint,1,req,name=success" json:"success,omitempty"`
	ErrCode *int32  `protobuf:"varint,2,req,name=errCode" json:"errCode,omitempty"`
	ErrMsg  *string `protobuf:"bytes,3,req,name=errMsg" json:"errMsg,omitempty"`
}

func (x *CloseResponseM2B) Reset() {
	*x = CloseResponseM2B{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloseResponseM2B) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseResponseM2B) ProtoMessage() {}

func (x *CloseResponseM2B) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseResponseM2B.ProtoReflect.Descriptor instead.
func (*CloseResponseM2B) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{25}
}

func (x *CloseResponseM2B) GetSuccess() bool {
	if x != nil && x.Success != nil {
		return *x.Success
	}
	return false
}

func (x *CloseResponseM2B) GetErrCode() int32 {
	if x != nil && x.ErrCode != nil {
		return *x.ErrCode
	}
	return 0
}

func (x *CloseResponseM2B) GetErrMsg() string {
	if x != nil && x.ErrMsg != nil {
		return *x.ErrMsg
	}
	return ""
}

type DataStorePath struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RecordId  *int32  `protobuf:"varint,1,req,name=recordId" json:"recordId,omitempty"`
	IsActive  *bool   `protobuf:"varint,2,req,name=isActive" json:"isActive,omitempty"`
	IsDefPath *bool   `protobuf:"varint,3,req,name=isDefPath" json:"isDefPath,omitempty"`
	DataPath  *string `protobuf:"bytes,4,opt,name=dataPath" json:"dataPath,omitempty"`
}

func (x *DataStorePath) Reset() {
	*x = DataStorePath{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataStorePath) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataStorePath) ProtoMessage() {}

func (x *DataStorePath) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataStorePath.ProtoReflect.Descriptor instead.
func (*DataStorePath) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{26}
}

func (x *DataStorePath) GetRecordId() int32 {
	if x != nil && x.RecordId != nil {
		return *x.RecordId
	}
	return 0
}

func (x *DataStorePath) GetIsActive() bool {
	if x != nil && x.IsActive != nil {
		return *x.IsActive
	}
	return false
}

func (x *DataStorePath) GetIsDefPath() bool {
	if x != nil && x.IsDefPath != nil {
		return *x.IsDefPath
	}
	return false
}

func (x *DataStorePath) GetDataPath() string {
	if x != nil && x.DataPath != nil {
		return *x.DataPath
	}
	return ""
}

type TopicRmvInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TopicName *string `protobuf:"bytes,1,req,name=topicName" json:"topicName,omitempty"`
	StatusId  *int32  `protobuf:"varint,2,req,name=statusId" json:"statusId,omitempty"`
}

func (x *TopicRmvInfo) Reset() {
	*x = TopicRmvInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TopicRmvInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TopicRmvInfo) ProtoMessage() {}

func (x *TopicRmvInfo) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TopicRmvInfo.ProtoReflect.Descriptor instead.
func (*TopicRmvInfo) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{27}
}

func (x *TopicRmvInfo) GetTopicName() string {
	if x != nil && x.TopicName != nil {
		return *x.TopicName
	}
	return ""
}

func (x *TopicRmvInfo) GetStatusId() int32 {
	if x != nil && x.StatusId != nil {
		return *x.StatusId
	}
	return 0
}

type DefaultConfigInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	NumTopicStores    *int32  `protobuf:"varint,1,req,name=numTopicStores" json:"numTopicStores,omitempty"`
	NumPartitions     *int32  `protobuf:"varint,2,req,name=numPartitions" json:"numPartitions,omitempty"`
	UnflushMsgCnt     *int32  `protobuf:"varint,3,req,name=unflushMsgCnt" json:"unflushMsgCnt,omitempty"`
	UnflushInterval   *int32  `protobuf:"varint,4,req,name=unflushInterval" json:"unflushInterval,omitempty"`
	UnflushDataSize   *int32  `protobuf:"varint,5,req,name=unflushDataSize" json:"unflushDataSize,omitempty"`
	MemCacheBlockSize *int32  `protobuf:"varint,6,req,name=memCacheBlockSize" json:"memCacheBlockSize,omitempty"`
	NumMemCacheBlock  *int32  `protobuf:"varint,7,req,name=numMemCacheBlock" json:"numMemCacheBlock,omitempty"`
	BathDiskWriteUnit *int32  `protobuf:"varint,8,req,name=bathDiskWriteUnit" json:"bathDiskWriteUnit,omitempty"`
	BathDiskReadUnit  *int32  `protobuf:"varint,9,req,name=bathDiskReadUnit" json:"bathDiskReadUnit,omitempty"`
	AcceptPublish     *bool   `protobuf:"varint,10,req,name=acceptPublish" json:"acceptPublish,omitempty"`
	AcceptSubscribe   *bool   `protobuf:"varint,11,req,name=acceptSubscribe" json:"acceptSubscribe,omitempty"`
	DeletePolicy      *string `protobuf:"bytes,12,req,name=deletePolicy" json:"deletePolicy,omitempty"`
}

func (x *DefaultConfigInfo) Reset() {
	*x = DefaultConfigInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DefaultConfigInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DefaultConfigInfo) ProtoMessage() {}

func (x *DefaultConfigInfo) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DefaultConfigInfo.ProtoReflect.Descriptor instead.
func (*DefaultConfigInfo) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{28}
}

func (x *DefaultConfigInfo) GetNumTopicStores() int32 {
	if x != nil && x.NumTopicStores != nil {
		return *x.NumTopicStores
	}
	return 0
}

func (x *DefaultConfigInfo) GetNumPartitions() int32 {
	if x != nil && x.NumPartitions != nil {
		return *x.NumPartitions
	}
	return 0
}

func (x *DefaultConfigInfo) GetUnflushMsgCnt() int32 {
	if x != nil && x.UnflushMsgCnt != nil {
		return *x.UnflushMsgCnt
	}
	return 0
}

func (x *DefaultConfigInfo) GetUnflushInterval() int32 {
	if x != nil && x.UnflushInterval != nil {
		return *x.UnflushInterval
	}
	return 0
}

func (x *DefaultConfigInfo) GetUnflushDataSize() int32 {
	if x != nil && x.UnflushDataSize != nil {
		return *x.UnflushDataSize
	}
	return 0
}

func (x *DefaultConfigInfo) GetMemCacheBlockSize() int32 {
	if x != nil && x.MemCacheBlockSize != nil {
		return *x.MemCacheBlockSize
	}
	return 0
}

func (x *DefaultConfigInfo) GetNumMemCacheBlock() int32 {
	if x != nil && x.NumMemCacheBlock != nil {
		return *x.NumMemCacheBlock
	}
	return 0
}

func (x *DefaultConfigInfo) GetBathDiskWriteUnit() int32 {
	if x != nil && x.BathDiskWriteUnit != nil {
		return *x.BathDiskWriteUnit
	}
	return 0
}

func (x *DefaultConfigInfo) GetBathDiskReadUnit() int32 {
	if x != nil && x.BathDiskReadUnit != nil {
		return *x.BathDiskReadUnit
	}
	return 0
}

func (x *DefaultConfigInfo) GetAcceptPublish() bool {
	if x != nil && x.AcceptPublish != nil {
		return *x.AcceptPublish
	}
	return false
}

func (x *DefaultConfigInfo) GetAcceptSubscribe() bool {
	if x != nil && x.AcceptSubscribe != nil {
		return *x.AcceptSubscribe
	}
	return false
}

func (x *DefaultConfigInfo) GetDeletePolicy() string {
	if x != nil && x.DeletePolicy != nil {
		return *x.DeletePolicy
	}
	return ""
}

type TopicConfigInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TopicName         *string          `protobuf:"bytes,1,req,name=topicName" json:"topicName,omitempty"`
	StatusId          *int32           `protobuf:"varint,2,opt,name=statusId" json:"statusId,omitempty"`
	NumTopicStores    *int32           `protobuf:"varint,3,opt,name=numTopicStores" json:"numTopicStores,omitempty"`
	NumPartitions     *int32           `protobuf:"varint,4,opt,name=numPartitions" json:"numPartitions,omitempty"`
	UnflushMsgCnt     *int32           `protobuf:"varint,5,opt,name=unflushMsgCnt" json:"unflushMsgCnt,omitempty"`
	UnflushInterval   *int32           `protobuf:"varint,6,opt,name=unflushInterval" json:"unflushInterval,omitempty"`
	UnflushDataSize   *int32           `protobuf:"varint,7,opt,name=unflushDataSize" json:"unflushDataSize,omitempty"`
	MemCacheBlockSize *int32           `protobuf:"varint,8,opt,name=memCacheBlockSize" json:"memCacheBlockSize,omitempty"`
	NumMemCacheBlock  *int32           `protobuf:"varint,9,opt,name=numMemCacheBlock" json:"numMemCacheBlock,omitempty"`
	AcceptPublish     *bool            `protobuf:"varint,10,opt,name=acceptPublish" json:"acceptPublish,omitempty"`
	AcceptSubscribe   *bool            `protobuf:"varint,11,opt,name=acceptSubscribe" json:"acceptSubscribe,omitempty"`
	DeletePolicy      *string          `protobuf:"bytes,12,opt,name=deletePolicy" json:"deletePolicy,omitempty"`
	DataPath          []*DataStorePath `protobuf:"bytes,13,rep,name=dataPath" json:"dataPath,omitempty"`
}

func (x *TopicConfigInfo) Reset() {
	*x = TopicConfigInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TopicConfigInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TopicConfigInfo) ProtoMessage() {}

func (x *TopicConfigInfo) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TopicConfigInfo.ProtoReflect.Descriptor instead.
func (*TopicConfigInfo) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{29}
}

func (x *TopicConfigInfo) GetTopicName() string {
	if x != nil && x.TopicName != nil {
		return *x.TopicName
	}
	return ""
}

func (x *TopicConfigInfo) GetStatusId() int32 {
	if x != nil && x.StatusId != nil {
		return *x.StatusId
	}
	return 0
}

func (x *TopicConfigInfo) GetNumTopicStores() int32 {
	if x != nil && x.NumTopicStores != nil {
		return *x.NumTopicStores
	}
	return 0
}

func (x *TopicConfigInfo) GetNumPartitions() int32 {
	if x != nil && x.NumPartitions != nil {
		return *x.NumPartitions
	}
	return 0
}

func (x *TopicConfigInfo) GetUnflushMsgCnt() int32 {
	if x != nil && x.UnflushMsgCnt != nil {
		return *x.UnflushMsgCnt
	}
	return 0
}

func (x *TopicConfigInfo) GetUnflushInterval() int32 {
	if x != nil && x.UnflushInterval != nil {
		return *x.UnflushInterval
	}
	return 0
}

func (x *TopicConfigInfo) GetUnflushDataSize() int32 {
	if x != nil && x.UnflushDataSize != nil {
		return *x.UnflushDataSize
	}
	return 0
}

func (x *TopicConfigInfo) GetMemCacheBlockSize() int32 {
	if x != nil && x.MemCacheBlockSize != nil {
		return *x.MemCacheBlockSize
	}
	return 0
}

func (x *TopicConfigInfo) GetNumMemCacheBlock() int32 {
	if x != nil && x.NumMemCacheBlock != nil {
		return *x.NumMemCacheBlock
	}
	return 0
}

func (x *TopicConfigInfo) GetAcceptPublish() bool {
	if x != nil && x.AcceptPublish != nil {
		return *x.AcceptPublish
	}
	return false
}

func (x *TopicConfigInfo) GetAcceptSubscribe() bool {
	if x != nil && x.AcceptSubscribe != nil {
		return *x.AcceptSubscribe
	}
	return false
}

func (x *TopicConfigInfo) GetDeletePolicy() string {
	if x != nil && x.DeletePolicy != nil {
		return *x.DeletePolicy
	}
	return ""
}

func (x *TopicConfigInfo) GetDataPath() []*DataStorePath {
	if x != nil {
		return x.DataPath
	}
	return nil
}

type BrokerConfigInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BrokerConfId     *int64             `protobuf:"varint,1,req,name=brokerConfId" json:"brokerConfId,omitempty"`
	ConfCheckSumId   *int32             `protobuf:"varint,2,req,name=confCheckSumId" json:"confCheckSumId,omitempty"`
	DefConfigInfo    *DefaultConfigInfo `protobuf:"bytes,3,opt,name=defConfigInfo" json:"defConfigInfo,omitempty"`
	TopicConfigInfos []*TopicConfigInfo `protobuf:"bytes,4,rep,name=topicConfigInfos" json:"topicConfigInfos,omitempty"`
	EnableTls        *bool              `protobuf:"varint,5,opt,name=enableTls" json:"enableTls,omitempty"`
	TlsPort          *int32             `protobuf:"varint,6,opt,name=tlsPort" json:"tlsPort,omitempty"`
	WebPort          *int32             `protobuf:"varint,7,opt,name=webPort" json:"webPort,omitempty"`
}

func (x *BrokerConfigInfo) Reset() {
	*x = BrokerConfigInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BrokerConfigInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BrokerConfigInfo) ProtoMessage() {}

func (x *BrokerConfigInfo) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BrokerConfigInfo.ProtoReflect.Descriptor instead.
func (*BrokerConfigInfo) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{30}
}

func (x *BrokerConfigInfo) GetBrokerConfId() int64 {
	if x != nil && x.BrokerConfId != nil {
		return *x.BrokerConfId
	}
	return 0
}

func (x *BrokerConfigInfo) GetConfCheckSumId() int32 {
	if x != nil && x.ConfCheckSumId != nil {
		return *x.ConfCheckSumId
	}
	return 0
}

func (x *BrokerConfigInfo) GetDefConfigInfo() *DefaultConfigInfo {
	if x != nil {
		return x.DefConfigInfo
	}
	return nil
}

func (x *BrokerConfigInfo) GetTopicConfigInfos() []*TopicConfigInfo {
	if x != nil {
		return x.TopicConfigInfos
	}
	return nil
}

func (x *BrokerConfigInfo) GetEnableTls() bool {
	if x != nil && x.EnableTls != nil {
		return *x.EnableTls
	}
	return false
}

func (x *BrokerConfigInfo) GetTlsPort() int32 {
	if x != nil && x.TlsPort != nil {
		return *x.TlsPort
	}
	return 0
}

func (x *BrokerConfigInfo) GetWebPort() int32 {
	if x != nil && x.WebPort != nil {
		return *x.WebPort
	}
	return 0
}

type BrokerPolicyInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PolicyId      *int64  `protobuf:"varint,1,opt,name=policyId" json:"policyId,omitempty"`
	QryPriorityId *int32  `protobuf:"varint,2,opt,name=qryPriorityId" json:"qryPriorityId,omitempty"`
	PolicyInfo    *string `protobuf:"bytes,3,opt,name=policyInfo" json:"policyInfo,omitempty"`
}

func (x *BrokerPolicyInfo) Reset() {
	*x = BrokerPolicyInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BrokerPolicyInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BrokerPolicyInfo) ProtoMessage() {}

func (x *BrokerPolicyInfo) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BrokerPolicyInfo.ProtoReflect.Descriptor instead.
func (*BrokerPolicyInfo) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{31}
}

func (x *BrokerPolicyInfo) GetPolicyId() int64 {
	if x != nil && x.PolicyId != nil {
		return *x.PolicyId
	}
	return 0
}

func (x *BrokerPolicyInfo) GetQryPriorityId() int32 {
	if x != nil && x.QryPriorityId != nil {
		return *x.QryPriorityId
	}
	return 0
}

func (x *BrokerPolicyInfo) GetPolicyInfo() string {
	if x != nil && x.PolicyInfo != nil {
		return *x.PolicyInfo
	}
	return ""
}

type BrokerStatusInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	IsOnline       *bool  `protobuf:"varint,1,req,name=isOnline" json:"isOnline,omitempty"`
	ReadStatusRpt  *int32 `protobuf:"varint,2,req,name=readStatusRpt" json:"readStatusRpt,omitempty"`
	WriteStatusRpt *int32 `protobuf:"varint,3,req,name=writeStatusRpt" json:"writeStatusRpt,omitempty"`
	LastOperateId  *int32 `protobuf:"varint,4,opt,name=lastOperateId" json:"lastOperateId,omitempty"`
}

func (x *BrokerStatusInfo) Reset() {
	*x = BrokerStatusInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BrokerStatusInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BrokerStatusInfo) ProtoMessage() {}

func (x *BrokerStatusInfo) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BrokerStatusInfo.ProtoReflect.Descriptor instead.
func (*BrokerStatusInfo) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{32}
}

func (x *BrokerStatusInfo) GetIsOnline() bool {
	if x != nil && x.IsOnline != nil {
		return *x.IsOnline
	}
	return false
}

func (x *BrokerStatusInfo) GetReadStatusRpt() int32 {
	if x != nil && x.ReadStatusRpt != nil {
		return *x.ReadStatusRpt
	}
	return 0
}

func (x *BrokerStatusInfo) GetWriteStatusRpt() int32 {
	if x != nil && x.WriteStatusRpt != nil {
		return *x.WriteStatusRpt
	}
	return 0
}

func (x *BrokerStatusInfo) GetLastOperateId() int32 {
	if x != nil && x.LastOperateId != nil {
		return *x.LastOperateId
	}
	return 0
}

type BrokerOperateInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	OperateId *int32 `protobuf:"varint,1,req,name=operateId" json:"operateId,omitempty"`
	// 00:normal, 01:stop read, 10:stop write, 11:stop read and write
	FrcServiceStatus          *int32          `protobuf:"varint,2,req,name=frcServiceStatus" json:"frcServiceStatus,omitempty"`
	FrcRptConfig              *bool           `protobuf:"varint,3,opt,name=frcRptConfig" json:"frcRptConfig,omitempty"`
	EnableConsumeAuthenticate *bool           `protobuf:"varint,4,opt,name=enableConsumeAuthenticate" json:"enableConsumeAuthenticate,omitempty"`
	EnableConsumeAuthorize    *bool           `protobuf:"varint,5,opt,name=enableConsumeAuthorize" json:"enableConsumeAuthorize,omitempty"`
	EnableProduceAuthenticate *bool           `protobuf:"varint,6,opt,name=enableProduceAuthenticate" json:"enableProduceAuthenticate,omitempty"`
	EnableProduceAuthorize    *bool           `protobuf:"varint,7,opt,name=enableProduceAuthorize" json:"enableProduceAuthorize,omitempty"`
	EnableVisitTokenCheck     *bool           `protobuf:"varint,8,opt,name=enableVisitTokenCheck" json:"enableVisitTokenCheck,omitempty"`
	RmvTopicsInfo             []*TopicRmvInfo `protobuf:"bytes,9,rep,name=rmvTopicsInfo" json:"rmvTopicsInfo,omitempty"`
}

func (x *BrokerOperateInfo) Reset() {
	*x = BrokerOperateInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BrokerOperateInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BrokerOperateInfo) ProtoMessage() {}

func (x *BrokerOperateInfo) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BrokerOperateInfo.ProtoReflect.Descriptor instead.
func (*BrokerOperateInfo) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{33}
}

func (x *BrokerOperateInfo) GetOperateId() int32 {
	if x != nil && x.OperateId != nil {
		return *x.OperateId
	}
	return 0
}

func (x *BrokerOperateInfo) GetFrcServiceStatus() int32 {
	if x != nil && x.FrcServiceStatus != nil {
		return *x.FrcServiceStatus
	}
	return 0
}

func (x *BrokerOperateInfo) GetFrcRptConfig() bool {
	if x != nil && x.FrcRptConfig != nil {
		return *x.FrcRptConfig
	}
	return false
}

func (x *BrokerOperateInfo) GetEnableConsumeAuthenticate() bool {
	if x != nil && x.EnableConsumeAuthenticate != nil {
		return *x.EnableConsumeAuthenticate
	}
	return false
}

func (x *BrokerOperateInfo) GetEnableConsumeAuthorize() bool {
	if x != nil && x.EnableConsumeAuthorize != nil {
		return *x.EnableConsumeAuthorize
	}
	return false
}

func (x *BrokerOperateInfo) GetEnableProduceAuthenticate() bool {
	if x != nil && x.EnableProduceAuthenticate != nil {
		return *x.EnableProduceAuthenticate
	}
	return false
}

func (x *BrokerOperateInfo) GetEnableProduceAuthorize() bool {
	if x != nil && x.EnableProduceAuthorize != nil {
		return *x.EnableProduceAuthorize
	}
	return false
}

func (x *BrokerOperateInfo) GetEnableVisitTokenCheck() bool {
	if x != nil && x.EnableVisitTokenCheck != nil {
		return *x.EnableVisitTokenCheck
	}
	return false
}

func (x *BrokerOperateInfo) GetRmvTopicsInfo() []*TopicRmvInfo {
	if x != nil {
		return x.RmvTopicsInfo
	}
	return nil
}

type RegisterRequest_V2_B2M struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientId      *string                `protobuf:"bytes,1,req,name=clientId" json:"clientId,omitempty"`
	StatusRptInfo *BrokerStatusInfo      `protobuf:"bytes,2,req,name=statusRptInfo" json:"statusRptInfo,omitempty"`
	ConfigInfo    *BrokerConfigInfo      `protobuf:"bytes,3,req,name=configInfo" json:"configInfo,omitempty"`
	PolicyInfo    *BrokerPolicyInfo      `protobuf:"bytes,4,req,name=policyInfo" json:"policyInfo,omitempty"`
	AuthInfo      *MasterCertificateInfo `protobuf:"bytes,5,opt,name=authInfo" json:"authInfo,omitempty"`
}

func (x *RegisterRequest_V2_B2M) Reset() {
	*x = RegisterRequest_V2_B2M{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterRequest_V2_B2M) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterRequest_V2_B2M) ProtoMessage() {}

func (x *RegisterRequest_V2_B2M) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterRequest_V2_B2M.ProtoReflect.Descriptor instead.
func (*RegisterRequest_V2_B2M) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{34}
}

func (x *RegisterRequest_V2_B2M) GetClientId() string {
	if x != nil && x.ClientId != nil {
		return *x.ClientId
	}
	return ""
}

func (x *RegisterRequest_V2_B2M) GetStatusRptInfo() *BrokerStatusInfo {
	if x != nil {
		return x.StatusRptInfo
	}
	return nil
}

func (x *RegisterRequest_V2_B2M) GetConfigInfo() *BrokerConfigInfo {
	if x != nil {
		return x.ConfigInfo
	}
	return nil
}

func (x *RegisterRequest_V2_B2M) GetPolicyInfo() *BrokerPolicyInfo {
	if x != nil {
		return x.PolicyInfo
	}
	return nil
}

func (x *RegisterRequest_V2_B2M) GetAuthInfo() *MasterCertificateInfo {
	if x != nil {
		return x.AuthInfo
	}
	return nil
}

type RegisterResponse_V2_M2B struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ErrCode        *int32                      `protobuf:"varint,1,req,name=errCode" json:"errCode,omitempty"`
	ErrMsg         *string                     `protobuf:"bytes,2,opt,name=errMsg" json:"errMsg,omitempty"`
	ConfigInfo     *BrokerConfigInfo           `protobuf:"bytes,3,opt,name=configInfo" json:"configInfo,omitempty"`
	OperateInfo    *BrokerOperateInfo          `protobuf:"bytes,4,opt,name=operateInfo" json:"operateInfo,omitempty"`
	PolicyInfo     *BrokerPolicyInfo           `protobuf:"bytes,5,opt,name=policyInfo" json:"policyInfo,omitempty"`
	AuthorizedInfo *MasterBrokerAuthorizedInfo `protobuf:"bytes,6,opt,name=authorizedInfo" json:"authorizedInfo,omitempty"`
}

func (x *RegisterResponse_V2_M2B) Reset() {
	*x = RegisterResponse_V2_M2B{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterResponse_V2_M2B) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterResponse_V2_M2B) ProtoMessage() {}

func (x *RegisterResponse_V2_M2B) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterResponse_V2_M2B.ProtoReflect.Descriptor instead.
func (*RegisterResponse_V2_M2B) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{35}
}

func (x *RegisterResponse_V2_M2B) GetErrCode() int32 {
	if x != nil && x.ErrCode != nil {
		return *x.ErrCode
	}
	return 0
}

func (x *RegisterResponse_V2_M2B) GetErrMsg() string {
	if x != nil && x.ErrMsg != nil {
		return *x.ErrMsg
	}
	return ""
}

func (x *RegisterResponse_V2_M2B) GetConfigInfo() *BrokerConfigInfo {
	if x != nil {
		return x.ConfigInfo
	}
	return nil
}

func (x *RegisterResponse_V2_M2B) GetOperateInfo() *BrokerOperateInfo {
	if x != nil {
		return x.OperateInfo
	}
	return nil
}

func (x *RegisterResponse_V2_M2B) GetPolicyInfo() *BrokerPolicyInfo {
	if x != nil {
		return x.PolicyInfo
	}
	return nil
}

func (x *RegisterResponse_V2_M2B) GetAuthorizedInfo() *MasterBrokerAuthorizedInfo {
	if x != nil {
		return x.AuthorizedInfo
	}
	return nil
}

type HeartRequest_V2_B2M struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BrokerId      *string                `protobuf:"bytes,1,req,name=brokerId" json:"brokerId,omitempty"`
	StatusRptInfo *BrokerStatusInfo      `protobuf:"bytes,2,req,name=statusRptInfo" json:"statusRptInfo,omitempty"`
	ConfigInfo    *BrokerConfigInfo      `protobuf:"bytes,3,req,name=configInfo" json:"configInfo,omitempty"`
	PolicyInfo    *BrokerPolicyInfo      `protobuf:"bytes,4,opt,name=policyInfo" json:"policyInfo,omitempty"`
	AuthInfo      *MasterCertificateInfo `protobuf:"bytes,5,opt,name=authInfo" json:"authInfo,omitempty"`
}

func (x *HeartRequest_V2_B2M) Reset() {
	*x = HeartRequest_V2_B2M{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeartRequest_V2_B2M) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeartRequest_V2_B2M) ProtoMessage() {}

func (x *HeartRequest_V2_B2M) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeartRequest_V2_B2M.ProtoReflect.Descriptor instead.
func (*HeartRequest_V2_B2M) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{36}
}

func (x *HeartRequest_V2_B2M) GetBrokerId() string {
	if x != nil && x.BrokerId != nil {
		return *x.BrokerId
	}
	return ""
}

func (x *HeartRequest_V2_B2M) GetStatusRptInfo() *BrokerStatusInfo {
	if x != nil {
		return x.StatusRptInfo
	}
	return nil
}

func (x *HeartRequest_V2_B2M) GetConfigInfo() *BrokerConfigInfo {
	if x != nil {
		return x.ConfigInfo
	}
	return nil
}

func (x *HeartRequest_V2_B2M) GetPolicyInfo() *BrokerPolicyInfo {
	if x != nil {
		return x.PolicyInfo
	}
	return nil
}

func (x *HeartRequest_V2_B2M) GetAuthInfo() *MasterCertificateInfo {
	if x != nil {
		return x.AuthInfo
	}
	return nil
}

type HeartResponse_V2_M2B struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ErrCode              *int32                      `protobuf:"varint,1,req,name=errCode" json:"errCode,omitempty"`
	ErrMsg               *string                     `protobuf:"bytes,2,opt,name=errMsg" json:"errMsg,omitempty"`
	ConfigInfo           *BrokerConfigInfo           `protobuf:"bytes,3,opt,name=configInfo" json:"configInfo,omitempty"`
	OperateInfo          *BrokerOperateInfo          `protobuf:"bytes,4,opt,name=operateInfo" json:"operateInfo,omitempty"`
	PolicyInfo           *BrokerPolicyInfo           `protobuf:"bytes,5,opt,name=policyInfo" json:"policyInfo,omitempty"`
	BrokerAuthorizedInfo *MasterBrokerAuthorizedInfo `protobuf:"bytes,6,opt,name=brokerAuthorizedInfo" json:"brokerAuthorizedInfo,omitempty"`
}

func (x *HeartResponse_V2_M2B) Reset() {
	*x = HeartResponse_V2_M2B{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeartResponse_V2_M2B) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeartResponse_V2_M2B) ProtoMessage() {}

func (x *HeartResponse_V2_M2B) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeartResponse_V2_M2B.ProtoReflect.Descriptor instead.
func (*HeartResponse_V2_M2B) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{37}
}

func (x *HeartResponse_V2_M2B) GetErrCode() int32 {
	if x != nil && x.ErrCode != nil {
		return *x.ErrCode
	}
	return 0
}

func (x *HeartResponse_V2_M2B) GetErrMsg() string {
	if x != nil && x.ErrMsg != nil {
		return *x.ErrMsg
	}
	return ""
}

func (x *HeartResponse_V2_M2B) GetConfigInfo() *BrokerConfigInfo {
	if x != nil {
		return x.ConfigInfo
	}
	return nil
}

func (x *HeartResponse_V2_M2B) GetOperateInfo() *BrokerOperateInfo {
	if x != nil {
		return x.OperateInfo
	}
	return nil
}

func (x *HeartResponse_V2_M2B) GetPolicyInfo() *BrokerPolicyInfo {
	if x != nil {
		return x.PolicyInfo
	}
	return nil
}

func (x *HeartResponse_V2_M2B) GetBrokerAuthorizedInfo() *MasterBrokerAuthorizedInfo {
	if x != nil {
		return x.BrokerAuthorizedInfo
	}
	return nil
}

type CloseRequest_V2_B2M struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BrokerId *string                `protobuf:"bytes,1,req,name=brokerId" json:"brokerId,omitempty"`
	AuthInfo *MasterCertificateInfo `protobuf:"bytes,2,opt,name=authInfo" json:"authInfo,omitempty"`
}

func (x *CloseRequest_V2_B2M) Reset() {
	*x = CloseRequest_V2_B2M{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloseRequest_V2_B2M) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseRequest_V2_B2M) ProtoMessage() {}

func (x *CloseRequest_V2_B2M) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseRequest_V2_B2M.ProtoReflect.Descriptor instead.
func (*CloseRequest_V2_B2M) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{38}
}

func (x *CloseRequest_V2_B2M) GetBrokerId() string {
	if x != nil && x.BrokerId != nil {
		return *x.BrokerId
	}
	return ""
}

func (x *CloseRequest_V2_B2M) GetAuthInfo() *MasterCertificateInfo {
	if x != nil {
		return x.AuthInfo
	}
	return nil
}

type CloseResponse_V2_M2B struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ErrCode *int32  `protobuf:"varint,1,req,name=errCode" json:"errCode,omitempty"`
	ErrMsg  *string `protobuf:"bytes,2,opt,name=errMsg" json:"errMsg,omitempty"`
}

func (x *CloseResponse_V2_M2B) Reset() {
	*x = CloseResponse_V2_M2B{}
	if protoimpl.UnsafeEnabled {
		mi := &file_MasterService_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloseResponse_V2_M2B) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseResponse_V2_M2B) ProtoMessage() {}

func (x *CloseResponse_V2_M2B) ProtoReflect() protoreflect.Message {
	mi := &file_MasterService_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseResponse_V2_M2B.ProtoReflect.Descriptor instead.
func (*CloseResponse_V2_M2B) Descriptor() ([]byte, []int) {
	return file_MasterService_proto_rawDescGZIP(), []int{39}
}

func (x *CloseResponse_V2_M2B) GetErrCode() int32 {
	if x != nil && x.ErrCode != nil {
		return *x.ErrCode
	}
	return 0
}

func (x *CloseResponse_V2_M2B) GetErrMsg() string {
	if x != nil && x.ErrMsg != nil {
		return *x.ErrMsg
	}
	return ""
}

var File_MasterService_proto protoreflect.FileDescriptor

var file_MasterService_proto_rawDesc = []byte{
	0x0a, 0x13, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x84, 0x01, 0x0a, 0x0a, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63,
	0x65, 0x49, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x62, 0x61, 0x6c,
	0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x70, 0x54, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x6f, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x16,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x24, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x62, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x73,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0xb7, 0x02, 0x0a,
	0x13, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x46, 0x75, 0x6e,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3c, 0x0a, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x08, 0x52, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43,
	0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x12, 0x36, 0x0a, 0x16, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x73,
	0x75, 0x6d, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x02,
	0x28, 0x08, 0x52, 0x16, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x12, 0x3c, 0x0a, 0x19, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x41, 0x75, 0x74, 0x68, 0x65,
	0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x08, 0x52, 0x19, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x41, 0x75, 0x74, 0x68,
	0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x36, 0x0a, 0x16, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x65, 0x18, 0x04, 0x20, 0x02, 0x28, 0x08, 0x52, 0x16, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65,
	0x12, 0x34, 0x0a, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x56, 0x69, 0x73, 0x69, 0x74, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x56, 0x69, 0x73, 0x69, 0x74, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x22, 0x9e, 0x01, 0x0a, 0x10, 0x41, 0x75, 0x74, 0x68, 0x65,
	0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1a, 0x0a, 0x08, 0x75,
	0x73, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x08, 0x75,
	0x73, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x02, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x14, 0x0a, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x18, 0x03,
	0x20, 0x02, 0x28, 0x05, 0x52, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6f,
	0x74, 0x68, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x02, 0x28, 0x09, 0x52, 0x09,
	0x6f, 0x74, 0x68, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x69, 0x67,
	0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x05, 0x20, 0x02, 0x28, 0x09, 0x52, 0x09, 0x73, 0x69,
	0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x22, 0x70, 0x0a, 0x15, 0x4d, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x2d, 0x0a, 0x08, 0x61, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x61, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x28, 0x0a, 0x0f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x65, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7c, 0x0a, 0x14, 0x4d, 0x61, 0x73,
	0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x32, 0x0a, 0x14, 0x76, 0x69, 0x73, 0x69, 0x74, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x65, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x02, 0x28, 0x03, 0x52,
	0x14, 0x76, 0x69, 0x73, 0x69, 0x74, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x30, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x13, 0x61, 0x75, 0x74, 0x68, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x82, 0x01, 0x0a, 0x1a, 0x4d, 0x61, 0x73, 0x74,
	0x65, 0x72, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x32, 0x0a, 0x14, 0x76, 0x69, 0x73, 0x69, 0x74, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x14, 0x76, 0x69, 0x73, 0x69, 0x74, 0x41, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x30, 0x0a, 0x13, 0x61, 0x75,
	0x74, 0x68, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x61, 0x75, 0x74, 0x68, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x52, 0x0a, 0x14,
	0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x03, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64,
	0x12, 0x1e, 0x0a, 0x0a, 0x6d, 0x61, 0x78, 0x4d, 0x73, 0x67, 0x53, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x4d, 0x73, 0x67, 0x53, 0x69, 0x7a, 0x65,
	0x22, 0x4b, 0x0a, 0x0d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x18, 0x01, 0x20,
	0x02, 0x28, 0x03, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x1e, 0x0a,
	0x0a, 0x6d, 0x61, 0x78, 0x4d, 0x73, 0x67, 0x53, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x4d, 0x73, 0x67, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x9d, 0x02,
	0x0a, 0x12, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x32, 0x4d, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64,
	0x12, 0x1c, 0x0a, 0x09, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x4c, 0x69, 0x73, 0x74, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x09, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x26,
	0x0a, 0x0e, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x53, 0x75, 0x6d,
	0x18, 0x03, 0x20, 0x02, 0x28, 0x03, 0x52, 0x0e, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x53, 0x75, 0x6d, 0x12, 0x1a, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x4e, 0x61,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x02, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x32, 0x0a, 0x08, 0x61, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x61, 0x75,
	0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1e, 0x0a, 0x0a, 0x6a, 0x64, 0x6b, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6a, 0x64, 0x6b, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x0a, 0x61, 0x70, 0x70, 0x64, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x41, 0x70, 0x70,
	0x72, 0x6f, 0x76, 0x65, 0x64, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x0a, 0x61, 0x70, 0x70, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xa1, 0x02,
	0x0a, 0x13, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x4d, 0x32, 0x50, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x08, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12,
	0x18, 0x0a, 0x07, 0x65, 0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x05,
	0x52, 0x07, 0x65, 0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x72, 0x72,
	0x4d, 0x73, 0x67, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73,
	0x67, 0x12, 0x26, 0x0a, 0x0e, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x53, 0x75, 0x6d, 0x18, 0x04, 0x20, 0x02, 0x28, 0x03, 0x52, 0x0e, 0x62, 0x72, 0x6f, 0x6b, 0x65,
	0x72, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x53, 0x75, 0x6d, 0x12, 0x20, 0x0a, 0x0b, 0x62, 0x72, 0x6f,
	0x6b, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b,
	0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x12, 0x3d, 0x0a, 0x0e, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0e, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x35, 0x0a, 0x0a, 0x61, 0x70,
	0x70, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15,
	0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0a, 0x61, 0x70, 0x70, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x22, 0xfa, 0x01, 0x0a, 0x0f, 0x48, 0x65, 0x61, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x32, 0x4d, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49,
	0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49,
	0x64, 0x12, 0x26, 0x0a, 0x0e, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x53, 0x75, 0x6d, 0x18, 0x02, 0x20, 0x02, 0x28, 0x03, 0x52, 0x0e, 0x62, 0x72, 0x6f, 0x6b, 0x65,
	0x72, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x53, 0x75, 0x6d, 0x12, 0x1a, 0x0a, 0x08, 0x68, 0x6f, 0x73,
	0x74, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73,
	0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x4c, 0x69,
	0x73, 0x74, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x4c,
	0x69, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x08, 0x61, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x61,
	0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x35, 0x0a, 0x0a, 0x61, 0x70, 0x70, 0x64, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x41, 0x70,
	0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x0a, 0x61, 0x70, 0x70, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xe0,
	0x02, 0x0a, 0x10, 0x48, 0x65, 0x61, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x4d, 0x32, 0x50, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x08, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x18, 0x0a,
	0x07, 0x65, 0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x05, 0x52, 0x07,
	0x65, 0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73,
	0x67, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67, 0x12,
	0x26, 0x0a, 0x0e, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x53, 0x75,
	0x6d, 0x18, 0x04, 0x20, 0x02, 0x28, 0x03, 0x52, 0x0e, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x53, 0x75, 0x6d, 0x12, 0x1e, 0x0a, 0x0a, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x49, 0x6e, 0x66, 0x6f, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x6f, 0x70,
	0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x62, 0x72, 0x6f, 0x6b, 0x65,
	0x72, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x62, 0x72,
	0x6f, 0x6b, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x41, 0x75, 0x74, 0x68, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b,
	0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x41, 0x75, 0x74, 0x68, 0x12, 0x3d, 0x0a, 0x0e, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0e, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x35, 0x0a, 0x0a, 0x61, 0x70,
	0x70, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15,
	0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0a, 0x61, 0x70, 0x70, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x22, 0x61, 0x0a, 0x0f, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x32, 0x4d, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64,
	0x12, 0x32, 0x0a, 0x08, 0x61, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x16, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x61, 0x75, 0x74, 0x68,
	0x49, 0x6e, 0x66, 0x6f, 0x22, 0x5e, 0x0a, 0x10, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x32, 0x50, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x02, 0x28, 0x08, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20,
	0x02, 0x28, 0x05, 0x52, 0x07, 0x65, 0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06,
	0x65, 0x72, 0x72, 0x4d, 0x73, 0x67, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x06, 0x65, 0x72,
	0x72, 0x4d, 0x73, 0x67, 0x22, 0xba, 0x05, 0x0a, 0x12, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x43, 0x32, 0x4d, 0x12, 0x1a, 0x0a, 0x08, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x08, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x4e, 0x61, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x4c, 0x69, 0x73, 0x74, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x4c, 0x69, 0x73, 0x74, 0x12,
	0x24, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x26, 0x0a, 0x0e, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x74,
	0x6f, 0x70, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a,
	0x0c, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x42, 0x6f, 0x75, 0x6e,
	0x64, 0x12, 0x20, 0x0a, 0x0b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65,
	0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x4b, 0x65, 0x79, 0x12, 0x1e, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x11, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11,
	0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x22, 0x0a, 0x0c, 0x6e, 0x6f, 0x74, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x6e, 0x6f, 0x74, 0x41, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x42,
	0x69, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x42, 0x69, 0x67, 0x12, 0x2a, 0x0a, 0x10, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x6c, 0x6f, 0x77,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x46, 0x6c, 0x6f, 0x77, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x64, 0x12,
	0x26, 0x0a, 0x0e, 0x64, 0x65, 0x66, 0x46, 0x6c, 0x6f, 0x77, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49,
	0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x64, 0x65, 0x66, 0x46, 0x6c, 0x6f, 0x77,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x73, 0x64, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x49, 0x64, 0x18, 0x10, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x73, 0x73, 0x64,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0d, 0x71, 0x72, 0x79, 0x50, 0x72,
	0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x49, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d,
	0x71, 0x72, 0x79, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x32, 0x0a,
	0x08, 0x61, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x16, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x61, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x1e, 0x0a, 0x0a, 0x6a, 0x64, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x13, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6a, 0x64, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x22, 0xe0, 0x03, 0x0a, 0x13, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x32, 0x43, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x02, 0x28, 0x08, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x18, 0x02,
	0x20, 0x02, 0x28, 0x05, 0x52, 0x07, 0x65, 0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a,
	0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x06, 0x65,
	0x72, 0x72, 0x4d, 0x73, 0x67, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x49, 0x6e,
	0x66, 0x6f, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x22, 0x0a, 0x0c, 0x6e, 0x6f, 0x74, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x6e, 0x6f, 0x74, 0x41, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x26, 0x0a, 0x0e, 0x64, 0x65, 0x66, 0x46, 0x6c,
	0x6f, 0x77, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0e, 0x64, 0x65, 0x66, 0x46, 0x6c, 0x6f, 0x77, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x64, 0x12,
	0x2e, 0x0a, 0x12, 0x64, 0x65, 0x66, 0x46, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x64, 0x65, 0x66,
	0x46, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x2a, 0x0a, 0x10, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x6c, 0x6f, 0x77, 0x43, 0x68, 0x65, 0x63,
	0x6b, 0x49, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x46, 0x6c, 0x6f, 0x77, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x14, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x46, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x49,
	0x6e, 0x66, 0x6f, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x46, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x1e, 0x0a, 0x0a, 0x73, 0x73, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0a, 0x73, 0x73, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x12,
	0x24, 0x0a, 0x0d, 0x71, 0x72, 0x79, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x49, 0x64,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x71, 0x72, 0x79, 0x50, 0x72, 0x69, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x3d, 0x0a, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e,
	0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64,
	0x49, 0x6e, 0x66, 0x6f, 0x22, 0x94, 0x03, 0x0a, 0x0f, 0x48, 0x65, 0x61, 0x72, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x43, 0x32, 0x4d, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x49, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x62, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x30, 0x0a, 0x13, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x18,
	0x04, 0x20, 0x02, 0x28, 0x08, 0x52, 0x13, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a, 0x05, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x26, 0x0a,
	0x0e, 0x64, 0x65, 0x66, 0x46, 0x6c, 0x6f, 0x77, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x64, 0x65, 0x66, 0x46, 0x6c, 0x6f, 0x77, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x10, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x6c,
	0x6f, 0x77, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x10, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x6c, 0x6f, 0x77, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49,
	0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x73, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x73, 0x73, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x49,
	0x64, 0x12, 0x24, 0x0a, 0x0d, 0x71, 0x72, 0x79, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79,
	0x49, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x71, 0x72, 0x79, 0x50, 0x72, 0x69,
	0x6f, 0x72, 0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x08, 0x61, 0x75, 0x74, 0x68, 0x49,
	0x6e, 0x66, 0x6f, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x4d, 0x61, 0x73, 0x74,
	0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x08, 0x61, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x84, 0x04, 0x0a, 0x10,
	0x48, 0x65, 0x61, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x32, 0x43,
	0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x08, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x72,
	0x72, 0x43, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x05, 0x52, 0x07, 0x65, 0x72, 0x72,
	0x43, 0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67, 0x18, 0x03,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67, 0x12, 0x21, 0x0a, 0x05,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x12,
	0x22, 0x0a, 0x0c, 0x6e, 0x6f, 0x74, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x6e, 0x6f, 0x74, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x65, 0x64, 0x12, 0x26, 0x0a, 0x0e, 0x64, 0x65, 0x66, 0x46, 0x6c, 0x6f, 0x77, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x49, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x64, 0x65, 0x66,
	0x46, 0x6c, 0x6f, 0x77, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x12, 0x64,
	0x65, 0x66, 0x46, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x49, 0x6e, 0x66,
	0x6f, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x64, 0x65, 0x66, 0x46, 0x6c, 0x6f, 0x77,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2a, 0x0a, 0x10, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x46, 0x6c, 0x6f, 0x77, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x64, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x6c, 0x6f, 0x77,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x46, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x6c, 0x6f, 0x77,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1e, 0x0a, 0x0a, 0x73,
	0x73, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0a, 0x73, 0x73, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0d, 0x71,
	0x72, 0x79, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x49, 0x64, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0d, 0x71, 0x72, 0x79, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x49,
	0x64, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x41, 0x75, 0x74, 0x68,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x41,
	0x75, 0x74, 0x68, 0x12, 0x3d, 0x0a, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65,
	0x64, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x4d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e,
	0x66, 0x6f, 0x22, 0x7f, 0x0a, 0x0f, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x43, 0x32, 0x4d, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49,
	0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49,
	0x64, 0x12, 0x1c, 0x0a, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x32, 0x0a, 0x08, 0x61, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x61, 0x75, 0x74, 0x68, 0x49,
	0x6e, 0x66, 0x6f, 0x22, 0x5e, 0x0a, 0x10, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x32, 0x43, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x18, 0x01, 0x20, 0x02, 0x28, 0x08, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x02,
	0x28, 0x05, 0x52, 0x07, 0x65, 0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x65,
	0x72, 0x72, 0x4d, 0x73, 0x67, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x06, 0x65, 0x72, 0x72,
	0x4d, 0x73, 0x67, 0x22, 0xe4, 0x04, 0x0a, 0x12, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x32, 0x4d, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0c, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72,
	0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x08, 0x52, 0x0c, 0x62, 0x72,
	0x6f, 0x6b, 0x65, 0x72, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x54, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x02, 0x28, 0x08, 0x52, 0x09, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x6c, 0x73, 0x12, 0x24, 0x0a, 0x0d, 0x72, 0x65, 0x61, 0x64,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x70, 0x74, 0x18, 0x04, 0x20, 0x02, 0x28, 0x05, 0x52,
	0x0d, 0x72, 0x65, 0x61, 0x64, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x70, 0x74, 0x12, 0x26,
	0x0a, 0x0e, 0x77, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x70, 0x74,
	0x18, 0x05, 0x20, 0x02, 0x28, 0x05, 0x52, 0x0e, 0x77, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x70, 0x74, 0x12, 0x28, 0x0a, 0x0f, 0x63, 0x75, 0x72, 0x42, 0x72, 0x6f,
	0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x64, 0x18, 0x06, 0x20, 0x02, 0x28, 0x03, 0x52,
	0x0f, 0x63, 0x75, 0x72, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x64,
	0x12, 0x26, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x53, 0x75, 0x6d,
	0x49, 0x64, 0x18, 0x07, 0x20, 0x02, 0x28, 0x05, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x53, 0x75, 0x6d, 0x49, 0x64, 0x12, 0x34, 0x0a, 0x15, 0x62, 0x72, 0x6f, 0x6b,
	0x65, 0x72, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x6e, 0x66,
	0x6f, 0x18, 0x08, 0x20, 0x02, 0x28, 0x09, 0x52, 0x15, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x44,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x36,
	0x0a, 0x16, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x53, 0x65, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x52, 0x16,
	0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x53, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x73, 0x64, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x49, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x73, 0x73, 0x64, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x49, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x66, 0x6c, 0x6f,
	0x77, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0d, 0x71, 0x72, 0x79, 0x50,
	0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x49, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0d, 0x71, 0x72, 0x79, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x18,
	0x0a, 0x07, 0x74, 0x6c, 0x73, 0x50, 0x6f, 0x72, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x07, 0x74, 0x6c, 0x73, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x32, 0x0a, 0x08, 0x61, 0x75, 0x74, 0x68,
	0x49, 0x6e, 0x66, 0x6f, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x4d, 0x61, 0x73,
	0x74, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x08, 0x61, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2c, 0x0a, 0x09,
	0x63, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x0e, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x09, 0x63, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x91, 0x06, 0x0a, 0x13, 0x52,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d,
	0x32, 0x42, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20,
	0x02, 0x28, 0x08, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x18, 0x0a, 0x07,
	0x65, 0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x05, 0x52, 0x07, 0x65,
	0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67,
	0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67, 0x12, 0x1a,
	0x0a, 0x08, 0x73, 0x74, 0x6f, 0x70, 0x52, 0x65, 0x61, 0x64, 0x18, 0x04, 0x20, 0x02, 0x28, 0x08,
	0x52, 0x08, 0x73, 0x74, 0x6f, 0x70, 0x52, 0x65, 0x61, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x74,
	0x6f, 0x70, 0x57, 0x72, 0x69, 0x74, 0x65, 0x18, 0x05, 0x20, 0x02, 0x28, 0x08, 0x52, 0x09, 0x73,
	0x74, 0x6f, 0x70, 0x57, 0x72, 0x69, 0x74, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x74, 0x61, 0x6b, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x06, 0x20, 0x02, 0x28, 0x08, 0x52, 0x0c,
	0x74, 0x61, 0x6b, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x40, 0x0a, 0x10,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x42,
	0x72, 0x6f, 0x6b, 0x65, 0x72, 0x46, 0x75, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x10, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x28,
	0x0a, 0x0f, 0x63, 0x75, 0x72, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x49,
	0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x63, 0x75, 0x72, 0x42, 0x72, 0x6f, 0x6b,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x66,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x53, 0x75, 0x6d, 0x49, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x53, 0x75, 0x6d, 0x49, 0x64,
	0x12, 0x34, 0x0a, 0x15, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x15, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x36, 0x0a, 0x16, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72,
	0x54, 0x6f, 0x70, 0x69, 0x63, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x6e, 0x66, 0x6f,
	0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x52, 0x16, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x54, 0x6f,
	0x70, 0x69, 0x63, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1e,
	0x0a, 0x0a, 0x73, 0x73, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0a, 0x73, 0x73, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x12, 0x20,
	0x0a, 0x0b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x64, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x64,
	0x12, 0x28, 0x0a, 0x0f, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x49,
	0x6e, 0x66, 0x6f, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x66, 0x6c, 0x6f, 0x77, 0x43,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x24, 0x0a, 0x0d, 0x71, 0x72,
	0x79, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x49, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0d, 0x71, 0x72, 0x79, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x49, 0x64,
	0x12, 0x3d, 0x0a, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e,
	0x66, 0x6f, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x0e, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x4f, 0x0a, 0x14, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x14, 0x62, 0x72, 0x6f, 0x6b,
	0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x2c, 0x0a, 0x09, 0x63, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x12, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x09, 0x63, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xaf,
	0x05, 0x0a, 0x0f, 0x48, 0x65, 0x61, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42,
	0x32, 0x4d, 0x12, 0x1a, 0x0a, 0x08, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x49, 0x64, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x08, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x49, 0x64, 0x12, 0x22,
	0x0a, 0x0c, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x02,
	0x20, 0x02, 0x28, 0x08, 0x52, 0x0c, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x4f, 0x6e, 0x6c, 0x69,
	0x6e, 0x65, 0x12, 0x24, 0x0a, 0x0d, 0x72, 0x65, 0x61, 0x64, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x70, 0x74, 0x18, 0x03, 0x20, 0x02, 0x28, 0x05, 0x52, 0x0d, 0x72, 0x65, 0x61, 0x64, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x70, 0x74, 0x12, 0x26, 0x0a, 0x0e, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x70, 0x74, 0x18, 0x04, 0x20, 0x02, 0x28, 0x05,
	0x52, 0x0e, 0x77, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x70, 0x74,
	0x12, 0x28, 0x0a, 0x0f, 0x63, 0x75, 0x72, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x49, 0x64, 0x18, 0x05, 0x20, 0x02, 0x28, 0x03, 0x52, 0x0f, 0x63, 0x75, 0x72, 0x42, 0x72,
	0x6f, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x0e, 0x63, 0x6f,
	0x6e, 0x66, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x53, 0x75, 0x6d, 0x49, 0x64, 0x18, 0x06, 0x20, 0x02,
	0x28, 0x05, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x53, 0x75, 0x6d,
	0x49, 0x64, 0x12, 0x22, 0x0a, 0x0c, 0x74, 0x61, 0x6b, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x6e,
	0x66, 0x6f, 0x18, 0x07, 0x20, 0x02, 0x28, 0x08, 0x52, 0x0c, 0x74, 0x61, 0x6b, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x32, 0x0a, 0x14, 0x74, 0x61, 0x6b, 0x65, 0x52, 0x65,
	0x6d, 0x6f, 0x76, 0x65, 0x64, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x08,
	0x20, 0x02, 0x28, 0x08, 0x52, 0x14, 0x74, 0x61, 0x6b, 0x65, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65,
	0x64, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x34, 0x0a, 0x15, 0x62, 0x72,
	0x6f, 0x6b, 0x65, 0x72, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x49,
	0x6e, 0x66, 0x6f, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x62, 0x72, 0x6f, 0x6b, 0x65,
	0x72, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x36, 0x0a, 0x16, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x53,
	0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x16, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x53, 0x65, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2c, 0x0a, 0x11, 0x72, 0x65, 0x6d, 0x6f,
	0x76, 0x65, 0x64, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x0b, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x11, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x54, 0x6f, 0x70, 0x69,
	0x63, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x73, 0x64, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x49, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x73, 0x73, 0x64, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x49, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x66, 0x6c, 0x6f,
	0x77, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0d, 0x71, 0x72, 0x79, 0x50,
	0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x49, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0d, 0x71, 0x72, 0x79, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x32,
	0x0a, 0x08, 0x61, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x61, 0x75, 0x74, 0x68, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x2c, 0x0a, 0x09, 0x63, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x09, 0x63, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0xd8, 0x06, 0x0a, 0x10, 0x48, 0x65, 0x61, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x4d, 0x32, 0x42, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x08, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12,
	0x18, 0x0a, 0x07, 0x65, 0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x05,
	0x52, 0x07, 0x65, 0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x72, 0x72,
	0x4d, 0x73, 0x67, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73,
	0x67, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x74, 0x6f, 0x70, 0x52, 0x65, 0x61, 0x64, 0x18, 0x04, 0x20,
	0x02, 0x28, 0x08, 0x52, 0x08, 0x73, 0x74, 0x6f, 0x70, 0x52, 0x65, 0x61, 0x64, 0x12, 0x1c, 0x0a,
	0x09, 0x73, 0x74, 0x6f, 0x70, 0x57, 0x72, 0x69, 0x74, 0x65, 0x18, 0x05, 0x20, 0x02, 0x28, 0x08,
	0x52, 0x09, 0x73, 0x74, 0x6f, 0x70, 0x57, 0x72, 0x69, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x0f, 0x63,
	0x75, 0x72, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x64, 0x18, 0x06,
	0x20, 0x02, 0x28, 0x03, 0x52, 0x0f, 0x63, 0x75, 0x72, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x53, 0x75, 0x6d, 0x49, 0x64, 0x18, 0x07, 0x20, 0x02, 0x28, 0x05, 0x52, 0x0e, 0x63,
	0x6f, 0x6e, 0x66, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x53, 0x75, 0x6d, 0x49, 0x64, 0x12, 0x26, 0x0a,
	0x0e, 0x6e, 0x65, 0x65, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x18,
	0x08, 0x20, 0x02, 0x28, 0x08, 0x52, 0x0e, 0x6e, 0x65, 0x65, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x22, 0x0a, 0x0c, 0x74, 0x61, 0x6b, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x09, 0x20, 0x02, 0x28, 0x08, 0x52, 0x0c, 0x74, 0x61, 0x6b,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x30, 0x0a, 0x13, 0x74, 0x61, 0x6b,
	0x65, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f,
	0x18, 0x0a, 0x20, 0x02, 0x28, 0x08, 0x52, 0x13, 0x74, 0x61, 0x6b, 0x65, 0x52, 0x65, 0x6d, 0x6f,
	0x76, 0x65, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x34, 0x0a, 0x15, 0x62,
	0x72, 0x6f, 0x6b, 0x65, 0x72, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x49, 0x6e, 0x66, 0x6f, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x62, 0x72, 0x6f, 0x6b,
	0x65, 0x72, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x36, 0x0a, 0x16, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x54, 0x6f, 0x70, 0x69, 0x63,
	0x53, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x0c, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x16, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x53, 0x65,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x30, 0x0a, 0x13, 0x72, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x6e, 0x66, 0x6f,
	0x18, 0x0d, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x54, 0x6f,
	0x70, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1e, 0x0a, 0x0a, 0x73,
	0x73, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0a, 0x73, 0x73, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x66,
	0x6c, 0x6f, 0x77, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x64, 0x12, 0x28, 0x0a,
	0x0f, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x49, 0x6e, 0x66, 0x6f,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x24, 0x0a, 0x0d, 0x71, 0x72, 0x79, 0x50, 0x72,
	0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x49, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d,
	0x71, 0x72, 0x79, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x3d, 0x0a,
	0x0e, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x18,
	0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0e, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x4f, 0x0a, 0x14,
	0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64,
	0x49, 0x6e, 0x66, 0x6f, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x4d, 0x61, 0x73,
	0x74, 0x65, 0x72, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x14, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2c, 0x0a,
	0x09, 0x63, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x0e, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x09, 0x63, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x61, 0x0a, 0x0f, 0x43,
	0x6c, 0x6f, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x32, 0x4d, 0x12, 0x1a,
	0x0a, 0x08, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x49, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09,
	0x52, 0x08, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x08, 0x61, 0x75,
	0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x4d,
	0x61, 0x73, 0x74, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x61, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x5e,
	0x0a, 0x10, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d,
	0x32, 0x42, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20,
	0x02, 0x28, 0x08, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x18, 0x0a, 0x07,
	0x65, 0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x05, 0x52, 0x07, 0x65,
	0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67,
	0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67, 0x22, 0x81,
	0x01, 0x0a, 0x0d, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x74, 0x68,
	0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x49, 0x64, 0x18, 0x01, 0x20, 0x02,
	0x28, 0x05, 0x52, 0x08, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08,
	0x69, 0x73, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x08, 0x52, 0x08,
	0x69, 0x73, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x69, 0x73, 0x44, 0x65,
	0x66, 0x50, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x02, 0x28, 0x08, 0x52, 0x09, 0x69, 0x73, 0x44,
	0x65, 0x66, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x50, 0x61,
	0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x50, 0x61,
	0x74, 0x68, 0x22, 0x48, 0x0a, 0x0c, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x6d, 0x76, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x09, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x1a, 0x0a, 0x08, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x49, 0x64, 0x18, 0x02, 0x20, 0x02,
	0x28, 0x05, 0x52, 0x08, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x49, 0x64, 0x22, 0x83, 0x04, 0x0a,
	0x11, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x26, 0x0a, 0x0e, 0x6e, 0x75, 0x6d, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x02, 0x28, 0x05, 0x52, 0x0e, 0x6e, 0x75, 0x6d, 0x54,
	0x6f, 0x70, 0x69, 0x63, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x24, 0x0a, 0x0d, 0x6e, 0x75,
	0x6d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x02, 0x28,
	0x05, 0x52, 0x0d, 0x6e, 0x75, 0x6d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x24, 0x0a, 0x0d, 0x75, 0x6e, 0x66, 0x6c, 0x75, 0x73, 0x68, 0x4d, 0x73, 0x67, 0x43, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x02, 0x28, 0x05, 0x52, 0x0d, 0x75, 0x6e, 0x66, 0x6c, 0x75, 0x73, 0x68,
	0x4d, 0x73, 0x67, 0x43, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0f, 0x75, 0x6e, 0x66, 0x6c, 0x75, 0x73,
	0x68, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x04, 0x20, 0x02, 0x28, 0x05, 0x52,
	0x0f, 0x75, 0x6e, 0x66, 0x6c, 0x75, 0x73, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c,
	0x12, 0x28, 0x0a, 0x0f, 0x75, 0x6e, 0x66, 0x6c, 0x75, 0x73, 0x68, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x69, 0x7a, 0x65, 0x18, 0x05, 0x20, 0x02, 0x28, 0x05, 0x52, 0x0f, 0x75, 0x6e, 0x66, 0x6c, 0x75,
	0x73, 0x68, 0x44, 0x61, 0x74, 0x61, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2c, 0x0a, 0x11, 0x6d, 0x65,
	0x6d, 0x43, 0x61, 0x63, 0x68, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x18,
	0x06, 0x20, 0x02, 0x28, 0x05, 0x52, 0x11, 0x6d, 0x65, 0x6d, 0x43, 0x61, 0x63, 0x68, 0x65, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2a, 0x0a, 0x10, 0x6e, 0x75, 0x6d, 0x4d,
	0x65, 0x6d, 0x43, 0x61, 0x63, 0x68, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x07, 0x20, 0x02,
	0x28, 0x05, 0x52, 0x10, 0x6e, 0x75, 0x6d, 0x4d, 0x65, 0x6d, 0x43, 0x61, 0x63, 0x68, 0x65, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x2c, 0x0a, 0x11, 0x62, 0x61, 0x74, 0x68, 0x44, 0x69, 0x73, 0x6b,
	0x57, 0x72, 0x69, 0x74, 0x65, 0x55, 0x6e, 0x69, 0x74, 0x18, 0x08, 0x20, 0x02, 0x28, 0x05, 0x52,
	0x11, 0x62, 0x61, 0x74, 0x68, 0x44, 0x69, 0x73, 0x6b, 0x57, 0x72, 0x69, 0x74, 0x65, 0x55, 0x6e,
	0x69, 0x74, 0x12, 0x2a, 0x0a, 0x10, 0x62, 0x61, 0x74, 0x68, 0x44, 0x69, 0x73, 0x6b, 0x52, 0x65,
	0x61, 0x64, 0x55, 0x6e, 0x69, 0x74, 0x18, 0x09, 0x20, 0x02, 0x28, 0x05, 0x52, 0x10, 0x62, 0x61,
	0x74, 0x68, 0x44, 0x69, 0x73, 0x6b, 0x52, 0x65, 0x61, 0x64, 0x55, 0x6e, 0x69, 0x74, 0x12, 0x24,
	0x0a, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x18,
	0x0a, 0x20, 0x02, 0x28, 0x08, 0x52, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x12, 0x28, 0x0a, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x18, 0x0b, 0x20, 0x02, 0x28, 0x08, 0x52, 0x0f, 0x61,
	0x63, 0x63, 0x65, 0x70, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x12, 0x22,
	0x0a, 0x0c, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0c,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x22, 0x8d, 0x04, 0x0a, 0x0f, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x4e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x09, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x49, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x49, 0x64,
	0x12, 0x26, 0x0a, 0x0e, 0x6e, 0x75, 0x6d, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x6e, 0x75, 0x6d, 0x54, 0x6f, 0x70,
	0x69, 0x63, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x24, 0x0a, 0x0d, 0x6e, 0x75, 0x6d, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0d, 0x6e, 0x75, 0x6d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x24,
	0x0a, 0x0d, 0x75, 0x6e, 0x66, 0x6c, 0x75, 0x73, 0x68, 0x4d, 0x73, 0x67, 0x43, 0x6e, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x75, 0x6e, 0x66, 0x6c, 0x75, 0x73, 0x68, 0x4d, 0x73,
	0x67, 0x43, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0f, 0x75, 0x6e, 0x66, 0x6c, 0x75, 0x73, 0x68, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x75,
	0x6e, 0x66, 0x6c, 0x75, 0x73, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x28,
	0x0a, 0x0f, 0x75, 0x6e, 0x66, 0x6c, 0x75, 0x73, 0x68, 0x44, 0x61, 0x74, 0x61, 0x53, 0x69, 0x7a,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x75, 0x6e, 0x66, 0x6c, 0x75, 0x73, 0x68,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2c, 0x0a, 0x11, 0x6d, 0x65, 0x6d, 0x43,
	0x61, 0x63, 0x68, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x11, 0x6d, 0x65, 0x6d, 0x43, 0x61, 0x63, 0x68, 0x65, 0x42, 0x6c, 0x6f,
	0x63, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2a, 0x0a, 0x10, 0x6e, 0x75, 0x6d, 0x4d, 0x65, 0x6d,
	0x43, 0x61, 0x63, 0x68, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x10, 0x6e, 0x75, 0x6d, 0x4d, 0x65, 0x6d, 0x43, 0x61, 0x63, 0x68, 0x65, 0x42, 0x6c, 0x6f,
	0x63, 0x6b, 0x12, 0x24, 0x0a, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x70,
	0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x12, 0x28, 0x0a, 0x0f, 0x61, 0x63, 0x63, 0x65,
	0x70, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x62, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2a, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x50, 0x61,
	0x74, 0x68, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x74, 0x68, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x50, 0x61,
	0x74, 0x68, 0x22, 0xa8, 0x02, 0x0a, 0x10, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x22, 0x0a, 0x0c, 0x62, 0x72, 0x6f, 0x6b, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x03, 0x52, 0x0c, 0x62,
	0x72, 0x6f, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x0e, 0x63,
	0x6f, 0x6e, 0x66, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x53, 0x75, 0x6d, 0x49, 0x64, 0x18, 0x02, 0x20,
	0x02, 0x28, 0x05, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x53, 0x75,
	0x6d, 0x49, 0x64, 0x12, 0x38, 0x0a, 0x0d, 0x64, 0x65, 0x66, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x49, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x44, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0d,
	0x64, 0x65, 0x66, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3c, 0x0a,
	0x10, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x10, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x6c, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x74, 0x6c, 0x73,
	0x50, 0x6f, 0x72, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x74, 0x6c, 0x73, 0x50,
	0x6f, 0x72, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x77, 0x65, 0x62, 0x50, 0x6f, 0x72, 0x74, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x77, 0x65, 0x62, 0x50, 0x6f, 0x72, 0x74, 0x22, 0x74, 0x0a,
	0x10, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x64, 0x12, 0x24, 0x0a,
	0x0d, 0x71, 0x72, 0x79, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x49, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x71, 0x72, 0x79, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74,
	0x79, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x6e, 0x66,
	0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49,
	0x6e, 0x66, 0x6f, 0x22, 0xa2, 0x01, 0x0a, 0x10, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x73, 0x4f, 0x6e,
	0x6c, 0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x08, 0x52, 0x08, 0x69, 0x73, 0x4f, 0x6e,
	0x6c, 0x69, 0x6e, 0x65, 0x12, 0x24, 0x0a, 0x0d, 0x72, 0x65, 0x61, 0x64, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x70, 0x74, 0x18, 0x02, 0x20, 0x02, 0x28, 0x05, 0x52, 0x0d, 0x72, 0x65, 0x61,
	0x64, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x70, 0x74, 0x12, 0x26, 0x0a, 0x0e, 0x77, 0x72,
	0x69, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x70, 0x74, 0x18, 0x03, 0x20, 0x02,
	0x28, 0x05, 0x52, 0x0e, 0x77, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x70, 0x74, 0x12, 0x24, 0x0a, 0x0d, 0x6c, 0x61, 0x73, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x49, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x6c, 0x61, 0x73, 0x74, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x65, 0x49, 0x64, 0x22, 0xd8, 0x03, 0x0a, 0x11, 0x42, 0x72, 0x6f,
	0x6b, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1c,
	0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x65, 0x49, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x05, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x65, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x10,
	0x66, 0x72, 0x63, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x02, 0x20, 0x02, 0x28, 0x05, 0x52, 0x10, 0x66, 0x72, 0x63, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x22, 0x0a, 0x0c, 0x66, 0x72, 0x63, 0x52,
	0x70, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c,
	0x66, 0x72, 0x63, 0x52, 0x70, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3c, 0x0a, 0x19,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x41, 0x75, 0x74,
	0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x41, 0x75,
	0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x36, 0x0a, 0x16, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x65, 0x12, 0x3c, 0x0a, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x65, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x65, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x12, 0x36, 0x0a, 0x16, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x16, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x12, 0x34, 0x0a, 0x15, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x56, 0x69, 0x73, 0x69, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x68, 0x65, 0x63,
	0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x56,
	0x69, 0x73, 0x69, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x33,
	0x0a, 0x0d, 0x72, 0x6d, 0x76, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x18,
	0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x6d, 0x76,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0d, 0x72, 0x6d, 0x76, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x49,
	0x6e, 0x66, 0x6f, 0x22, 0x87, 0x02, 0x0a, 0x16, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x56, 0x32, 0x5f, 0x42, 0x32, 0x4d, 0x12, 0x1a,
	0x0a, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09,
	0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x37, 0x0a, 0x0d, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x70, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x02, 0x28,
	0x0b, 0x32, 0x11, 0x2e, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x70, 0x74, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x31, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x6e, 0x66,
	0x6f, 0x18, 0x03, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x31, 0x0a, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x49, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x42, 0x72, 0x6f,
	0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x32, 0x0a, 0x08, 0x61, 0x75, 0x74,
	0x68, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x4d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x08, 0x61, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0xac, 0x02,
	0x0a, 0x17, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x5f, 0x56, 0x32, 0x5f, 0x4d, 0x32, 0x42, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x72, 0x72,
	0x43, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x05, 0x52, 0x07, 0x65, 0x72, 0x72, 0x43,
	0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67, 0x12, 0x31, 0x0a, 0x0a, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x11, 0x2e, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x34,
	0x0a, 0x0b, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0b, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x31, 0x0a, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x6e,
	0x66, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x42, 0x72, 0x6f, 0x6b, 0x65,
	0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x43, 0x0a, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x41, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0e, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x84, 0x02, 0x0a,
	0x13, 0x48, 0x65, 0x61, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x56, 0x32,
	0x5f, 0x42, 0x32, 0x4d, 0x12, 0x1a, 0x0a, 0x08, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x49, 0x64,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x08, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x37, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x70, 0x74, 0x49, 0x6e, 0x66,
	0x6f, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x70, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x31, 0x0a, 0x0a, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x11, 0x2e,
	0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x31, 0x0a, 0x0a,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x11, 0x2e, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x32, 0x0a, 0x08, 0x61, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x61, 0x75, 0x74, 0x68, 0x49,
	0x6e, 0x66, 0x6f, 0x22, 0xb5, 0x02, 0x0a, 0x14, 0x48, 0x65, 0x61, 0x72, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x56, 0x32, 0x5f, 0x4d, 0x32, 0x42, 0x12, 0x18, 0x0a, 0x07,
	0x65, 0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x05, 0x52, 0x07, 0x65,
	0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67, 0x12, 0x31,
	0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x34, 0x0a, 0x0b, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0b, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x31, 0x0a, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x42, 0x72,
	0x6f, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x4f, 0x0a, 0x14, 0x62, 0x72,
	0x6f, 0x6b, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e,
	0x66, 0x6f, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65,
	0x64, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x14, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x65, 0x0a, 0x13, 0x43,
	0x6c, 0x6f, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x56, 0x32, 0x5f, 0x42,
	0x32, 0x4d, 0x12, 0x1a, 0x0a, 0x08, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x49, 0x64, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x08, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x49, 0x64, 0x12, 0x32,
	0x0a, 0x08, 0x61, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x61, 0x75, 0x74, 0x68, 0x49, 0x6e,
	0x66, 0x6f, 0x22, 0x48, 0x0a, 0x14, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x5f, 0x56, 0x32, 0x5f, 0x4d, 0x32, 0x42, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x72,
	0x72, 0x43, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x05, 0x52, 0x07, 0x65, 0x72, 0x72,
	0x43, 0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67, 0x42, 0x57, 0x0a, 0x34,
	0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x69, 0x6e, 0x6c, 0x6f, 0x6e,
	0x67, 0x2e, 0x74, 0x75, 0x62, 0x65, 0x6d, 0x71, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x64, 0x42, 0x0c, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x73, 0x74,
	0x65, 0x72, 0x48, 0x01, 0x5a, 0x09, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2f, 0x88,
	0x01, 0x01, 0xa0, 0x01, 0x01,
}

var (
	file_MasterService_proto_rawDescOnce sync.Once
	file_MasterService_proto_rawDescData = file_MasterService_proto_rawDesc
)

func file_MasterService_proto_rawDescGZIP() []byte {
	file_MasterService_proto_rawDescOnce.Do(func() {
		file_MasterService_proto_rawDescData = protoimpl.X.CompressGZIP(file_MasterService_proto_rawDescData)
	})
	return file_MasterService_proto_rawDescData
}

var file_MasterService_proto_msgTypes = make([]protoimpl.MessageInfo, 40)
var file_MasterService_proto_goTypes = []interface{}{
	(*EventProto)(nil),                 // 0: EventProto
	(*EnableBrokerFunInfo)(nil),        // 1: EnableBrokerFunInfo
	(*AuthenticateInfo)(nil),           // 2: AuthenticateInfo
	(*MasterCertificateInfo)(nil),      // 3: MasterCertificateInfo
	(*MasterAuthorizedInfo)(nil),       // 4: MasterAuthorizedInfo
	(*MasterBrokerAuthorizedInfo)(nil), // 5: MasterBrokerAuthorizedInfo
	(*ApprovedClientConfig)(nil),       // 6: ApprovedClientConfig
	(*ClusterConfig)(nil),              // 7: ClusterConfig
	(*RegisterRequestP2M)(nil),         // 8: RegisterRequestP2M
	(*RegisterResponseM2P)(nil),        // 9: RegisterResponseM2P
	(*HeartRequestP2M)(nil),            // 10: HeartRequestP2M
	(*HeartResponseM2P)(nil),           // 11: HeartResponseM2P
	(*CloseRequestP2M)(nil),            // 12: CloseRequestP2M
	(*CloseResponseM2P)(nil),           // 13: CloseResponseM2P
	(*RegisterRequestC2M)(nil),         // 14: RegisterRequestC2M
	(*RegisterResponseM2C)(nil),        // 15: RegisterResponseM2C
	(*HeartRequestC2M)(nil),            // 16: HeartRequestC2M
	(*HeartResponseM2C)(nil),           // 17: HeartResponseM2C
	(*CloseRequestC2M)(nil),            // 18: CloseRequestC2M
	(*CloseResponseM2C)(nil),           // 19: CloseResponseM2C
	(*RegisterRequestB2M)(nil),         // 20: RegisterRequestB2M
	(*RegisterResponseM2B)(nil),        // 21: RegisterResponseM2B
	(*HeartRequestB2M)(nil),            // 22: HeartRequestB2M
	(*HeartResponseM2B)(nil),           // 23: HeartResponseM2B
	(*CloseRequestB2M)(nil),            // 24: CloseRequestB2M
	(*CloseResponseM2B)(nil),           // 25: CloseResponseM2B
	(*DataStorePath)(nil),              // 26: DataStorePath
	(*TopicRmvInfo)(nil),               // 27: TopicRmvInfo
	(*DefaultConfigInfo)(nil),          // 28: DefaultConfigInfo
	(*TopicConfigInfo)(nil),            // 29: TopicConfigInfo
	(*BrokerConfigInfo)(nil),           // 30: BrokerConfigInfo
	(*BrokerPolicyInfo)(nil),           // 31: BrokerPolicyInfo
	(*BrokerStatusInfo)(nil),           // 32: BrokerStatusInfo
	(*BrokerOperateInfo)(nil),          // 33: BrokerOperateInfo
	(*RegisterRequest_V2_B2M)(nil),     // 34: RegisterRequest_V2_B2M
	(*RegisterResponse_V2_M2B)(nil),    // 35: RegisterResponse_V2_M2B
	(*HeartRequest_V2_B2M)(nil),        // 36: HeartRequest_V2_B2M
	(*HeartResponse_V2_M2B)(nil),       // 37: HeartResponse_V2_M2B
	(*CloseRequest_V2_B2M)(nil),        // 38: CloseRequest_V2_B2M
	(*CloseResponse_V2_M2B)(nil),       // 39: CloseResponse_V2_M2B
}
var file_MasterService_proto_depIdxs = []int32{
	2,  // 0: MasterCertificateInfo.authInfo:type_name -> AuthenticateInfo
	3,  // 1: RegisterRequestP2M.authInfo:type_name -> MasterCertificateInfo
	6,  // 2: RegisterRequestP2M.appdConfig:type_name -> ApprovedClientConfig
	4,  // 3: RegisterResponseM2P.authorizedInfo:type_name -> MasterAuthorizedInfo
	6,  // 4: RegisterResponseM2P.appdConfig:type_name -> ApprovedClientConfig
	3,  // 5: HeartRequestP2M.authInfo:type_name -> MasterCertificateInfo
	6,  // 6: HeartRequestP2M.appdConfig:type_name -> ApprovedClientConfig
	4,  // 7: HeartResponseM2P.authorizedInfo:type_name -> MasterAuthorizedInfo
	6,  // 8: HeartResponseM2P.appdConfig:type_name -> ApprovedClientConfig
	3,  // 9: CloseRequestP2M.authInfo:type_name -> MasterCertificateInfo
	3,  // 10: RegisterRequestC2M.authInfo:type_name -> MasterCertificateInfo
	4,  // 11: RegisterResponseM2C.authorizedInfo:type_name -> MasterAuthorizedInfo
	0,  // 12: HeartRequestC2M.event:type_name -> EventProto
	3,  // 13: HeartRequestC2M.authInfo:type_name -> MasterCertificateInfo
	0,  // 14: HeartResponseM2C.event:type_name -> EventProto
	4,  // 15: HeartResponseM2C.authorizedInfo:type_name -> MasterAuthorizedInfo
	3,  // 16: CloseRequestC2M.authInfo:type_name -> MasterCertificateInfo
	3,  // 17: RegisterRequestB2M.authInfo:type_name -> MasterCertificateInfo
	7,  // 18: RegisterRequestB2M.clsConfig:type_name -> ClusterConfig
	1,  // 19: RegisterResponseM2B.enableBrokerInfo:type_name -> EnableBrokerFunInfo
	4,  // 20: RegisterResponseM2B.authorizedInfo:type_name -> MasterAuthorizedInfo
	5,  // 21: RegisterResponseM2B.brokerAuthorizedInfo:type_name -> MasterBrokerAuthorizedInfo
	7,  // 22: RegisterResponseM2B.clsConfig:type_name -> ClusterConfig
	3,  // 23: HeartRequestB2M.authInfo:type_name -> MasterCertificateInfo
	7,  // 24: HeartRequestB2M.clsConfig:type_name -> ClusterConfig
	4,  // 25: HeartResponseM2B.authorizedInfo:type_name -> MasterAuthorizedInfo
	5,  // 26: HeartResponseM2B.brokerAuthorizedInfo:type_name -> MasterBrokerAuthorizedInfo
	7,  // 27: HeartResponseM2B.clsConfig:type_name -> ClusterConfig
	3,  // 28: CloseRequestB2M.authInfo:type_name -> MasterCertificateInfo
	26, // 29: TopicConfigInfo.dataPath:type_name -> DataStorePath
	28, // 30: BrokerConfigInfo.defConfigInfo:type_name -> DefaultConfigInfo
	29, // 31: BrokerConfigInfo.topicConfigInfos:type_name -> TopicConfigInfo
	27, // 32: BrokerOperateInfo.rmvTopicsInfo:type_name -> TopicRmvInfo
	32, // 33: RegisterRequest_V2_B2M.statusRptInfo:type_name -> BrokerStatusInfo
	30, // 34: RegisterRequest_V2_B2M.configInfo:type_name -> BrokerConfigInfo
	31, // 35: RegisterRequest_V2_B2M.policyInfo:type_name -> BrokerPolicyInfo
	3,  // 36: RegisterRequest_V2_B2M.authInfo:type_name -> MasterCertificateInfo
	30, // 37: RegisterResponse_V2_M2B.configInfo:type_name -> BrokerConfigInfo
	33, // 38: RegisterResponse_V2_M2B.operateInfo:type_name -> BrokerOperateInfo
	31, // 39: RegisterResponse_V2_M2B.policyInfo:type_name -> BrokerPolicyInfo
	5,  // 40: RegisterResponse_V2_M2B.authorizedInfo:type_name -> MasterBrokerAuthorizedInfo
	32, // 41: HeartRequest_V2_B2M.statusRptInfo:type_name -> BrokerStatusInfo
	30, // 42: HeartRequest_V2_B2M.configInfo:type_name -> BrokerConfigInfo
	31, // 43: HeartRequest_V2_B2M.policyInfo:type_name -> BrokerPolicyInfo
	3,  // 44: HeartRequest_V2_B2M.authInfo:type_name -> MasterCertificateInfo
	30, // 45: HeartResponse_V2_M2B.configInfo:type_name -> BrokerConfigInfo
	33, // 46: HeartResponse_V2_M2B.operateInfo:type_name -> BrokerOperateInfo
	31, // 47: HeartResponse_V2_M2B.policyInfo:type_name -> BrokerPolicyInfo
	5,  // 48: HeartResponse_V2_M2B.brokerAuthorizedInfo:type_name -> MasterBrokerAuthorizedInfo
	3,  // 49: CloseRequest_V2_B2M.authInfo:type_name -> MasterCertificateInfo
	50, // [50:50] is the sub-list for method output_type
	50, // [50:50] is the sub-list for method input_type
	50, // [50:50] is the sub-list for extension type_name
	50, // [50:50] is the sub-list for extension extendee
	0,  // [0:50] is the sub-list for field type_name
}

func init() { file_MasterService_proto_init() }
func file_MasterService_proto_init() {
	if File_MasterService_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_MasterService_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnableBrokerFunInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthenticateInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MasterCertificateInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MasterAuthorizedInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MasterBrokerAuthorizedInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApprovedClientConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClusterConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterRequestP2M); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterResponseM2P); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HeartRequestP2M); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HeartResponseM2P); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloseRequestP2M); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloseResponseM2P); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterRequestC2M); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterResponseM2C); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HeartRequestC2M); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HeartResponseM2C); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloseRequestC2M); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloseResponseM2C); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterRequestB2M); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterResponseM2B); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HeartRequestB2M); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HeartResponseM2B); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloseRequestB2M); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloseResponseM2B); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataStorePath); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TopicRmvInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DefaultConfigInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TopicConfigInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BrokerConfigInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BrokerPolicyInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BrokerStatusInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BrokerOperateInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterRequest_V2_B2M); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterResponse_V2_M2B); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HeartRequest_V2_B2M); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HeartResponse_V2_M2B); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloseRequest_V2_B2M); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_MasterService_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloseResponse_V2_M2B); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_MasterService_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   40,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_MasterService_proto_goTypes,
		DependencyIndexes: file_MasterService_proto_depIdxs,
		MessageInfos:      file_MasterService_proto_msgTypes,
	}.Build()
	File_MasterService_proto = out.File
	file_MasterService_proto_rawDesc = nil
	file_MasterService_proto_goTypes = nil
	file_MasterService_proto_depIdxs = nil
}
