/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.util.check;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.jsieve.ConfigurationManager;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.mail.Action;
import org.apache.jsieve.mail.ActionFileInto;
import org.apache.jsieve.mail.ActionKeep;
import org.apache.jsieve.mail.ActionRedirect;
import org.apache.jsieve.mail.ActionReject;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.parser.generated.ParseException;
import org.apache.jsieve.util.check.ScriptCheckMailAdapter;

public class ScriptChecker {
    private final ScriptCheckMailAdapter adapter = new ScriptCheckMailAdapter();

    public Results check(File message, File script) throws IOException, MessagingException {
        FileInputStream messageStream = new FileInputStream(message);
        FileInputStream scriptStream = new FileInputStream(script);
        return this.check(messageStream, scriptStream);
    }

    public Results check(InputStream message, InputStream script) throws IOException, MessagingException {
        Results results;
        MimeMessage mimeMessage = new MimeMessage(null, message);
        this.adapter.setMail((Message)mimeMessage);
        try {
            new ConfigurationManager().build().interpret((MailAdapter)this.adapter, script);
            List<Action> executedActions = this.adapter.getExecutedActions();
            results = new Results(executedActions);
        }
        catch (ParseException e) {
            e.printStackTrace();
            results = new Results((Exception)((Object)e));
        }
        catch (SieveException e) {
            e.printStackTrace();
            results = new Results((Exception)((Object)e));
        }
        return results;
    }

    public static final class Results {
        private final boolean pass;
        private final Exception exception;
        private final List actionsExecuted;

        public Results(Exception ex) {
            this.exception = ex;
            this.pass = false;
            this.actionsExecuted = null;
        }

        public Results(List actions) {
            this.pass = true;
            this.exception = null;
            this.actionsExecuted = actions;
        }

        public boolean isPass() {
            return this.pass;
        }

        public Exception getException() {
            return this.exception;
        }

        public List getActionsExecuted() {
            return this.actionsExecuted;
        }

        public boolean isActionFileInto(String destination, int n) {
            boolean result = false;
            Object action = this.actionsExecuted.get(n);
            if (action != null && action instanceof ActionFileInto) {
                ActionFileInto actionFileInto = (ActionFileInto)action;
                result = destination.equals(actionFileInto.getDestination());
            }
            return result;
        }

        public boolean isActionRedirect(String address, int n) {
            boolean result = false;
            Object action = this.actionsExecuted.get(n);
            if (action != null && action instanceof ActionRedirect) {
                ActionRedirect actionRedirect = (ActionRedirect)action;
                result = address.equals(actionRedirect.getAddress());
            }
            return result;
        }

        public boolean isActionReject(String message, int n) {
            boolean result = false;
            Object action = this.actionsExecuted.get(n);
            if (action != null && action instanceof ActionReject) {
                ActionReject actionReject = (ActionReject)action;
                result = message.equals(actionReject.getMessage());
            }
            return result;
        }

        public boolean isActionKeep(int n) {
            boolean result = false;
            Object action = this.actionsExecuted.get(n);
            if (action != null && action instanceof ActionKeep) {
                result = true;
            }
            return result;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder("Results: ");
            if (this.pass) {
                buffer.append("PASS");
            } else {
                buffer.append("FAIL: ");
                if (this.exception != null) {
                    if (this.exception instanceof ParseException) {
                        buffer.append("Cannot parse script");
                    } else {
                        buffer.append("Cannot excute script");
                    }
                    buffer.append(this.exception.getMessage());
                }
            }
            return buffer.toString();
        }
    }
}

