/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.webadmin;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.james.DisconnectorNotifier;
import org.apache.james.core.ConnectionDescription;
import org.apache.james.core.ConnectionDescriptionSupplier;
import org.apache.james.core.Username;
import org.apache.james.protocols.lib.netty.CertificateReloadable;
import org.apache.james.util.Port;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.Responses;
import spark.Request;
import spark.Response;
import spark.Service;

public class ProtocolServerRoutes
implements Routes {
    public static final String SERVERS = "servers";
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final TypeReference<List<String>> LIST_OF_STRING = new TypeReference<List<String>>(){};
    private final Set<CertificateReloadable.Factory> servers;
    private final DisconnectorNotifier disconnectorNotifier;
    private final ConnectionDescriptionSupplier connectionDescriptionSupplier;

    @Inject
    public ProtocolServerRoutes(Set<CertificateReloadable.Factory> servers, DisconnectorNotifier disconnectorNotifier, ConnectionDescriptionSupplier connectionDescriptionSupplier) {
        this.servers = servers;
        this.disconnectorNotifier = disconnectorNotifier;
        this.connectionDescriptionSupplier = connectionDescriptionSupplier;
    }

    public String getBasePath() {
        return SERVERS;
    }

    public void define(Service service) {
        service.post(SERVERS, (request, response) -> {
            Preconditions.checkArgument((boolean)request.queryParams().contains("reload-certificate"), (Object)"'reload-certificate' query parameter shall be specified");
            if (this.noServerEnabled()) {
                return ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.NOT_FOUND).message("No servers configured, nothing to reload").haltError();
            }
            this.servers.stream().flatMap(CertificateReloadable.Factory::certificatesReloadable).filter(this.filters(request)).forEach((Consumer<CertificateReloadable>)Throwing.consumer(CertificateReloadable::reloadSSLCertificate));
            return Responses.returnNoContent((Response)response);
        });
        service.delete("servers/channels/:user", (request, response) -> {
            Username username = Username.of((String)request.params("user"));
            this.disconnectorNotifier.disconnect((DisconnectorNotifier.Request)DisconnectorNotifier.MultipleUserRequest.of((Username)username));
            return Responses.returnNoContent((Response)response);
        });
        service.delete("servers/channels", (request, response) -> {
            String body = request.body();
            if (Strings.isNullOrEmpty((String)body)) {
                this.disconnectorNotifier.disconnect((DisconnectorNotifier.Request)DisconnectorNotifier.AllUsersRequest.ALL_USERS_REQUEST);
            } else {
                ImmutableSet userSet = (ImmutableSet)((List)OBJECT_MAPPER.readValue(body, LIST_OF_STRING)).stream().map(Username::of).collect(ImmutableSet.toImmutableSet());
                this.disconnectorNotifier.disconnect((DisconnectorNotifier.Request)DisconnectorNotifier.MultipleUserRequest.of((Set)userSet));
            }
            return Responses.returnNoContent((Response)response);
        });
        service.get("servers/channels", (request, response) -> OBJECT_MAPPER.writeValueAsString(this.connectionDescriptionSupplier.describeConnections().map(ConnectionDescriptionDTO::from).toList()));
        service.get("servers/channels/:user", (request, response) -> {
            Username username = Username.of((String)request.params("user"));
            return OBJECT_MAPPER.writeValueAsString(this.connectionDescriptionSupplier.describeConnections().filter(connectionDescription -> connectionDescription.username().map(arg_0 -> ((Username)username).equals(arg_0)).orElse(false)).map(ConnectionDescriptionDTO::from).toList());
        });
        service.get("servers/connectedUsers", (request, response) -> OBJECT_MAPPER.writeValueAsString(this.connectionDescriptionSupplier.describeConnections().flatMap(connectionDescription -> connectionDescription.username().stream()).distinct().map(Username::asString).toList()));
    }

    private Predicate<CertificateReloadable> filters(Request request) {
        Optional<Port> port = Optional.ofNullable(request.queryParams("port")).map(Integer::parseUnsignedInt).map(Port::of);
        return server -> port.map(p -> server.getPort() == p.getValue()).orElse(true);
    }

    private boolean noServerEnabled() {
        return this.servers.stream().flatMap(CertificateReloadable.Factory::certificatesReloadable).findFirst().isEmpty();
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new Jdk8Module());
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
        OBJECT_MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }

    record ConnectionDescriptionDTO(String protocol, String endpoint, Optional<String> remoteAddress, Optional<Instant> connectionDate, boolean isActive, boolean isOpen, boolean isWritable, boolean isEncrypted, Optional<String> username, Map<String, String> protocolSpecificInformation) {
        static ConnectionDescriptionDTO from(ConnectionDescription domainObject) {
            return new ConnectionDescriptionDTO(domainObject.protocol(), domainObject.endpoint(), domainObject.remoteAddress(), domainObject.connectionDate(), domainObject.isActive(), domainObject.isOpen(), domainObject.isWritable(), domainObject.isEncrypted(), domainObject.username().map(Username::asString), domainObject.protocolSpecificInformation());
        }
    }
}

