/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class IndexingStats
implements PlainJsonSerializable {
    private final long indexCurrent;
    private final long deleteCurrent;
    @Nullable
    private final String deleteTime;
    private final long deleteTimeInMillis;
    private final long deleteTotal;
    private final boolean isThrottled;
    private final long noopUpdateTotal;
    @Nullable
    private final String throttleTime;
    private final long throttleTimeInMillis;
    @Nullable
    private final String indexTime;
    private final long indexTimeInMillis;
    private final long indexTotal;
    private final long indexFailed;
    private final Map<String, IndexingStats> types;
    public static final JsonpDeserializer<IndexingStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexingStats::setupIndexingStatsDeserializer);

    private IndexingStats(Builder builder) {
        this.indexCurrent = ApiTypeHelper.requireNonNull(builder.indexCurrent, this, "indexCurrent");
        this.deleteCurrent = ApiTypeHelper.requireNonNull(builder.deleteCurrent, this, "deleteCurrent");
        this.deleteTime = builder.deleteTime;
        this.deleteTimeInMillis = ApiTypeHelper.requireNonNull(builder.deleteTimeInMillis, this, "deleteTimeInMillis");
        this.deleteTotal = ApiTypeHelper.requireNonNull(builder.deleteTotal, this, "deleteTotal");
        this.isThrottled = ApiTypeHelper.requireNonNull(builder.isThrottled, this, "isThrottled");
        this.noopUpdateTotal = ApiTypeHelper.requireNonNull(builder.noopUpdateTotal, this, "noopUpdateTotal");
        this.throttleTime = builder.throttleTime;
        this.throttleTimeInMillis = ApiTypeHelper.requireNonNull(builder.throttleTimeInMillis, this, "throttleTimeInMillis");
        this.indexTime = builder.indexTime;
        this.indexTimeInMillis = ApiTypeHelper.requireNonNull(builder.indexTimeInMillis, this, "indexTimeInMillis");
        this.indexTotal = ApiTypeHelper.requireNonNull(builder.indexTotal, this, "indexTotal");
        this.indexFailed = ApiTypeHelper.requireNonNull(builder.indexFailed, this, "indexFailed");
        this.types = ApiTypeHelper.unmodifiable(builder.types);
    }

    public static IndexingStats of(Function<Builder, ObjectBuilder<IndexingStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long indexCurrent() {
        return this.indexCurrent;
    }

    public final long deleteCurrent() {
        return this.deleteCurrent;
    }

    @Nullable
    public final String deleteTime() {
        return this.deleteTime;
    }

    public final long deleteTimeInMillis() {
        return this.deleteTimeInMillis;
    }

    public final long deleteTotal() {
        return this.deleteTotal;
    }

    public final boolean isThrottled() {
        return this.isThrottled;
    }

    public final long noopUpdateTotal() {
        return this.noopUpdateTotal;
    }

    @Nullable
    public final String throttleTime() {
        return this.throttleTime;
    }

    public final long throttleTimeInMillis() {
        return this.throttleTimeInMillis;
    }

    @Nullable
    public final String indexTime() {
        return this.indexTime;
    }

    public final long indexTimeInMillis() {
        return this.indexTimeInMillis;
    }

    public final long indexTotal() {
        return this.indexTotal;
    }

    public final long indexFailed() {
        return this.indexFailed;
    }

    public final Map<String, IndexingStats> types() {
        return this.types;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index_current");
        generator.write(this.indexCurrent);
        generator.writeKey("delete_current");
        generator.write(this.deleteCurrent);
        if (this.deleteTime != null) {
            generator.writeKey("delete_time");
            generator.write(this.deleteTime);
        }
        generator.writeKey("delete_time_in_millis");
        generator.write(this.deleteTimeInMillis);
        generator.writeKey("delete_total");
        generator.write(this.deleteTotal);
        generator.writeKey("is_throttled");
        generator.write(this.isThrottled);
        generator.writeKey("noop_update_total");
        generator.write(this.noopUpdateTotal);
        if (this.throttleTime != null) {
            generator.writeKey("throttle_time");
            generator.write(this.throttleTime);
        }
        generator.writeKey("throttle_time_in_millis");
        generator.write(this.throttleTimeInMillis);
        if (this.indexTime != null) {
            generator.writeKey("index_time");
            generator.write(this.indexTime);
        }
        generator.writeKey("index_time_in_millis");
        generator.write(this.indexTimeInMillis);
        generator.writeKey("index_total");
        generator.write(this.indexTotal);
        generator.writeKey("index_failed");
        generator.write(this.indexFailed);
        if (ApiTypeHelper.isDefined(this.types)) {
            generator.writeKey("types");
            generator.writeStartObject();
            for (Map.Entry<String, IndexingStats> item0 : this.types.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupIndexingStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indexCurrent, JsonpDeserializer.longDeserializer(), "index_current");
        op.add(Builder::deleteCurrent, JsonpDeserializer.longDeserializer(), "delete_current");
        op.add(Builder::deleteTime, JsonpDeserializer.stringDeserializer(), "delete_time");
        op.add(Builder::deleteTimeInMillis, JsonpDeserializer.longDeserializer(), "delete_time_in_millis");
        op.add(Builder::deleteTotal, JsonpDeserializer.longDeserializer(), "delete_total");
        op.add(Builder::isThrottled, JsonpDeserializer.booleanDeserializer(), "is_throttled");
        op.add(Builder::noopUpdateTotal, JsonpDeserializer.longDeserializer(), "noop_update_total");
        op.add(Builder::throttleTime, JsonpDeserializer.stringDeserializer(), "throttle_time");
        op.add(Builder::throttleTimeInMillis, JsonpDeserializer.longDeserializer(), "throttle_time_in_millis");
        op.add(Builder::indexTime, JsonpDeserializer.stringDeserializer(), "index_time");
        op.add(Builder::indexTimeInMillis, JsonpDeserializer.longDeserializer(), "index_time_in_millis");
        op.add(Builder::indexTotal, JsonpDeserializer.longDeserializer(), "index_total");
        op.add(Builder::indexFailed, JsonpDeserializer.longDeserializer(), "index_failed");
        op.add(Builder::types, JsonpDeserializer.stringMapDeserializer(_DESERIALIZER), "types");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IndexingStats> {
        private Long indexCurrent;
        private Long deleteCurrent;
        @Nullable
        private String deleteTime;
        private Long deleteTimeInMillis;
        private Long deleteTotal;
        private Boolean isThrottled;
        private Long noopUpdateTotal;
        @Nullable
        private String throttleTime;
        private Long throttleTimeInMillis;
        @Nullable
        private String indexTime;
        private Long indexTimeInMillis;
        private Long indexTotal;
        private Long indexFailed;
        @Nullable
        private Map<String, IndexingStats> types;

        public final Builder indexCurrent(long value) {
            this.indexCurrent = value;
            return this;
        }

        public final Builder deleteCurrent(long value) {
            this.deleteCurrent = value;
            return this;
        }

        public final Builder deleteTime(@Nullable String value) {
            this.deleteTime = value;
            return this;
        }

        public final Builder deleteTimeInMillis(long value) {
            this.deleteTimeInMillis = value;
            return this;
        }

        public final Builder deleteTotal(long value) {
            this.deleteTotal = value;
            return this;
        }

        public final Builder isThrottled(boolean value) {
            this.isThrottled = value;
            return this;
        }

        public final Builder noopUpdateTotal(long value) {
            this.noopUpdateTotal = value;
            return this;
        }

        public final Builder throttleTime(@Nullable String value) {
            this.throttleTime = value;
            return this;
        }

        public final Builder throttleTimeInMillis(long value) {
            this.throttleTimeInMillis = value;
            return this;
        }

        public final Builder indexTime(@Nullable String value) {
            this.indexTime = value;
            return this;
        }

        public final Builder indexTimeInMillis(long value) {
            this.indexTimeInMillis = value;
            return this;
        }

        public final Builder indexTotal(long value) {
            this.indexTotal = value;
            return this;
        }

        public final Builder indexFailed(long value) {
            this.indexFailed = value;
            return this;
        }

        public final Builder types(Map<String, IndexingStats> map) {
            this.types = Builder._mapPutAll(this.types, map);
            return this;
        }

        public final Builder types(String key, IndexingStats value) {
            this.types = Builder._mapPut(this.types, key, value);
            return this;
        }

        public final Builder types(String key, Function<Builder, ObjectBuilder<IndexingStats>> fn) {
            return this.types(key, fn.apply(new Builder()).build());
        }

        @Override
        public IndexingStats build() {
            this._checkSingleUse();
            return new IndexingStats(this);
        }
    }
}

