/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.reindex;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class RemoteSource
implements PlainJsonSerializable {
    private final Time connectTimeout;
    private final String host;
    private final String username;
    private final String password;
    private final Time socketTimeout;
    public static final JsonpDeserializer<RemoteSource> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RemoteSource::setupRemoteSourceDeserializer);

    private RemoteSource(Builder builder) {
        this.connectTimeout = ApiTypeHelper.requireNonNull(builder.connectTimeout, this, "connectTimeout");
        this.host = ApiTypeHelper.requireNonNull(builder.host, this, "host");
        this.username = ApiTypeHelper.requireNonNull(builder.username, this, "username");
        this.password = ApiTypeHelper.requireNonNull(builder.password, this, "password");
        this.socketTimeout = ApiTypeHelper.requireNonNull(builder.socketTimeout, this, "socketTimeout");
    }

    public static RemoteSource of(Function<Builder, ObjectBuilder<RemoteSource>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Time connectTimeout() {
        return this.connectTimeout;
    }

    public final String host() {
        return this.host;
    }

    public final String username() {
        return this.username;
    }

    public final String password() {
        return this.password;
    }

    public final Time socketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("connect_timeout");
        this.connectTimeout.serialize(generator, mapper);
        generator.writeKey("host");
        generator.write(this.host);
        generator.writeKey("username");
        generator.write(this.username);
        generator.writeKey("password");
        generator.write(this.password);
        generator.writeKey("socket_timeout");
        this.socketTimeout.serialize(generator, mapper);
    }

    protected static void setupRemoteSourceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::connectTimeout, Time._DESERIALIZER, "connect_timeout");
        op.add(Builder::host, JsonpDeserializer.stringDeserializer(), "host");
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username");
        op.add(Builder::password, JsonpDeserializer.stringDeserializer(), "password");
        op.add(Builder::socketTimeout, Time._DESERIALIZER, "socket_timeout");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RemoteSource> {
        private Time connectTimeout;
        private String host;
        private String username;
        private String password;
        private Time socketTimeout;

        public final Builder connectTimeout(Time value) {
            this.connectTimeout = value;
            return this;
        }

        public final Builder connectTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.connectTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder host(String value) {
            this.host = value;
            return this;
        }

        public final Builder username(String value) {
            this.username = value;
            return this;
        }

        public final Builder password(String value) {
            this.password = value;
            return this;
        }

        public final Builder socketTimeout(Time value) {
            this.socketTimeout = value;
            return this;
        }

        public final Builder socketTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.socketTimeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        public RemoteSource build() {
            this._checkSingleUse();
            return new RemoteSource(this);
        }
    }
}

