/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.healthcheck;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.mail.internet.InternetAddress;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.commons.io.IOUtils;
import org.apache.james.core.Username;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.events.Registration;
import org.apache.james.events.RegistrationKey;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.events.MailboxIdRegistrationKey;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.server.core.MailImpl;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.util.DurationParser;
import org.apache.james.util.ReactorUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

public class MailReceptionCheck
implements HealthCheck {
    public static final ComponentName COMPONENT_NAME = new ComponentName("MailReceptionCheck");
    private static final Logger LOGGER = LoggerFactory.getLogger(MailReceptionCheck.class);
    private final MailetContext mailetContext;
    private final MailboxManager mailboxManager;
    private final EventBus eventBus;
    private final UsersRepository usersRepository;
    private final Configuration configuration;

    @Inject
    public MailReceptionCheck(MailetContext mailetContext, MailboxManager mailboxManager, EventBus eventBus, UsersRepository usersRepository, Configuration configuration) {
        this.mailetContext = mailetContext;
        this.mailboxManager = mailboxManager;
        this.eventBus = eventBus;
        this.usersRepository = usersRepository;
        this.configuration = configuration;
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Publisher<Result> check() {
        return (Publisher)this.configuration.getCheckUser().map(this::check).orElse(Mono.just((Object)Result.healthy((ComponentName)this.componentName())));
    }

    private Mono<Result> check(Username username) {
        Content content = Content.generate();
        MailboxSession session = this.mailboxManager.createSystemSession(username);
        return this.retrieveInbox(username, session).flatMap(mailbox -> {
            AwaitReceptionListener listener = new AwaitReceptionListener((MessageManager)mailbox, content, session);
            return Mono.usingWhen((Publisher)Mono.from((Publisher)this.eventBus.register((EventListener.ReactiveEventListener)listener, (RegistrationKey)new MailboxIdRegistrationKey(mailbox.getId()))), registration -> listener.results().doOnSubscribe(any -> this.sendMail(username, content).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER).subscribe()).map(any -> Result.healthy((ComponentName)this.componentName())).next(), Registration::unregister);
        }).timeout(this.configuration.getTimeout(), Mono.error(() -> new RuntimeException("HealthCheck email was not received after " + this.configuration.getTimeout().toMillis() + "ms"))).onErrorResume(e -> {
            LOGGER.error("Mail reception check failed", e);
            return Mono.just((Object)Result.unhealthy((ComponentName)this.componentName(), (String)e.getMessage()));
        }).doFinally(any -> this.mailboxManager.endProcessingRequest(session));
    }

    private Mono<MessageManager> retrieveInbox(Username username, MailboxSession session) {
        MailboxPath mailboxPath = MailboxPath.inbox((Username)username);
        return Mono.from((Publisher)this.mailboxManager.getMailboxReactive(mailboxPath, session)).onErrorResume(MailboxNotFoundException.class, e -> Mono.from((Publisher)this.mailboxManager.createMailboxReactive(mailboxPath, session)).then(Mono.from((Publisher)this.mailboxManager.getMailboxReactive(mailboxPath, session))));
    }

    private Mono<Result> checkReceived(AwaitReceptionListener listener) {
        return listener.results().map(any -> Result.healthy((ComponentName)this.componentName())).next();
    }

    private Mono<Content> sendMail(Username username, Content content) {
        return Mono.fromCallable(() -> this.usersRepository.getMailAddressFor(username)).flatMap(address -> Mono.using(() -> MailImpl.builder().name(content.asString()).sender(address).addRecipient(address).mimeMessage(MimeMessageBuilder.mimeMessageBuilder().addFrom(new InternetAddress[]{new InternetAddress(address.asString())}).addToRecipient(address.asString()).setSubject(content.asString()).setText(content.asString())).build(), mail -> Mono.fromRunnable((Runnable)Throwing.runnable(() -> this.mailetContext.sendMail((Mail)mail))), LifecycleUtil::dispose)).thenReturn((Object)content).subscribeOn(Schedulers.boundedElastic());
    }

    public static class Configuration {
        private static final Duration DEFAULT_TIMEOUT = Duration.ofMinutes(1L);
        public static final Configuration DEFAULT = new Configuration(Optional.empty(), DEFAULT_TIMEOUT);
        private final Optional<Username> checkUser;
        private final Duration timeout;

        public static Configuration from(org.apache.commons.configuration2.Configuration configuration) {
            Optional<Username> username = Optional.ofNullable(configuration.getString("reception.check.user", null)).map(Username::of);
            Duration timeout = Optional.ofNullable(configuration.getString("reception.check.timeout", null)).map(s -> DurationParser.parse((String)s, (ChronoUnit)ChronoUnit.SECONDS)).orElse(DEFAULT_TIMEOUT);
            return new Configuration(username, timeout);
        }

        public Configuration(Optional<Username> checkUser, Duration timeout) {
            this.checkUser = checkUser;
            this.timeout = timeout;
        }

        public Optional<Username> getCheckUser() {
            return this.checkUser;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public final boolean equals(Object o) {
            if (o instanceof Configuration) {
                Configuration that = (Configuration)o;
                return Objects.equals(this.checkUser, that.checkUser) && Objects.equals(this.timeout, that.timeout);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.checkUser, this.timeout);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("checkUser", this.checkUser).add("timeout", (Object)this.timeout).toString();
        }
    }

    public static class Content {
        private final UUID uuid;

        public static Content generate() {
            return new Content(UUID.randomUUID());
        }

        private Content(UUID uuid) {
            this.uuid = uuid;
        }

        public String asString() {
            return this.uuid.toString();
        }

        public final boolean equals(Object o) {
            if (o instanceof Content) {
                Content that = (Content)o;
                return Objects.equals(this.uuid, that.uuid);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.uuid);
        }

        public String toString() {
            return this.asString();
        }
    }

    public static class AwaitReceptionListener
    implements EventListener.ReactiveEventListener {
        private final Sinks.Many<Result> sink;
        private final MessageManager mailbox;
        private final Content content;
        private final MailboxSession session;

        public AwaitReceptionListener(MessageManager mailbox, Content content, MailboxSession session) {
            this.mailbox = mailbox;
            this.content = content;
            this.session = session;
            this.sink = Sinks.many().multicast().onBackpressureBuffer();
        }

        public Publisher<Void> reactiveEvent(Event event) {
            if (event instanceof MailboxEvents.Added) {
                MailboxEvents.Added added = (MailboxEvents.Added)event;
                return this.checkReceived(added).flatMap(result -> Mono.fromRunnable(() -> this.sink.emitNext(result, Sinks.EmitFailureHandler.FAIL_FAST)).subscribeOn(Schedulers.boundedElastic())).then();
            }
            return Mono.empty();
        }

        private Mono<Result> checkReceived(MailboxEvents.Added added) {
            return Flux.fromIterable((Iterable)added.getUids()).flatMap(uid -> Flux.from((Publisher)this.mailbox.getMessagesReactive(MessageRange.one((MessageUid)uid), FetchGroup.FULL_CONTENT, this.session))).filter((Predicate)Throwing.predicate(messageResult -> IOUtils.toString((InputStream)messageResult.getBody().getInputStream(), (Charset)StandardCharsets.US_ASCII).contains(this.content.asString()))).concatMap(messageResult -> Mono.from((Publisher)this.mailbox.deleteReactive((List)ImmutableList.of((Object)messageResult.getUid()), this.session)).onErrorResume(e -> {
                LOGGER.warn("Failed to delete Health check testing email", e);
                return Mono.empty();
            }).thenReturn(messageResult)).map(any -> Result.healthy((ComponentName)COMPONENT_NAME)).next();
        }

        public Flux<Result> results() {
            return this.sink.asFlux();
        }
    }
}

