/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib.netty;

import jakarta.inject.Inject;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.protocols.api.handler.ProtocolHandlerChain;
import org.apache.james.protocols.lib.ProtocolHandlerChainImpl;
import org.apache.james.protocols.lib.handler.HandlersPackage;
import org.apache.james.protocols.lib.handler.ProtocolHandlerLoader;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;

public abstract class AbstractProtocolAsyncServer
extends AbstractConfigurableAsyncServer {
    private ProtocolHandlerChainImpl handlerChain;
    private ProtocolHandlerLoader loader;
    private HierarchicalConfiguration<ImmutableNode> config;

    @Inject
    public void setProtocolHandlerLoader(ProtocolHandlerLoader loader) {
        this.loader = loader;
    }

    @Override
    protected void preInit() throws Exception {
        super.preInit();
        this.handlerChain = new ProtocolHandlerChainImpl(this.loader, (HierarchicalConfiguration<ImmutableNode>)this.config.configurationAt("handlerchain"), this.jmxName, this.getCoreHandlersPackage(), this.getJMXHandlersPackage());
        this.handlerChain.init();
    }

    @Override
    protected void doConfigure(HierarchicalConfiguration<ImmutableNode> config) throws ConfigurationException {
        super.doConfigure(config);
        this.config = config;
    }

    @Override
    protected void postDestroy() {
        super.postDestroy();
        this.handlerChain.destroy();
    }

    protected ProtocolHandlerChain getProtocolHandlerChain() {
        return this.handlerChain;
    }

    protected abstract Class<? extends HandlersPackage> getCoreHandlersPackage();

    protected abstract Class<? extends HandlersPackage> getJMXHandlersPackage();
}

