/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.apache.james.util.MDCStructuredLogger;
import org.apache.james.webadmin.mdc.LoggingRequestFilter;
import org.apache.james.webadmin.mdc.RequestId;
import org.apache.james.webadmin.mdc.RequestLogger;
import org.slf4j.Logger;
import spark.Request;

public class UserCreationRequestLogger
implements RequestLogger {
    public boolean applies(Request request) {
        return request.uri().startsWith("/users") && request.requestMethod().equals("PUT");
    }

    public void log(Request request, RequestId requestId) {
        MDCStructuredLogger.forLogger((Logger)LoggingRequestFilter.LOGGER).field("requestId", requestId.asString()).field("ip", request.ip()).field("endpoint", request.url()).field("method", request.requestMethod()).field("LOGIN", (String)request.attribute("LOGIN")).field("queryParameters", ImmutableSet.copyOf((Collection)request.queryParams()).toString()).log(logger -> logger.info("WebAdmin request received: user creation request"));
    }
}

