/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.jpa;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PersistenceUnit;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.james.backends.jpa.EntityManagerUtils;
import org.apache.james.core.Domain;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.jpa.model.JPARecipientRewrite;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPARecipientRewriteTable
extends AbstractRecipientRewriteTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JPARecipientRewriteTable.class);
    private EntityManagerFactory entityManagerFactory;

    @Inject
    @PersistenceUnit(unitName="James")
    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public void addMapping(MappingSource source, Mapping mapping) throws RecipientRewriteTableException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            JPARecipientRewrite jpaRecipientRewrite = new JPARecipientRewrite(source.getFixedUser(), Domain.of((String)source.getFixedDomain()), mapping.asString());
            transaction.begin();
            entityManager.merge((Object)jpaRecipientRewrite);
            transaction.commit();
        }
        catch (PersistenceException e) {
            LOGGER.debug("Failed to save virtual user", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new RecipientRewriteTableException("Unable to add mapping", (Throwable)e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    public void removeMapping(MappingSource source, Mapping mapping) throws RecipientRewriteTableException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            entityManager.createNamedQuery("deleteMapping").setParameter("user", (Object)source.getFixedUser()).setParameter("domain", (Object)source.getFixedDomain()).setParameter("targetAddress", (Object)mapping.asString()).executeUpdate();
            transaction.commit();
        }
        catch (PersistenceException e) {
            LOGGER.debug("Failed to remove mapping", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new RecipientRewriteTableException("Unable to remove mapping", (Throwable)e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    public Mappings getStoredMappings(MappingSource source) throws RecipientRewriteTableException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            List mappings = entityManager.createNamedQuery("selectUserDomainMapping").setParameter("user", (Object)source.getFixedUser()).setParameter("domain", (Object)source.getFixedDomain()).getResultStream().map(r -> Mapping.of((String)((JPARecipientRewrite)r).getTargetAddress())).collect(Collectors.toList());
            MappingsImpl mappingsImpl = MappingsImpl.fromMappings(mappings.stream());
            return mappingsImpl;
        }
        catch (PersistenceException e) {
            LOGGER.debug("Failed to get user domain mappings", (Throwable)e);
            throw new RecipientRewriteTableException("Error while retrieve mappings", (Throwable)e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    public Map<MappingSource, Mappings> getAllMappings() throws RecipientRewriteTableException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            Map<MappingSource, MappingsImpl> map = entityManager.createNamedQuery("selectAllMappings").getResultStream().collect(Collectors.toMap(r -> MappingSource.fromUser((String)((JPARecipientRewrite)r).getUser(), (String)((JPARecipientRewrite)r).getDomain()), r -> MappingsImpl.fromRawString((String)((JPARecipientRewrite)r).getTargetAddress()), (m1, m2) -> MappingsImpl.from((Mappings)m1).addAll((Mappings)m2).build()));
            return map;
        }
        catch (PersistenceException e) {
            LOGGER.debug("Failed to get all mappings", (Throwable)e);
            throw new RecipientRewriteTableException("Error while retrieve mappings", (Throwable)e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    public Stream<MappingSource> listSources(Mapping mapping) throws RecipientRewriteTableException {
        Preconditions.checkArgument((boolean)listSourcesSupportedType.contains(mapping.getType()), (String)"Not supported mapping of type %s", (Object)mapping.getType());
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            Stream<MappingSource> stream = entityManager.createNamedQuery("selectSourcesByMapping", JPARecipientRewrite.class).setParameter("targetAddress", (Object)mapping.asString()).getResultStream().map(r -> MappingSource.fromUser((String)r.getUser(), (String)r.getDomain()));
            return stream;
        }
        catch (PersistenceException e) {
            String error = "Unable to list sources by mapping";
            LOGGER.debug(error, (Throwable)e);
            throw new RecipientRewriteTableException(error, (Throwable)e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }
}

