/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.mail.Flags;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.apache.james.core.Username;
import org.apache.james.imap.api.ImapConfiguration;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.AppendRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.AuditTrail;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class AppendProcessor
extends AbstractMailboxProcessor<AppendRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppendProcessor.class);
    private ImmutableList<Capability> capabilities = ImmutableList.of();
    private final PathConverter.Factory pathConverterFactory;

    @Inject
    public AppendProcessor(MailboxManager mailboxManager, StatusResponseFactory statusResponseFactory, MetricFactory metricFactory, PathConverter.Factory pathConverterFactory) {
        super(AppendRequest.class, mailboxManager, statusResponseFactory, metricFactory);
        this.pathConverterFactory = pathConverterFactory;
    }

    @Override
    public void configure(ImapConfiguration imapConfiguration) {
        super.configure(imapConfiguration);
        this.capabilities = ImmutableList.of((Object)imapConfiguration.getAppendLimit().map(value -> Capability.of("APPENDLIMIT=" + value)).orElse(Capability.of("APPENDLIMIT")));
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return this.capabilities;
    }

    @Override
    protected Mono<Void> processRequestReactive(AppendRequest request, ImapSession session, ImapProcessor.Responder responder) {
        String mailboxName = request.getMailboxName();
        Content messageIn = request.getMessage().asMailboxContent();
        Date datetime = request.getDatetime();
        Flags flags = request.getFlags();
        MailboxPath mailboxPath = this.pathConverterFactory.forSession(session).buildFullPath(mailboxName);
        MailboxManager mailboxManager = this.getMailboxManager();
        session.stopDetectingCommandInjection();
        return Mono.from((Publisher)mailboxManager.getMailboxReactive(mailboxPath, session.getMailboxSession())).flatMap(mailbox -> this.appendToMailbox(messageIn, datetime, flags, session, request, (MessageManager)mailbox, responder)).doOnEach(ReactorUtils.logOnError(MailboxNotFoundException.class, e -> LOGGER.debug("Append failed for mailbox {}", (Object)mailboxPath, e))).onErrorResume(MailboxNotFoundException.class, e -> {
            this.no(request, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX, StatusResponse.ResponseCode.tryCreate());
            return Mono.empty();
        }).doOnEach(ReactorUtils.logOnError(OverQuotaException.class, e -> LOGGER.info("Append failed for mailbox {} because overquota", (Object)mailboxPath))).onErrorResume(OverQuotaException.class, e -> {
            this.no(request, responder, HumanReadableText.FAILURE_OVERQUOTA, StatusResponse.ResponseCode.overQuota());
            return Mono.empty();
        }).doOnEach(ReactorUtils.logOnError(MailboxException.class, e -> LOGGER.error("Append failed for mailbox {}", (Object)mailboxPath, e))).onErrorResume(MailboxException.class, e -> {
            this.no(request, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
            return Mono.empty();
        });
    }

    private Mono<Void> appendToMailbox(Content message, Date datetime, Flags flagsToBeSet, ImapSession session, AppendRequest request, MessageManager mailbox, ImapProcessor.Responder responder) {
        MailboxSession mailboxSession = session.getMailboxSession();
        SelectedMailbox selectedMailbox = session.getSelected();
        boolean isSelectedMailbox = selectedMailbox != null && selectedMailbox.getMailboxId().equals((Object)mailbox.getId());
        return Mono.from((Publisher)mailbox.appendMessageReactive(MessageManager.AppendCommand.builder().withInternalDate(datetime).withFlags(flagsToBeSet).isRecent(!isSelectedMailbox).build(message), mailboxSession)).doOnSuccess(result -> AuditTrail.entry().username(() -> mailboxSession.getUser().asString()).sessionId(() -> session.sessionId().asString()).protocol("IMAP").action("APPEND").parameters(() -> ImmutableMap.of((Object)"loggedInUser", (Object)mailboxSession.getLoggedInUser().map(Username::asString).orElse(""), (Object)"mailboxId", (Object)mailbox.getId().serialize(), (Object)"size", (Object)String.valueOf(result.getSize()), (Object)"mailboxName", (Object)mailbox.getMailboxPath().getName(), (Object)"uid", (Object)String.valueOf(result.getId().getUid().asLong()), (Object)"messageId", (Object)String.valueOf(result.getId().getMessageId().serialize()))).log("IMAP APPEND succeeded.")).map(MessageManager.AppendResult::getId).map(Throwing.function(messageId -> {
            if (isSelectedMailbox) {
                selectedMailbox.addRecent(messageId.getUid());
            }
            return messageId;
        }).sneakyThrow()).flatMap(messageId -> this.unsolicitedResponses(session, responder, false).thenReturn(messageId)).doOnNext((Consumer)Throwing.consumer(messageId -> {
            UidValidity uidValidity = mailbox.getMailboxEntity().getUidValidity();
            this.okComplete(request, StatusResponse.ResponseCode.appendUid(uidValidity, new UidRange[]{new UidRange(messageId.getUid())}), responder);
        })).then();
    }

    @Override
    protected MDCBuilder mdc(AppendRequest request) {
        return MDCBuilder.create().addToContext("action", "APPEND").addToContext("mailbox", request.getMailboxName());
    }
}

