/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.extractor;

import com.github.fge.lambdas.Throwing;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.extractor.ParsedContent;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.model.ContentType;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class DefaultTextExtractor
implements TextExtractor {
    public boolean applicable(ContentType contentType) {
        return contentType != null && contentType.mediaType().equals((Object)ContentType.MediaType.TEXT);
    }

    public ParsedContent extractContent(InputStream inputStream, ContentType contentType) throws Exception {
        try (InputStream input = inputStream;){
            if (this.applicable(contentType)) {
                Charset charset = contentType.charset().orElse(StandardCharsets.UTF_8);
                ParsedContent parsedContent = ParsedContent.of((String)IOUtils.toString((InputStream)input, (Charset)charset));
                return parsedContent;
            }
            ParsedContent parsedContent = ParsedContent.empty();
            return parsedContent;
        }
    }

    public Mono<ParsedContent> extractContentReactive(InputStream inputStream, ContentType contentType) {
        if (this.applicable(contentType)) {
            Charset charset = contentType.charset().orElse(StandardCharsets.UTF_8);
            return Mono.using(() -> inputStream, stream -> Mono.fromCallable(() -> ParsedContent.of((String)IOUtils.toString((InputStream)stream, (Charset)charset))).subscribeOn(Schedulers.boundedElastic()), (Consumer)Throwing.consumer(InputStream::close).orDoNothing());
        }
        return Mono.just((Object)ParsedContent.empty());
    }
}

