/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.mailbox.cassandra.mail.CassandraAttachmentMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageMetadata;
import org.apache.james.mailbox.cassandra.mail.MessageAttachmentRepresentation;
import org.apache.james.mailbox.cassandra.mail.MessageRepresentation;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AttachmentLoader {
    private final CassandraAttachmentMapper attachmentMapper;

    public AttachmentLoader(CassandraAttachmentMapper attachmentMapper) {
        this.attachmentMapper = attachmentMapper;
    }

    public Mono<CassandraMessageMetadata.CassandraMailboxMessage> addAttachmentToMessage(Pair<ComposedMessageIdWithMetaData, MessageRepresentation> messageRepresentation, Optional<Date> saveDate, MessageMapper.FetchType fetchType) {
        return this.loadAttachments(((MessageRepresentation)messageRepresentation.getRight()).getAttachments().stream(), fetchType).map(attachments -> ((MessageRepresentation)messageRepresentation.getRight()).toMailboxMessage((ComposedMessageIdWithMetaData)messageRepresentation.getLeft(), (List<MessageAttachmentMetadata>)attachments, saveDate)).map(message -> new CassandraMessageMetadata.CassandraMailboxMessage((MailboxMessage)message, ((MessageRepresentation)messageRepresentation.getRight()).getHeaderId()));
    }

    private Mono<List<MessageAttachmentMetadata>> loadAttachments(Stream<MessageAttachmentRepresentation> messageAttachmentRepresentations, MessageMapper.FetchType fetchType) {
        if (fetchType == MessageMapper.FetchType.FULL || fetchType == MessageMapper.FetchType.ATTACHMENTS_METADATA) {
            return this.getAttachments((List)messageAttachmentRepresentations.collect(ImmutableList.toImmutableList()));
        }
        return Mono.just((Object)ImmutableList.of());
    }

    @VisibleForTesting
    Mono<List<MessageAttachmentMetadata>> getAttachments(List<MessageAttachmentRepresentation> attachmentRepresentations) {
        return Flux.fromIterable(attachmentRepresentations).flatMapSequential(attachmentRepresentation -> this.attachmentMapper.getAttachmentsAsMono((AttachmentId)attachmentRepresentation.getAttachmentId()).map(attachment -> this.constructMessageAttachment((AttachmentMetadata)attachment, (MessageAttachmentRepresentation)attachmentRepresentation))).collect(ImmutableList.toImmutableList());
    }

    private MessageAttachmentMetadata constructMessageAttachment(AttachmentMetadata attachment, MessageAttachmentRepresentation messageAttachmentRepresentation) {
        return MessageAttachmentMetadata.builder().attachment(attachment).name((String)messageAttachmentRepresentation.getName().orElse(null)).cid(messageAttachmentRepresentation.getCid()).isInline(Boolean.valueOf(messageAttachmentRepresentation.isInline())).build();
    }
}

