/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.transport.rest_client;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.WarningsHandler;
import org.opensearch.client.transport.TransportOptions;
import org.opensearch.client.transport.Version;
import org.opensearch.client.transport.rest_client.RestClientTransport;

public class RestClientOptions
implements TransportOptions {
    private final RequestOptions options;

    static RestClientOptions of(TransportOptions options) {
        if (options instanceof RestClientOptions) {
            return (RestClientOptions)options;
        }
        Builder builder = new Builder(RequestOptions.DEFAULT.toBuilder());
        options.headers().forEach(h -> builder.addHeader((String)h.getKey(), (String)h.getValue()));
        options.queryParameters().forEach(builder::setParameter);
        builder.onWarnings(options.onWarnings());
        return builder.build();
    }

    public RestClientOptions(RequestOptions options) {
        this.options = options;
    }

    public static Builder builder() {
        return new Builder(RequestOptions.DEFAULT.toBuilder());
    }

    public RequestOptions restClientRequestOptions() {
        return this.options;
    }

    @Override
    public Collection<Map.Entry<String, String>> headers() {
        return this.options.getHeaders().stream().map(h -> new AbstractMap.SimpleImmutableEntry<String, String>(h.getName(), h.getValue())).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> queryParameters() {
        return null;
    }

    @Override
    public Function<List<String>, Boolean> onWarnings() {
        WarningsHandler handler = this.options.getWarningsHandler();
        if (handler == null) {
            return null;
        }
        return warnings -> this.options.getWarningsHandler().warningsShouldFailRequest(warnings);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this.options.toBuilder());
    }

    static RestClientOptions initialOptions() {
        String ua = String.format(Locale.ROOT, "opensearch-java/%s (Java/%s)", Version.VERSION == null ? "Unknown" : Version.VERSION.toString(), System.getProperty("java.version"));
        return new RestClientOptions(RequestOptions.DEFAULT.toBuilder().addHeader("User-Agent", ua).addHeader("Accept", RestClientTransport.JsonContentType.toString()).build());
    }

    public static class Builder
    implements TransportOptions.Builder {
        private RequestOptions.Builder builder;

        public Builder(RequestOptions.Builder builder) {
            this.builder = builder;
        }

        public RequestOptions.Builder restClientRequestOptionsBuilder() {
            return this.builder;
        }

        @Override
        public TransportOptions.Builder addHeader(String name, String value) {
            if (name.equalsIgnoreCase("User-Agent")) {
                RequestOptions options = this.builder.build();
                this.builder = RequestOptions.DEFAULT.toBuilder();
                options.getHeaders().forEach(h -> {
                    if (!h.getName().equalsIgnoreCase("User-Agent")) {
                        this.builder.addHeader(h.getName(), h.getValue());
                    }
                });
                this.builder.setWarningsHandler(options.getWarningsHandler());
                if (options.getHttpAsyncResponseConsumerFactory() != null) {
                    this.builder.setHttpAsyncResponseConsumerFactory(options.getHttpAsyncResponseConsumerFactory());
                }
            }
            this.builder.addHeader(name, value);
            return this;
        }

        @Override
        public TransportOptions.Builder setParameter(String name, String value) {
            return this;
        }

        @Override
        public TransportOptions.Builder onWarnings(Function<List<String>, Boolean> listener) {
            if (listener == null) {
                this.builder.setWarningsHandler(null);
            } else {
                this.builder.setWarningsHandler(w -> {
                    if (w != null && !w.isEmpty()) {
                        return (Boolean)listener.apply(w);
                    }
                    return false;
                });
            }
            return this;
        }

        @Override
        public RestClientOptions build() {
            return new RestClientOptions(this.builder.build());
        }
    }
}

