/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.ctl.ActionCtl;
import org.apache.jena.fuseki.main.FusekiLib;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.RDFParser;

public class ActionReload
extends ActionCtl {
    @Override
    public void validate(HttpAction action) {
        if (action.getRequestMethod() != "POST") {
            ServletOps.errorMethodNotAllowed(action.getRequestMethod());
        }
    }

    @Override
    public void execute(HttpAction action) {
        FusekiServer server = FusekiServer.get(action.getRequest().getServletContext());
        if (server == null) {
            ServletOps.errorOccurred("Failed to find the server for this action");
            return;
        }
        String configFilename = server.getConfigFilename();
        if (configFilename == null) {
            FmtLog.warn(Fuseki.serverLog, "[%d] Server does not have an associated configuration file", action.id);
            ServletOps.errorBadRequest("Server does not have an associated configuration file");
            return;
        }
        Model model = RDFParser.source(configFilename).toModel();
        FmtLog.info(Fuseki.serverLog, "[%d] Reload configuration", action.id);
        FusekiLib.reload(server, model);
    }
}

