/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.lucene.store;

/**
 * Hints on the type of file being opened.
 *
 * <p><b>NOTE</b>: There is no constant for metadata files, since metadata files should be opened
 * with {@link Directory#openChecksumInput(String)}, which doesn't take hints.
 */
public enum FileTypeHint implements IOContext.FileOpenHint {
  /**
   * The file contains indexes. It is small (~1% or less of the data size) and generally fits in the
   * page cache.
   */
  INDEX,
  /** The file contains field data. */
  DATA
}
