/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.simpletext.SimpleTextCodec;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatDocValuesField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.analysis.MockAnalyzer;
import org.apache.lucene.tests.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.junit.Assert;

public abstract class LegacyBaseDocValuesFormatTestCase
extends BaseIndexFileFormatTestCase {
    @Override
    protected void addRandomFields(Document doc) {
        int i;
        if (LegacyBaseDocValuesFormatTestCase.usually()) {
            doc.add((IndexableField)new NumericDocValuesField("ndv", (long)LegacyBaseDocValuesFormatTestCase.random().nextInt(4096)));
            doc.add((IndexableField)new BinaryDocValuesField("bdv", LegacyBaseDocValuesFormatTestCase.newBytesRef(TestUtil.randomSimpleString(LegacyBaseDocValuesFormatTestCase.random()))));
            doc.add((IndexableField)new SortedDocValuesField("sdv", LegacyBaseDocValuesFormatTestCase.newBytesRef(TestUtil.randomSimpleString(LegacyBaseDocValuesFormatTestCase.random(), 2))));
        }
        int numValues = LegacyBaseDocValuesFormatTestCase.random().nextInt(5);
        for (i = 0; i < numValues; ++i) {
            doc.add((IndexableField)new SortedSetDocValuesField("ssdv", LegacyBaseDocValuesFormatTestCase.newBytesRef(TestUtil.randomSimpleString(LegacyBaseDocValuesFormatTestCase.random(), 2))));
        }
        numValues = LegacyBaseDocValuesFormatTestCase.random().nextInt(5);
        for (i = 0; i < numValues; ++i) {
            doc.add((IndexableField)new SortedNumericDocValuesField("sndv", TestUtil.nextLong(LegacyBaseDocValuesFormatTestCase.random(), Long.MIN_VALUE, Long.MAX_VALUE)));
        }
    }

    public void testOneNumber() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)LegacyBaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv", 5L));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        StoredFields storedFields = isearcher.storedFields();
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.count((Query)new TermQuery(new Term("fieldname", longTerm))));
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits.value());
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Document hitDoc = storedFields.document(hits.scoreDocs[i].doc);
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
            int docID = hits.scoreDocs[i].doc;
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv.advance(docID));
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv.longValue());
        }
        ireader.close();
        directory.close();
    }

    public void testOneFloat() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)LegacyBaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new FloatDocValuesField("dv", 5.7f));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        StoredFields storedFields = isearcher.storedFields();
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.count((Query)new TermQuery(new Term("fieldname", longTerm))));
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits.value());
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            int docID = hits.scoreDocs[i].doc;
            Document hitDoc = storedFields.document(docID);
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv.advance(docID));
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)Float.floatToRawIntBits(5.7f), (long)dv.longValue());
        }
        ireader.close();
        directory.close();
    }

    public void testTwoNumbers() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)LegacyBaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv1", 5L));
        doc.add((IndexableField)new NumericDocValuesField("dv2", 17L));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        StoredFields storedFields = isearcher.storedFields();
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.count((Query)new TermQuery(new Term("fieldname", longTerm))));
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits.value());
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            int docID = hits.scoreDocs[i].doc;
            Document hitDoc = storedFields.document(docID);
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv1");
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv.advance(docID));
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv.longValue());
            dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv2");
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv.advance(docID));
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)17L, (long)dv.longValue());
        }
        ireader.close();
        directory.close();
    }

    public void testTwoBinaryValues() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)LegacyBaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv1", LegacyBaseDocValuesFormatTestCase.newBytesRef(longTerm)));
        doc.add((IndexableField)new BinaryDocValuesField("dv2", LegacyBaseDocValuesFormatTestCase.newBytesRef(text)));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        StoredFields storedFields = isearcher.storedFields();
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.count((Query)new TermQuery(new Term("fieldname", longTerm))));
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits.value());
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            int hitDocID = hits.scoreDocs[i].doc;
            Document hitDoc = storedFields.document(hitDocID);
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv1");
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)hitDocID, (long)dv.advance(hitDocID));
            BytesRef scratch = dv.binaryValue();
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef(longTerm), (Object)scratch);
            dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv2");
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)hitDocID, (long)dv.advance(hitDocID));
            scratch = dv.binaryValue();
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef(text), (Object)scratch);
        }
        ireader.close();
        directory.close();
    }

    public void testVariouslyCompressibleBinaryValues() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory);
        int numDocs = 1 + LegacyBaseDocValuesFormatTestCase.random().nextInt(100);
        HashMap<Integer, BytesRef> writtenValues = new HashMap<Integer, BytesRef>();
        int vocabRange = 1 + LegacyBaseDocValuesFormatTestCase.random().nextInt(126);
        for (int i = 0; i < numDocs; ++i) {
            Document doc = new Document();
            byte[] value = new byte[500 + LegacyBaseDocValuesFormatTestCase.random().nextInt(1024)];
            for (int j = 0; j < value.length; ++j) {
                value[j] = (byte)LegacyBaseDocValuesFormatTestCase.random().nextInt(vocabRange);
            }
            BytesRef bytesRef = LegacyBaseDocValuesFormatTestCase.newBytesRef(value);
            writtenValues.put(i, bytesRef);
            doc.add((IndexableField)LegacyBaseDocValuesFormatTestCase.newTextField("id", Integer.toString(i), Field.Store.YES));
            doc.add((IndexableField)new BinaryDocValuesField("dv1", bytesRef));
            iwriter.addDocument(doc);
        }
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        StoredFields storedFields = isearcher.storedFields();
        for (int i = 0; i < numDocs; ++i) {
            String id = Integer.toString(i);
            TermQuery query = new TermQuery(new Term("id", id));
            TopDocs hits = isearcher.search((Query)query, 1);
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits.value());
            int hitDocID = hits.scoreDocs[0].doc;
            Document hitDoc = storedFields.document(hitDocID);
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)id, (Object)hitDoc.get("id"));
            assert (ireader.leaves().size() == 1);
            BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv1");
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)hitDocID, (long)dv.advance(hitDocID));
            BytesRef scratch = dv.binaryValue();
            LegacyBaseDocValuesFormatTestCase.assertEquals(writtenValues.get(i), (Object)scratch);
        }
        ireader.close();
        directory.close();
    }

    public void testTwoFieldsMixed() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)LegacyBaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv1", 5L));
        doc.add((IndexableField)new BinaryDocValuesField("dv2", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        StoredFields storedFields = isearcher.storedFields();
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.count((Query)new TermQuery(new Term("fieldname", longTerm))));
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits.value());
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            int docID = hits.scoreDocs[i].doc;
            Document hitDoc = storedFields.document(docID);
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv1");
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv.advance(docID));
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv.longValue());
            BinaryDocValues dv2 = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv2");
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv2.advance(docID));
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world"), (Object)dv2.binaryValue());
        }
        ireader.close();
        directory.close();
    }

    public void testThreeFieldsMixed() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)LegacyBaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new SortedDocValuesField("dv1", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello hello")));
        doc.add((IndexableField)new NumericDocValuesField("dv2", 5L));
        doc.add((IndexableField)new BinaryDocValuesField("dv3", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.count((Query)new TermQuery(new Term("fieldname", longTerm))));
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        StoredFields storedFields = isearcher.storedFields();
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits.value());
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            int docID = hits.scoreDocs[i].doc;
            Document hitDoc = storedFields.document(docID);
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv1");
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv.advance(docID));
            int ord = dv.ordValue();
            BytesRef scratch = dv.lookupOrd(ord);
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("hello hello"), (Object)scratch);
            NumericDocValues dv2 = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv2");
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv2.advance(docID));
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv2.longValue());
            BinaryDocValues dv3 = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv3");
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv3.advance(docID));
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world"), (Object)dv3.binaryValue());
        }
        ireader.close();
        directory.close();
    }

    public void testThreeFieldsMixed2() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)LegacyBaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv1", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world")));
        doc.add((IndexableField)new SortedDocValuesField("dv2", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello hello")));
        doc.add((IndexableField)new NumericDocValuesField("dv3", 5L));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        StoredFields storedFields = isearcher.storedFields();
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.count((Query)new TermQuery(new Term("fieldname", longTerm))));
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits.value());
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            int docID = hits.scoreDocs[i].doc;
            Document hitDoc = storedFields.document(docID);
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv2");
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv.advance(docID));
            int ord = dv.ordValue();
            BytesRef scratch = dv.lookupOrd(ord);
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("hello hello"), (Object)scratch);
            NumericDocValues dv2 = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv3");
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv2.advance(docID));
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv2.longValue());
            BinaryDocValues dv3 = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv1");
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv3.advance(docID));
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world"), (Object)dv3.binaryValue());
        }
        ireader.close();
        directory.close();
    }

    public void testTwoDocumentsNumeric() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", 1L));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", 2L));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (ireader.leaves().size() == 1);
        NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.longValue());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.longValue());
        ireader.close();
        directory.close();
    }

    public void testTwoDocumentsMerged() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)LegacyBaseDocValuesFormatTestCase.newField("id", "0", StringField.TYPE_STORED));
        doc.add((IndexableField)new NumericDocValuesField("dv", -10L));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)LegacyBaseDocValuesFormatTestCase.newField("id", "1", StringField.TYPE_STORED));
        doc.add((IndexableField)new NumericDocValuesField("dv", 99L));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (ireader.leaves().size() == 1);
        NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
        StoredFields storedFields = ((LeafReaderContext)ireader.leaves().get(0)).reader().storedFields();
        for (int i = 0; i < 2; ++i) {
            Document doc2 = storedFields.document(i);
            long expected = doc2.get("id").equals("0") ? -10L : 99L;
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)i, (long)dv.nextDoc());
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)expected, (long)dv.longValue());
        }
        ireader.close();
        directory.close();
    }

    public void testBigNumericRange() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", Long.MIN_VALUE));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", Long.MAX_VALUE));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (ireader.leaves().size() == 1);
        NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)Long.MIN_VALUE, (long)dv.longValue());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)Long.MAX_VALUE, (long)dv.longValue());
        ireader.close();
        directory.close();
    }

    public void testBigNumericRange2() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", -8841491950446638677L));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", 9062230939892376225L));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (ireader.leaves().size() == 1);
        NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)-8841491950446638677L, (long)dv.longValue());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)9062230939892376225L, (long)dv.longValue());
        ireader.close();
        directory.close();
    }

    public void testBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)LegacyBaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        StoredFields storedFields = isearcher.storedFields();
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.count((Query)new TermQuery(new Term("fieldname", longTerm))));
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits.value());
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            int hitDocID = hits.scoreDocs[i].doc;
            Document hitDoc = storedFields.document(hitDocID);
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)hitDocID, (long)dv.advance(hitDocID));
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world"), (Object)dv.binaryValue());
        }
        ireader.close();
        directory.close();
    }

    public void testBytesTwoDocumentsMerged() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)LegacyBaseDocValuesFormatTestCase.newField("id", "0", StringField.TYPE_STORED));
        doc.add((IndexableField)new BinaryDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world 1")));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)LegacyBaseDocValuesFormatTestCase.newField("id", "1", StringField.TYPE_STORED));
        doc.add((IndexableField)new BinaryDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello 2")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
        StoredFields storedFields = ((LeafReaderContext)ireader.leaves().get(0)).reader().storedFields();
        for (int i = 0; i < 2; ++i) {
            Document doc2 = storedFields.document(i);
            String expected = doc2.get("id").equals("0") ? "hello world 1" : "hello 2";
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)i, (long)dv.nextDoc());
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)expected, (Object)dv.binaryValue().utf8ToString());
        }
        ireader.close();
        directory.close();
    }

    public void testBytesMergeAwayAllValues() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new BinaryDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("hi")));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        BinaryDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getBinaryDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ireader.close();
        directory.close();
    }

    public void testSortedBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)LegacyBaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new SortedDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.count((Query)new TermQuery(new Term("fieldname", longTerm))));
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits.value());
        StoredFields storedFields = isearcher.storedFields();
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            int docID = hits.scoreDocs[i].doc;
            Document hitDoc = storedFields.document(docID);
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv.advance(docID));
            BytesRef scratch = dv.lookupOrd(dv.ordValue());
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world"), (Object)scratch);
        }
        ireader.close();
        directory.close();
    }

    public void testSortedBytesTwoDocuments() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world 1")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world 2")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BytesRef scratch = dv.lookupOrd(dv.ordValue());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"hello world 1", (Object)scratch.utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        scratch = dv.lookupOrd(dv.ordValue());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"hello world 2", (Object)scratch.utf8ToString());
        ireader.close();
        directory.close();
    }

    public void testSortedBytesThreeDocuments() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world 1")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world 2")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world 1")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.getValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.ordValue());
        BytesRef scratch = dv.lookupOrd(0);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"hello world 1", (Object)scratch.utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.ordValue());
        scratch = dv.lookupOrd(1);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"hello world 2", (Object)scratch.utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.ordValue());
        ireader.close();
        directory.close();
    }

    public void testSortedBytesTwoDocumentsMerged() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)LegacyBaseDocValuesFormatTestCase.newField("id", "0", StringField.TYPE_STORED));
        doc.add((IndexableField)new SortedDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world 1")));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)LegacyBaseDocValuesFormatTestCase.newField("id", "1", StringField.TYPE_STORED));
        doc.add((IndexableField)new SortedDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world 2")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.getValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BytesRef scratch = dv.lookupOrd(dv.ordValue());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world 1"), (Object)scratch);
        scratch = dv.lookupOrd(1);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world 2"), (Object)scratch);
        StoredFields storedFields = ((LeafReaderContext)ireader.leaves().get(0)).reader().storedFields();
        for (int i = 0; i < 2; ++i) {
            Document doc2 = storedFields.document(i);
            String expected = doc2.get("id").equals("0") ? "hello world 1" : "hello world 2";
            if (dv.docID() < i) {
                LegacyBaseDocValuesFormatTestCase.assertEquals((long)i, (long)dv.nextDoc());
            }
            scratch = dv.lookupOrd(dv.ordValue());
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)expected, (Object)scratch.utf8ToString());
        }
        ireader.close();
        directory.close();
    }

    public void testSortedMergeAwayAllValues() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new SortedDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello")));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        TermsEnum termsEnum = dv.termsEnum();
        LegacyBaseDocValuesFormatTestCase.assertFalse((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"lucene")));
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.END, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"lucene")));
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.lookupTerm(new BytesRef((CharSequence)"lucene")));
        ireader.close();
        directory.close();
    }

    public void testBytesWithNewline() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new BinaryDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello\nworld\r1")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("hello\nworld\r1"), (Object)dv.binaryValue());
        ireader.close();
        directory.close();
    }

    public void testMissingSortedBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world 2")));
        iwriter.addDocument(doc);
        iwriter.addDocument(new Document());
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BytesRef scratch = dv.lookupOrd(dv.ordValue());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("hello world 2"), (Object)scratch);
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ireader.close();
        directory.close();
    }

    public void testSortedTermsEnum() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("world")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("beer")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)3L, (long)dv.getValueCount());
        TermsEnum termsEnum = dv.termsEnum();
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.next().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.next().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.next().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.NOT_FOUND, (Object)termsEnum.seekCeil(LegacyBaseDocValuesFormatTestCase.newBytesRef("ha!")));
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.term().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.FOUND, (Object)termsEnum.seekCeil(LegacyBaseDocValuesFormatTestCase.newBytesRef("beer")));
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.END, (Object)termsEnum.seekCeil(LegacyBaseDocValuesFormatTestCase.newBytesRef("zzz")));
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.NOT_FOUND, (Object)termsEnum.seekCeil(LegacyBaseDocValuesFormatTestCase.newBytesRef("aba")));
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(LegacyBaseDocValuesFormatTestCase.newBytesRef("beer")));
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(LegacyBaseDocValuesFormatTestCase.newBytesRef("hello")));
        LegacyBaseDocValuesFormatTestCase.assertEquals((String)Codec.getDefault().toString(), (Object)"hello", (Object)termsEnum.term().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(LegacyBaseDocValuesFormatTestCase.newBytesRef("world")));
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.term().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertFalse((boolean)termsEnum.seekExact(LegacyBaseDocValuesFormatTestCase.newBytesRef("bogus")));
        termsEnum.seekExact(0L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        termsEnum.seekExact(1L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.term().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        termsEnum.seekExact(2L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.term().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        termsEnum = dv.intersect(new CompiledAutomaton(Operations.determinize((Automaton)new RegExp(".*l.*").toAutomaton(), (int)10000)));
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.next().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.next().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertNull((Object)termsEnum.next());
        termsEnum = dv.intersect(new CompiledAutomaton(new RegExp("hello").toAutomaton()));
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.next().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertNull((Object)termsEnum.next());
        ireader.close();
        directory.close();
    }

    public void testEmptySortedBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef("")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef("")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.ordValue());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.ordValue());
        BytesRef scratch = dv.lookupOrd(0);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"", (Object)scratch.utf8ToString());
        ireader.close();
        directory.close();
    }

    public void testEmptyBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new BinaryDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef("")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new BinaryDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef("")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"", (Object)dv.binaryValue().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"", (Object)dv.binaryValue().utf8ToString());
        ireader.close();
        directory.close();
    }

    public void testVeryLargeButLegalBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        byte[] bytes = new byte[32766];
        LegacyBaseDocValuesFormatTestCase.random().nextBytes(bytes);
        BytesRef b = LegacyBaseDocValuesFormatTestCase.newBytesRef(bytes);
        doc.add((IndexableField)new BinaryDocValuesField("dv", b));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef(bytes), (Object)dv.binaryValue());
        ireader.close();
        directory.close();
    }

    public void testVeryLargeButLegalSortedBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        byte[] bytes = new byte[32766];
        LegacyBaseDocValuesFormatTestCase.random().nextBytes(bytes);
        BytesRef b = LegacyBaseDocValuesFormatTestCase.newBytesRef(bytes);
        doc.add((IndexableField)new SortedDocValuesField("dv", b));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = DocValues.getSorted((LeafReader)((LeafReaderContext)ireader.leaves().get(0)).reader(), (String)"dv");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef(bytes), (Object)dv.lookupOrd(dv.ordValue()));
        ireader.close();
        directory.close();
    }

    public void testCodecUsesOwnBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new BinaryDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef("boo!")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"boo!", (Object)dv.binaryValue().utf8ToString());
        ireader.close();
        directory.close();
    }

    public void testCodecUsesOwnSortedBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef("boo!")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = DocValues.getSorted((LeafReader)((LeafReaderContext)ireader.leaves().get(0)).reader(), (String)"dv");
        byte[] mybytes = new byte[20];
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"boo!", (Object)dv.lookupOrd(dv.ordValue()).utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertFalse((dv.lookupOrd((int)dv.ordValue()).bytes == mybytes ? 1 : 0) != 0);
        ireader.close();
        directory.close();
    }

    public void testDocValuesSimple() throws IOException {
        BaseDirectoryWrapper dir = LegacyBaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        IndexWriter writer = new IndexWriter((Directory)dir, conf);
        for (int i = 0; i < 5; ++i) {
            Document doc = new Document();
            doc.add((IndexableField)new NumericDocValuesField("docId", (long)i));
            doc.add((IndexableField)new TextField("docId", "" + i, Field.Store.NO));
            writer.addDocument((Iterable)doc);
        }
        writer.commit();
        writer.forceMerge(1, true);
        writer.close();
        DirectoryReader reader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)dir));
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)reader.leaves().size());
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        query.add((Query)new TermQuery(new Term("docId", "0")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("docId", "1")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("docId", "2")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("docId", "3")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("docId", "4")), BooleanClause.Occur.SHOULD);
        TopDocs search = searcher.search((Query)query.build(), 10);
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)5L, (long)search.totalHits.value());
        ScoreDoc[] scoreDocs = search.scoreDocs;
        NumericDocValues docValues = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)reader).getNumericDocValues("docId");
        for (int i = 0; i < scoreDocs.length; ++i) {
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)i, (long)scoreDocs[i].doc);
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)i, (long)docValues.advance(i));
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)i, (long)docValues.longValue());
        }
        reader.close();
        dir.close();
    }

    public void testRandomSortedBytes() throws IOException {
        Document doc;
        int i;
        BaseDirectoryWrapper dir = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig cfg = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random()));
        RandomIndexWriter w = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)dir, cfg);
        int numDocs = LegacyBaseDocValuesFormatTestCase.atLeast(100);
        BytesRefHash hash = new BytesRefHash();
        HashMap<CallSite, String> docToString = new HashMap<CallSite, String>();
        int maxLength = TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), 1, 50);
        for (int i2 = 0; i2 < numDocs; ++i2) {
            Document doc2 = new Document();
            doc2.add((IndexableField)LegacyBaseDocValuesFormatTestCase.newTextField("id", "" + i2, Field.Store.YES));
            String string = TestUtil.randomRealisticUnicodeString(LegacyBaseDocValuesFormatTestCase.random(), 1, maxLength);
            BytesRef br = LegacyBaseDocValuesFormatTestCase.newBytesRef(string);
            doc2.add((IndexableField)new SortedDocValuesField("field", br));
            hash.add(br);
            docToString.put((CallSite)((Object)("" + i2)), string);
            w.addDocument(doc2);
        }
        if (LegacyBaseDocValuesFormatTestCase.rarely()) {
            w.commit();
        }
        int numDocsNoValue = LegacyBaseDocValuesFormatTestCase.atLeast(10);
        for (i = 0; i < numDocsNoValue; ++i) {
            doc = new Document();
            doc.add((IndexableField)LegacyBaseDocValuesFormatTestCase.newTextField("id", "noValue", Field.Store.YES));
            w.addDocument(doc);
        }
        if (LegacyBaseDocValuesFormatTestCase.rarely()) {
            w.commit();
        }
        for (i = 0; i < numDocs; ++i) {
            doc = new Document();
            String id = "" + (i + numDocs);
            doc.add((IndexableField)LegacyBaseDocValuesFormatTestCase.newTextField("id", id, Field.Store.YES));
            String string = TestUtil.randomRealisticUnicodeString(LegacyBaseDocValuesFormatTestCase.random(), 1, maxLength);
            BytesRef br = LegacyBaseDocValuesFormatTestCase.newBytesRef(string);
            hash.add(br);
            docToString.put((CallSite)((Object)id), string);
            doc.add((IndexableField)new SortedDocValuesField("field", br));
            w.addDocument(doc);
        }
        w.commit();
        DirectoryReader reader = w.getReader();
        SortedDocValues docValues = MultiDocValues.getSortedValues((IndexReader)reader, (String)"field");
        int[] sort = hash.sort();
        BytesRef expected = LegacyBaseDocValuesFormatTestCase.newBytesRef();
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)hash.size(), (long)docValues.getValueCount());
        for (int i3 = 0; i3 < hash.size(); ++i3) {
            hash.get(sort[i3], expected);
            BytesRef actual = docValues.lookupOrd(i3);
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)expected.utf8ToString(), (Object)actual.utf8ToString());
            int ord = docValues.lookupTerm(expected);
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)i3, (long)ord);
        }
        Set entrySet = docToString.entrySet();
        for (Map.Entry entry : entrySet) {
            PostingsEnum termPostingsEnum = TestUtil.docs(LegacyBaseDocValuesFormatTestCase.random(), (IndexReader)reader, "id", LegacyBaseDocValuesFormatTestCase.newBytesRef((String)entry.getKey()), null, 0);
            int docId = termPostingsEnum.nextDoc();
            expected = LegacyBaseDocValuesFormatTestCase.newBytesRef((String)entry.getValue());
            docValues = MultiDocValues.getSortedValues((IndexReader)reader, (String)"field");
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)docId, (long)docValues.advance(docId));
            BytesRef actual = docValues.lookupOrd(docValues.ordValue());
            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)expected, (Object)actual);
        }
        reader.close();
        w.close();
        dir.close();
    }

    private void doTestNumericsVsStoredFields(double density, LongSupplier longs) throws Exception {
        this.doTestNumericsVsStoredFields(density, longs, 256);
    }

    private void doTestNumericsVsStoredFields(double density, LongSupplier longs, int minDocs) throws Exception {
        BaseDirectoryWrapper dir = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        Document doc = new Document();
        StringField idField = new StringField("id", "", Field.Store.NO);
        Field storedField = LegacyBaseDocValuesFormatTestCase.newStringField("stored", "", Field.Store.YES);
        NumericDocValuesField dvField = new NumericDocValuesField("dv", 0L);
        doc.add((IndexableField)idField);
        doc.add((IndexableField)storedField);
        doc.add((IndexableField)dvField);
        int numDocs = LegacyBaseDocValuesFormatTestCase.atLeast((int)((double)minDocs * 1.172));
        assert (numDocs > 256);
        for (int i = 0; i < numDocs; ++i) {
            if (LegacyBaseDocValuesFormatTestCase.random().nextDouble() > density) {
                writer.addDocument(new Document());
                continue;
            }
            idField.setStringValue(Integer.toString(i));
            long value = longs.getAsLong();
            storedField.setStringValue(Long.toString(value));
            dvField.setLongValue(value);
            writer.addDocument(doc);
            if (LegacyBaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = LegacyBaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i = 0; i < numDeletions; ++i) {
            int id = LegacyBaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        writer.forceMerge(numDocs / Math.max(256, minDocs));
        writer.close();
        this.assertDVIterate((Directory)dir);
        dir.close();
    }

    protected void assertDVIterate(Directory dir) throws IOException {
        DirectoryReader ir = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)dir));
        TestUtil.checkReader((IndexReader)ir);
        for (LeafReaderContext context : ir.leaves()) {
            LeafReader r = context.reader();
            NumericDocValues docValues = DocValues.getNumeric((LeafReader)r, (String)"dv");
            docValues.nextDoc();
            StoredFields storedFields = r.storedFields();
            for (int i = 0; i < r.maxDoc(); ++i) {
                String storedValue = storedFields.document(i).get("stored");
                if (storedValue == null) {
                    LegacyBaseDocValuesFormatTestCase.assertTrue((docValues.docID() > i ? 1 : 0) != 0);
                    continue;
                }
                LegacyBaseDocValuesFormatTestCase.assertEquals((long)i, (long)docValues.docID());
                LegacyBaseDocValuesFormatTestCase.assertEquals((long)Long.parseLong(storedValue), (long)docValues.longValue());
                docValues.nextDoc();
            }
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docValues.docID());
        }
        ir.close();
    }

    protected void compareStoredFieldWithSortedNumericsDV(DirectoryReader directoryReader, String storedField, String dvField) throws IOException {
        for (LeafReaderContext leaf : directoryReader.leaves()) {
            int doc;
            int i;
            int doc2;
            LeafReader reader = leaf.reader();
            StoredFields storedFields = reader.storedFields();
            SortedNumericDocValues docValues = reader.getSortedNumericDocValues(dvField);
            if (docValues == null) {
                for (doc2 = 0; doc2 < reader.maxDoc(); ++doc2) {
                    LegacyBaseDocValuesFormatTestCase.assertArrayEquals((Object[])new String[0], (Object[])storedFields.document(doc2).getValues(storedField));
                }
                continue;
            }
            for (doc2 = 0; doc2 < reader.maxDoc(); ++doc2) {
                String[] storedValues = storedFields.document(doc2).getValues(storedField);
                if (storedValues.length == 0) {
                    LegacyBaseDocValuesFormatTestCase.assertFalse((boolean)docValues.advanceExact(doc2));
                    continue;
                }
                switch (LegacyBaseDocValuesFormatTestCase.random().nextInt(3)) {
                    case 0: {
                        LegacyBaseDocValuesFormatTestCase.assertEquals((long)doc2, (long)docValues.nextDoc());
                        break;
                    }
                    case 1: {
                        LegacyBaseDocValuesFormatTestCase.assertEquals((long)doc2, (long)docValues.advance(doc2));
                        break;
                    }
                    default: {
                        LegacyBaseDocValuesFormatTestCase.assertTrue((boolean)docValues.advanceExact(doc2));
                    }
                }
                LegacyBaseDocValuesFormatTestCase.assertEquals((long)doc2, (long)docValues.docID());
                int repeats = 1 + LegacyBaseDocValuesFormatTestCase.random().nextInt(3);
                for (int r = 0; r < repeats; ++r) {
                    if (r > 0 || LegacyBaseDocValuesFormatTestCase.random().nextBoolean()) {
                        LegacyBaseDocValuesFormatTestCase.assertTrue((boolean)docValues.advanceExact(doc2));
                    }
                    LegacyBaseDocValuesFormatTestCase.assertEquals((long)storedValues.length, (long)docValues.docValueCount());
                    for (int v = 0; v < docValues.docValueCount(); ++v) {
                        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)storedValues[v], (Object)Long.toString(docValues.nextValue()));
                    }
                }
            }
            int iters = 1 + LegacyBaseDocValuesFormatTestCase.random().nextInt(3);
            for (i = 0; i < iters; ++i) {
                docValues = reader.getSortedNumericDocValues(dvField);
                for (doc = LegacyBaseDocValuesFormatTestCase.random().nextInt(leaf.reader().maxDoc()); doc < reader.maxDoc(); ++doc) {
                    Object[] storedValues = storedFields.document(doc).getValues(storedField);
                    if (docValues.advanceExact(doc)) {
                        LegacyBaseDocValuesFormatTestCase.assertEquals((long)doc, (long)docValues.docID());
                        int repeats = 1 + LegacyBaseDocValuesFormatTestCase.random().nextInt(3);
                        for (int r = 0; r < repeats; ++r) {
                            if (r > 0 || LegacyBaseDocValuesFormatTestCase.random().nextBoolean()) {
                                LegacyBaseDocValuesFormatTestCase.assertTrue((boolean)docValues.advanceExact(doc));
                            }
                            LegacyBaseDocValuesFormatTestCase.assertEquals((long)storedValues.length, (long)docValues.docValueCount());
                            for (int v = 0; v < docValues.docValueCount(); ++v) {
                                LegacyBaseDocValuesFormatTestCase.assertEquals((Object)storedValues[v], (Object)Long.toString(docValues.nextValue()));
                            }
                        }
                    } else {
                        LegacyBaseDocValuesFormatTestCase.assertArrayEquals((Object[])new String[0], (Object[])storedValues);
                    }
                    doc += LegacyBaseDocValuesFormatTestCase.random().nextInt(5);
                }
            }
            for (i = 0; i < iters; ++i) {
                docValues = reader.getSortedNumericDocValues(dvField);
                doc = LegacyBaseDocValuesFormatTestCase.random().nextInt(leaf.reader().maxDoc());
                while (doc != Integer.MAX_VALUE) {
                    int nextDoc = docValues.advance(doc);
                    for (int d = doc; d < (nextDoc == Integer.MAX_VALUE ? reader.maxDoc() : nextDoc); ++d) {
                        Object[] storedValues = storedFields.document(d).getValues(storedField);
                        LegacyBaseDocValuesFormatTestCase.assertArrayEquals((Object[])new String[0], (Object[])storedValues);
                    }
                    doc = nextDoc;
                    if (doc == Integer.MAX_VALUE) continue;
                    String[] storedValues = storedFields.document(doc).getValues(storedField);
                    int repeats = 1 + LegacyBaseDocValuesFormatTestCase.random().nextInt(3);
                    for (int r = 0; r < repeats; ++r) {
                        if (r > 0 || LegacyBaseDocValuesFormatTestCase.random().nextBoolean()) {
                            LegacyBaseDocValuesFormatTestCase.assertTrue((boolean)docValues.advanceExact(doc));
                        }
                        LegacyBaseDocValuesFormatTestCase.assertEquals((long)storedValues.length, (long)docValues.docValueCount());
                        for (int v = 0; v < docValues.docValueCount(); ++v) {
                            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)storedValues[v], (Object)Long.toString(docValues.nextValue()));
                        }
                    }
                    doc = nextDoc + 1;
                    doc += LegacyBaseDocValuesFormatTestCase.random().nextInt(5);
                }
            }
        }
    }

    private void doTestSortedNumericsVsStoredFields(LongSupplier counts, LongSupplier values) throws Exception {
        BaseDirectoryWrapper dir = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        int numDocs = LegacyBaseDocValuesFormatTestCase.atLeast(300);
        assert (numDocs > 256);
        for (int i = 0; i < numDocs; ++i) {
            int j;
            Document doc = new Document();
            doc.add((IndexableField)new StringField("id", Integer.toString(i), Field.Store.NO));
            int valueCount = (int)counts.getAsLong();
            long[] valueArray = new long[valueCount];
            for (j = 0; j < valueCount; ++j) {
                long value;
                valueArray[j] = value = values.getAsLong();
                doc.add((IndexableField)new SortedNumericDocValuesField("dv", value));
            }
            Arrays.sort(valueArray);
            for (j = 0; j < valueCount; ++j) {
                doc.add((IndexableField)new StoredField("stored", Long.toString(valueArray[j])));
            }
            writer.addDocument(doc);
            if (LegacyBaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = LegacyBaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i = 0; i < numDeletions; ++i) {
            int id = LegacyBaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        try (DirectoryReader reader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)dir));){
            TestUtil.checkReader((IndexReader)reader);
            this.compareStoredFieldWithSortedNumericsDV(reader, "stored", "dv");
        }
        writer.forceMerge(numDocs / 256);
        reader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)dir));
        try {
            TestUtil.checkReader((IndexReader)reader);
            this.compareStoredFieldWithSortedNumericsDV(reader, "stored", "dv");
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        IOUtils.close((Closeable[])new Closeable[]{writer, dir});
    }

    public void testBooleanNumericsVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(1.0, () -> LegacyBaseDocValuesFormatTestCase.random().nextInt(2));
        }
    }

    public void testSparseBooleanNumericsVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(LegacyBaseDocValuesFormatTestCase.random().nextDouble(), () -> LegacyBaseDocValuesFormatTestCase.random().nextInt(2));
        }
    }

    public void testByteNumericsVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(1.0, () -> TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), -128, 127));
        }
    }

    public void testSparseByteNumericsVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(LegacyBaseDocValuesFormatTestCase.random().nextDouble(), () -> TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), -128, 127));
        }
    }

    public void testShortNumericsVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(1.0, () -> TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), Short.MIN_VALUE, Short.MAX_VALUE));
        }
    }

    public void testSparseShortNumericsVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(LegacyBaseDocValuesFormatTestCase.random().nextDouble(), () -> TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), Short.MIN_VALUE, Short.MAX_VALUE));
        }
    }

    public void testIntNumericsVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(1.0, LegacyBaseDocValuesFormatTestCase.random()::nextInt);
        }
    }

    public void testSparseIntNumericsVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(LegacyBaseDocValuesFormatTestCase.random().nextDouble(), LegacyBaseDocValuesFormatTestCase.random()::nextInt);
        }
    }

    public void testLongNumericsVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(1.0, LegacyBaseDocValuesFormatTestCase.random()::nextLong);
        }
    }

    public void testSparseLongNumericsVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(LegacyBaseDocValuesFormatTestCase.random().nextDouble(), LegacyBaseDocValuesFormatTestCase.random()::nextLong);
        }
    }

    private void doTestBinaryVsStoredFields(double density, Supplier<byte[]> bytes) throws Exception {
        BytesRef binaryValue;
        int i;
        BinaryDocValues docValues;
        StoredFields storedFields;
        LeafReader r;
        BaseDirectoryWrapper dir = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        Document doc = new Document();
        StringField idField = new StringField("id", "", Field.Store.NO);
        StoredField storedField = new StoredField("stored", new byte[0]);
        BinaryDocValuesField dvField = new BinaryDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef());
        doc.add((IndexableField)idField);
        doc.add((IndexableField)storedField);
        doc.add((IndexableField)dvField);
        int numDocs = LegacyBaseDocValuesFormatTestCase.atLeast(300);
        for (int i2 = 0; i2 < numDocs; ++i2) {
            if (LegacyBaseDocValuesFormatTestCase.random().nextDouble() > density) {
                writer.addDocument(new Document());
                continue;
            }
            idField.setStringValue(Integer.toString(i2));
            byte[] buffer = bytes.get();
            storedField.setBytesValue(buffer);
            dvField.setBytesValue(buffer);
            writer.addDocument(doc);
            if (LegacyBaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = LegacyBaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i3 = 0; i3 < numDeletions; ++i3) {
            int id = LegacyBaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        DirectoryReader ir = writer.getReader();
        TestUtil.checkReader((IndexReader)ir);
        for (LeafReaderContext context : ir.leaves()) {
            r = context.reader();
            storedFields = r.storedFields();
            docValues = DocValues.getBinary((LeafReader)r, (String)"dv");
            docValues.nextDoc();
            for (i = 0; i < r.maxDoc(); ++i) {
                binaryValue = storedFields.document(i).getBinaryValue("stored");
                if (binaryValue == null) {
                    LegacyBaseDocValuesFormatTestCase.assertTrue((docValues.docID() > i ? 1 : 0) != 0);
                    continue;
                }
                LegacyBaseDocValuesFormatTestCase.assertEquals((long)i, (long)docValues.docID());
                LegacyBaseDocValuesFormatTestCase.assertEquals((Object)binaryValue, (Object)docValues.binaryValue());
                docValues.nextDoc();
            }
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docValues.docID());
        }
        ir.close();
        writer.forceMerge(1);
        ir = writer.getReader();
        TestUtil.checkReader((IndexReader)ir);
        for (LeafReaderContext context : ir.leaves()) {
            r = context.reader();
            storedFields = r.storedFields();
            docValues = DocValues.getBinary((LeafReader)r, (String)"dv");
            docValues.nextDoc();
            for (i = 0; i < r.maxDoc(); ++i) {
                binaryValue = storedFields.document(i).getBinaryValue("stored");
                if (binaryValue == null) {
                    LegacyBaseDocValuesFormatTestCase.assertTrue((docValues.docID() > i ? 1 : 0) != 0);
                    continue;
                }
                LegacyBaseDocValuesFormatTestCase.assertEquals((long)i, (long)docValues.docID());
                LegacyBaseDocValuesFormatTestCase.assertEquals((Object)binaryValue, (Object)docValues.binaryValue());
                docValues.nextDoc();
            }
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docValues.docID());
        }
        ir.close();
        writer.close();
        dir.close();
    }

    public void testBinaryFixedLengthVsStoredFields() throws Exception {
        this.doTestBinaryFixedLengthVsStoredFields(1.0);
    }

    public void testSparseBinaryFixedLengthVsStoredFields() throws Exception {
        this.doTestBinaryFixedLengthVsStoredFields(LegacyBaseDocValuesFormatTestCase.random().nextDouble());
    }

    private void doTestBinaryFixedLengthVsStoredFields(double density) throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            int fixedLength = TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), 0, 10);
            this.doTestBinaryVsStoredFields(density, () -> {
                byte[] buffer = new byte[fixedLength];
                LegacyBaseDocValuesFormatTestCase.random().nextBytes(buffer);
                return buffer;
            });
        }
    }

    public void testBinaryVariableLengthVsStoredFields() throws Exception {
        this.doTestBinaryVariableLengthVsStoredFields(1.0);
    }

    public void testSparseBinaryVariableLengthVsStoredFields() throws Exception {
        this.doTestBinaryVariableLengthVsStoredFields(LegacyBaseDocValuesFormatTestCase.random().nextDouble());
    }

    public void doTestBinaryVariableLengthVsStoredFields(double density) throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestBinaryVsStoredFields(density, () -> {
                int length = LegacyBaseDocValuesFormatTestCase.random().nextInt(10);
                byte[] buffer = new byte[length];
                LegacyBaseDocValuesFormatTestCase.random().nextBytes(buffer);
                return buffer;
            });
        }
    }

    protected void doTestSortedVsStoredFields(int numDocs, double density, Supplier<byte[]> bytes) throws Exception {
        BytesRef binaryValue;
        int i;
        SortedDocValues docValues;
        StoredFields storedFields;
        LeafReader r;
        BaseDirectoryWrapper dir = LegacyBaseDocValuesFormatTestCase.newFSDirectory(LegacyBaseDocValuesFormatTestCase.createTempDir("dvduel"));
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        Document doc = new Document();
        StringField idField = new StringField("id", "", Field.Store.NO);
        StoredField storedField = new StoredField("stored", new byte[0]);
        SortedDocValuesField dvField = new SortedDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef());
        doc.add((IndexableField)idField);
        doc.add((IndexableField)storedField);
        doc.add((IndexableField)dvField);
        for (int i2 = 0; i2 < numDocs; ++i2) {
            if (LegacyBaseDocValuesFormatTestCase.random().nextDouble() > density) {
                writer.addDocument(new Document());
                continue;
            }
            idField.setStringValue(Integer.toString(i2));
            byte[] buffer = bytes.get();
            storedField.setBytesValue(buffer);
            dvField.setBytesValue(buffer);
            writer.addDocument(doc);
            if (LegacyBaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = LegacyBaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i3 = 0; i3 < numDeletions; ++i3) {
            int id = LegacyBaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        DirectoryReader ir = writer.getReader();
        TestUtil.checkReader((IndexReader)ir);
        for (LeafReaderContext context : ir.leaves()) {
            r = context.reader();
            storedFields = r.storedFields();
            docValues = DocValues.getSorted((LeafReader)r, (String)"dv");
            docValues.nextDoc();
            for (i = 0; i < r.maxDoc(); ++i) {
                binaryValue = storedFields.document(i).getBinaryValue("stored");
                if (binaryValue == null) {
                    LegacyBaseDocValuesFormatTestCase.assertTrue((docValues.docID() > i ? 1 : 0) != 0);
                    continue;
                }
                LegacyBaseDocValuesFormatTestCase.assertEquals((long)i, (long)docValues.docID());
                LegacyBaseDocValuesFormatTestCase.assertEquals((Object)binaryValue, (Object)docValues.lookupOrd(docValues.ordValue()));
                docValues.nextDoc();
            }
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docValues.docID());
        }
        ir.close();
        writer.forceMerge(1);
        ir = writer.getReader();
        TestUtil.checkReader((IndexReader)ir);
        for (LeafReaderContext context : ir.leaves()) {
            r = context.reader();
            storedFields = r.storedFields();
            docValues = DocValues.getSorted((LeafReader)r, (String)"dv");
            docValues.nextDoc();
            for (i = 0; i < r.maxDoc(); ++i) {
                binaryValue = storedFields.document(i).getBinaryValue("stored");
                if (binaryValue == null) {
                    LegacyBaseDocValuesFormatTestCase.assertTrue((docValues.docID() > i ? 1 : 0) != 0);
                    continue;
                }
                LegacyBaseDocValuesFormatTestCase.assertEquals((long)i, (long)docValues.docID());
                LegacyBaseDocValuesFormatTestCase.assertEquals((Object)binaryValue, (Object)docValues.lookupOrd(docValues.ordValue()));
                docValues.nextDoc();
            }
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docValues.docID());
        }
        ir.close();
        writer.close();
        dir.close();
    }

    public void testSortedFixedLengthVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            int fixedLength = TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), 1, 10);
            this.doTestSortedVsStoredFields(LegacyBaseDocValuesFormatTestCase.atLeast(300), 1.0, fixedLength, fixedLength);
        }
    }

    public void testSparseSortedFixedLengthVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            int fixedLength = TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), 1, 10);
            this.doTestSortedVsStoredFields(LegacyBaseDocValuesFormatTestCase.atLeast(300), LegacyBaseDocValuesFormatTestCase.random().nextDouble(), fixedLength, fixedLength);
        }
    }

    public void testSortedVariableLengthVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedVsStoredFields(LegacyBaseDocValuesFormatTestCase.atLeast(300), 1.0, 1, 10);
        }
    }

    public void testSparseSortedVariableLengthVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedVsStoredFields(LegacyBaseDocValuesFormatTestCase.atLeast(300), LegacyBaseDocValuesFormatTestCase.random().nextDouble(), 1, 10);
        }
    }

    protected void doTestSortedVsStoredFields(int numDocs, double density, int minLength, int maxLength) throws Exception {
        this.doTestSortedVsStoredFields(numDocs, density, () -> {
            int length = TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), minLength, maxLength);
            byte[] buffer = new byte[length];
            LegacyBaseDocValuesFormatTestCase.random().nextBytes(buffer);
            return buffer;
        });
    }

    public void testSortedSetOneValue() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello")));
        iwriter.addDocument(doc);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.docValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("hello"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoFields() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello")));
        doc.add((IndexableField)new SortedSetDocValuesField("field2", LegacyBaseDocValuesFormatTestCase.newBytesRef("world")));
        iwriter.addDocument(doc);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.docValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("hello"), (Object)bytes);
        dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field2");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.docValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        bytes = dv.lookupOrd(0L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("world"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoDocumentsMerged() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello")));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("world")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.getValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.docValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("hello"), (Object)bytes);
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.docValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextOrd());
        bytes = dv.lookupOrd(1L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("world"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoValues() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("world")));
        iwriter.addDocument(doc);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.docValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("hello"), (Object)bytes);
        bytes = dv.lookupOrd(1L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("world"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoValuesUnordered() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("world")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello")));
        iwriter.addDocument(doc);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.docValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("hello"), (Object)bytes);
        bytes = dv.lookupOrd(1L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("world"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetThreeValuesTwoDocs() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("world")));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("beer")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)3L, (long)dv.getValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.docValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextOrd());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.nextOrd());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.docValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("beer"), (Object)bytes);
        bytes = dv.lookupOrd(1L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("hello"), (Object)bytes);
        bytes = dv.lookupOrd(2L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("world"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoDocumentsLastMissing() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello")));
        iwriter.addDocument(doc);
        doc = new Document();
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.getValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.docValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("hello"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoDocumentsLastMissingMerge() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello")));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.getValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.docValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("hello"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoDocumentsFirstMissing() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.getValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.docValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("hello"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoDocumentsFirstMissingMerge() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.getValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.docValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("hello"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetMergeAwayAllValues() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello")));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.getValueCount());
        TermsEnum termsEnum = dv.termsEnum();
        LegacyBaseDocValuesFormatTestCase.assertFalse((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"lucene")));
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.END, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"lucene")));
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.lookupTerm(new BytesRef((CharSequence)"lucene")));
        ireader.close();
        directory.close();
    }

    public void testSortedSetTermsEnum() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("world")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("beer")));
        iwriter.addDocument(doc);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)3L, (long)dv.getValueCount());
        TermsEnum termsEnum = dv.termsEnum();
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.next().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.next().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.next().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.NOT_FOUND, (Object)termsEnum.seekCeil(LegacyBaseDocValuesFormatTestCase.newBytesRef("ha!")));
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.term().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.FOUND, (Object)termsEnum.seekCeil(LegacyBaseDocValuesFormatTestCase.newBytesRef("beer")));
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.END, (Object)termsEnum.seekCeil(LegacyBaseDocValuesFormatTestCase.newBytesRef("zzz")));
        LegacyBaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(LegacyBaseDocValuesFormatTestCase.newBytesRef("beer")));
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(LegacyBaseDocValuesFormatTestCase.newBytesRef("hello")));
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.term().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(LegacyBaseDocValuesFormatTestCase.newBytesRef("world")));
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.term().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertFalse((boolean)termsEnum.seekExact(LegacyBaseDocValuesFormatTestCase.newBytesRef("bogus")));
        termsEnum.seekExact(0L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        termsEnum.seekExact(1L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.term().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        termsEnum.seekExact(2L);
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.term().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        termsEnum = dv.intersect(new CompiledAutomaton(Operations.determinize((Automaton)new RegExp(".*l.*").toAutomaton(), (int)10000)));
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.next().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.next().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertNull((Object)termsEnum.next());
        termsEnum = dv.intersect(new CompiledAutomaton(new RegExp("hello").toAutomaton()));
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.next().utf8ToString());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        LegacyBaseDocValuesFormatTestCase.assertNull((Object)termsEnum.next());
        ireader.close();
        directory.close();
    }

    protected void compareStoredFieldWithSortedSetDV(DirectoryReader directoryReader, String storedField, String dvField) throws IOException {
        for (LeafReaderContext leaf : directoryReader.leaves()) {
            int repeats;
            int doc;
            int i;
            int doc2;
            LeafReader reader = leaf.reader();
            StoredFields storedFields = reader.storedFields();
            SortedSetDocValues docValues = reader.getSortedSetDocValues(dvField);
            if (docValues == null) {
                for (doc2 = 0; doc2 < reader.maxDoc(); ++doc2) {
                    LegacyBaseDocValuesFormatTestCase.assertArrayEquals((Object[])new String[0], (Object[])storedFields.document(doc2).getValues(storedField));
                }
                continue;
            }
            for (doc2 = 0; doc2 < reader.maxDoc(); ++doc2) {
                String[] storedValues = storedFields.document(doc2).getValues(storedField);
                if (storedValues.length == 0) {
                    LegacyBaseDocValuesFormatTestCase.assertFalse((boolean)docValues.advanceExact(doc2));
                    continue;
                }
                switch (LegacyBaseDocValuesFormatTestCase.random().nextInt(3)) {
                    case 0: {
                        LegacyBaseDocValuesFormatTestCase.assertEquals((long)doc2, (long)docValues.nextDoc());
                        break;
                    }
                    case 1: {
                        LegacyBaseDocValuesFormatTestCase.assertEquals((long)doc2, (long)docValues.advance(doc2));
                        break;
                    }
                    default: {
                        LegacyBaseDocValuesFormatTestCase.assertTrue((boolean)docValues.advanceExact(doc2));
                    }
                }
                LegacyBaseDocValuesFormatTestCase.assertEquals((long)doc2, (long)docValues.docID());
                LegacyBaseDocValuesFormatTestCase.assertEquals((long)storedValues.length, (long)docValues.docValueCount());
                int repeats2 = 1 + LegacyBaseDocValuesFormatTestCase.random().nextInt(3);
                for (int r = 0; r < repeats2; ++r) {
                    if (r > 0 || LegacyBaseDocValuesFormatTestCase.random().nextBoolean()) {
                        LegacyBaseDocValuesFormatTestCase.assertTrue((boolean)docValues.advanceExact(doc2));
                    }
                    for (int v = 0; v < docValues.docValueCount(); ++v) {
                        long ord = docValues.nextOrd();
                        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)storedValues[v], (Object)docValues.lookupOrd(ord).utf8ToString());
                    }
                }
            }
            int iters = 1 + LegacyBaseDocValuesFormatTestCase.random().nextInt(3);
            for (i = 0; i < iters; ++i) {
                docValues = reader.getSortedSetDocValues(dvField);
                for (doc = LegacyBaseDocValuesFormatTestCase.random().nextInt(leaf.reader().maxDoc()); doc < reader.maxDoc(); ++doc) {
                    Object[] storedValues = storedFields.document(doc).getValues(storedField);
                    if (docValues.advanceExact(doc)) {
                        LegacyBaseDocValuesFormatTestCase.assertEquals((long)doc, (long)docValues.docID());
                        LegacyBaseDocValuesFormatTestCase.assertEquals((long)storedValues.length, (long)docValues.docValueCount());
                        repeats = 1 + LegacyBaseDocValuesFormatTestCase.random().nextInt(3);
                        for (int r = 0; r < repeats; ++r) {
                            if (r > 0 || LegacyBaseDocValuesFormatTestCase.random().nextBoolean()) {
                                LegacyBaseDocValuesFormatTestCase.assertTrue((boolean)docValues.advanceExact(doc));
                            }
                            for (int v = 0; v < docValues.docValueCount(); ++v) {
                                long ord = docValues.nextOrd();
                                LegacyBaseDocValuesFormatTestCase.assertEquals((Object)storedValues[v], (Object)docValues.lookupOrd(ord).utf8ToString());
                            }
                        }
                    } else {
                        LegacyBaseDocValuesFormatTestCase.assertArrayEquals((Object[])new String[0], (Object[])storedValues);
                    }
                    doc += LegacyBaseDocValuesFormatTestCase.random().nextInt(5);
                }
            }
            for (i = 0; i < iters; ++i) {
                docValues = reader.getSortedSetDocValues(dvField);
                doc = LegacyBaseDocValuesFormatTestCase.random().nextInt(leaf.reader().maxDoc());
                while (doc != Integer.MAX_VALUE) {
                    Object[] storedValues;
                    int nextDoc = docValues.advance(doc);
                    for (int d = doc; d < (nextDoc == Integer.MAX_VALUE ? reader.maxDoc() : nextDoc); ++d) {
                        storedValues = storedFields.document(d).getValues(storedField);
                        LegacyBaseDocValuesFormatTestCase.assertArrayEquals((Object[])new String[0], (Object[])storedValues);
                    }
                    doc = nextDoc;
                    if (doc == Integer.MAX_VALUE) continue;
                    repeats = 1 + LegacyBaseDocValuesFormatTestCase.random().nextInt(3);
                    storedValues = storedFields.document(doc).getValues(storedField);
                    for (int r = 0; r < repeats; ++r) {
                        if (r > 0 || LegacyBaseDocValuesFormatTestCase.random().nextBoolean()) {
                            LegacyBaseDocValuesFormatTestCase.assertTrue((boolean)docValues.advanceExact(doc));
                        }
                        for (int v = 0; v < docValues.docValueCount(); ++v) {
                            long ord = docValues.nextOrd();
                            LegacyBaseDocValuesFormatTestCase.assertEquals((Object)storedValues[v], (Object)docValues.lookupOrd(ord).utf8ToString());
                        }
                    }
                    doc = nextDoc + 1;
                    doc += LegacyBaseDocValuesFormatTestCase.random().nextInt(5);
                }
            }
        }
    }

    protected void doTestSortedSetVsStoredFields(int numDocs, int minLength, int maxLength, int maxValuesPerDoc, int maxUniqueValues) throws Exception {
        BaseDirectoryWrapper dir = LegacyBaseDocValuesFormatTestCase.newFSDirectory(LegacyBaseDocValuesFormatTestCase.createTempDir("dvduel"));
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        HashSet<String> valueSet = new HashSet<String>();
        for (int i = 0; i < 10000 && valueSet.size() < maxUniqueValues; ++i) {
            int length = TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), minLength, maxLength);
            valueSet.add(TestUtil.randomSimpleString(LegacyBaseDocValuesFormatTestCase.random(), length));
        }
        Object[] uniqueValues = valueSet.toArray(new String[0]);
        if (VERBOSE) {
            System.out.println("\nTEST: now add numDocs=" + numDocs);
        }
        for (int i = 0; i < numDocs; ++i) {
            Document doc = new Document();
            StringField idField = new StringField("id", Integer.toString(i), Field.Store.NO);
            doc.add((IndexableField)idField);
            int numValues = TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), 0, maxValuesPerDoc);
            TreeSet<String> values = new TreeSet<String>();
            for (int v = 0; v < numValues; ++v) {
                values.add((String)RandomPicks.randomFrom((Random)LegacyBaseDocValuesFormatTestCase.random(), (Object[])uniqueValues));
            }
            for (String v : values) {
                doc.add((IndexableField)new StoredField("stored", v));
            }
            ArrayList unordered = new ArrayList(values);
            Collections.shuffle(unordered, LegacyBaseDocValuesFormatTestCase.random());
            for (String v : unordered) {
                doc.add((IndexableField)new SortedSetDocValuesField("dv", LegacyBaseDocValuesFormatTestCase.newBytesRef(v)));
            }
            writer.addDocument(doc);
            if (LegacyBaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = LegacyBaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i = 0; i < numDeletions; ++i) {
            int id = LegacyBaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        try (DirectoryReader reader = writer.getReader();){
            TestUtil.checkReader((IndexReader)reader);
            this.compareStoredFieldWithSortedSetDV(reader, "stored", "dv");
        }
        writer.forceMerge(1);
        reader = writer.getReader();
        try {
            TestUtil.checkReader((IndexReader)reader);
            this.compareStoredFieldWithSortedSetDV(reader, "stored", "dv");
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        IOUtils.close((Closeable[])new Closeable[]{writer, dir});
    }

    public void testSortedSetFixedLengthVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            int fixedLength = TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), 1, 10);
            this.doTestSortedSetVsStoredFields(LegacyBaseDocValuesFormatTestCase.atLeast(300), fixedLength, fixedLength, 16, 100);
        }
    }

    public void testSortedNumericsSingleValuedVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedNumericsVsStoredFields(() -> 1L, LegacyBaseDocValuesFormatTestCase.random()::nextLong);
        }
    }

    public void testSortedNumericsSingleValuedMissingVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedNumericsVsStoredFields(() -> LegacyBaseDocValuesFormatTestCase.random().nextBoolean() ? 0L : 1L, LegacyBaseDocValuesFormatTestCase.random()::nextLong);
        }
    }

    public void testSortedNumericsMultipleValuesVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedNumericsVsStoredFields(() -> TestUtil.nextLong(LegacyBaseDocValuesFormatTestCase.random(), 0L, 50L), LegacyBaseDocValuesFormatTestCase.random()::nextLong);
        }
    }

    public void testSortedNumericsFewUniqueSetsVsStoredFields() throws Exception {
        long[] values = new long[TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), 2, 6)];
        for (int i = 0; i < values.length; ++i) {
            values[i] = LegacyBaseDocValuesFormatTestCase.random().nextLong();
        }
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedNumericsVsStoredFields(() -> TestUtil.nextLong(LegacyBaseDocValuesFormatTestCase.random(), 0L, 6L), () -> values[LegacyBaseDocValuesFormatTestCase.random().nextInt(values.length)]);
        }
    }

    public void testSortedSetVariableLengthVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedSetVsStoredFields(LegacyBaseDocValuesFormatTestCase.atLeast(300), 1, 10, 16, 100);
        }
    }

    public void testSortedSetFixedLengthSingleValuedVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            int fixedLength = TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), 1, 10);
            this.doTestSortedSetVsStoredFields(LegacyBaseDocValuesFormatTestCase.atLeast(300), fixedLength, fixedLength, 1, 100);
        }
    }

    public void testSortedSetVariableLengthSingleValuedVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedSetVsStoredFields(LegacyBaseDocValuesFormatTestCase.atLeast(300), 1, 10, 1, 100);
        }
    }

    public void testSortedSetFixedLengthFewUniqueSetsVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedSetVsStoredFields(LegacyBaseDocValuesFormatTestCase.atLeast(300), 10, 10, 6, 6);
        }
    }

    public void testSortedSetVariableLengthFewUniqueSetsVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedSetVsStoredFields(LegacyBaseDocValuesFormatTestCase.atLeast(300), 1, 10, 6, 6);
        }
    }

    public void testSortedSetVariableLengthManyValuesPerDocVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedSetVsStoredFields(LegacyBaseDocValuesFormatTestCase.atLeast(20), 1, 10, 500, 1000);
        }
    }

    public void testSortedSetFixedLengthManyValuesPerDocVsStoredFields() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedSetVsStoredFields(LegacyBaseDocValuesFormatTestCase.atLeast(20), 10, 10, 500, 1000);
        }
    }

    public void testGCDCompression() throws Exception {
        this.doTestGCDCompression(1.0);
    }

    public void testSparseGCDCompression() throws Exception {
        this.doTestGCDCompression(LegacyBaseDocValuesFormatTestCase.random().nextDouble());
    }

    private void doTestGCDCompression(double density) throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            long min = -((long)LegacyBaseDocValuesFormatTestCase.random().nextInt(0x40000000) << 32);
            long mul = (long)LegacyBaseDocValuesFormatTestCase.random().nextInt() & 0xFFFFFFFFL;
            LongSupplier longs = () -> min + mul * (long)LegacyBaseDocValuesFormatTestCase.random().nextInt(0x100000);
            this.doTestNumericsVsStoredFields(density, longs);
        }
    }

    public void testZeros() throws Exception {
        this.doTestNumericsVsStoredFields(1.0, () -> 0L);
    }

    public void testSparseZeros() throws Exception {
        this.doTestNumericsVsStoredFields(LegacyBaseDocValuesFormatTestCase.random().nextDouble(), () -> 0L);
    }

    public void testZeroOrMin() throws Exception {
        int numIterations = LegacyBaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            LongSupplier longs = () -> LegacyBaseDocValuesFormatTestCase.random().nextBoolean() ? 0L : Long.MIN_VALUE;
            this.doTestNumericsVsStoredFields(1.0, longs);
        }
    }

    public void testTwoNumbersOneMissing() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(null);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iw = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv1", 0L));
        iw.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.YES));
        iw.addDocument(doc);
        iw.forceMerge(1);
        iw.close();
        DirectoryReader ir = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)ir.leaves().size());
        LeafReader ar = ((LeafReaderContext)ir.leaves().get(0)).reader();
        NumericDocValues dv = ar.getNumericDocValues("dv1");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.longValue());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ir.close();
        directory.close();
    }

    public void testTwoNumbersOneMissingWithMerging() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(null);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iw = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv1", 0L));
        iw.addDocument(doc);
        iw.commit();
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.YES));
        iw.addDocument(doc);
        iw.forceMerge(1);
        iw.close();
        DirectoryReader ir = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)ir.leaves().size());
        LeafReader ar = ((LeafReaderContext)ir.leaves().get(0)).reader();
        NumericDocValues dv = ar.getNumericDocValues("dv1");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.longValue());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ir.close();
        directory.close();
    }

    public void testThreeNumbersOneMissingWithMerging() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(null);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iw = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv1", 0L));
        iw.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.YES));
        iw.addDocument(doc);
        iw.commit();
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "2", Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv1", 5L));
        iw.addDocument(doc);
        iw.forceMerge(1);
        iw.close();
        DirectoryReader ir = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)ir.leaves().size());
        LeafReader ar = ((LeafReaderContext)ir.leaves().get(0)).reader();
        NumericDocValues dv = ar.getNumericDocValues("dv1");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.longValue());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv.longValue());
        ir.close();
        directory.close();
    }

    public void testTwoBytesOneMissing() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(null);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iw = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv1", LegacyBaseDocValuesFormatTestCase.newBytesRef()));
        iw.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.YES));
        iw.addDocument(doc);
        iw.forceMerge(1);
        iw.close();
        DirectoryReader ir = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)ir.leaves().size());
        LeafReader ar = ((LeafReaderContext)ir.leaves().get(0)).reader();
        BinaryDocValues dv = ar.getBinaryDocValues("dv1");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef(), (Object)dv.binaryValue());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ir.close();
        directory.close();
    }

    public void testTwoBytesOneMissingWithMerging() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(null);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iw = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv1", LegacyBaseDocValuesFormatTestCase.newBytesRef()));
        iw.addDocument(doc);
        iw.commit();
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.YES));
        iw.addDocument(doc);
        iw.forceMerge(1);
        iw.close();
        DirectoryReader ir = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)ir.leaves().size());
        LeafReader ar = ((LeafReaderContext)ir.leaves().get(0)).reader();
        BinaryDocValues dv = ar.getBinaryDocValues("dv1");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef(), (Object)dv.binaryValue());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ir.close();
        directory.close();
    }

    public void testThreeBytesOneMissingWithMerging() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(null);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iw = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv1", LegacyBaseDocValuesFormatTestCase.newBytesRef()));
        iw.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.YES));
        iw.addDocument(doc);
        iw.commit();
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "2", Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv1", LegacyBaseDocValuesFormatTestCase.newBytesRef("boo")));
        iw.addDocument(doc);
        iw.forceMerge(1);
        iw.close();
        DirectoryReader ir = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)ir.leaves().size());
        LeafReader ar = ((LeafReaderContext)ir.leaves().get(0)).reader();
        BinaryDocValues dv = ar.getBinaryDocValues("dv1");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef(), (Object)dv.binaryValue());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)LegacyBaseDocValuesFormatTestCase.newBytesRef("boo"), (Object)dv.binaryValue());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ir.close();
        directory.close();
    }

    public void testThreads() throws Exception {
        BaseDirectoryWrapper dir = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        Document doc = new Document();
        StringField idField = new StringField("id", "", Field.Store.NO);
        StoredField storedBinField = new StoredField("storedBin", new byte[0]);
        BinaryDocValuesField dvBinField = new BinaryDocValuesField("dvBin", LegacyBaseDocValuesFormatTestCase.newBytesRef());
        SortedDocValuesField dvSortedField = new SortedDocValuesField("dvSorted", LegacyBaseDocValuesFormatTestCase.newBytesRef());
        StoredField storedNumericField = new StoredField("storedNum", "");
        NumericDocValuesField dvNumericField = new NumericDocValuesField("dvNum", 0L);
        doc.add((IndexableField)idField);
        doc.add((IndexableField)storedBinField);
        doc.add((IndexableField)dvBinField);
        doc.add((IndexableField)dvSortedField);
        doc.add((IndexableField)storedNumericField);
        doc.add((IndexableField)dvNumericField);
        int numDocs = LegacyBaseDocValuesFormatTestCase.atLeast(300);
        for (int i = 0; i < numDocs; ++i) {
            idField.setStringValue(Integer.toString(i));
            int length = TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), 0, 8);
            byte[] buffer = new byte[length];
            LegacyBaseDocValuesFormatTestCase.random().nextBytes(buffer);
            storedBinField.setBytesValue(buffer);
            dvBinField.setBytesValue(buffer);
            dvSortedField.setBytesValue(buffer);
            long numericValue = LegacyBaseDocValuesFormatTestCase.random().nextLong();
            storedNumericField.setStringValue(Long.toString(numericValue));
            dvNumericField.setLongValue(numericValue);
            writer.addDocument(doc);
            if (LegacyBaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = LegacyBaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i = 0; i < numDeletions; ++i) {
            int id = LegacyBaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        writer.close();
        final DirectoryReader ir = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)dir));
        int numThreads = TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), 2, 7);
        Thread[] threads = new Thread[numThreads];
        final CountDownLatch startingGun = new CountDownLatch(1);
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(this){

                @Override
                public void run() {
                    try {
                        startingGun.await();
                        for (LeafReaderContext context : ir.leaves()) {
                            LeafReader r = context.reader();
                            StoredFields storedFields = r.storedFields();
                            BinaryDocValues binaries = r.getBinaryDocValues("dvBin");
                            SortedDocValues sorted = r.getSortedDocValues("dvSorted");
                            NumericDocValues numerics = r.getNumericDocValues("dvNum");
                            for (int j = 0; j < r.maxDoc(); ++j) {
                                BytesRef binaryValue = storedFields.document(j).getBinaryValue("storedBin");
                                Assert.assertEquals((long)j, (long)binaries.nextDoc());
                                BytesRef scratch = binaries.binaryValue();
                                Assert.assertEquals((Object)binaryValue, (Object)scratch);
                                Assert.assertEquals((long)j, (long)sorted.nextDoc());
                                scratch = sorted.lookupOrd(sorted.ordValue());
                                Assert.assertEquals((Object)binaryValue, (Object)scratch);
                                String expected = storedFields.document(j).get("storedNum");
                                Assert.assertEquals((long)j, (long)numerics.nextDoc());
                                Assert.assertEquals((long)Long.parseLong(expected), (long)numerics.longValue());
                            }
                        }
                        TestUtil.checkReader((IndexReader)ir);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            threads[i].start();
        }
        startingGun.countDown();
        for (Thread t : threads) {
            t.join();
        }
        ir.close();
        dir.close();
    }

    @LuceneTestCase.Nightly
    public void testThreads2() throws Exception {
        BaseDirectoryWrapper dir = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        StringField idField = new StringField("id", "", Field.Store.NO);
        StoredField storedBinField = new StoredField("storedBin", new byte[0]);
        BinaryDocValuesField dvBinField = new BinaryDocValuesField("dvBin", LegacyBaseDocValuesFormatTestCase.newBytesRef());
        SortedDocValuesField dvSortedField = new SortedDocValuesField("dvSorted", LegacyBaseDocValuesFormatTestCase.newBytesRef());
        StoredField storedNumericField = new StoredField("storedNum", "");
        NumericDocValuesField dvNumericField = new NumericDocValuesField("dvNum", 0L);
        int numDocs = TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), 1025, 2047);
        for (int i = 0; i < numDocs; ++i) {
            idField.setStringValue(Integer.toString(i));
            int length = TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), 0, 8);
            byte[] buffer = new byte[length];
            LegacyBaseDocValuesFormatTestCase.random().nextBytes(buffer);
            storedBinField.setBytesValue(buffer);
            dvBinField.setBytesValue(buffer);
            dvSortedField.setBytesValue(buffer);
            long numericValue = LegacyBaseDocValuesFormatTestCase.random().nextLong();
            storedNumericField.setStringValue(Long.toString(numericValue));
            dvNumericField.setLongValue(numericValue);
            Document doc = new Document();
            doc.add((IndexableField)idField);
            if (LegacyBaseDocValuesFormatTestCase.random().nextInt(4) > 0) {
                doc.add((IndexableField)storedBinField);
                doc.add((IndexableField)dvBinField);
                doc.add((IndexableField)dvSortedField);
            }
            if (LegacyBaseDocValuesFormatTestCase.random().nextInt(4) > 0) {
                doc.add((IndexableField)storedNumericField);
                doc.add((IndexableField)dvNumericField);
            }
            int numSortedSetFields = LegacyBaseDocValuesFormatTestCase.random().nextInt(3);
            TreeSet<String> values = new TreeSet<String>();
            for (int j = 0; j < numSortedSetFields; ++j) {
                values.add(TestUtil.randomSimpleString(LegacyBaseDocValuesFormatTestCase.random()));
            }
            for (String v : values) {
                doc.add((IndexableField)new SortedSetDocValuesField("dvSortedSet", LegacyBaseDocValuesFormatTestCase.newBytesRef(v)));
                doc.add((IndexableField)new StoredField("storedSortedSet", v));
            }
            int numSortedNumericFields = LegacyBaseDocValuesFormatTestCase.random().nextInt(3);
            TreeSet<Long> numValues = new TreeSet<Long>();
            for (int j = 0; j < numSortedNumericFields; ++j) {
                numValues.add(TestUtil.nextLong(LegacyBaseDocValuesFormatTestCase.random(), Long.MIN_VALUE, Long.MAX_VALUE));
            }
            for (Long l : numValues) {
                doc.add((IndexableField)new SortedNumericDocValuesField("dvSortedNumeric", l.longValue()));
                doc.add((IndexableField)new StoredField("storedSortedNumeric", Long.toString(l)));
            }
            writer.addDocument(doc);
            if (LegacyBaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = LegacyBaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i = 0; i < numDeletions; ++i) {
            int id = LegacyBaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        writer.close();
        final DirectoryReader ir = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)dir));
        int numThreads = TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), 2, 7);
        Thread[] threads = new Thread[numThreads];
        final CountDownLatch startingGun = new CountDownLatch(1);
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(this){

                @Override
                public void run() {
                    try {
                        startingGun.await();
                        for (LeafReaderContext context : ir.leaves()) {
                            LeafReader r = context.reader();
                            StoredFields storedFields = r.storedFields();
                            BinaryDocValues binaries = r.getBinaryDocValues("dvBin");
                            SortedDocValues sorted = r.getSortedDocValues("dvSorted");
                            NumericDocValues numerics = r.getNumericDocValues("dvNum");
                            SortedSetDocValues sortedSet = r.getSortedSetDocValues("dvSortedSet");
                            SortedNumericDocValues sortedNumeric = r.getSortedNumericDocValues("dvSortedNumeric");
                            for (int j = 0; j < r.maxDoc(); ++j) {
                                String[] numValues;
                                String[] values;
                                String number;
                                BytesRef binaryValue = storedFields.document(j).getBinaryValue("storedBin");
                                if (binaryValue != null && binaries != null) {
                                    Assert.assertEquals((long)j, (long)binaries.nextDoc());
                                    BytesRef scratch = binaries.binaryValue();
                                    Assert.assertEquals((Object)binaryValue, (Object)scratch);
                                    Assert.assertEquals((long)j, (long)sorted.nextDoc());
                                    scratch = sorted.lookupOrd(sorted.ordValue());
                                    Assert.assertEquals((Object)binaryValue, (Object)scratch);
                                }
                                if ((number = storedFields.document(j).get("storedNum")) != null && numerics != null) {
                                    Assert.assertEquals((long)j, (long)numerics.advance(j));
                                    Assert.assertEquals((long)Long.parseLong(number), (long)numerics.longValue());
                                }
                                if ((values = storedFields.document(j).getValues("storedSortedSet")).length > 0) {
                                    Assert.assertNotNull((Object)sortedSet);
                                    Assert.assertEquals((long)j, (long)sortedSet.nextDoc());
                                    Assert.assertEquals((long)values.length, (long)sortedSet.docValueCount());
                                    for (String s : values) {
                                        long ord = sortedSet.nextOrd();
                                        BytesRef value = sortedSet.lookupOrd(ord);
                                        Assert.assertEquals((Object)s, (Object)value.utf8ToString());
                                    }
                                }
                                if ((numValues = storedFields.document(j).getValues("storedSortedNumeric")).length <= 0) continue;
                                Assert.assertNotNull((Object)sortedNumeric);
                                Assert.assertEquals((long)j, (long)sortedNumeric.nextDoc());
                                Assert.assertEquals((long)numValues.length, (long)sortedNumeric.docValueCount());
                                for (String numValue : numValues) {
                                    long v = sortedNumeric.nextValue();
                                    Assert.assertEquals((Object)numValue, (Object)Long.toString(v));
                                }
                            }
                        }
                        TestUtil.checkReader((IndexReader)ir);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            threads[i].start();
        }
        startingGun.countDown();
        for (Thread t : threads) {
            t.join();
        }
        ir.close();
        dir.close();
    }

    @LuceneTestCase.Nightly
    public void testThreads3() throws Exception {
        int i;
        BaseDirectoryWrapper dir = LegacyBaseDocValuesFormatTestCase.newFSDirectory(LegacyBaseDocValuesFormatTestCase.createTempDir());
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        int numSortedSets = LegacyBaseDocValuesFormatTestCase.random().nextInt(21);
        int numBinaries = LegacyBaseDocValuesFormatTestCase.random().nextInt(21);
        int numSortedNums = LegacyBaseDocValuesFormatTestCase.random().nextInt(21);
        int numDocs = TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), 2025, 2047);
        for (i = 0; i < numDocs; ++i) {
            int j;
            Document doc = new Document();
            for (j = 0; j < numSortedSets; ++j) {
                doc.add((IndexableField)new SortedSetDocValuesField("ss" + j, LegacyBaseDocValuesFormatTestCase.newBytesRef(TestUtil.randomSimpleString(LegacyBaseDocValuesFormatTestCase.random()))));
                doc.add((IndexableField)new SortedSetDocValuesField("ss" + j, LegacyBaseDocValuesFormatTestCase.newBytesRef(TestUtil.randomSimpleString(LegacyBaseDocValuesFormatTestCase.random()))));
            }
            for (j = 0; j < numBinaries; ++j) {
                doc.add((IndexableField)new BinaryDocValuesField("b" + j, LegacyBaseDocValuesFormatTestCase.newBytesRef(TestUtil.randomSimpleString(LegacyBaseDocValuesFormatTestCase.random()))));
            }
            for (j = 0; j < numSortedNums; ++j) {
                doc.add((IndexableField)new SortedNumericDocValuesField("sn" + j, TestUtil.nextLong(LegacyBaseDocValuesFormatTestCase.random(), Long.MIN_VALUE, Long.MAX_VALUE)));
                doc.add((IndexableField)new SortedNumericDocValuesField("sn" + j, TestUtil.nextLong(LegacyBaseDocValuesFormatTestCase.random(), Long.MIN_VALUE, Long.MAX_VALUE)));
            }
            writer.addDocument(doc);
        }
        writer.close();
        for (i = 0; i < 10; ++i) {
            final DirectoryReader r = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)dir));
            final CountDownLatch startingGun = new CountDownLatch(1);
            Thread[] threads = new Thread[TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), 4, 10)];
            for (int tid = 0; tid < threads.length; ++tid) {
                threads[tid] = new Thread(this){

                    @Override
                    public void run() {
                        try {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
                            PrintStream infoStream = new PrintStream((OutputStream)bos, false, StandardCharsets.UTF_8);
                            startingGun.await();
                            for (LeafReaderContext leaf : r.leaves()) {
                                CheckIndex.Status.DocValuesStatus status = CheckIndex.testDocValues((CodecReader)((CodecReader)leaf.reader()), (PrintStream)infoStream, (boolean)true);
                                if (status.error == null) continue;
                                throw status.error;
                            }
                        }
                        catch (Throwable e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
            for (Thread thread : threads) {
                thread.start();
            }
            startingGun.countDown();
            for (Thread thread : threads) {
                thread.join();
            }
            r.close();
        }
        dir.close();
    }

    @LuceneTestCase.Nightly
    public void testEmptyBinaryValueOnPageSizes() throws Exception {
        for (int i = 0; i < 20 && (i <= 14 || this.codecAcceptsHugeBinaryValues("field")); ++i) {
            BaseDirectoryWrapper dir = LegacyBaseDocValuesFormatTestCase.newDirectory();
            RandomIndexWriter w = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)dir);
            BytesRef bytes = LegacyBaseDocValuesFormatTestCase.newBytesRef(new byte[1 << i], 0, 1 << i);
            for (int j = 0; j < 4; ++j) {
                Document doc = new Document();
                doc.add((IndexableField)new BinaryDocValuesField("field", bytes));
                w.addDocument(doc);
            }
            Document doc = new Document();
            doc.add((IndexableField)new StoredField("id", "5"));
            doc.add((IndexableField)new BinaryDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef()));
            w.addDocument(doc);
            DirectoryReader r = w.getReader();
            w.close();
            BinaryDocValues values = MultiDocValues.getBinaryValues((IndexReader)r, (String)"field");
            for (int j = 0; j < 5; ++j) {
                LegacyBaseDocValuesFormatTestCase.assertEquals((long)j, (long)values.nextDoc());
                BytesRef result = values.binaryValue();
                LegacyBaseDocValuesFormatTestCase.assertTrue((result.length == 0 || result.length == 1 << i ? 1 : 0) != 0);
            }
            r.close();
            dir.close();
        }
    }

    public void testOneSortedNumber() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", 5L));
        writer.addDocument(doc);
        writer.close();
        DirectoryReader reader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (reader.leaves().size() == 1);
        SortedNumericDocValues dv = ((LeafReaderContext)reader.leaves().get(0)).reader().getSortedNumericDocValues("dv");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.docValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv.nextValue());
        reader.close();
        directory.close();
    }

    public void testOneSortedNumberOneMissing() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriter writer = new IndexWriter((Directory)directory, new IndexWriterConfig(null));
        Document doc = new Document();
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", 5L));
        writer.addDocument((Iterable)doc);
        writer.addDocument((Iterable)new Document());
        writer.close();
        DirectoryReader reader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (reader.leaves().size() == 1);
        SortedNumericDocValues dv = ((LeafReaderContext)reader.leaves().get(0)).reader().getSortedNumericDocValues("dv");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.docValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv.nextValue());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        reader.close();
        directory.close();
    }

    public void testNumberMergeAwayAllValues() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new NumericDocValuesField("field", 5L));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        NumericDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getNumericDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ireader.close();
        directory.close();
    }

    public void testTwoSortedNumber() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", 11L));
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", -5L));
        writer.addDocument(doc);
        writer.close();
        DirectoryReader reader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (reader.leaves().size() == 1);
        SortedNumericDocValues dv = ((LeafReaderContext)reader.leaves().get(0)).reader().getSortedNumericDocValues("dv");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.docValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)-5L, (long)dv.nextValue());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)11L, (long)dv.nextValue());
        reader.close();
        directory.close();
    }

    public void testTwoSortedNumberSameValue() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", 11L));
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", 11L));
        writer.addDocument(doc);
        writer.close();
        DirectoryReader reader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (reader.leaves().size() == 1);
        SortedNumericDocValues dv = ((LeafReaderContext)reader.leaves().get(0)).reader().getSortedNumericDocValues("dv");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.docValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)11L, (long)dv.nextValue());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)11L, (long)dv.nextValue());
        reader.close();
        directory.close();
    }

    public void testTwoSortedNumberOneMissing() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriter writer = new IndexWriter((Directory)directory, new IndexWriterConfig(null));
        Document doc = new Document();
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", 11L));
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", -5L));
        writer.addDocument((Iterable)doc);
        writer.addDocument((Iterable)new Document());
        writer.close();
        DirectoryReader reader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (reader.leaves().size() == 1);
        SortedNumericDocValues dv = ((LeafReaderContext)reader.leaves().get(0)).reader().getSortedNumericDocValues("dv");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.docValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)-5L, (long)dv.nextValue());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)11L, (long)dv.nextValue());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        reader.close();
        directory.close();
    }

    public void testSortedNumberMerge() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(null);
        iwc.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        IndexWriter writer = new IndexWriter((Directory)directory, iwc);
        Document doc = new Document();
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", 11L));
        writer.addDocument((Iterable)doc);
        writer.commit();
        doc = new Document();
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", -5L));
        writer.addDocument((Iterable)doc);
        writer.forceMerge(1);
        writer.close();
        DirectoryReader reader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)directory));
        assert (reader.leaves().size() == 1);
        SortedNumericDocValues dv = ((LeafReaderContext)reader.leaves().get(0)).reader().getSortedNumericDocValues("dv");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.docValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)11L, (long)dv.nextValue());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.docValueCount());
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)-5L, (long)dv.nextValue());
        reader.close();
        directory.close();
    }

    public void testSortedNumberMergeAwayAllValues() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new SortedNumericDocValuesField("field", 5L));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedNumericDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedNumericDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ireader.close();
        directory.close();
    }

    public void testSortedEnumAdvanceIndependently() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        SortedDocValuesField field = new SortedDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("2"));
        doc.add((IndexableField)field);
        iwriter.addDocument(doc);
        field.setBytesValue(LegacyBaseDocValuesFormatTestCase.newBytesRef("1"));
        iwriter.addDocument(doc);
        field.setBytesValue(LegacyBaseDocValuesFormatTestCase.newBytesRef("3"));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedDocValues("field");
        this.doTestSortedSetEnumAdvanceIndependently(DocValues.singleton((SortedDocValues)dv));
        ireader.close();
        directory.close();
    }

    public void testSortedSetEnumAdvanceIndependently() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        SortedSetDocValuesField field1 = new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("2"));
        SortedSetDocValuesField field2 = new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("3"));
        doc.add((IndexableField)field1);
        doc.add((IndexableField)field2);
        iwriter.addDocument(doc);
        field1.setBytesValue(LegacyBaseDocValuesFormatTestCase.newBytesRef("1"));
        iwriter.addDocument(doc);
        field2.setBytesValue(LegacyBaseDocValuesFormatTestCase.newBytesRef("2"));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        this.doTestSortedSetEnumAdvanceIndependently(dv);
        ireader.close();
        directory.close();
    }

    protected void doTestSortedSetEnumAdvanceIndependently(SortedSetDocValues dv) throws IOException {
        if (dv.getValueCount() < 2L) {
            return;
        }
        ArrayList<BytesRef> terms = new ArrayList<BytesRef>();
        TermsEnum te = dv.termsEnum();
        terms.add(BytesRef.deepCopyOf((BytesRef)te.next()));
        terms.add(BytesRef.deepCopyOf((BytesRef)te.next()));
        TermsEnum enum1 = dv.termsEnum();
        TermsEnum enum2 = dv.termsEnum();
        BytesRefBuilder term1 = new BytesRefBuilder();
        BytesRefBuilder term2 = new BytesRefBuilder();
        term1.copyBytes(enum1.next());
        term2.copyBytes(enum2.next());
        term1.copyBytes(enum1.next());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)term1.get(), (Object)enum1.term());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)term2.get(), (Object)enum2.term());
        enum1 = dv.termsEnum();
        enum2 = dv.termsEnum();
        term1 = new BytesRefBuilder();
        term2 = new BytesRefBuilder();
        term2.copyBytes(enum2.next());
        BytesRefBuilder seekTerm = new BytesRefBuilder();
        seekTerm.append((BytesRef)terms.get(0));
        seekTerm.append((byte)0);
        enum1.seekCeil(seekTerm.get());
        term1.copyBytes(enum1.term());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)term1.get(), (Object)enum1.term());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)term2.get(), (Object)enum2.term());
        enum1 = dv.termsEnum();
        enum2 = dv.termsEnum();
        term1 = new BytesRefBuilder();
        term2 = new BytesRefBuilder();
        term2.copyBytes(enum2.next());
        enum1.seekCeil((BytesRef)terms.get(1));
        term1.copyBytes(enum1.term());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)term1.get(), (Object)enum1.term());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)term2.get(), (Object)enum2.term());
        enum1 = dv.termsEnum();
        enum2 = dv.termsEnum();
        term1 = new BytesRefBuilder();
        term2 = new BytesRefBuilder();
        term2.copyBytes(enum2.next());
        boolean found = enum1.seekExact((BytesRef)terms.get(1));
        LegacyBaseDocValuesFormatTestCase.assertTrue((boolean)found);
        term1.copyBytes(enum1.term());
        enum1 = dv.termsEnum();
        enum2 = dv.termsEnum();
        term1 = new BytesRefBuilder();
        term2 = new BytesRefBuilder();
        term2.copyBytes(enum2.next());
        enum1.seekExact(1L);
        term1.copyBytes(enum1.term());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)term1.get(), (Object)enum1.term());
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)term2.get(), (Object)enum2.term());
    }

    public void testSortedMergeAwayAllValuesLargeSegment() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new SortedDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello")));
        iwriter.addDocument(doc);
        int numEmptyDocs = LegacyBaseDocValuesFormatTestCase.atLeast(1024);
        for (int i = 0; i < numEmptyDocs; ++i) {
            iwriter.addDocument(new Document());
        }
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        TermsEnum termsEnum = dv.termsEnum();
        LegacyBaseDocValuesFormatTestCase.assertFalse((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"lucene")));
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.END, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"lucene")));
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.lookupTerm(new BytesRef((CharSequence)"lucene")));
        ireader.close();
        directory.close();
    }

    public void testSortedSetMergeAwayAllValuesLargeSegment() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new SortedSetDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello")));
        iwriter.addDocument(doc);
        int numEmptyDocs = LegacyBaseDocValuesFormatTestCase.atLeast(1024);
        for (int i = 0; i < numEmptyDocs; ++i) {
            iwriter.addDocument(new Document());
        }
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        TermsEnum termsEnum = dv.termsEnum();
        LegacyBaseDocValuesFormatTestCase.assertFalse((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"lucene")));
        LegacyBaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.END, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"lucene")));
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.lookupTerm(new BytesRef((CharSequence)"lucene")));
        ireader.close();
        directory.close();
    }

    public void testNumericMergeAwayAllValuesLargeSegment() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new NumericDocValuesField("field", 42L));
        iwriter.addDocument(doc);
        int numEmptyDocs = LegacyBaseDocValuesFormatTestCase.atLeast(1024);
        for (int i = 0; i < numEmptyDocs; ++i) {
            iwriter.addDocument(new Document());
        }
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        NumericDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getNumericDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ireader.close();
        directory.close();
    }

    public void testSortedNumericMergeAwayAllValuesLargeSegment() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new SortedNumericDocValuesField("field", 42L));
        iwriter.addDocument(doc);
        int numEmptyDocs = LegacyBaseDocValuesFormatTestCase.atLeast(1024);
        for (int i = 0; i < numEmptyDocs; ++i) {
            iwriter.addDocument(new Document());
        }
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedNumericDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedNumericDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ireader.close();
        directory.close();
    }

    public void testBinaryMergeAwayAllValuesLargeSegment() throws IOException {
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new BinaryDocValuesField("field", LegacyBaseDocValuesFormatTestCase.newBytesRef("hello")));
        iwriter.addDocument(doc);
        int numEmptyDocs = LegacyBaseDocValuesFormatTestCase.atLeast(1024);
        for (int i = 0; i < numEmptyDocs; ++i) {
            iwriter.addDocument(new Document());
        }
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        BinaryDocValues dv = LegacyBaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getBinaryDocValues("field");
        LegacyBaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ireader.close();
        directory.close();
    }

    public void testRandomAdvanceNumeric() throws IOException {
        final long longRange = LegacyBaseDocValuesFormatTestCase.random().nextBoolean() ? (long)TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), 1, 1024) : TestUtil.nextLong(LegacyBaseDocValuesFormatTestCase.random(), 1L, Long.MAX_VALUE);
        this.doTestRandomAdvance(new FieldCreator(){

            @Override
            public Field next() {
                return new NumericDocValuesField("field", TestUtil.nextLong(LuceneTestCase.random(), 0L, longRange));
            }

            @Override
            public DocIdSetIterator iterator(IndexReader r) throws IOException {
                return MultiDocValues.getNumericValues((IndexReader)r, (String)"field");
            }
        });
    }

    public void testRandomAdvanceBinary() throws IOException {
        this.doTestRandomAdvance(new FieldCreator(this){

            @Override
            public Field next() {
                byte[] bytes = new byte[LuceneTestCase.random().nextInt(10)];
                LuceneTestCase.random().nextBytes(bytes);
                return new BinaryDocValuesField("field", LuceneTestCase.newBytesRef(bytes));
            }

            @Override
            public DocIdSetIterator iterator(IndexReader r) throws IOException {
                return MultiDocValues.getBinaryValues((IndexReader)r, (String)"field");
            }
        });
    }

    @LuceneTestCase.Nightly
    public void testHighOrdsSortedSetDV() throws Exception {
        LegacyBaseDocValuesFormatTestCase.assumeFalse("This test with SimpleTextCodec requires a lot of memory", this.getCodec() instanceof SimpleTextCodec);
        BaseDirectoryWrapper dir = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig();
        iwc.setRAMBufferSizeMB((double)(8 + LegacyBaseDocValuesFormatTestCase.random().nextInt(64)));
        IndexWriter writer = new IndexWriter((Directory)dir, iwc);
        int numDocs = 20000 + LegacyBaseDocValuesFormatTestCase.random().nextInt(10000);
        for (int i = 1; i < numDocs; ++i) {
            int numOrds = LegacyBaseDocValuesFormatTestCase.random().nextInt(100) <= 5 ? 1000 + LegacyBaseDocValuesFormatTestCase.random().nextInt(500) : LegacyBaseDocValuesFormatTestCase.random().nextInt(10);
            Document doc = new Document();
            for (int ord = 0; ord < numOrds; ++ord) {
                doc.add((IndexableField)new SortedSetDocValuesField("sorted_set_dv", TestUtil.randomBinaryTerm(LegacyBaseDocValuesFormatTestCase.random(), 2)));
            }
            writer.addDocument((Iterable)doc);
        }
        writer.forceMerge(1, true);
        try (DirectoryReader reader = DirectoryReader.open((IndexWriter)writer);){
            TestUtil.checkReader((IndexReader)reader);
        }
        IOUtils.close((Closeable[])new Closeable[]{writer, dir});
    }

    private void doTestRandomAdvance(FieldCreator fieldCreator) throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(LegacyBaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = LegacyBaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = LegacyBaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)LegacyBaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter w = new RandomIndexWriter(LegacyBaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        int numChunks = LegacyBaseDocValuesFormatTestCase.atLeast(10);
        int id = 0;
        HashSet<Integer> missingSet = new HashSet<Integer>();
        for (int i = 0; i < numChunks; ++i) {
            double sparseChance = LegacyBaseDocValuesFormatTestCase.random().nextDouble();
            int docCount = LegacyBaseDocValuesFormatTestCase.atLeast(1000);
            for (int j = 0; j < docCount; ++j) {
                Document doc = new Document();
                doc.add((IndexableField)new StoredField("id", id));
                if (LegacyBaseDocValuesFormatTestCase.random().nextDouble() > sparseChance) {
                    doc.add((IndexableField)fieldCreator.next());
                } else {
                    missingSet.add(id);
                }
                ++id;
                w.addDocument(doc);
            }
        }
        if (LegacyBaseDocValuesFormatTestCase.random().nextBoolean()) {
            w.forceMerge(1);
        }
        DirectoryReader r = w.getReader();
        StoredFields storedFields = r.storedFields();
        FixedBitSet missing = new FixedBitSet(r.maxDoc());
        for (int docID = 0; docID < r.maxDoc(); ++docID) {
            Document doc = storedFields.document(docID);
            if (!missingSet.contains(doc.getField("id").numericValue())) continue;
            missing.set(docID);
        }
        int numIters = LegacyBaseDocValuesFormatTestCase.atLeast(10);
        block3: for (int iter = 0; iter < numIters; ++iter) {
            DocIdSetIterator values = fieldCreator.iterator((IndexReader)r);
            LegacyBaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)values.docID());
            while (true) {
                int docID;
                if (LegacyBaseDocValuesFormatTestCase.random().nextBoolean()) {
                    docID = values.nextDoc();
                } else {
                    int range = LegacyBaseDocValuesFormatTestCase.random().nextInt(10) == 7 ? r.maxDoc() - values.docID() : 25;
                    int inc = TestUtil.nextInt(LegacyBaseDocValuesFormatTestCase.random(), 1, range);
                    docID = values.advance(values.docID() + inc);
                }
                if (docID == Integer.MAX_VALUE) continue block3;
                LegacyBaseDocValuesFormatTestCase.assertFalse((boolean)missing.get(docID));
            }
        }
        IOUtils.close((Closeable[])new Closeable[]{r, w, directory});
    }

    protected boolean codecAcceptsHugeBinaryValues(String field) {
        return true;
    }

    private static interface FieldCreator {
        public Field next();

        public DocIdSetIterator iterator(IndexReader var1) throws IOException;
    }
}

