/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene99;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.backward_codecs.lucene99.OffHeapQuantizedByteVectorValues;
import org.apache.lucene.backward_codecs.lucene99.OffHeapQuantizedFloatVectorValues;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsReader;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.internal.hppc.IntObjectHashMap;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataAccessHint;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.FileDataHint;
import org.apache.lucene.store.FileTypeHint;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.quantization.QuantizedByteVectorValues;
import org.apache.lucene.util.quantization.QuantizedVectorsReader;
import org.apache.lucene.util.quantization.ScalarQuantizer;

public final class Lucene99ScalarQuantizedVectorsReader
extends FlatVectorsReader
implements QuantizedVectorsReader {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(Lucene99ScalarQuantizedVectorsReader.class);
    private final IntObjectHashMap<FieldEntry> fields = new IntObjectHashMap();
    private final IndexInput quantizedVectorData;
    private final FlatVectorsReader rawVectorsReader;
    private final FieldInfos fieldInfos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene99ScalarQuantizedVectorsReader(SegmentReadState state, FlatVectorsReader rawVectorsReader, FlatVectorsScorer scorer) throws IOException {
        super(scorer);
        this.rawVectorsReader = rawVectorsReader;
        this.fieldInfos = state.fieldInfos;
        int versionMeta = -1;
        String metaFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"vemq");
        boolean success = false;
        try {
            try (ChecksumIndexInput meta = state.directory.openChecksumInput(metaFileName);){
                Throwable priorE = null;
                try {
                    versionMeta = CodecUtil.checkIndexHeader((DataInput)meta, (String)"Lucene99ScalarQuantizedVectorsFormatMeta", (int)0, (int)1, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    this.readFields(meta, versionMeta, state.fieldInfos);
                }
                catch (Throwable exception) {
                    priorE = exception;
                }
                finally {
                    CodecUtil.checkFooter((ChecksumIndexInput)meta, (Throwable)priorE);
                }
                this.quantizedVectorData = Lucene99ScalarQuantizedVectorsReader.openDataInput(state, versionMeta, "veq", "Lucene99ScalarQuantizedVectorsFormatData", state.context.withHints(new IOContext.FileOpenHint[]{FileTypeHint.DATA, FileDataHint.KNN_VECTORS, DataAccessHint.RANDOM}));
                success = true;
            }
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
    }

    private void readFields(ChecksumIndexInput meta, int versionMeta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, (DataInput)meta);
            }
            FieldEntry fieldEntry = this.readField((IndexInput)meta, versionMeta, info);
            Lucene99ScalarQuantizedVectorsReader.validateFieldEntry(info, fieldEntry);
            this.fields.put(info.number, (Object)fieldEntry);
            fieldNumber = meta.readInt();
        }
    }

    static void validateFieldEntry(FieldInfo info, FieldEntry fieldEntry) {
        int dimension = info.getVectorDimension();
        if (dimension != fieldEntry.dimension) {
            throw new IllegalStateException("Inconsistent vector dimension for field=\"" + info.name + "\"; " + dimension + " != " + fieldEntry.dimension);
        }
        long quantizedVectorBytes = fieldEntry.bits <= 4 && fieldEntry.compress ? (long)((dimension + 1 >> 1) + 4) : (long)(dimension + 4);
        long numQuantizedVectorBytes = Math.multiplyExact(quantizedVectorBytes, fieldEntry.size);
        if (numQuantizedVectorBytes != fieldEntry.vectorDataLength) {
            throw new IllegalStateException("Quantized vector data length " + fieldEntry.vectorDataLength + " not matching size=" + fieldEntry.size + " * (dim=" + dimension + " + 4) = " + numQuantizedVectorBytes);
        }
    }

    public void checkIntegrity() throws IOException {
        this.rawVectorsReader.checkIntegrity();
        CodecUtil.checksumEntireFile((IndexInput)this.quantizedVectorData);
    }

    private FieldEntry getFieldEntry(String field) {
        FieldEntry fieldEntry;
        FieldInfo info = this.fieldInfos.fieldInfo(field);
        if (info == null || (fieldEntry = (FieldEntry)this.fields.get(info.number)) == null) {
            throw new IllegalArgumentException("field=\"" + field + "\" not found");
        }
        if (fieldEntry.vectorEncoding != VectorEncoding.FLOAT32) {
            throw new IllegalArgumentException("field=\"" + field + "\" is encoded as: " + String.valueOf(fieldEntry.vectorEncoding) + " expected: " + String.valueOf(VectorEncoding.FLOAT32));
        }
        return fieldEntry;
    }

    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        FieldEntry fieldEntry = this.getFieldEntry(field);
        FloatVectorValues rawVectorValues = this.rawVectorsReader.getFloatVectorValues(field);
        if (rawVectorValues.size() == 0) {
            return OffHeapQuantizedFloatVectorValues.load(fieldEntry.ordToDoc, fieldEntry.dimension, fieldEntry.size, fieldEntry.scalarQuantizer, fieldEntry.similarityFunction, this.vectorScorer, fieldEntry.compress, fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength, this.quantizedVectorData);
        }
        OffHeapQuantizedByteVectorValues quantizedByteVectorValues = OffHeapQuantizedByteVectorValues.load(fieldEntry.ordToDoc, fieldEntry.dimension, fieldEntry.size, fieldEntry.scalarQuantizer, fieldEntry.similarityFunction, this.vectorScorer, fieldEntry.compress, fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength, this.quantizedVectorData);
        return new QuantizedVectorValues(rawVectorValues, quantizedByteVectorValues);
    }

    public ByteVectorValues getByteVectorValues(String field) throws IOException {
        return this.rawVectorsReader.getByteVectorValues(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexInput openDataInput(SegmentReadState state, int versionMeta, String fileExtension, String codecName, IOContext context) throws IOException {
        IndexInput indexInput;
        block4: {
            String fileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)fileExtension);
            IndexInput in = state.directory.openInput(fileName, context);
            boolean success = false;
            try {
                int versionVectorData = CodecUtil.checkIndexHeader((DataInput)in, (String)codecName, (int)0, (int)1, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                if (versionMeta != versionVectorData) {
                    throw new CorruptIndexException("Format versions mismatch: meta=" + versionMeta + ", " + codecName + "=" + versionVectorData, (DataInput)in);
                }
                CodecUtil.retrieveChecksum((IndexInput)in);
                success = true;
                indexInput = in;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
        }
        return indexInput;
    }

    public RandomVectorScorer getRandomVectorScorer(String field, float[] target) throws IOException {
        FieldEntry fieldEntry = this.getFieldEntry(field);
        if (fieldEntry.scalarQuantizer == null) {
            return this.rawVectorsReader.getRandomVectorScorer(field, target);
        }
        OffHeapQuantizedByteVectorValues vectorValues = OffHeapQuantizedByteVectorValues.load(fieldEntry.ordToDoc, fieldEntry.dimension, fieldEntry.size, fieldEntry.scalarQuantizer, fieldEntry.similarityFunction, this.vectorScorer, fieldEntry.compress, fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength, this.quantizedVectorData);
        return this.vectorScorer.getRandomVectorScorer(fieldEntry.similarityFunction, (KnnVectorValues)vectorValues, target);
    }

    public RandomVectorScorer getRandomVectorScorer(String field, byte[] target) throws IOException {
        return this.rawVectorsReader.getRandomVectorScorer(field, target);
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.quantizedVectorData, this.rawVectorsReader});
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.fields.ramBytesUsed() + this.rawVectorsReader.ramBytesUsed();
    }

    public Map<String, Long> getOffHeapByteSize(FieldInfo fieldInfo) {
        Map raw = this.rawVectorsReader.getOffHeapByteSize(fieldInfo);
        FieldEntry fieldEntry = (FieldEntry)this.fields.get(fieldInfo.number);
        if (fieldEntry == null) {
            assert (fieldInfo.getVectorEncoding() == VectorEncoding.BYTE);
            return raw;
        }
        Map<String, Long> quant = Map.of("veq", fieldEntry.vectorDataLength());
        return KnnVectorsReader.mergeOffHeapByteSizeMaps((Map)raw, quant);
    }

    private FieldEntry readField(IndexInput input, int versionMeta, FieldInfo info) throws IOException {
        VectorEncoding vectorEncoding = Lucene99HnswVectorsReader.readVectorEncoding((DataInput)input);
        VectorSimilarityFunction similarityFunction = Lucene99HnswVectorsReader.readSimilarityFunction((DataInput)input);
        if (similarityFunction != info.getVectorSimilarityFunction()) {
            throw new IllegalStateException("Inconsistent vector similarity function for field=\"" + info.name + "\"; " + String.valueOf(similarityFunction) + " != " + String.valueOf(info.getVectorSimilarityFunction()));
        }
        return FieldEntry.create(input, versionMeta, vectorEncoding, info.getVectorSimilarityFunction());
    }

    public QuantizedByteVectorValues getQuantizedVectorValues(String field) throws IOException {
        FieldEntry fieldEntry = this.getFieldEntry(field);
        return OffHeapQuantizedByteVectorValues.load(fieldEntry.ordToDoc, fieldEntry.dimension, fieldEntry.size, fieldEntry.scalarQuantizer, fieldEntry.similarityFunction, this.vectorScorer, fieldEntry.compress, fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength, this.quantizedVectorData);
    }

    public ScalarQuantizer getQuantizationState(String field) {
        FieldEntry fieldEntry = this.getFieldEntry(field);
        return fieldEntry.scalarQuantizer;
    }

    private record FieldEntry(VectorSimilarityFunction similarityFunction, VectorEncoding vectorEncoding, int dimension, long vectorDataOffset, long vectorDataLength, ScalarQuantizer scalarQuantizer, int size, byte bits, boolean compress, OrdToDocDISIReaderConfiguration ordToDoc) {
        static FieldEntry create(IndexInput input, int versionMeta, VectorEncoding vectorEncoding, VectorSimilarityFunction similarityFunction) throws IOException {
            ScalarQuantizer scalarQuantizer;
            boolean compress;
            byte bits;
            long vectorDataOffset = input.readVLong();
            long vectorDataLength = input.readVLong();
            int dimension = input.readVInt();
            int size = input.readInt();
            if (size > 0) {
                if (versionMeta < 1) {
                    int floatBits = input.readInt();
                    if (floatBits == -1) {
                        throw new CorruptIndexException("Missing confidence interval for scalar quantizer", (DataInput)input);
                    }
                    float confidenceInterval = Float.intBitsToFloat(floatBits);
                    if (confidenceInterval == 0.0f) {
                        throw new CorruptIndexException("Invalid confidence interval for scalar quantizer: " + confidenceInterval, (DataInput)input);
                    }
                    bits = 7;
                    compress = false;
                    float minQuantile = Float.intBitsToFloat(input.readInt());
                    float maxQuantile = Float.intBitsToFloat(input.readInt());
                    scalarQuantizer = new ScalarQuantizer(minQuantile, maxQuantile, 7);
                } else {
                    input.readInt();
                    bits = input.readByte();
                    compress = input.readByte() == 1;
                    float minQuantile = Float.intBitsToFloat(input.readInt());
                    float maxQuantile = Float.intBitsToFloat(input.readInt());
                    scalarQuantizer = new ScalarQuantizer(minQuantile, maxQuantile, bits);
                }
            } else {
                scalarQuantizer = null;
                bits = 7;
                compress = false;
            }
            OrdToDocDISIReaderConfiguration ordToDoc = OrdToDocDISIReaderConfiguration.fromStoredMeta((IndexInput)input, (int)size);
            return new FieldEntry(similarityFunction, vectorEncoding, dimension, vectorDataOffset, vectorDataLength, scalarQuantizer, size, bits, compress, ordToDoc);
        }
    }

    private static final class QuantizedVectorValues
    extends FloatVectorValues {
        private final FloatVectorValues rawVectorValues;
        private final QuantizedByteVectorValues quantizedVectorValues;

        QuantizedVectorValues(FloatVectorValues rawVectorValues, QuantizedByteVectorValues quantizedVectorValues) {
            this.rawVectorValues = rawVectorValues;
            this.quantizedVectorValues = quantizedVectorValues;
        }

        public int dimension() {
            return this.rawVectorValues.dimension();
        }

        public int size() {
            return this.rawVectorValues.size();
        }

        public float[] vectorValue(int ord) throws IOException {
            return this.rawVectorValues.vectorValue(ord);
        }

        public int ordToDoc(int ord) {
            return this.rawVectorValues.ordToDoc(ord);
        }

        public QuantizedVectorValues copy() throws IOException {
            return new QuantizedVectorValues(this.rawVectorValues.copy(), this.quantizedVectorValues.copy());
        }

        public VectorScorer scorer(float[] query) throws IOException {
            return this.quantizedVectorValues.scorer(query);
        }

        public VectorScorer rescorer(float[] query) throws IOException {
            return this.rawVectorValues.rescorer(query);
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return this.rawVectorValues.iterator();
        }
    }
}

