/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.wrapper;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.faces.FacesWrapper;
import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.Validator;
import jakarta.faces.validator.ValidatorException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.cdi.wrapper.FacesValidatorAnnotationLiteral;

public class FacesValidatorCDIWrapper
implements PartialStateHolder,
Validator,
FacesWrapper<Validator> {
    private static final Type VALIDATOR_TYPE = new TypeLiteral<Validator<?>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private transient Validator delegate;
    private String validatorId;
    private boolean _transient;
    private boolean _initialStateMarked = false;

    public FacesValidatorCDIWrapper() {
    }

    public FacesValidatorCDIWrapper(Class<? extends Validator> validatorClass, String validatorId) {
        this.validatorId = validatorId;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        this.getWrapped().validate(context, component, value);
    }

    public Validator getWrapped() {
        if (this.delegate == null) {
            BeanManager bm = CDIUtils.getBeanManager(FacesContext.getCurrentInstance());
            FacesValidatorAnnotationLiteral literal = new FacesValidatorAnnotationLiteral(this.validatorId);
            this.delegate = (Validator)CDIUtils.get(bm, VALIDATOR_TYPE, true, new Annotation[]{literal});
            if (this.delegate == null) {
                this.delegate = CDIUtils.get(bm, Validator.class, true, new Annotation[]{literal});
            }
        }
        return this.delegate;
    }

    public Object saveState(FacesContext context) {
        if (!this.initialStateMarked()) {
            Object[] values = new Object[]{this.validatorId};
            return values;
        }
        return null;
    }

    public void restoreState(FacesContext context, Object state) {
        if (state != null) {
            Object[] values = (Object[])state;
            this.validatorId = (String)values[0];
        }
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }

    public void clearInitialState() {
        this._initialStateMarked = false;
    }

    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    public void markInitialState() {
        this._initialStateMarked = true;
    }
}

