/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.faces.core;

import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ValueChangeEvent;
import jakarta.faces.event.ValueChangeListener;
import jakarta.faces.view.AttachedObjectHandler;
import jakarta.faces.view.EditableValueHolderAttachedObjectHandler;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.FaceletException;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributeException;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import jakarta.faces.view.facelets.TagHandler;
import java.io.IOException;
import java.io.Serializable;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;

public final class ValueChangeListenerHandler
extends TagHandler
implements EditableValueHolderAttachedObjectHandler {
    private final TagAttribute binding = this.getAttribute("binding");
    private final String listenerType;

    public ValueChangeListenerHandler(TagConfig config) {
        super(config);
        TagAttribute type = this.getAttribute("type");
        if (type != null) {
            if (!type.isLiteral()) {
                throw new TagAttributeException(type, "Must be a literal class name of type ValueChangeListener");
            }
            try {
                ClassUtils.forName((String)type.getValue());
            }
            catch (ClassNotFoundException e) {
                throw new TagAttributeException(type, "Couldn't qualify ValueChangeListener", (Throwable)e);
            }
            this.listenerType = type.getValue();
        } else {
            this.listenerType = null;
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        if (parent instanceof EditableValueHolder) {
            this.applyAttachedObject(ctx.getFacesContext(), parent);
        } else if (UIComponent.isCompositeComponent((UIComponent)parent)) {
            FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(ctx);
            mctx.addAttachedObjectHandler(parent, (AttachedObjectHandler)this);
        } else {
            throw new TagException(this.tag, "Parent not composite component or an instance of EditableValueHolder: " + String.valueOf(parent));
        }
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext faceletContext = (FaceletContext)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY);
        EditableValueHolder evh = (EditableValueHolder)parent;
        ValueExpression b = null;
        if (this.binding != null) {
            b = this.binding.getValueExpression(faceletContext, ValueChangeListener.class);
        }
        LazyValueChangeListener listener = new LazyValueChangeListener(this.listenerType, b);
        evh.addValueChangeListener((ValueChangeListener)listener);
    }

    public String getFor() {
        TagAttribute forAttribute = this.getAttribute("for");
        if (forAttribute == null) {
            return null;
        }
        return forAttribute.getValue();
    }

    private static class LazyValueChangeListener
    implements ValueChangeListener,
    Serializable {
        private static final long serialVersionUID = 7613811124326963180L;
        private final String type;
        private final ValueExpression binding;

        public LazyValueChangeListener(String type, ValueExpression binding) {
            this.type = type;
            this.binding = binding;
        }

        public void processValueChange(ValueChangeEvent event) throws AbortProcessingException {
            FacesContext facesContext = event.getFacesContext();
            if (facesContext == null) {
                return;
            }
            ValueChangeListener instance = null;
            if (this.binding != null) {
                instance = (ValueChangeListener)this.binding.getValue(facesContext.getELContext());
            }
            if (instance == null && this.type != null) {
                try {
                    instance = (ValueChangeListener)ClassUtils.forName((String)this.type).newInstance();
                }
                catch (Exception e) {
                    throw new AbortProcessingException("Couldn't Lazily instantiate ValueChangeListener", (Throwable)e);
                }
                if (this.binding != null) {
                    this.binding.setValue(facesContext.getELContext(), (Object)instance);
                }
            }
            if (instance != null) {
                instance.processValueChange(event);
            }
        }
    }
}

