/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.data.ContextURL;

public class ContextURLParser {
    public static ContextURL parse(URI contextURL) {
        String[] pathElems;
        String entitySetOrSingletonOrType;
        String firstToken;
        if (contextURL == null) {
            return null;
        }
        ContextURL.Builder contextUrl = ContextURL.with();
        String contextURLasString = contextURL.toASCIIString();
        boolean isEntity = false;
        if (contextURLasString.endsWith("/$entity") || contextURLasString.endsWith("/@Element")) {
            isEntity = true;
            contextUrl.suffix(ContextURL.Suffix.ENTITY);
            contextURLasString = contextURLasString.replace("/$entity", "").replace("/@Element", "");
        } else if (contextURLasString.endsWith("/$ref")) {
            contextUrl.suffix(ContextURL.Suffix.REFERENCE);
            contextURLasString = contextURLasString.replace("/$ref", "");
        } else if (contextURLasString.endsWith("/$delta")) {
            contextUrl.suffix(ContextURL.Suffix.DELTA);
            contextURLasString = contextURLasString.replace("/$delta", "");
        } else if (contextURLasString.endsWith("/$deletedEntity")) {
            contextUrl.suffix(ContextURL.Suffix.DELTA_DELETED_ENTITY);
            contextURLasString = contextURLasString.replace("/$deletedEntity", "");
        } else if (contextURLasString.endsWith("/$link")) {
            contextUrl.suffix(ContextURL.Suffix.DELTA_LINK);
            contextURLasString = contextURLasString.replace("/$link", "");
        } else if (contextURLasString.endsWith("/$deletedLink")) {
            contextUrl.suffix(ContextURL.Suffix.DELTA_DELETED_LINK);
            contextURLasString = contextURLasString.replace("/$deletedLink", "");
        }
        contextUrl.serviceRoot(URI.create(StringUtils.substringBefore(contextURLasString, "$metadata")));
        String rest = StringUtils.substringAfter(contextURLasString, "$metadata#");
        if (rest.startsWith("Collection(")) {
            entitySetOrSingletonOrType = firstToken = rest.substring(0, rest.indexOf(41) + 1);
        } else {
            int openParIdx = rest.indexOf(40);
            if (openParIdx == -1) {
                entitySetOrSingletonOrType = firstToken = StringUtils.substringBeforeLast(rest, "/");
            } else {
                firstToken = isEntity ? rest : StringUtils.substringBeforeLast(rest, ")") + ")";
                ArrayList<String> parts = new ArrayList<String>();
                for (String split : firstToken.split("\\)/")) {
                    parts.add(split.replaceAll("\\(.*", ""));
                }
                entitySetOrSingletonOrType = StringUtils.join(parts, '/');
                int commaIdx = firstToken.indexOf(44);
                if (commaIdx != -1) {
                    contextUrl.selectList(firstToken.substring(openParIdx + 1, firstToken.length() - 1));
                }
            }
        }
        contextUrl.entitySetOrSingletonOrType(entitySetOrSingletonOrType);
        int slashIdx = entitySetOrSingletonOrType.lastIndexOf(47);
        if (slashIdx != -1 && entitySetOrSingletonOrType.substring(slashIdx + 1).indexOf(46) != -1) {
            contextUrl.entitySetOrSingletonOrType(entitySetOrSingletonOrType.substring(0, slashIdx));
            contextUrl.derivedEntity(entitySetOrSingletonOrType.substring(slashIdx + 1));
        }
        if (!firstToken.equals(rest) && (pathElems = StringUtils.substringAfter(rest, "/").split("/")).length > 0 && pathElems[0].length() > 0) {
            if (pathElems[0].indexOf(46) == -1) {
                contextUrl.navOrPropertyPath(pathElems[0]);
            } else {
                contextUrl.derivedEntity(pathElems[0]);
            }
            if (pathElems.length > 1) {
                contextUrl.navOrPropertyPath(pathElems[1]);
            }
        }
        return contextUrl.build();
    }
}

