/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.annotation;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.annotation.EdmExpression;
import org.apache.olingo.commons.api.edm.annotation.EdmPropertyValue;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlPropertyValue;
import org.apache.olingo.commons.core.edm.AbstractEdmAnnotatable;
import org.apache.olingo.commons.core.edm.annotation.AbstractEdmExpression;

public class EdmPropertyValueImpl
extends AbstractEdmAnnotatable
implements EdmPropertyValue {
    private EdmExpression value;
    private CsdlPropertyValue csdlExp;

    public EdmPropertyValueImpl(Edm edm, CsdlPropertyValue csdlExp) {
        super(edm, csdlExp);
        this.csdlExp = csdlExp;
    }

    @Override
    public String getProperty() {
        if (this.csdlExp.getProperty() == null) {
            throw new EdmException("PropertyValue expressions require a referenced property value.");
        }
        return this.csdlExp.getProperty();
    }

    @Override
    public EdmExpression getValue() {
        if (this.value == null) {
            if (this.csdlExp.getValue() == null) {
                throw new EdmException("PropertyValue expressions require an expression value.");
            }
            this.value = AbstractEdmExpression.getExpression(this.edm, this.csdlExp.getValue());
        }
        return this.value;
    }
}

