/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.communication.request.retrieve.ODataEntityRequest;
import org.apache.olingo.client.api.communication.request.retrieve.ODataMediaRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.domain.ClientAnnotation;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.domain.ClientValuable;
import org.apache.olingo.client.api.uri.URIBuilder;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.AbstractTerm;
import org.apache.olingo.ext.proxy.api.Annotatable;
import org.apache.olingo.ext.proxy.api.EdmStreamValue;
import org.apache.olingo.ext.proxy.api.annotations.EntityType;
import org.apache.olingo.ext.proxy.api.annotations.Namespace;
import org.apache.olingo.ext.proxy.api.annotations.NavigationProperty;
import org.apache.olingo.ext.proxy.api.annotations.Term;
import org.apache.olingo.ext.proxy.commons.AbstractStructuredInvocationHandler;
import org.apache.olingo.ext.proxy.commons.ComplexInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EdmStreamValueHandler;
import org.apache.olingo.ext.proxy.commons.EntitySetInvocationHandler;
import org.apache.olingo.ext.proxy.context.AttachedEntityStatus;
import org.apache.olingo.ext.proxy.context.EntityUUID;
import org.apache.olingo.ext.proxy.utils.CoreUtils;

public class EntityInvocationHandler
extends AbstractStructuredInvocationHandler
implements Annotatable {
    private static final long serialVersionUID = 2629912294765040037L;
    private final Map<Class<? extends AbstractTerm>, Object> annotations = new HashMap<Class<? extends AbstractTerm>, Object>();
    private EdmStreamValue stream;
    private EntityUUID uuid;

    static EntityInvocationHandler getInstance(ClientEntity entity, EntitySetInvocationHandler<?, ?, ?> entitySet, Class<?> typeRef) {
        return new EntityInvocationHandler(null, entity, entitySet.getURI(), typeRef, entitySet.service);
    }

    static EntityInvocationHandler getInstance(Object key, ClientEntity entity, URI entitySetURI, Class<?> typeRef, AbstractService<?> service) {
        return new EntityInvocationHandler(key, entity, entitySetURI, typeRef, service);
    }

    public static EntityInvocationHandler getInstance(ClientEntity entity, URI entitySetURI, Class<?> typeRef, AbstractService<?> service) {
        return new EntityInvocationHandler(null, entity, entitySetURI, typeRef, service);
    }

    public static EntityInvocationHandler getInstance(ClientEntity entity, URI entitySetURI, URI entityURI, Class<?> typeRef, AbstractService<?> service) {
        return new EntityInvocationHandler(entity, entityURI, entitySetURI, typeRef, service);
    }

    public static EntityInvocationHandler getInstance(URI entityURI, Class<?> typeRef, AbstractService<?> service) {
        return new EntityInvocationHandler(entityURI, typeRef, service);
    }

    public static EntityInvocationHandler getInstance(Class<?> typeRef, AbstractService<?> service) {
        return new EntityInvocationHandler(typeRef, service);
    }

    private EntityInvocationHandler(Class<?> typeRef, AbstractService<?> service) {
        super(typeRef, service);
        String name = typeRef.getAnnotation(EntityType.class).name();
        String namespace = typeRef.getAnnotation(Namespace.class).value();
        this.internal = service.getClient().getObjectFactory().newEntity(new FullQualifiedName(namespace, name));
        ((ClientEntity)ClientEntity.class.cast(this.internal)).setMediaEntity(typeRef.getAnnotation(EntityType.class).hasStream());
        this.uuid = new EntityUUID(null, typeRef, null);
    }

    private EntityInvocationHandler(URI entityURI, Class<?> typeRef, AbstractService<?> service) {
        super(typeRef, service);
        String name = typeRef.getAnnotation(EntityType.class).name();
        String namespace = typeRef.getAnnotation(Namespace.class).value();
        this.internal = service.getClient().getObjectFactory().newEntity(new FullQualifiedName(namespace, name));
        ((ClientEntity)ClientEntity.class.cast(this.internal)).setMediaEntity(typeRef.getAnnotation(EntityType.class).hasStream());
        this.baseURI = entityURI;
        this.uri = entityURI == null ? null : this.getClient().newURIBuilder(this.baseURI.toASCIIString());
        this.uuid = new EntityUUID(null, typeRef, null);
    }

    private EntityInvocationHandler(ClientEntity entity, URI entitySetURI, URI entityURI, Class<?> typeRef, AbstractService<?> service) {
        super(typeRef, (Object)entity, service);
        if (entityURI != null) {
            this.baseURI = entityURI;
            this.uri = this.getClient().newURIBuilder(this.baseURI.toASCIIString());
        } else {
            this.baseURI = null;
            this.uri = null;
        }
        this.internal = entity;
        this.getEntity().setMediaEntity(typeRef.getAnnotation(EntityType.class).hasStream());
        this.uuid = new EntityUUID(entitySetURI, typeRef, null);
    }

    private EntityInvocationHandler(Object entityKey, ClientEntity entity, URI entitySetURI, Class<?> typeRef, AbstractService<?> service) {
        super(typeRef, (Object)entity, service);
        Object key;
        Object object = key = entityKey == null ? CoreUtils.getKey(this.getClient(), this, typeRef, entity) : entityKey;
        if (entity.getEditLink() != null) {
            this.baseURI = entity.getEditLink();
            this.uri = this.getClient().newURIBuilder(this.baseURI.toASCIIString());
        } else if (key != null) {
            URIBuilder uriBuilder;
            this.uri = uriBuilder = CoreUtils.buildEditLink(this.getClient(), entitySetURI.toASCIIString(), key);
            this.baseURI = this.uri.build();
            entity.setEditLink(this.baseURI);
        } else {
            this.baseURI = null;
            this.uri = null;
        }
        this.internal = entity;
        this.getEntity().setMediaEntity(typeRef.getAnnotation(EntityType.class).hasStream());
        this.uuid = new EntityUUID(entitySetURI, typeRef, key);
    }

    public void setEntity(ClientEntity entity) {
        this.internal = entity;
        this.getEntity().setMediaEntity(this.typeRef.getAnnotation(EntityType.class).hasStream());
        Object key = CoreUtils.getKey(this.getClient(), this, this.typeRef, entity);
        this.uuid = new EntityUUID(this.getUUID().getEntitySetURI(), this.getUUID().getType(), key);
        if (this.uri == null) {
            URIBuilder uriBuilder;
            this.uri = uriBuilder = entity.getEditLink() == null ? CoreUtils.buildEditLink(this.getClient(), this.getUUID().getEntitySetURI().toASCIIString(), key) : this.getClient().newURIBuilder(entity.getEditLink().toASCIIString());
            this.baseURI = this.uri == null ? null : this.uri.build();
        }
        this.streamedPropertyChanges.clear();
        this.streamedPropertyCache.clear();
        this.propertyChanges.clear();
        this.propertyCache.clear();
        this.linkChanges.clear();
        this.linkCache.clear();
        this.annotations.clear();
    }

    public EntityUUID getUUID() {
        return this.uuid;
    }

    public EntityUUID updateEntityUUID(URI entitySetURI, Class<?> type, ClientEntity entity) {
        CoreUtils.addProperties(this.service.getClient(), this.getPropertyChanges(), entity);
        Object key = CoreUtils.getKey(this.getClient(), this, this.getUUID().getType(), entity);
        return this.updateUUID(entitySetURI, type, key);
    }

    public EntityUUID updateUUID(URI entitySetURI, Class<?> type, Object key) {
        this.uuid = new EntityUUID(entitySetURI, type, key);
        if (this.uri == null) {
            URIBuilder uriBuilder;
            this.uri = uriBuilder = this.getEntity().getEditLink() == null ? CoreUtils.buildEditLink(this.getClient(), entitySetURI.toASCIIString(), key) : this.getClient().newURIBuilder(this.getEntity().getEditLink().toASCIIString());
            this.baseURI = this.uri == null ? null : this.uri.build();
        }
        return this.uuid;
    }

    public URI getEntitySetURI() {
        return this.uuid.getEntitySetURI();
    }

    public final ClientEntity getEntity() {
        return (ClientEntity)this.internal;
    }

    public URI getEntityURI() {
        return this.baseURI;
    }

    public String getETag() {
        return this.getEntity().getETag();
    }

    public void setETag(String eTag) {
        this.getEntity().setETag(eTag);
    }

    public Map<Class<? extends AbstractTerm>, Object> getAnnotations() {
        return this.annotations;
    }

    @Override
    public boolean isChanged() {
        return this.isChanged(true);
    }

    public boolean isChanged(boolean considerStreamProperties) {
        return super.isChanged() || considerStreamProperties && (this.stream != null || !this.streamedPropertyChanges.isEmpty());
    }

    public void uploadStream(EdmStreamValue stream) {
        if (this.typeRef.getAnnotation(EntityType.class).hasStream()) {
            if (this.stream != null) {
                this.stream.close();
            }
            this.stream = stream;
            this.attach(AttachedEntityStatus.CHANGED);
        }
    }

    public EdmStreamValue getStreamChanges() {
        return this.stream;
    }

    public EdmStreamValue loadStream() {
        URI contentSource;
        URI uRI = contentSource = this.getEntity().getMediaContentSource() == null ? this.getClient().newURIBuilder(this.baseURI.toASCIIString()).appendValueSegment().build() : this.getEntity().getMediaContentSource();
        if (this.stream == null && this.typeRef.getAnnotation(EntityType.class).hasStream() && contentSource != null) {
            ODataMediaRequest retrieveReq = this.getClient().getRetrieveRequestFactory().getMediaEntityRequest(contentSource);
            if (StringUtils.isNotBlank(this.getEntity().getMediaContentType())) {
                retrieveReq.setFormat(ContentType.parse(this.getEntity().getMediaContentType()));
            }
            ODataRetrieveResponse res = (ODataRetrieveResponse)retrieveReq.execute();
            this.stream = (EdmStreamValue)EdmStreamValue.class.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{EdmStreamValue.class}, (InvocationHandler)new EdmStreamValueHandler(res.getContentType(), (InputStream)res.getBody(), contentSource, this.service)));
        }
        return this.stream;
    }

    @Override
    protected Object getNavigationPropertyValue(NavigationProperty property, Method getter) {
        Object navPropValue = this.linkChanges.containsKey(property) ? this.linkChanges.get(property) : (this.linkCache.containsKey(property) ? this.linkCache.get(property) : this.retrieveNavigationProperty(property, getter));
        if (navPropValue != null) {
            this.cacheLink(property, navPropValue);
            this.attach();
        }
        return navPropValue;
    }

    protected void cacheLink(NavigationProperty navProp, Object value) {
        this.linkCache.put(navProp, value);
    }

    @Override
    public void addAnnotation(Class<? extends AbstractTerm> term, Object value) {
        this.annotations.put(term, value);
        if (value != null) {
            Collection<Object> coll = Collection.class.isAssignableFrom(value.getClass()) ? (Collection)Collection.class.cast(value) : Collections.singleton(value);
            for (Object e : coll) {
                InvocationHandler handler;
                if (!(e instanceof Proxy) || !((handler = Proxy.getInvocationHandler(e)) instanceof ComplexInvocationHandler) || ((ComplexInvocationHandler)handler).getEntityHandler() != null) continue;
                ((ComplexInvocationHandler)handler).setEntityHandler(this);
            }
        }
        this.attach(AttachedEntityStatus.CHANGED);
    }

    @Override
    public void removeAnnotation(Class<? extends AbstractTerm> term) {
        this.annotations.remove(term);
        this.attach(AttachedEntityStatus.CHANGED);
    }

    @Override
    public Object readAnnotation(Class<? extends AbstractTerm> term) {
        Object res = null;
        if (this.annotations.containsKey(term)) {
            res = this.annotations.get(term);
        } else {
            try {
                Term termAnn = term.getAnnotation(Term.class);
                Namespace namespaceAnn = term.getAnnotation(Namespace.class);
                ClientValuable annotation = null;
                for (ClientAnnotation _annotation : this.getEntity().getAnnotations()) {
                    if (!(namespaceAnn.value() + "." + termAnn.name()).equals(_annotation.getTerm())) continue;
                    annotation = _annotation;
                }
                Object object = res = annotation == null || annotation.hasNullValue() ? null : CoreUtils.getObjectFromODataValue(annotation.getValue(), null, this.service);
                if (res != null) {
                    this.annotations.put(term, res);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error getting annotation for term '" + term.getName() + "'", e);
            }
        }
        return res;
    }

    @Override
    public Collection<Class<? extends AbstractTerm>> readAnnotationTerms() {
        return CoreUtils.getAnnotationTerms(this.service, this.getEntity().getAnnotations());
    }

    @Override
    protected void load() {
        Object key = this.uuid.getKey();
        try {
            ODataEntityRequest<ClientEntity> req = this.getClient().getRetrieveRequestFactory().getEntityRequest(this.uri.build());
            req.setPrefer(this.getClient().newPreferences().includeAnnotations("*"));
            ODataRetrieveResponse res = (ODataRetrieveResponse)req.execute();
            ClientEntity entity = (ClientEntity)res.getBody();
            if (entity == null) {
                throw new IllegalArgumentException("Invalid " + this.typeRef.getSimpleName() + "(" + key + ")");
            }
            this.setEntity(entity);
            this.setETag(res.getETag());
            if (key != null && !key.equals(CoreUtils.getKey(this.getClient(), this, this.typeRef, entity))) {
                throw new IllegalArgumentException("Invalid " + this.typeRef.getSimpleName() + "(" + key + ")");
            }
            if (this.stream != null) {
                this.stream.close();
                this.stream = null;
            }
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Entity '" + this.uuid + "' not found", e);
            throw e;
        }
        catch (Exception e) {
            LOG.warn("Error retrieving entity '" + this.uuid + "'", e);
            throw new IllegalArgumentException("Error retrieving " + this.typeRef.getSimpleName() + "(" + key + ")", e);
        }
    }

    @Override
    protected <T extends ClientProperty> List<T> getInternalProperties() {
        return this.getEntity() == null ? Collections.emptyList() : this.getEntity().getProperties();
    }

    @Override
    protected ClientProperty getInternalProperty(String name) {
        return this.getEntity() == null ? null : this.getEntity().getProperty(name);
    }

    public String readEntityReferenceID() {
        URI id = this.getEntity() == null ? null : this.getEntity().getId();
        return id == null ? null : id.toASCIIString();
    }

    @Override
    public String toString() {
        return this.uuid.toString();
    }

    @Override
    public int hashCode() {
        return this.uuid.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof EntityInvocationHandler && ((EntityInvocationHandler)obj).getUUID().equals(this.uuid);
    }
}

