/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.api.registry;

import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.registry.api.registry.FindInstancesResponse;

public class MicroserviceInstances {
    private boolean microserviceNotExist;
    private boolean needRefresh = true;
    private String revision;
    private FindInstancesResponse instancesResponse;

    public boolean isMicroserviceNotExist() {
        return this.microserviceNotExist;
    }

    public MicroserviceInstances setMicroserviceNotExist(boolean microserviceNotExist) {
        this.microserviceNotExist = microserviceNotExist;
        return this;
    }

    public boolean isNeedRefresh() {
        return this.needRefresh;
    }

    public MicroserviceInstances setNeedRefresh(boolean needRefresh) {
        this.needRefresh = needRefresh;
        return this;
    }

    public String getRevision() {
        return this.revision;
    }

    public MicroserviceInstances setRevision(String revision) {
        this.revision = revision;
        return this;
    }

    public FindInstancesResponse getInstancesResponse() {
        return this.instancesResponse;
    }

    public MicroserviceInstances setInstancesResponse(FindInstancesResponse instancesResponse) {
        this.instancesResponse = instancesResponse;
        return this;
    }

    public void mergeMicroserviceInstances(MicroserviceInstances other) {
        this.mergeNeedRefresh(other.needRefresh);
        this.mergeMicroserviceNotExist(other.microserviceNotExist);
        this.mergeRevision(other);
        this.mergeInstanceResponse(other.getInstancesResponse());
    }

    private void mergeRevision(MicroserviceInstances other) {
        if (!other.isMicroserviceNotExist() && other.needRefresh) {
            Mac mac = HmacUtils.getInitializedMac((HmacAlgorithms)HmacAlgorithms.HMAC_SHA_1, (byte[])this.stringToBytes(this.revision));
            this.revision = Base64.encodeBase64String((byte[])mac.doFinal(this.stringToBytes(other.revision)));
        }
    }

    private byte[] stringToBytes(String input) {
        if (StringUtils.isEmpty((CharSequence)input)) {
            input = "@";
        }
        return input.getBytes(StandardCharsets.UTF_8);
    }

    private void mergeMicroserviceNotExist(boolean microserviceNotExist) {
        if (this.microserviceNotExist) {
            this.microserviceNotExist = microserviceNotExist;
        }
    }

    private void mergeNeedRefresh(boolean needRefresh) {
        if (!this.needRefresh) {
            this.needRefresh = needRefresh;
        }
    }

    private void mergeInstanceResponse(FindInstancesResponse instancesResponse) {
        if (instancesResponse == null) {
            return;
        }
        if (this.instancesResponse == null) {
            this.instancesResponse = instancesResponse;
            return;
        }
        this.instancesResponse.mergeInstances(instancesResponse.getInstances());
    }
}

