/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper;

import java.awt.Shape;
import java.util.Iterator;
import java.util.Objects;
import java.util.OptionalInt;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.filter.sqlmm.SQLMM;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.wrapper.AbstractGeometry;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryType;
import org.apache.sis.geometry.wrapper.SpatialOperationContext;
import org.apache.sis.pending.geoapi.filter.DistanceOperatorName;
import org.apache.sis.pending.geoapi.filter.SpatialOperatorName;
import org.apache.sis.pending.geoapi.geometry.Geometry;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class GeometryWrapper
extends AbstractGeometry
implements Geometry {
    protected CoordinateReferenceSystem crs;

    protected GeometryWrapper() {
    }

    protected abstract Geometries<?> factory();

    protected abstract Object implementation();

    public OptionalInt getSRID() {
        return OptionalInt.empty();
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)this.getCoordinateDimension(), (CoordinateReferenceSystem)crs);
        this.crs = crs;
    }

    public int getCoordinateDimension() {
        return 2;
    }

    protected final GeneralEnvelope createEnvelope() {
        return this.crs != null ? new GeneralEnvelope(this.crs) : new GeneralEnvelope(this.getCoordinateDimension());
    }

    public abstract GeneralEnvelope getEnvelope();

    public abstract DirectPosition getCentroid();

    public abstract double[] getPointCoordinates();

    public abstract double[] getAllCoordinates();

    public abstract Object mergePolylines(Iterator<?> var1);

    public final boolean predicate(DistanceOperatorName type, GeometryWrapper other, Quantity<Length> distance, SpatialOperationContext context) throws FactoryException, TransformException, IncommensurableException {
        GeometryWrapper[] geometries = new GeometryWrapper[]{this, other};
        if (context.transform(geometries)) {
            double dv = distance.getValue().doubleValue();
            Unit unit = ReferencingUtilities.getUnit((CoordinateReferenceSystem)context.commonCRS);
            if (unit != null) {
                dv = distance.getUnit().getConverterToAny(unit).convert(dv);
            }
            return geometries[0].predicateSameCRS(type, geometries[1], dv);
        }
        return SpatialOperationContext.emptyResult(type);
    }

    public final boolean predicate(SpatialOperatorName type, GeometryWrapper other, SpatialOperationContext context) throws FactoryException, TransformException, IncommensurableException {
        GeometryWrapper[] geometries = new GeometryWrapper[]{this, other};
        if (context.transform(geometries)) {
            return geometries[0].predicateSameCRS(type, geometries[1]);
        }
        return SpatialOperationContext.emptyResult(type);
    }

    public final Object operation(SQLMM operation) {
        assert (operation.geometryCount() == 1 && operation.maxParamCount == 1) : operation;
        Object result = this.operationSameCRS(operation, null, null);
        assert (this.isInstance(operation, result)) : result;
        return result;
    }

    public final Object operation(SQLMM operation, GeometryWrapper other) throws TransformException {
        assert (operation.geometryCount() == 2 && operation.maxParamCount == 2) : operation;
        Object result = this.operationSameCRS(operation, other.transform(this.crs), null);
        assert (this.isInstance(operation, result)) : result;
        return result;
    }

    public final Object operationWithArgument(SQLMM operation, Object argument) {
        assert (operation.geometryCount() == 1 && operation.maxParamCount == 2) : operation;
        if (operation.minParamCount > 1) {
            ArgumentChecks.ensureNonNull((String)"arg1", (Object)argument);
        }
        Object result = this.operationSameCRS(operation, null, argument);
        assert (this.isInstance(operation, result)) : result;
        return result;
    }

    public final Object operationWithArgument(SQLMM operation, GeometryWrapper other, Object argument) throws TransformException {
        assert (operation.geometryCount() == 2 && operation.maxParamCount == 3) : operation;
        if (argument == null && operation.minParamCount > 2) {
            throw new NullPointerException(Errors.format((short)141, (Object)"arg2"));
        }
        Object result = this.operationSameCRS(operation, other.transform(this.crs), argument);
        assert (this.isInstance(operation, result)) : result;
        return result;
    }

    private boolean isInstance(SQLMM operation, Object result) {
        return result == null || operation.getReturnType(this.factory()).isInstance(result);
    }

    protected boolean predicateSameCRS(SpatialOperatorName type, GeometryWrapper other) {
        throw new UnsupportedOperationException(Geometries.unsupported(type.name()));
    }

    protected boolean predicateSameCRS(DistanceOperatorName type, GeometryWrapper other, double distance) {
        throw new UnsupportedOperationException(Geometries.unsupported(type.name()));
    }

    protected Object operationSameCRS(SQLMM operation, GeometryWrapper other, Object argument) {
        throw new UnsupportedOperationException(Geometries.unsupported(operation.name()));
    }

    public GeometryWrapper toGeometryType(GeometryType target) {
        Object geometry;
        Class<?> type = this.factory().getGeometryClass(target);
        if (type.isInstance(geometry = this.implementation())) {
            return this;
        }
        throw new UnconvertibleObjectException(Errors.format((short)11, geometry.getClass(), type));
    }

    public GeometryWrapper transform(CoordinateOperation operation, boolean validate) throws FactoryException, TransformException {
        MathTransform transform = operation.getMathTransform();
        if (validate && this.crs != null) {
            CoordinateOperation step = CRS.findOperation((CoordinateReferenceSystem)this.crs, (CoordinateReferenceSystem)operation.getSourceCRS(), null);
            transform = MathTransforms.concatenate((MathTransform)step.getMathTransform(), (MathTransform)transform);
        }
        GeometryWrapper wrapper = this.transform(transform);
        wrapper.setCoordinateReferenceSystem(operation.getTargetCRS());
        return wrapper;
    }

    public GeometryWrapper transform(MathTransform transform) throws FactoryException, TransformException {
        if (transform.isIdentity()) {
            return this;
        }
        throw new UnsupportedOperationException(Geometries.unsupported("transform"));
    }

    public GeometryWrapper transform(CoordinateReferenceSystem targetCRS) throws TransformException {
        if (targetCRS == null || targetCRS == this.crs || this.crs == null) {
            return this;
        }
        try {
            return this.transform(CRS.findOperation((CoordinateReferenceSystem)this.crs, (CoordinateReferenceSystem)targetCRS, null), false);
        }
        catch (FactoryException e) {
            throw new TransformException(e.toString(), (Throwable)e);
        }
    }

    public abstract String formatWKT(double var1);

    public Shape toJava2D() {
        throw new UnsupportedOperationException(Geometries.unsupported("toJava2D"));
    }

    public final boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && Objects.equals(((GeometryWrapper)obj).implementation(), this.implementation());
    }

    public final int hashCode() {
        return ~Objects.hashCode(this.implementation());
    }

    public final String toString() {
        Class<?> c = this.implementation().getClass();
        Class<?> e = c.getEnclosingClass();
        Object s = Classes.getShortName(e != null ? e : c);
        GeneralEnvelope envelope = this.getEnvelope();
        if (envelope != null) {
            String bbox = envelope.toString();
            s = (String)s + bbox.substring(bbox.indexOf(40));
        }
        return s;
    }
}

