/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.ParametricCRS;
import org.apache.sis.referencing.crs.SubTypes;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultCompoundCS;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.apache.sis.referencing.internal.shared.WKTUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.bind.referencing.SC_CRS;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystem;

@XmlType(name="CompoundCRSType")
@XmlRootElement(name="CompoundCRS")
public class DefaultCompoundCRS
extends AbstractCRS
implements CompoundCRS {
    private static final long serialVersionUID = -2656710314586929287L;
    private List<? extends CoordinateReferenceSystem> components;
    private transient List<SingleCRS> singles;

    public DefaultCompoundCRS(Map<String, ?> properties, CoordinateReferenceSystem ... components) {
        super(properties, DefaultCompoundCRS.createCoordinateSystem(properties, components));
        this.setComponents(properties, Arrays.asList(components));
    }

    private DefaultCompoundCRS(DefaultCompoundCRS original, CoordinateReferenceSystem[] components) {
        super(original, null, DefaultCompoundCRS.createCoordinateSystem(null, components));
        this.setComponents(null, Arrays.asList(components));
    }

    private static void verify(Map<String, ?> properties, CoordinateReferenceSystem[] components) {
        boolean allTypes = false;
        int isProjected = 0;
        boolean isEllipsoidalHeight = false;
        for (CoordinateReferenceSystem component : components) {
            int type;
            if (component instanceof GeodeticCRS) {
                type = 1;
            } else if (component instanceof ProjectedCRS) {
                isProjected = 1;
                type = 1;
            } else {
                if (!(component instanceof VerticalCRS)) continue;
                isEllipsoidalHeight = ReferencingUtilities.isEllipsoidalHeight(((VerticalCRS)component).getDatum());
                type = 2;
            }
            if (allTypes != (allTypes |= type)) continue;
            throw new IllegalArgumentException(Resources.forProperties(properties).getString((short)76, type));
        }
        if (isEllipsoidalHeight && allTypes & true) {
            throw new IllegalArgumentException(Resources.forProperties(properties).getString((short)77, isProjected));
        }
    }

    private static AbstractCS createCoordinateSystem(Map<String, ?> properties, CoordinateReferenceSystem[] components) {
        ArgumentChecks.ensureNonNull((String)"components", (Object)components);
        DefaultCompoundCRS.verify(properties, components);
        if (components.length < 2) {
            throw new IllegalArgumentException(Errors.forProperties(properties).getString((short)156, (Object)2, (Object)components.length));
        }
        CoordinateSystem[] cs = new CoordinateSystem[components.length];
        for (int i = 0; i < components.length; ++i) {
            CoordinateReferenceSystem crs = components[i];
            ArgumentChecks.ensureNonNullElement((String)"components", (int)i, (Object)crs);
            cs[i] = crs.getCoordinateSystem();
        }
        return new DefaultCompoundCS(cs);
    }

    protected DefaultCompoundCRS(CompoundCRS crs) {
        super((CoordinateReferenceSystem)crs);
        if (crs instanceof DefaultCompoundCRS) {
            DefaultCompoundCRS that = (DefaultCompoundCRS)crs;
            this.components = that.components;
            this.singles = that.singles;
        } else {
            this.setComponents(null, crs.getComponents());
        }
    }

    public static DefaultCompoundCRS castOrCopy(CompoundCRS object) {
        return object == null || object instanceof DefaultCompoundCRS ? (DefaultCompoundCRS)object : new DefaultCompoundCRS(object);
    }

    public Class<? extends CompoundCRS> getInterface() {
        return CompoundCRS.class;
    }

    public List<CoordinateReferenceSystem> getComponents() {
        return this.components;
    }

    private void setComponents(Map<String, ?> properties, List<? extends CoordinateReferenceSystem> elements) {
        if (this.setSingleComponents(elements)) {
            this.components = this.singles;
        } else {
            this.components = Containers.copyToImmutableList(elements, CoordinateReferenceSystem.class);
            DefaultCompoundCRS.verify(properties, (CoordinateReferenceSystem[])this.singles.toArray(SingleCRS[]::new));
        }
    }

    public List<SingleCRS> getSingleComponents() {
        return this.singles;
    }

    private boolean setSingleComponents(List<? extends CoordinateReferenceSystem> elements) {
        ArrayList flattened = new ArrayList(elements.size());
        boolean identical = ReferencingUtilities.getSingleComponents(elements, flattened);
        this.singles = Containers.copyToImmutableList(flattened, SingleCRS.class);
        return identical;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Class type;
        in.defaultReadObject();
        List<? extends CoordinateReferenceSystem> components = this.components;
        if (components instanceof CheckedContainer && (type = ((CheckedContainer)components).getElementType()) == SingleCRS.class) {
            this.singles = components;
            return;
        }
        this.setSingleComponents(components);
    }

    static boolean isStandardCompliant(List<? extends CoordinateReferenceSystem> singles) {
        if (Containers.isNullOrEmpty(singles)) {
            return false;
        }
        int state = 0;
        block9: for (CoordinateReferenceSystem coordinateReferenceSystem : singles) {
            switch (state) {
                case 0: {
                    if (coordinateReferenceSystem instanceof GeodeticCRS || coordinateReferenceSystem instanceof ProjectedCRS || coordinateReferenceSystem instanceof EngineeringCRS) {
                        switch (coordinateReferenceSystem.getCoordinateSystem().getDimension()) {
                            case 2: {
                                state = 1;
                                continue block9;
                            }
                            case 3: {
                                state = 2;
                                continue block9;
                            }
                        }
                    }
                    return false;
                }
                case 1: {
                    if (coordinateReferenceSystem instanceof VerticalCRS || coordinateReferenceSystem instanceof ParametricCRS) {
                        state = 2;
                        continue block9;
                    }
                }
                case 2: {
                    if (!(coordinateReferenceSystem instanceof TemporalCRS)) break;
                    state = 3;
                    continue block9;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public DefaultCompoundCRS forConvention(AxesConvention convention) {
        DefaultCompoundCRS crs = (DefaultCompoundCRS)this.getCached(Objects.requireNonNull(convention));
        if (crs == null) {
            crs = this;
            boolean changed = false;
            boolean reorderCRS = convention.ordinal() >= AxesConvention.DISPLAY_ORIENTED.ordinal();
            List<SingleCRS> elements = reorderCRS ? this.singles : this.components;
            CoordinateReferenceSystem[] newComponents = new CoordinateReferenceSystem[elements.size()];
            for (int i = 0; i < newComponents.length; ++i) {
                CoordinateReferenceSystem component = (CoordinateReferenceSystem)elements.get(i);
                AbstractCRS m = DefaultCompoundCRS.castOrCopy(component);
                if (m != (m = m.forConvention(convention))) {
                    component = m;
                    changed = true;
                }
                newComponents[i] = component;
            }
            if (changed) {
                if (reorderCRS) {
                    Arrays.sort(newComponents, SubTypes.BY_TYPE);
                }
                crs = new DefaultCompoundCRS(crs, newComponents);
            }
            crs = (DefaultCompoundCRS)this.setCached(convention, crs);
        }
        return crs;
    }

    @Override
    final AbstractCRS createSameType(AbstractCS cs) {
        throw new AssertionError();
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            switch (mode) {
                case STRICT: {
                    return this.components.equals(((DefaultCompoundCRS)object).components);
                }
            }
            return Utilities.deepEquals(this.getComponents(), (Object)((CompoundCRS)object).getComponents(), (ComparisonMode)mode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)(31 * this.components.hashCode());
    }

    @Override
    protected String formatTo(Formatter formatter) {
        boolean isStandardCompliant;
        List<CoordinateReferenceSystem> elements;
        boolean isWKT1;
        WKTUtilities.appendName(this, formatter, null);
        Convention convention = formatter.getConvention();
        boolean bl = isWKT1 = convention.majorVersion() == 1;
        if (isWKT1 || convention == Convention.INTERNAL) {
            elements = this.getComponents();
            isStandardCompliant = true;
        } else {
            elements = this.getSingleComponents();
            isStandardCompliant = DefaultCompoundCRS.isStandardCompliant(elements);
        }
        for (CoordinateReferenceSystem component : elements) {
            formatter.newLine();
            formatter.append(WKTUtilities.toFormattable(component));
        }
        formatter.newLine();
        if (!isStandardCompliant) {
            formatter.setInvalidWKT(this, null);
        }
        return isWKT1 ? "Compd_CS" : "CompoundCRS";
    }

    private DefaultCompoundCRS() {
        this.components = List.of();
        this.singles = List.of();
    }

    @XmlJavaTypeAdapter(value=SC_CRS.class)
    @XmlElement(name="componentReferenceSystem", required=true)
    private CoordinateReferenceSystem[] getXMLComponents() {
        return (CoordinateReferenceSystem[])this.getSingleComponents().toArray(CoordinateReferenceSystem[]::new);
    }

    private void setXMLComponents(CoordinateReferenceSystem[] elements) {
        this.components = Containers.viewAsUnmodifiableList((Object[])elements);
        if (this.setSingleComponents(this.components)) {
            this.components = this.singles;
        }
        this.setCoordinateSystem("coordinateSystem", DefaultCompoundCRS.createCoordinateSystem(null, elements));
    }
}

