/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.shared.Strings;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.util.FactoryException;

final class ObjectPertinence
implements Comparable<ObjectPertinence> {
    final int code;
    private final double area;
    final List<Integer> replacedBy;

    ObjectPertinence(int code, List<String> extents, GeodeticAuthorityFactory factory) throws FactoryException {
        this.code = code;
        GeographicBoundingBox bbox = null;
        for (String extentCode : extents) {
            Extent extent = factory.createExtent(extentCode);
            bbox = Extents.union(bbox, (GeographicBoundingBox)Extents.getGeographicBoundingBox((Extent)extent));
        }
        this.area = -Extents.area(bbox);
        this.replacedBy = new ArrayList<Integer>();
    }

    @Override
    public int compareTo(ObjectPertinence other) {
        return Double.compare(this.area, other.area);
    }

    static boolean sort(ObjectPertinence[] elements) {
        boolean redo;
        boolean changed = false;
        for (int i = 1; i < elements.length; ++i) {
            if (elements[i - 1].compareTo(elements[i]) <= 0) continue;
            Arrays.sort(elements);
            changed = true;
            break;
        }
        int iteration = 0;
        do {
            redo = false;
            for (int i = 0; i < elements.length; ++i) {
                for (int replacement : elements[i].replacedBy) {
                    for (int j = i + 1; j < elements.length; ++j) {
                        ObjectPertinence candidate = elements[j];
                        if (candidate.code != replacement) continue;
                        System.arraycopy(elements, i, elements, i + 1, j - i);
                        elements[i++] = candidate;
                        changed = true;
                        redo = true;
                    }
                }
            }
        } while (redo && ++iteration < 18);
        return changed;
    }

    public String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{"code", this.code, "area", Float.valueOf(Math.abs((float)(this.area / 1000000.0))), "replacedBy", Containers.peekFirst(this.replacedBy)});
    }
}

