/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jetty.thread.pool;

import org.apache.skywalking.apm.agent.core.meter.Gauge;
import org.apache.skywalking.apm.agent.core.meter.MeterFactory;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class JettyServerInterceptor
implements InstanceConstructorInterceptor {
    private static final String METER_NAME = "thread_pool";
    private static final String METRIC_POOL_NAME_TAG_NAME = "pool_name";
    private static final String THREAD_POOL_NAME = "jetty_execute_pool";
    private static final String METRIC_TYPE_TAG_NAME = "metric_type";

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) throws Throwable {
        Server server = (Server)objInst;
        QueuedThreadPool queuedThreadPool = (QueuedThreadPool)server.getThreadPool();
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> queuedThreadPool.getMinThreads()).tag(METRIC_POOL_NAME_TAG_NAME, THREAD_POOL_NAME)).tag(METRIC_TYPE_TAG_NAME, "core_pool_size")).build();
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> queuedThreadPool.getMaxThreads()).tag(METRIC_POOL_NAME_TAG_NAME, THREAD_POOL_NAME)).tag(METRIC_TYPE_TAG_NAME, "max_pool_size")).build();
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> queuedThreadPool.getThreads()).tag(METRIC_POOL_NAME_TAG_NAME, THREAD_POOL_NAME)).tag(METRIC_TYPE_TAG_NAME, "pool_size")).build();
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> queuedThreadPool.getQueueSize()).tag(METRIC_POOL_NAME_TAG_NAME, THREAD_POOL_NAME)).tag(METRIC_TYPE_TAG_NAME, "queue_size")).build();
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> (double)queuedThreadPool.getThreads() - (double)queuedThreadPool.getIdleThreads()).tag(METRIC_POOL_NAME_TAG_NAME, THREAD_POOL_NAME)).tag(METRIC_TYPE_TAG_NAME, "active_size")).build();
    }
}

