/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.internals;

import java.security.PrivilegedAction;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.security.auth.Subject;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.internals.LegacyStrategy;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.internals.ModernStrategy;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.internals.ReflectiveStrategy;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.internals.SecurityManagerCompatibility;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.internals.UnsupportedStrategy;
import org.apache.skywalking.apm.dependencies.org.slf4j.Logger;
import org.apache.skywalking.apm.dependencies.org.slf4j.LoggerFactory;

class CompositeStrategy
implements SecurityManagerCompatibility {
    private static final Logger log = LoggerFactory.getLogger(CompositeStrategy.class);
    static final CompositeStrategy INSTANCE = new CompositeStrategy(ReflectiveStrategy.Loader.forName());
    private final SecurityManagerCompatibility fallbackStrategy;
    private final AtomicReference<SecurityManagerCompatibility> activeStrategy;

    CompositeStrategy(ReflectiveStrategy.Loader loader) {
        SecurityManagerCompatibility initial;
        ModernStrategy fallback = null;
        try {
            initial = new LegacyStrategy(loader);
            try {
                fallback = new ModernStrategy(loader);
                log.debug("Loaded legacy SecurityManager methods, will fall back to modern methods after UnsupportedOperationException");
            }
            catch (ClassNotFoundException | NoSuchMethodException ex) {
                log.debug("Unable to load modern Subject methods, relying only on legacy methods", ex);
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            try {
                initial = new ModernStrategy(loader);
                log.debug("Unable to load legacy SecurityManager methods, relying only on modern methods", e);
            }
            catch (ClassNotFoundException | NoSuchMethodException ex) {
                initial = new UnsupportedStrategy(e, ex);
                log.error("Unable to load legacy SecurityManager methods", e);
                log.error("Unable to load modern Subject methods", ex);
            }
        }
        Objects.requireNonNull(initial, "initial strategy must be defined");
        this.activeStrategy = new AtomicReference<LegacyStrategy>((LegacyStrategy)initial);
        this.fallbackStrategy = fallback;
    }

    private <T> T performAction(Function<SecurityManagerCompatibility, T> action) {
        SecurityManagerCompatibility active = this.activeStrategy.get();
        try {
            return action.apply(active);
        }
        catch (UnsupportedOperationException e) {
            if (active != this.fallbackStrategy && this.fallbackStrategy != null) {
                if (this.activeStrategy.compareAndSet(active, this.fallbackStrategy)) {
                    log.debug("Using fallback strategy after encountering degraded legacy method", e);
                }
                return action.apply(this.fallbackStrategy);
            }
            throw e;
        }
    }

    @Override
    public <T> T doPrivileged(PrivilegedAction<T> action) {
        return (T)this.performAction(compatibility -> compatibility.doPrivileged(action));
    }

    @Override
    public Subject current() {
        return this.performAction(SecurityManagerCompatibility::current);
    }

    @Override
    public <T> T callAs(Subject subject, Callable<T> action) throws CompletionException {
        return (T)this.performAction(compatibility -> compatibility.callAs(subject, action));
    }
}

