/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

abstract class SharedDictBase
implements Closeable {
    private static final AtomicIntegerFieldUpdater<SharedDictBase> SHARED_LOCK_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SharedDictBase.class, "sharedLock");
    private static final int SHARED_LOCK_CLOSED = -1;
    private volatile int sharedLock;

    SharedDictBase() {
    }

    void storeFence() {
        this.sharedLock = 0;
    }

    void acquireSharedLock() {
        int n;
        do {
            if ((n = this.sharedLock) < 0) {
                throw new IllegalStateException("ZstdDictCompress is closed");
            }
            if (n != Integer.MAX_VALUE) continue;
            throw new IllegalStateException("ZstdDictCompress shared lock overflow");
        } while (!SHARED_LOCK_UPDATER.compareAndSet(this, n, n + 1));
    }

    void releaseSharedLock() {
        int n;
        do {
            if ((n = this.sharedLock) < 0) {
                throw new IllegalStateException("ZstdDictCompress is closed");
            }
            if (n != 0) continue;
            throw new IllegalStateException("ZstdDictCompress shared lock underflow");
        } while (!SHARED_LOCK_UPDATER.compareAndSet(this, n, n - 1));
    }

    abstract void doClose();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        SharedDictBase sharedDictBase = this;
        synchronized (sharedDictBase) {
            if (this.sharedLock == -1) {
                return;
            }
            if (!SHARED_LOCK_UPDATER.compareAndSet(this, 0, -1)) {
                throw new IllegalStateException("Attempt to close ZstdDictCompress while it's in use");
            }
            this.doClose();
        }
    }

    protected void finalize() {
        this.close();
    }
}

