/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.forms.impl.actions;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.cms.reference.forms.FormAction;
import org.apache.sling.cms.reference.forms.FormActionResult;
import org.apache.sling.cms.reference.forms.FormException;
import org.apache.sling.cms.reference.forms.FormRequest;
import org.apache.sling.commons.messaging.mail.MailService;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FormAction.class})
public class SendEmailAction
implements FormAction {
    public static final String RESOURCE_TYPE = "reference/components/forms/actions/sendemail";
    public static final String FROM = "from";
    private static final Logger log = LoggerFactory.getLogger(SendEmailAction.class);
    public static final String MESSAGE = "message";
    public static final String SUBJECT = "subject";
    public static final String TO = "to";
    private final MailService mailService;

    @Activate
    public SendEmailAction(@Reference MailService mailService) {
        this.mailService = mailService;
    }

    @Override
    public FormActionResult handleForm(Resource actionResource, FormRequest request) throws FormException {
        StringSubstitutor sub = new StringSubstitutor((Map)request.getFormData());
        ValueMap properties = actionResource.getValueMap();
        String to = sub.replace((String)properties.get(TO, String.class));
        log.debug("Sending message to {}", (Object)to);
        try {
            @NotNull MimeMessage message = this.mailService.getMessageBuilder().from(sub.replace((String)properties.get(FROM, String.class))).to(to).subject(sub.replace((String)properties.get(SUBJECT, String.class))).text(sub.replace((String)properties.get(MESSAGE, String.class))).build();
            log.debug("Sending message...");
            this.mailService.sendMessage(message);
            log.debug("Message sent successfully!");
            return FormActionResult.success("Message sent successfully!");
        }
        catch (MessagingException e) {
            log.error("Failed to send message", (Throwable)e);
            return FormActionResult.failure("Failed to send message: " + e.toString());
        }
    }

    @Override
    public boolean handles(Resource actionResource) {
        return RESOURCE_TYPE.equals(actionResource.getResourceType());
    }
}

