/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.xml.ProtectedItemImporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportConfig {
    private static final Logger log = LoggerFactory.getLogger(ImportConfig.class);
    private final List<BeanConfig> protectedItemImporters;

    public ImportConfig() {
        this.protectedItemImporters = Collections.emptyList();
    }

    public ImportConfig(List<BeanConfig> protectedItemImporters) {
        this.protectedItemImporters = protectedItemImporters;
    }

    public List<? extends ProtectedItemImporter> getProtectedItemImporters() {
        ArrayList<ProtectedItemImporter> piis = new ArrayList<ProtectedItemImporter>();
        for (BeanConfig bc : this.protectedItemImporters) {
            try {
                piis.add(bc.newInstance(ProtectedItemImporter.class));
            }
            catch (ConfigurationException e) {
                log.warn(e.getMessage());
            }
        }
        return piis;
    }
}

