/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.tags;

import java.io.UnsupportedEncodingException;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.errors.EncodingException;

public class ELEncodeFunctions {
    private static final String DEFAULT_ENCODING = "UTF-8";

    private ELEncodeFunctions() {
    }

    public static String encodeForBase64(String str) throws UnsupportedEncodingException {
        return ELEncodeFunctions.encodeForBase64Charset(DEFAULT_ENCODING, str);
    }

    public static String encodeForBase64Wrap(String str) throws UnsupportedEncodingException {
        return ELEncodeFunctions.encodeForBase64CharsetWrap(DEFAULT_ENCODING, str);
    }

    public static String encodeForBase64Charset(String charset, String str) throws UnsupportedEncodingException {
        return ESAPI.encoder().encodeForBase64(str.getBytes(charset), false);
    }

    public static String encodeForBase64CharsetWrap(String charset, String str) throws UnsupportedEncodingException {
        return ESAPI.encoder().encodeForBase64(str.getBytes(charset), true);
    }

    public static String encodeForCSS(String str) {
        return ESAPI.encoder().encodeForCSS(str);
    }

    public static String encodeForHTML(String str) {
        return ESAPI.encoder().encodeForHTML(str);
    }

    public static String encodeForHTMLAttribute(String str) {
        return ESAPI.encoder().encodeForHTMLAttribute(str);
    }

    public static String encodeForJavaScript(String str) {
        return ESAPI.encoder().encodeForJavaScript(str);
    }

    public static String encodeForURL(String str) throws EncodingException {
        return ESAPI.encoder().encodeForURL(str);
    }

    public static String encodeForVBScript(String str) {
        return ESAPI.encoder().encodeForVBScript(str);
    }

    public static String encodeForXML(String str) {
        return ESAPI.encoder().encodeForXML(str);
    }

    public static String encodeForXMLAttribute(String str) {
        return ESAPI.encoder().encodeForXMLAttribute(str);
    }

    public static String encodeForXPath(String str) {
        return ESAPI.encoder().encodeForXPath(str);
    }
}

