/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.matrix.data.IJV;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public abstract class ColGroup
implements Serializable {
    protected static final Log LOG = LogFactory.getLog((String)ColGroup.class.getName());
    private static final long serialVersionUID = 2439785418908671481L;
    protected int[] _colIndexes;
    protected int _numRows;
    protected boolean _zeros;
    protected boolean _lossy;

    protected ColGroup() {
        this._colIndexes = null;
        this._numRows = -1;
    }

    protected ColGroup(int[] colIndices, int numRows) {
        if (colIndices == null) {
            throw new DMLRuntimeException("null input to ColGroup is invalid");
        }
        if (colIndices.length == 0) {
            throw new DMLRuntimeException("0 is an invalid number of columns in a ColGroup");
        }
        if (numRows < 1) {
            throw new DMLRuntimeException(numRows + " is an invalid number of rows in a ColGroup");
        }
        this._colIndexes = colIndices;
        this._numRows = numRows;
    }

    public int[] getColIndices() {
        return this._colIndexes;
    }

    public int getColIndex(int colNum) {
        return this._colIndexes[colNum];
    }

    public int getNumRows() {
        return this._numRows;
    }

    public int getNumCols() {
        return this._colIndexes.length;
    }

    public abstract CompressionType getCompType();

    protected abstract ColGroupType getColGroupType();

    public void shiftColIndices(int offset) {
        int i = 0;
        while (i < this._colIndexes.length) {
            int n = i++;
            this._colIndexes[n] = this._colIndexes[n] + offset;
        }
    }

    public abstract long estimateInMemorySize();

    public abstract void decompressToBlock(MatrixBlock var1, int var2, int var3);

    public abstract void decompressToBlock(MatrixBlock var1, int[] var2);

    public abstract void decompressToBlock(MatrixBlock var1, int var2);

    public abstract void write(DataOutput var1) throws IOException;

    public abstract void readFields(DataInput var1) throws IOException;

    public abstract long getExactSizeOnDisk();

    public abstract double get(int var1, int var2);

    public abstract double[] getValues();

    public abstract MatrixBlock getValuesAsBlock();

    public abstract boolean getIfCountsType();

    public abstract void rightMultByVector(double[] var1, double[] var2, int var3, int var4, double[] var5);

    public abstract void rightMultByMatrix(double[] var1, double[] var2, int var3, double[] var4, int var5, int var6, int var7);

    public abstract void leftMultByRowVector(double[] var1, double[] var2, int var3);

    public abstract void leftMultByRowVector(double[] var1, double[] var2, int var3, double[] var4);

    public abstract void leftMultByMatrix(double[] var1, double[] var2, int var3, double[] var4, int var5, int var6, int var7, int var8, int var9);

    public abstract ColGroup scalarOperation(ScalarOperator var1);

    public abstract void unaryAggregateOperations(AggregateUnaryOperator var1, double[] var2);

    public abstract void unaryAggregateOperations(AggregateUnaryOperator var1, double[] var2, int var3, int var4);

    public abstract Iterator<IJV> getIterator(int var1, int var2, boolean var3, boolean var4);

    public abstract ColGroupRowIterator getRowIterator(int var1, int var2);

    public abstract void countNonZerosPerRow(int[] var1, int var2, int var3);

    public abstract boolean isLossy();

    protected abstract class ColGroupRowIterator {
        protected ColGroupRowIterator() {
        }

        public abstract void next(double[] var1, int var2, int var3, boolean var4);
    }

    protected static enum ColGroupType {
        UNCOMPRESSED,
        RLE,
        OLE,
        DDC1,
        DDC2;

    }

    public static enum CompressionType {
        UNCOMPRESSED,
        RLE,
        OLE,
        DDC;

    }
}

