/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.StringLocalStep;

public final class SubstringLocalStep<S, E>
extends StringLocalStep<S, E> {
    private final Integer start;
    private final Integer end;

    public SubstringLocalStep(Traversal.Admin traversal, Integer startIndex, Integer endIndex) {
        super(traversal);
        this.start = startIndex;
        this.end = endIndex;
    }

    public SubstringLocalStep(Traversal.Admin traversal, Integer startIndex) {
        this(traversal, startIndex, null);
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getEnd() {
        return this.end;
    }

    @Override
    protected E applyStringOperation(String item) {
        int newStart = this.processStringIndex(item.length(), this.start);
        if (null == this.end) {
            return (E)item.substring(newStart);
        }
        int newEnd = this.processStringIndex(item.length(), this.end);
        if (newEnd <= newStart) {
            return (E)"";
        }
        return (E)item.substring(newStart, newEnd);
    }

    @Override
    public String getStepName() {
        return "substring(local)";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.start.hashCode();
        result = 31 * result + (null != this.end ? this.end.hashCode() : 0);
        return result;
    }

    private int processStringIndex(int strLen, int index) {
        if (index < 0) {
            return Math.max(0, (strLen + index) % strLen);
        }
        return Math.min(index, strLen);
    }
}

