/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.grammar;

import java.util.Map;
import java.util.function.BiFunction;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.language.grammar.VariableResolverException;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;

public interface VariableResolver<T>
extends BiFunction<String, GremlinParser.VariableContext, T> {
    @Override
    public T apply(String var1, GremlinParser.VariableContext var2);

    public static class DirectVariableResolver
    implements VariableResolver<Object> {
        private final Map<String, Object> variables;

        public DirectVariableResolver(Map<String, Object> variables) {
            this.variables = variables;
        }

        @Override
        public Object apply(String s, GremlinParser.VariableContext variableContext) {
            if (!this.variables.containsKey(s)) {
                throw new VariableResolverException(String.format("No variable found for %s", s));
            }
            return this.variables.get(s);
        }
    }

    public static class NullVariableResolver
    implements VariableResolver<Object> {
        private static NullVariableResolver instance = new NullVariableResolver();

        public static VariableResolver instance() {
            return instance;
        }

        @Override
        public Object apply(String s, GremlinParser.VariableContext variableContext) {
            return null;
        }
    }

    public static class DefaultVariableResolver
    implements VariableResolver<GValue<?>> {
        private final Map<String, Object> variables;

        public DefaultVariableResolver(Map<String, Object> variables) {
            this.variables = variables;
        }

        @Override
        public GValue<?> apply(String s, GremlinParser.VariableContext variableContext) {
            if (!this.variables.containsKey(s)) {
                throw new VariableResolverException(String.format("No variable found for %s", s));
            }
            return GValue.of(s, this.variables.get(s));
        }
    }

    public static class NoVariableResolver
    implements VariableResolver<Object> {
        private static NoVariableResolver instance = new NoVariableResolver();

        public static VariableResolver instance() {
            return instance;
        }

        @Override
        public Object apply(String s, GremlinParser.VariableContext variableContext) {
            throw new VariableResolverException(String.format("No variable found for %s", s));
        }
    }
}

