/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer;

import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.process.computer.util.VertexProgramHelper;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public abstract class MessageScope {

    public static final class Local<M>
    extends MessageScope {
        public final Supplier<? extends Traversal<Vertex, Edge>> incidentTraversal;
        public final BiFunction<M, Edge, M> edgeFunction;

        private Local(Supplier<? extends Traversal<Vertex, Edge>> incidentTraversal) {
            this(incidentTraversal, (m, e) -> m);
        }

        private Local(Supplier<? extends Traversal<Vertex, Edge>> incidentTraversal, BiFunction<M, Edge, M> edgeFunction) {
            this.incidentTraversal = incidentTraversal;
            this.edgeFunction = edgeFunction;
        }

        public static <M> Local<M> of(Supplier<? extends Traversal<Vertex, Edge>> incidentTraversal) {
            return new Local<M>(incidentTraversal);
        }

        public static <M> Local<M> of(Supplier<? extends Traversal<Vertex, Edge>> incidentTraversal, BiFunction<M, Edge, M> edgeFunction) {
            return new Local<M>(incidentTraversal, edgeFunction);
        }

        public BiFunction<M, Edge, M> getEdgeFunction() {
            return this.edgeFunction;
        }

        public Supplier<? extends Traversal<Vertex, Edge>> getIncidentTraversal() {
            return this.incidentTraversal;
        }

        public int hashCode() {
            return this.edgeFunction.hashCode() ^ this.incidentTraversal.get().hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof Local && ((Local)other).incidentTraversal.get().equals(this.incidentTraversal.get()) && ((Local)other).edgeFunction == this.edgeFunction;
        }

        public static class ReverseTraversalSupplier
        implements Supplier<Traversal<Vertex, Edge>> {
            private final Local<?> localMessageScope;

            public ReverseTraversalSupplier(Local<?> localMessageScope) {
                this.localMessageScope = localMessageScope;
            }

            @Override
            public Traversal<Vertex, Edge> get() {
                return VertexProgramHelper.reverse(this.localMessageScope.getIncidentTraversal().get().asAdmin());
            }
        }
    }

    public static final class Global
    extends MessageScope {
        private static final Global INSTANCE = Global.of(new Vertex[0]);
        private final Iterable<Vertex> vertices;

        private Global(Iterable<Vertex> vertices) {
            this.vertices = vertices;
        }

        public static Global of(Iterable<Vertex> vertices) {
            return new Global(vertices);
        }

        public static Global of(Vertex ... vertices) {
            return new Global(Arrays.asList(vertices));
        }

        public Iterable<Vertex> vertices() {
            return this.vertices;
        }

        public static Global instance() {
            return INSTANCE;
        }

        public int hashCode() {
            return 4676576;
        }

        public boolean equals(Object other) {
            return other instanceof Global;
        }
    }
}

