/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class GetListAction
extends AbstractRutaAction {
    private static final String TYPES = "Types";
    private static final String TYPES_AT_END = "Types:End";
    private static final String TYPES_AT_BEGIN = "Types:Begin";
    private String var;
    private StringExpression opExpr;

    public GetListAction(String var, StringExpression op) {
        this.var = var;
        this.opExpr = op;
    }

    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        String op = this.opExpr.getStringValue(element.getParent());
        ArrayList<Type> list = new ArrayList<Type>();
        int indexOf = element.getContainer().getRuleElements().indexOf(element);
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        indexes.add(indexOf + 1);
        List<AnnotationFS> matchedAnnotations = match.getMatchedAnnotations(stream, indexes, element.getContainer());
        block0: for (AnnotationFS matched : matchedAnnotations) {
            HashSet<AnnotationFS> aset;
            Collection<Set<AnnotationFS>> values;
            if (TYPES_AT_BEGIN.equals(op)) {
                RutaBasic beginAnchor = stream.getBeginAnchor(matched.getBegin());
                values = beginAnchor.getBeginMap().values();
                aset = new HashSet<AnnotationFS>();
                for (Set<Object> set : values) {
                    aset.addAll(set);
                }
                for (AnnotationFS annotationFS : aset) {
                    list.add(annotationFS.getType());
                }
                continue;
            }
            if (TYPES_AT_END.equals(op)) {
                RutaBasic endAnchor = stream.getEndAnchor(matched.getEnd());
                values = endAnchor.getEndMap().values();
                aset = new HashSet();
                for (Set<Object> set : values) {
                    aset.addAll(set);
                }
                for (AnnotationFS annotationFS : aset) {
                    list.add(annotationFS.getType());
                }
                continue;
            }
            if (!TYPES.equals(op)) continue;
            Type annotationType = stream.getCas().getAnnotationType();
            List<AnnotationFS> inWindow = stream.getAnnotationsInWindow(matched, annotationType);
            for (AnnotationFS each : inWindow) {
                if (each.getBegin() == matched.getBegin() && each.getEnd() == matched.getEnd()) {
                    list.add(each.getType());
                }
                if (each.getBegin() <= matched.getBegin() && each.getEnd() >= matched.getEnd()) continue;
                continue block0;
            }
        }
        element.getParent().getEnvironment().setVariableValue(this.var, list);
    }

    public String getVar() {
        return this.var;
    }

    public StringExpression getOpExpr() {
        return this.opExpr;
    }
}

