/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.MarkAction;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.AnnotationComparator;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShiftAction
extends MarkAction {
    public ShiftAction(TypeExpression type, List<NumberExpression> list) {
        super(type, null, list);
    }

    @Override
    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        Type targetType = this.type.getType(element.getParent());
        List<Integer> indexList = this.getIndexList(element, this.list);
        List<AnnotationFS> destinationAnnotationSpans = match.getMatchedAnnotations(stream, indexList, element.getContainer());
        List<AnnotationFS> annotationsMatchedByRuleElementofAction = match.getMatchedAnnotationsOf(element, stream);
        int size = Math.min(annotationsMatchedByRuleElementofAction.size(), destinationAnnotationSpans.size());
        for (int i = 0; i < size; ++i) {
            AnnotationFS eachMatched = annotationsMatchedByRuleElementofAction.get(i);
            AnnotationFS eachDestination = destinationAnnotationSpans.get(i);
            TreeSet<AnnotationFS> allAnchoredAnnotations = new TreeSet<AnnotationFS>(new AnnotationComparator());
            Set<AnnotationFS> beginAnchors = stream.getBeginAnchor(eachMatched.getBegin()).getBeginAnchors(targetType);
            Set<AnnotationFS> endAnchors = stream.getEndAnchor(eachMatched.getEnd()).getEndAnchors(targetType);
            allAnchoredAnnotations.addAll(beginAnchors);
            allAnchoredAnnotations.addAll(endAnchors);
            for (AnnotationFS eachAnchored : allAnchoredAnnotations) {
                Annotation a = (Annotation)eachAnchored;
                stream.removeAnnotation((AnnotationFS)a);
                a.setBegin(eachDestination.getBegin());
                a.setEnd(eachDestination.getEnd());
                stream.addAnnotation((AnnotationFS)a, true, match);
            }
        }
    }
}

