/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TypeSentiveCondition;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class ContextCountCondition
extends TypeSentiveCondition {
    private final NumberExpression min;
    private final NumberExpression max;
    private final String var;

    public ContextCountCondition(TypeExpression type, NumberExpression min, NumberExpression max, String var) {
        super(type);
        this.min = min == null ? new SimpleNumberExpression(Integer.MIN_VALUE) : min;
        this.max = max == null ? new SimpleNumberExpression(Integer.MAX_VALUE) : max;
        this.var = var;
    }

    public EvaluatedCondition eval(AnnotationFS annotation, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        Type contextType = this.type.getType(element.getParent());
        stream.moveToFirst();
        ArrayList<AnnotationFS> visibleContexts = new ArrayList<AnnotationFS>();
        while (stream.isValid()) {
            RutaBasic each = (RutaBasic)stream.get();
            if (each.beginsWith(contextType)) {
                visibleContexts.addAll(each.getBeginAnchors(contextType));
            }
            stream.moveToNext();
        }
        ArrayList<AnnotationFS> overlappingContexts = new ArrayList<AnnotationFS>();
        for (AnnotationFS eachContext : visibleContexts) {
            if (eachContext.getBegin() > annotation.getBegin() || eachContext.getEnd() < annotation.getEnd()) continue;
            overlappingContexts.add(eachContext);
        }
        boolean result = false;
        for (AnnotationFS eachContext : overlappingContexts) {
            boolean value;
            int index = 0;
            int counter = 0;
            List<RutaBasic> basicsInWindow = stream.getBasicsInWindow(eachContext);
            for (RutaBasic eachBasic : basicsInWindow) {
                Set<AnnotationFS> beginAnchors = eachBasic.getBeginAnchors(annotation.getType());
                if (beginAnchors == null) continue;
                for (AnnotationFS each : beginAnchors) {
                    ++counter;
                    if (each.getBegin() != annotation.getBegin() || each.getEnd() != annotation.getEnd() || !each.getType().equals(annotation.getType()) && !stream.getCas().getTypeSystem().subsumes(annotation.getType(), each.getType())) continue;
                    index = counter;
                }
            }
            if (this.var != null) {
                element.getParent().getEnvironment().setVariableValue(this.var, index);
            }
            if (!(result |= (value = index >= this.min.getIntegerValue(element.getParent()) && index <= this.max.getIntegerValue(element.getParent())))) continue;
            break;
        }
        return new EvaluatedCondition(this, result);
    }

    public NumberExpression getMin() {
        return this.min;
    }

    public NumberExpression getMax() {
        return this.max;
    }

    public String getVar() {
        return this.var;
    }
}

